/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.platform.integration.create;

import com.simibubi.create.content.contraptions.AbstractContraptionEntity;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class CreateCompat {
    public static final ResourceLocation CREATE = ResourceLocation.fromNamespaceAndPath((String)"flan", (String)"create_contraption");

    public static boolean canMinecartPass(AbstractMinecart minecart) {
        Level level;
        if (!Flan.create || !((level = minecart.level()) instanceof ServerLevel)) {
            return true;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        Entity entity = minecart.getFirstPassenger();
        if (entity instanceof AbstractContraptionEntity) {
            AbstractContraptionEntity contraption = (AbstractContraptionEntity)entity;
            ClaimStorage storage = ClaimStorage.get(serverLevel);
            Vec3 delta = minecart.getDeltaMovement();
            AABB aabb = contraption.getContraption().bounds.expandTowards(delta);
            BlockPos pos = minecart.blockPosition();
            int rX = Mth.ceil((double)(aabb.getXsize() * 0.5));
            int rZ = Mth.ceil((double)(aabb.getZsize() * 0.5));
            Set<Claim> claims = storage.getNearbyClaims(serverLevel, pos, rX, rZ);
            claims.remove(storage.getClaimAt(pos));
            if (claims.isEmpty()) {
                return true;
            }
            if (delta.x != 0.0) {
                Iterable eastWest = delta.x > 0.0 ? BlockPos.betweenClosed((int)(pos.getX() + rX), (int)pos.getY(), (int)(pos.getZ() - rZ), (int)(pos.getX() + rX), (int)pos.getY(), (int)(pos.getZ() + rZ)) : BlockPos.betweenClosed((int)(pos.getX() - rX), (int)pos.getY(), (int)(pos.getZ() - rZ), (int)(pos.getX() - rX), (int)pos.getY(), (int)(pos.getZ() + rZ));
                for (BlockPos ipos : eastWest) {
                    for (Claim claim : claims) {
                        if (!claim.insideClaim(ipos) || claim.canInteract(null, CREATE, ipos, false)) continue;
                        return false;
                    }
                }
            }
            if (delta.z != 0.0) {
                Iterable northSouth = delta.z > 0.0 ? BlockPos.betweenClosed((int)(pos.getX() - rX), (int)pos.getY(), (int)(pos.getZ() + rZ), (int)(pos.getX() + rX), (int)pos.getY(), (int)(pos.getZ() + rZ)) : BlockPos.betweenClosed((int)(pos.getX() - rX), (int)pos.getY(), (int)(pos.getZ() - rZ), (int)(pos.getX() + rX), (int)pos.getY(), (int)(pos.getZ() - rZ));
                for (BlockPos ipos : northSouth) {
                    for (Claim claim : claims) {
                        if (!claim.insideClaim(ipos) || claim.canInteract(null, CREATE, ipos, false)) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return true;
    }
}

