/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.player;

import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.player.ClaimMode;
import io.github.flemmli97.flan.player.OfflinePlayerData;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;

public class PlayerDataHandler {
    private static Map<UUID, OfflinePlayerData> inActivePlayerData = null;

    public static void initInactivePlayers(MinecraftServer server) {
        inActivePlayerData = new HashMap<UUID, OfflinePlayerData>();
        LocalDateTime now = LocalDateTime.now();
        Map<UUID, OfflinePlayerData> playerData = PlayerDataHandler.collectAllPlayerData(server);
        playerData.forEach((uuid, data) -> {
            if (data.isExpired(now)) {
                inActivePlayerData.put((UUID)uuid, (OfflinePlayerData)data);
            }
        });
        Flan.log("Collected player data to delete {}", inActivePlayerData);
    }

    public static Map<UUID, OfflinePlayerData> collectAllPlayerData(MinecraftServer server) {
        Path dir = ConfigHandler.getPlayerSavePath(server);
        HashMap<UUID, OfflinePlayerData> playerDatas = new HashMap<UUID, OfflinePlayerData>();
        if (Files.exists(dir, new LinkOption[0])) {
            for (String name2 : dir.toFile().list((d, name) -> name.endsWith(".json"))) {
                UUID uuid = UUID.fromString(name2.replace(".json", ""));
                playerDatas.put(uuid, new OfflinePlayerData(server, uuid));
            }
        }
        return playerDatas;
    }

    public static void deleteUnusedClaims(MinecraftServer server, ClaimStorage storage, ServerLevel level) {
        if (inActivePlayerData == null) {
            PlayerDataHandler.initInactivePlayers(server);
        }
        inActivePlayerData.forEach((uuid, data) -> {
            Flan.log("{} Deleting all claims for inactive player {} last seen {}", level.dimension(), data.owner, data.lastOnline);
            storage.allClaimsFromPlayer(data.owner).forEach(claim -> storage.deleteClaim((Claim)claim, true, ClaimMode.DEFAULT, level));
        });
    }

    public static void deleteInactivePlayerData(MinecraftServer server) {
        if (ConfigHandler.CONFIG.deletePlayerFile && inActivePlayerData != null) {
            inActivePlayerData.forEach((uuid, data) -> data.deleteFile());
            inActivePlayerData = null;
        }
    }
}

