/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.api.permission;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import io.github.flemmli97.flan.api.permission.ObjectToPermissionMap;
import io.github.flemmli97.flan.api.permission.interactions.InteractionType;
import io.github.flemmli97.flan.api.permission.interactions.ResolvableEntry;
import io.github.flemmli97.flan.api.permission.interactions.ResolvableHolderSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1676;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_3730;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class InteractionOverrideManager
extends class_4309<InteractionEntry<?>> {
    public static final class_5321<? extends class_2378<InteractionEntry<?>>> ID = class_5321.method_29180((class_2960)class_2960.method_60655((String)"flan", (String)"claim_interactions_override"));
    public static final Codec<ResolvableEntry<class_2248>> BLOCK_CODEC = ResolvableHolderSet.codec(class_7923.field_41175);
    public static final Codec<ResolvableEntry<class_1792>> ITEM_CODEC = ResolvableHolderSet.codec(class_7923.field_41178);
    public static final Codec<ResolvableEntry<class_1299<?>>> ENTITY_CODEC = ResolvableHolderSet.codec(class_7923.field_41177);
    public static final InteractionType<class_2248> BLOCK_LEFT_CLICK = new InteractionType<class_2248>(class_2960.method_60655((String)"flan", (String)"block_left_click"), BLOCK_CODEC, InteractionHolder::new);
    public static final InteractionType<class_2248> BLOCK_INTERACT = new InteractionType<class_2248>(class_2960.method_60655((String)"flan", (String)"block_interact"), BLOCK_CODEC, InteractionHolder::new);
    public static final InteractionType<class_1792> ITEM_USE = new InteractionType<class_1792>(class_2960.method_60655((String)"flan", (String)"item_use"), ITEM_CODEC, InteractionHolder::new);
    public static final InteractionType<class_1299<?>> ENTITY_ATTACK = new InteractionType(class_2960.method_60655((String)"flan", (String)"entity_attack"), ENTITY_CODEC, InteractionHolder::new);
    public static final InteractionType<class_1299<?>> ENTITY_INTERACT = new InteractionType(class_2960.method_60655((String)"flan", (String)"entity_interact"), ENTITY_CODEC, InteractionHolder::new);
    public static final InteractionType<class_2248> PROJECTILE_BLOCK_INTERACT = new InteractionType<class_2248>(class_2960.method_60655((String)"flan", (String)"projectile_block_interact"), BLOCK_CODEC, InteractionHolder::new);
    public static final InteractionType<class_1299<?>> PROJECTILE_ENTITY_INTERACT = new InteractionType(class_2960.method_60655((String)"flan", (String)"projectile_entity_interact"), ENTITY_CODEC, InteractionHolder::new);
    private static InteractionOverrideManager INSTANCE;
    private final Map<InteractionType<?>, InteractionHolder<?>> overrides = new HashMap();

    private InteractionOverrideManager(class_7225.class_7874 provider) {
        super(provider, InteractionEntry.CODEC, ID);
    }

    public static InteractionOverrideManager create(class_7225.class_7874 provider) {
        INSTANCE = new InteractionOverrideManager(provider);
        return InteractionOverrideManager.getInstance();
    }

    public static InteractionOverrideManager getInstance() {
        return INSTANCE;
    }

    public class_2960 getBlockLeftClick(class_2248 block) {
        return this.getOverride(BLOCK_LEFT_CLICK, block);
    }

    public class_2960 getBlockInteract(class_2248 block) {
        return this.getOverride(BLOCK_INTERACT, block);
    }

    public class_2960 getItemUse(class_1792 item) {
        return this.getOverride(ITEM_USE, item);
    }

    public class_2960 getEntityAttack(class_1299<?> entity) {
        return this.getOverride(ENTITY_ATTACK, entity);
    }

    public class_2960 getEntityInteract(class_1299<?> entity) {
        return this.getOverride(ENTITY_INTERACT, entity);
    }

    public class_2960 getProjectileBlockInteract(class_2248 block) {
        return this.getOverride(PROJECTILE_BLOCK_INTERACT, block);
    }

    public class_2960 getProjectileEntityInteract(class_1676 entity) {
        InteractionHolder<class_1299<?>> holder = this.getHolder(PROJECTILE_ENTITY_INTERACT);
        if (!holder.unresolved()) {
            for (class_1299 type : class_7923.field_41177) {
                InteractionHolder<class_1299<?>> map = this.getHolder(PROJECTILE_ENTITY_INTERACT);
                ObjectToPermissionMap.PROJECTILE_PERMISSION_BUILDER.entrySet().stream().filter(e -> {
                    class_1297 dummy = type.method_5883(entity.method_37908(), class_3730.field_16461);
                    return ((Predicate)e.getKey()).test(dummy);
                }).map(Map.Entry::getValue).findFirst().ifPresent(sub -> map.defaults.put(type, (class_2960)sub.get()));
            }
        }
        return this.getOverride(PROJECTILE_ENTITY_INTERACT, entity.method_5864());
    }

    public <T> class_2960 getOverride(InteractionType<T> type, T entry) {
        return this.getHolder(type).get(entry);
    }

    private <T> InteractionHolder<T> getHolder(InteractionType<T> type) {
        return this.overrides.computeIfAbsent(type, k -> type.getGen().get());
    }

    protected void apply(Map<class_2960, InteractionEntry<?>> data, class_3300 manager, class_3695 profiler) {
        InteractionHolder<class_2248> map;
        this.overrides.clear();
        for (class_2248 block : class_7923.field_41175) {
            map = this.getHolder(BLOCK_INTERACT);
            ObjectToPermissionMap.BLOCK_PERMISSION_BUILDER.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(block)).map(Map.Entry::getValue).findFirst().ifPresent(sub -> map.defaults.put(block, (class_2960)sub.get()));
        }
        for (class_1792 item : class_7923.field_41178) {
            map = this.getHolder(ITEM_USE);
            ObjectToPermissionMap.ITEM_PERMISSION_BUILDER.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(item)).map(Map.Entry::getValue).findFirst().ifPresent(sub -> map.defaults.put(item, (class_2960)sub.get()));
        }
        for (class_2248 block : class_7923.field_41175) {
            map = this.getHolder(PROJECTILE_BLOCK_INTERACT);
            ObjectToPermissionMap.PROJECTILE_BLOCK_PERMISSION_BUILDER.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(block)).map(Map.Entry::getValue).findFirst().ifPresent(sub -> map.defaults.put(block, (class_2960)sub.get()));
        }
        data.forEach((res, entry) -> this.appendTo((InteractionEntry)entry));
    }

    private <T> void appendTo(InteractionEntry<T> entry) {
        InteractionHolder<T> map = this.getHolder(entry.type());
        entry.elements().forEach(pair -> map.unresolvedTags.put((ResolvableEntry)pair.getFirst(), (class_2960)pair.getSecond()));
    }

    public record InteractionEntry<T>(InteractionType<T> type, List<Pair<ResolvableEntry<T>, class_2960>> elements) {
        public static final Codec<InteractionEntry<?>> CODEC = class_2960.field_25139.dispatch(e -> e.type().getId(), t -> InteractionType.get(t).getCodec());
    }

    public static class InteractionHolder<T> {
        private final Map<T, class_2960> direct = new HashMap<T, class_2960>();
        private final Map<ResolvableEntry<T>, class_2960> unresolvedTags = new HashMap<ResolvableEntry<T>, class_2960>();
        private final Map<T, class_2960> defaults = new HashMap<T, class_2960>();

        public class_2960 get(T val) {
            if (this.unresolved()) {
                this.resolve();
            }
            return this.direct.get(val);
        }

        public boolean unresolved() {
            return !this.unresolvedTags.isEmpty() || !this.defaults.isEmpty();
        }

        private void resolve() {
            this.unresolvedTags.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> ((ResolvableEntry)entry.getKey()).resolve().forEach(item -> {
                if (!this.direct.containsKey(item)) {
                    this.direct.put(item, (class_2960)entry.getValue());
                }
            }));
            this.unresolvedTags.clear();
            this.defaults.forEach((key, value) -> {
                if (!this.direct.containsKey(key)) {
                    this.direct.put((T)key, (class_2960)value);
                }
            });
            this.defaults.clear();
        }
    }
}

