/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.claim;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.api.permission.PermissionManager;
import io.github.flemmli97.flan.claim.ClaimBox;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.claim.attachment.AllowedRegistryListHolder;
import io.github.flemmli97.flan.claim.attachment.ClaimAllowListKey;
import io.github.flemmli97.flan.config.Config;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.platform.ClaimEvents;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.platform.integration.webmap.WebmapCalls;
import io.github.flemmli97.flan.player.LogoutTracker;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.player.display.ClaimDisplayBox;
import io.github.flemmli97.flan.player.display.DisplayBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2588;
import net.minecraft.class_2596;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3518;
import net.minecraft.class_5250;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_6880;
import net.minecraft.class_6903;
import net.minecraft.class_7417;
import net.minecraft.class_7923;
import net.minecraft.class_8824;
import net.minecraft.class_8828;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class Claim
implements IPermissionContainer {
    private boolean dirty;
    private int minX;
    private int minZ;
    private int maxX;
    private int maxZ;
    private int minY;
    private Integer maxY;
    private UUID owner;
    private UUID claimID;
    private String claimName = "";
    private class_2338 homePos;
    private final Map<class_2960, Boolean> globalPerm = new HashMap<class_2960, Boolean>();
    private final Map<String, Map<class_2960, Boolean>> permissions = new HashMap<String, Map<class_2960, Boolean>>();
    private final Map<UUID, String> playersGroups = new HashMap<UUID, String>();
    private final Set<UUID> fakePlayers = new HashSet<UUID>();
    private final List<Claim> subClaims = new ArrayList<Claim>();
    private UUID parent;
    private Claim parentClaim;
    private boolean removed;
    private final class_3218 level;
    private final Map<class_6880<class_1291>, Pair<Integer, Integer>> potions = new HashMap<class_6880<class_1291>, Pair<Integer, Integer>>();
    public final AllowedRegistryListHolder allowedEntries = new AllowedRegistryListHolder(this);
    public class_2561 enterTitle;
    public class_2561 enterSubtitle;
    public class_2561 leaveTitle;
    public class_2561 leaveSubtitle;

    private Claim(class_3218 level) {
        this.level = level;
    }

    public Claim(class_2338 pos1, class_2338 pos2, class_3222 creator) {
        this(pos1.method_10263(), pos2.method_10263(), pos1.method_10260(), pos2.method_10260(), Math.min(pos1.method_10264(), pos2.method_10264()), creator.method_5667(), creator.method_51469(), PlayerClaimData.get(creator).playerDefaultGroups().isEmpty());
        PlayerClaimData.get(creator).playerDefaultGroups().forEach((s, m) -> m.forEach((perm, bool) -> this.editPerms(null, (String)s, (class_2960)perm, bool != false ? 1 : 0, true)));
        Collection<Claim> all = ClaimStorage.get(creator.method_51469()).allClaimsFromPlayer(creator.method_5667());
        Object name = String.format(ConfigHandler.CONFIG.defaultClaimName, "%1$s", all.size());
        if (!((String)name).isEmpty()) {
            for (Claim claim : all) {
                String numbered = claim.claimName.replace((String)name + " #", "");
                if (numbered.isEmpty()) continue;
                name = (String)name + " #" + all.size();
                break;
            }
        }
        this.claimName = name;
        if (!ConfigHandler.CONFIG.defaultEnterMessage.isEmpty()) {
            this.enterTitle = class_2561.method_43470((String)String.format(ConfigHandler.CONFIG.defaultEnterMessage, this.claimName));
        }
        if (!ConfigHandler.CONFIG.defaultLeaveMessage.isEmpty()) {
            this.leaveTitle = class_2561.method_43470((String)String.format(ConfigHandler.CONFIG.defaultLeaveMessage, this.claimName));
        }
    }

    public Claim(class_2338 pos1, class_2338 pos2, UUID creator, class_3218 level) {
        this(pos1.method_10263(), pos2.method_10263(), pos1.method_10260(), pos2.method_10260(), Math.min(pos1.method_10264(), pos2.method_10264()), creator, level);
    }

    public Claim(int x1, int x2, int z1, int z2, int minY, UUID creator, class_3218 level) {
        this(x1, x2, z1, z2, minY, creator, level, true);
    }

    public Claim(int x1, int x2, int z1, int z2, int minY, UUID creator, class_3218 level, boolean setDefaultGroups) {
        this.minX = Math.min(x1, x2);
        this.minZ = Math.min(z1, z2);
        this.maxX = Math.max(x1, x2);
        this.maxZ = Math.max(z1, z2);
        this.minY = Math.max(level.method_31607(), minY);
        this.owner = creator;
        this.level = level;
        this.homePos = this.getInitCenterPos();
        this.setDirty(true);
        PermissionManager.getInstance().getAll().stream().filter(perm -> perm.defaultVal).forEach(perm -> this.globalPerm.put(perm.getId(), true));
        ConfigHandler.CONFIG.getGloballyDefinedVals(level).forEach(e -> this.globalPerm.put((class_2960)e.getKey(), ((Config.GlobalType)((Object)((Object)e.getValue()))).getValue()));
        if (setDefaultGroups) {
            ConfigHandler.CONFIG.defaultGroups.forEach((s, m) -> m.forEach((perm, bool) -> this.editPerms(null, (String)s, (class_2960)perm, bool != false ? 1 : 0, true)));
        }
    }

    public static Claim fromJson(JsonObject obj, UUID owner, class_3218 level) {
        Claim claim = new Claim(level);
        claim.readJson(obj, owner);
        ClaimUpdater.updateClaim(claim);
        return claim;
    }

    private class_2338 getInitCenterPos() {
        class_2338 center = class_2338.method_49637((double)((double)this.minX + (double)(this.maxX - this.minX) * 0.5), (double)0.0, (double)((double)this.minZ + (double)(this.maxZ - this.minZ) * 0.5));
        int y = !this.level.method_8393(center.method_10263() >> 4, center.method_10260() >> 4) ? this.minY + 1 : this.level.method_8497(center.method_10263() >> 4, center.method_10260() >> 4).method_12005(class_2902.class_2903.field_13197, center.method_10263() & 0xF, center.method_10260() & 0xF);
        return new class_2338(center.method_10263(), y + 1, center.method_10260());
    }

    private class_2338 getDefaultCenterPos() {
        class_2338 center = class_2338.method_49637((double)((double)this.minX + (double)(this.maxX - this.minX) * 0.5), (double)0.0, (double)((double)this.minZ + (double)(this.maxZ - this.minZ) * 0.5));
        return new class_2338(center.method_10263(), 255, center.method_10260());
    }

    public void setClaimID(UUID uuid) {
        this.claimID = uuid;
        this.setDirty(true);
    }

    public Claim withHeight(int y) {
        this.maxY = Math.max(y, this.minY + 1);
        return this;
    }

    public void extendDownwards(class_2338 pos) {
        if (this.maxY != null) {
            return;
        }
        this.minY = Math.min(this.minY, pos.method_10264());
        this.setDirty(true);
        WebmapCalls.onExtendDownwards(this);
    }

    public UUID getClaimID() {
        return this.claimID;
    }

    public String getClaimName() {
        String ownerName = this.isAdminClaim() ? "Admin" : ClaimUtils.fetchUsername(this.owner, this.level.method_8503()).orElse(this.owner.toString());
        return String.format(this.claimName, ownerName);
    }

    public void setClaimName(String name) {
        this.claimName = name;
        this.setDirty(true);
        WebmapCalls.changeClaimName(this);
    }

    public UUID getOwner() {
        return this.owner;
    }

    public Optional<class_3222> getOwnerPlayer() {
        if (this.getOwner() != null) {
            return Optional.ofNullable(this.level.method_8503().method_3760().method_14602(this.getOwner()));
        }
        return Optional.empty();
    }

    public class_3218 getLevel() {
        return this.level;
    }

    public Claim parentClaim() {
        if (this.parent == null) {
            return null;
        }
        if (this.parentClaim == null) {
            ClaimStorage storage = ClaimStorage.get(this.level);
            this.parentClaim = storage.getFromUUID(this.parent);
        }
        return this.parentClaim;
    }

    public boolean isSubclaim() {
        return this.parentClaim() != null;
    }

    public void copySizes(Claim claim) {
        this.minX = claim.minX;
        this.maxX = claim.maxX;
        this.minZ = claim.minZ;
        this.maxZ = claim.maxZ;
        this.minY = claim.minY;
        this.maxY = claim.maxY;
        this.removed = false;
        this.setDirty(true);
    }

    public void toggleAdminClaim(class_3222 player, boolean flag) {
        if (!flag) {
            this.transferOwner(player.method_5667());
        } else {
            this.owner = null;
            this.subClaims.forEach(claim -> {
                claim.owner = null;
            });
        }
        this.setDirty(true);
    }

    public boolean isAdminClaim() {
        return this.owner == null;
    }

    public void transferOwner(UUID player) {
        this.owner = player;
        this.subClaims.forEach(claim -> {
            claim.owner = player;
        });
        this.setDirty(true);
    }

    public int getPlane() {
        return (this.maxX - this.minX + 1) * (this.maxZ - this.minZ + 1);
    }

    public ClaimBox getDimensions() {
        int maxY;
        int minY = this.minY;
        int n = maxY = this.is3d() ? this.maxY : this.getLevel().method_31600() + 10;
        if (!this.is3d()) {
            minY = ConfigHandler.CONFIG.subClaimsInheritParentDepth && this.isSubclaim() ? this.parentClaim().minY : (ConfigHandler.CONFIG.defaultClaimDepth != -1 ? this.minY : this.getLevel().method_31607() - 10);
        }
        return new ClaimBox(this.minX, minY, this.minZ, this.maxX, Math.max(minY + 1, maxY), this.maxZ);
    }

    public boolean is3d() {
        return this.maxY != null;
    }

    public boolean insideClaim(class_2338 pos) {
        return this.getDimensions().insideClaim(pos);
    }

    public boolean intersects(Claim other) {
        return this.getDimensions().intersects(other.getDimensions());
    }

    public boolean intersects(class_238 box) {
        return this.getDimensions().intersects(box);
    }

    public boolean isCorner(class_2338 pos) {
        if (this.maxY != null && pos.method_10264() != this.minY && pos.method_10264() != this.maxY.intValue()) {
            return false;
        }
        return pos.method_10263() == this.minX && pos.method_10260() == this.minZ || pos.method_10263() == this.minX && pos.method_10260() == this.maxZ || pos.method_10263() == this.maxX && pos.method_10260() == this.minZ || pos.method_10263() == this.maxX && pos.method_10260() == this.maxZ;
    }

    public void remove() {
        this.removed = true;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    @Override
    public boolean canInteract(class_3222 player, class_2960 perm, class_2338 pos, boolean message) {
        Map<class_2960, Boolean> map;
        class_1269 res;
        boolean realPlayer = player != null && player.getClass().equals(class_3222.class);
        boolean bl = message = message && realPlayer && player.field_13987 != null;
        if (player != null && !realPlayer) {
            if (this.fakePlayers.contains(player.method_5667())) {
                return true;
            }
            if (this.level.method_8503().method_3793().method_14512(player.method_5667()).isEmpty() && !player.method_5667().equals(this.owner) && !this.playersGroups.containsKey(player.method_5667())) {
                perm = BuiltinPermission.FAKEPLAYER;
            }
        }
        if ((res = ClaimEvents.INSTANCE.claimCheck(player, perm, pos)) != class_1269.field_5811) {
            return res != class_1269.field_5814;
        }
        if (!this.isAdminClaim()) {
            Object global = ConfigHandler.CONFIG.getGlobal(this.level, perm);
            if (!global.canModify()) {
                ClaimPermission permission;
                if (global.getValue()) {
                    return true;
                }
                if (player != null && this.isAdminIgnore(player) && (permission = PermissionManager.getInstance().get(perm)) != null && !permission.requireExplicitSet) {
                    return true;
                }
                if (message) {
                    player.method_7353((class_2561)ClaimUtils.translatedText("flan.noPermissionSimple", class_124.field_1079), true);
                }
                if (perm.equals((Object)BuiltinPermission.FAKEPLAYER)) {
                    this.getOwnerPlayer().ifPresent(p -> PlayerClaimData.get(p).notifyFakePlayerInteraction(player, pos, this));
                }
                return false;
            }
            if (ConfigHandler.CONFIG.offlineProtectActivation != -1 && (LogoutTracker.getInstance(this.level.method_8503()).justLoggedOut(this.getOwner()) || this.getOwnerPlayer().isPresent())) {
                return global == Config.GlobalType.NONE || global.getValue();
            }
        }
        if (PermissionManager.getInstance().isGlobalPermission(perm)) {
            for (Claim claim : this.subClaims) {
                if (!claim.insideClaim(pos)) continue;
                return claim.canInteract(player, perm, pos, message);
            }
            if (this.hasPerm(perm)) {
                return true;
            }
            if (message) {
                player.method_7353((class_2561)ClaimUtils.translatedText("flan.noPermissionSimple", class_124.field_1079), true);
            }
            if (perm.equals((Object)BuiltinPermission.FAKEPLAYER)) {
                this.getOwnerPlayer().ifPresent(p -> PlayerClaimData.get(p).notifyFakePlayerInteraction(player, pos, this));
            }
            return false;
        }
        if (this.playerBypassesPermission(player, perm)) {
            return true;
        }
        if (!perm.equals((Object)BuiltinPermission.EDITCLAIM) && !perm.equals((Object)BuiltinPermission.EDITPERMS)) {
            for (Claim claim : this.subClaims) {
                if (!claim.insideClaim(pos)) continue;
                return claim.canInteract(player, perm, pos, message);
            }
        }
        if (this.playersGroups.containsKey(player.method_5667()) && (map = this.permissions.get(this.playersGroups.get(player.method_5667()))) != null && map.containsKey(perm)) {
            if (map.get(perm).booleanValue()) {
                return true;
            }
            if (message) {
                player.method_7353((class_2561)ClaimUtils.translatedText("flan.noPermissionSimple", class_124.field_1079), true);
            }
            if (perm.equals((Object)BuiltinPermission.FAKEPLAYER)) {
                this.getOwnerPlayer().ifPresent(p -> PlayerClaimData.get(p).notifyFakePlayerInteraction(player, pos, this));
            }
            return false;
        }
        if (this.hasPerm(perm)) {
            return true;
        }
        if (message) {
            player.method_7353((class_2561)ClaimUtils.translatedText("flan.noPermissionSimple", class_124.field_1079), true);
        }
        if (perm.equals((Object)BuiltinPermission.FAKEPLAYER)) {
            this.getOwnerPlayer().ifPresent(p -> PlayerClaimData.get(p).notifyFakePlayerInteraction(player, pos, this));
        }
        return false;
    }

    private boolean playerBypassesPermission(class_3222 player, class_2960 perm) {
        if (player == null) {
            return true;
        }
        ClaimPermission permission = PermissionManager.getInstance().get(perm);
        if (permission != null && permission.requireExplicitSet) {
            return false;
        }
        return player.method_5667().equals(this.owner) || this.isAdminIgnore(player);
    }

    private boolean isAdminIgnore(class_3222 player) {
        if (player == null) {
            return true;
        }
        if (PlayerClaimData.get(player).isAdminIgnoreClaim()) {
            return !this.isAdminClaim() || PermissionNodeHandler.INSTANCE.perm(player, "flan.bypass.admin.mode", true);
        }
        return this.isAdminClaim() && player.method_64475(2);
    }

    public int permEnabled(class_2960 perm) {
        return !this.globalPerm.containsKey(perm) ? -1 : (this.globalPerm.get(perm) != false ? 1 : 0);
    }

    private boolean hasPerm(class_2960 perm) {
        if (this.parentClaim() == null) {
            return this.permEnabled(perm) == 1;
        }
        if (this.permEnabled(perm) == -1) {
            return this.parentClaim().permEnabled(perm) == 1;
        }
        return this.permEnabled(perm) == 1;
    }

    private UUID generateUUID() {
        UUID uuid = UUID.randomUUID();
        for (Claim claim : this.subClaims) {
            if (!claim.claimID.equals(uuid)) continue;
            return this.generateUUID();
        }
        return uuid;
    }

    public Set<Claim> tryCreateSubClaim(class_2338 pos1, class_2338 pos2, boolean is3d) {
        if (this.parentClaim() != null) {
            return Set.of(this.parentClaim());
        }
        Claim sub = new Claim(pos1, pos2, this.owner, this.level);
        if (is3d) {
            sub.withHeight(Math.max(pos1.method_10264(), pos2.method_10264()));
        }
        sub.setClaimID(this.generateUUID());
        HashSet<Claim> conflicts = new HashSet<Claim>();
        for (Claim other : this.subClaims) {
            if (!sub.intersects(other)) continue;
            conflicts.add(other);
        }
        if (conflicts.isEmpty()) {
            sub.parent = this.claimID;
            sub.parentClaim = this;
            this.subClaims.add(sub);
            sub.permissions.clear();
            sub.permissions.putAll(this.permissions);
            sub.playersGroups.clear();
            sub.playersGroups.putAll(this.playersGroups);
            sub.potions.clear();
            sub.potions.putAll(this.potions);
            this.setDirty(true);
        }
        return conflicts;
    }

    public void addSubClaimGriefprevention(Claim claim) {
        claim.setClaimID(this.generateUUID());
        claim.parent = this.claimID;
        claim.parentClaim = this;
        this.subClaims.add(claim);
        this.setDirty(true);
    }

    public Claim getSubClaim(class_2338 pos) {
        for (Claim claim : this.subClaims) {
            if (!claim.insideClaim(pos)) continue;
            return claim;
        }
        return null;
    }

    public boolean deleteSubClaim(Claim claim) {
        claim.remove();
        this.setDirty(true);
        return this.subClaims.remove(claim);
    }

    public List<Claim> getAllSubclaims() {
        return ImmutableList.copyOf(this.subClaims);
    }

    public Set<Claim> resizeSubclaim(Claim claim, class_2338 from, class_2338 to) {
        ClaimBox dims = claim.getDimensions();
        int minY = claim.is3d() && dims.minY() == from.method_10264() ? dims.maxY() : dims.minY();
        class_2338 opposite = new class_2338(dims.minX() == from.method_10263() ? dims.maxX() : dims.minX(), minY, dims.minZ() == from.method_10260() ? dims.maxZ() : dims.minZ());
        Claim newClaim = new Claim(opposite, to, claim.claimID, this.level);
        if (claim.is3d()) {
            newClaim.withHeight(Math.max(minY, to.method_10264()));
        }
        HashSet<Claim> conflicts = new HashSet<Claim>();
        for (Claim other : this.subClaims) {
            if (claim.equals(other) || !newClaim.intersects(other)) continue;
            conflicts.add(other);
        }
        if (conflicts.isEmpty()) {
            claim.copySizes(newClaim);
            this.setDirty(true);
        }
        return conflicts;
    }

    public boolean setPlayerGroup(UUID player, String group, boolean force) {
        if (player.equals(this.owner)) {
            return false;
        }
        if (group == null) {
            this.playersGroups.remove(player);
            this.setDirty(true);
            return true;
        }
        if (!this.playersGroups.containsKey(player) || force) {
            this.playersGroups.put(player, group);
            this.setDirty(true);
            return true;
        }
        return false;
    }

    public boolean modifyFakePlayerUUID(UUID uuid, boolean remove) {
        if (remove) {
            return this.fakePlayers.remove(uuid);
        }
        return this.fakePlayers.add(uuid);
    }

    public List<GameProfile> playersFromGroup(MinecraftServer server, String group) {
        ArrayList l = new ArrayList();
        this.playersGroups.forEach((uuid, g) -> {
            if (g.equals(group)) {
                l.add(uuid);
            }
        });
        ArrayList<GameProfile> profs = new ArrayList<GameProfile>();
        l.forEach(uuid -> server.method_3793().method_14512(uuid).ifPresent(profs::add));
        profs.sort(Comparator.comparing(GameProfile::getName));
        return profs;
    }

    public List<String> getAllowedFakePlayerUUID() {
        return this.fakePlayers.stream().map(UUID::toString).toList();
    }

    public boolean editGlobalPerms(class_3222 player, class_2960 toggle, int mode) {
        if (player != null && !this.canInteract(player, BuiltinPermission.EDITPERMS, player.method_24515()) || !this.isAdminClaim() && ConfigHandler.CONFIG.globallyDefined(this.level, toggle)) {
            return false;
        }
        if (mode > 1) {
            mode = -1;
        }
        if (mode == -1) {
            this.globalPerm.remove(toggle);
        } else {
            this.globalPerm.put(toggle, mode == 1);
        }
        this.setDirty(true);
        return true;
    }

    public boolean editPerms(class_3222 player, String group, class_2960 perm, int mode) {
        return this.editPerms(player, group, perm, mode, false);
    }

    public boolean editPerms(class_3222 player, String group, class_2960 perm, int mode, boolean alwaysCan) {
        if (PermissionManager.getInstance().isGlobalPermission(perm) || !this.isAdminClaim() && ConfigHandler.CONFIG.globallyDefined(this.level, perm)) {
            return false;
        }
        if (alwaysCan || this.canInteract(player, BuiltinPermission.EDITPERMS, player.method_24515())) {
            boolean has;
            HashMap<class_2960, Boolean> perms;
            if (mode > 1) {
                mode = -1;
            }
            Map<class_2960, Boolean> map = perms = (has = this.permissions.containsKey(group)) ? this.permissions.get(group) : new HashMap<class_2960, Boolean>();
            if (mode == -1) {
                perms.remove(perm);
            } else {
                perms.put(perm, mode == 1);
            }
            if (!has) {
                this.permissions.put(group, perms);
            }
            this.setDirty(true);
            return true;
        }
        return false;
    }

    public boolean removePermGroup(class_3222 player, String group) {
        if (this.canInteract(player, BuiltinPermission.EDITPERMS, player.method_24515())) {
            this.permissions.remove(group);
            ArrayList toRemove = new ArrayList();
            this.playersGroups.forEach((uuid, g) -> {
                if (g.equals(group)) {
                    toRemove.add(uuid);
                }
            });
            toRemove.forEach(this.playersGroups::remove);
            this.setDirty(true);
            return true;
        }
        return false;
    }

    public int groupHasPerm(String rank, class_2960 perm) {
        if (!this.permissions.containsKey(rank) || !this.permissions.get(rank).containsKey(perm)) {
            return -1;
        }
        return this.permissions.get(rank).get(perm) != false ? 1 : 0;
    }

    public List<String> groups() {
        ArrayList<String> l = new ArrayList<String>(this.permissions.keySet());
        l.sort(null);
        return l;
    }

    public boolean setHomePos(class_2338 homePos) {
        if (this.insideClaim(homePos)) {
            this.homePos = homePos;
            this.setDirty(true);
            return true;
        }
        return false;
    }

    public void addPotion(class_6880<class_1291> effect, int duration, int amplifier) {
        this.potions.put(effect, (Pair<Integer, Integer>)Pair.of((Object)duration, (Object)amplifier));
        this.setDirty(true);
    }

    public void removePotion(class_6880<class_1291> effect) {
        this.potions.remove(effect);
        this.setDirty(true);
    }

    public Map<class_6880<class_1291>, Pair<Integer, Integer>> getPotions() {
        return this.potions;
    }

    public void applyEffects(class_3222 player) {
        if (player.method_51469().method_8510() % 20L == 0L) {
            this.potions.forEach((effect, meta) -> {
                class_1293 inst = player.method_6112(effect);
                if (inst == null || inst.method_5584() <= 20 || effect.method_55838(class_1294.field_5925) && inst.method_5584() <= 220) {
                    player.method_37222(new class_1293(effect, ((Integer)meta.getFirst()).intValue(), (Integer)meta.getSecond() - 1, true, false), null);
                }
            });
        }
    }

    public class_2338 getHomePos() {
        return this.homePos;
    }

    public void setEnterTitle(class_2561 title, class_2561 sub) {
        if (title != null && title.getString().equals("$empty")) {
            title = null;
        }
        if (sub != null && sub.getString().equals("$empty")) {
            sub = null;
        }
        this.enterTitle = title;
        this.enterSubtitle = sub;
        this.setDirty(true);
    }

    public void setLeaveTitle(class_2561 title, class_2561 sub) {
        if (title != null && title.getString().equals("$empty")) {
            title = null;
        }
        if (sub != null && sub.getString().equals("$empty")) {
            sub = null;
        }
        this.leaveTitle = title;
        this.leaveSubtitle = sub;
        this.setDirty(true);
    }

    private void displayTitleMessage(class_3222 player, @Nullable class_2561 title, @Nullable class_2561 subtitle) {
        if ((title = this.transformForDisplay(title)) == null) {
            return;
        }
        subtitle = this.transformForDisplay(subtitle);
        if (ConfigHandler.CONFIG.claimDisplayActionBar) {
            if (subtitle != null) {
                class_5250 message = title.method_27661().method_10852((class_2561)class_2561.method_43470((String)" | ").method_10862(class_2583.field_24360.method_10977(class_124.field_1068))).method_10852(subtitle);
                player.method_7353((class_2561)message, true);
                return;
            }
            player.method_7353(title, true);
            return;
        }
        player.field_13987.method_14364((class_2596)new class_5904(title));
        if (subtitle != null) {
            player.field_13987.method_14364((class_2596)new class_5903(subtitle));
        }
    }

    @Nullable
    private class_2561 transformForDisplay(class_2561 component) {
        class_5250 res;
        if (component == null) {
            return null;
        }
        String claimName = this.getClaimName();
        class_7417 class_74172 = component.method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 trans = (class_2588)class_74172;
            res = class_2561.method_43469((String)trans.method_11022(), (Object[])new Object[]{this.isAdminClaim() ? "Admin" : ClaimUtils.fetchUsername(this.owner, this.level.method_8503(), true).orElse("<UNKNOWN>"), claimName});
        } else {
            class_74172 = component.method_10851();
            if (class_74172 instanceof class_8828) {
                class_8828 comp = (class_8828)class_74172;
                res = class_2561.method_43469((String)comp.comp_737(), (Object[])new Object[]{this.isAdminClaim() ? "Admin" : ClaimUtils.fetchUsername(this.owner, this.level.method_8503(), true).orElse("<UNKNOWN>"), claimName});
            } else {
                res = component.method_27662();
            }
        }
        res.method_10855().addAll(component.method_10855().stream().map(this::transformForDisplay).toList());
        res.method_10862(component.method_10866());
        return res;
    }

    public void displayEnterTitle(class_3222 player) {
        this.displayTitleMessage(player, this.enterTitle, this.enterSubtitle);
    }

    public void displayLeaveTitle(class_3222 player) {
        this.displayTitleMessage(player, this.leaveTitle, this.leaveSubtitle);
    }

    public void setDirty(boolean flag) {
        if (this.parentClaim() != null) {
            this.parentClaim().setDirty(flag);
        } else {
            this.dirty = flag;
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void readJson(JsonObject obj, UUID uuid) {
        try {
            JsonArray home;
            this.claimID = UUID.fromString(obj.get("ID").getAsString());
            this.claimName = ConfigHandler.fromJson(obj, "Name", "");
            JsonArray pos = obj.getAsJsonArray("PosxXzZY");
            this.minX = pos.get(0).getAsInt();
            this.maxX = pos.get(1).getAsInt();
            this.minZ = pos.get(2).getAsInt();
            this.maxZ = pos.get(3).getAsInt();
            this.minY = pos.get(4).getAsInt();
            if (obj.has("MaxY")) {
                this.maxY = obj.get("MaxY").getAsInt();
            }
            this.homePos = (home = ConfigHandler.arrayFromJson(obj, "Home")).size() != 3 ? this.getDefaultCenterPos() : new class_2338(home.get(0).getAsInt(), home.get(1).getAsInt(), home.get(2).getAsInt());
            class_6903 ops = this.level.method_30349().method_57093((DynamicOps)JsonOps.INSTANCE);
            this.enterTitle = this.readComponent(obj, "EnterTitle", (DynamicOps<JsonElement>)ops);
            this.enterSubtitle = this.readComponent(obj, "EnterSubtitle", (DynamicOps<JsonElement>)ops);
            this.leaveTitle = this.readComponent(obj, "LeaveTitle", (DynamicOps<JsonElement>)ops);
            this.leaveSubtitle = this.readComponent(obj, "LeaveSubtitle", (DynamicOps<JsonElement>)ops);
            JsonObject potion = ConfigHandler.fromJson(obj, "Potions");
            potion.entrySet().forEach(e -> class_7923.field_41174.method_10223(class_2960.method_60654((String)((String)e.getKey()))).ifPresent(effect -> {
                if (((JsonElement)e.getValue()).isJsonObject()) {
                    JsonObject potionObj = ((JsonElement)e.getValue()).getAsJsonObject();
                    this.potions.put((class_6880<class_1291>)effect, (Pair<Integer, Integer>)Pair.of((Object)class_3518.method_15260((JsonObject)potionObj, (String)"Duration"), (Object)class_3518.method_15260((JsonObject)potionObj, (String)"Amplifier")));
                } else {
                    int duration = effect.method_55838(class_1294.field_5925) ? 400 : 200;
                    this.potions.put((class_6880<class_1291>)effect, (Pair<Integer, Integer>)Pair.of((Object)duration, (Object)((JsonElement)e.getValue()).getAsInt()));
                }
            }));
            this.owner = ConfigHandler.fromJson(obj, "AdminClaim", false) ? null : uuid;
            JsonObject allowedEntryObj = ConfigHandler.fromJson(obj, "AllowedEntries");
            if (obj.has("AllowedItems")) {
                allowedEntryObj.add(ClaimAllowListKey.ITEM_USE.id().toString(), (JsonElement)ConfigHandler.arrayFromJson(obj, "AllowedItems"));
            }
            if (obj.has("AllowedUseBlocks")) {
                allowedEntryObj.add(ClaimAllowListKey.BLOCK_BREAK.id().toString(), (JsonElement)ConfigHandler.arrayFromJson(obj, "AllowedUseBlocks"));
            }
            if (obj.has("AllowedBreakBlocks")) {
                allowedEntryObj.add(ClaimAllowListKey.BLOCK_USE.id().toString(), (JsonElement)ConfigHandler.arrayFromJson(obj, "AllowedBreakBlocks"));
            }
            if (obj.has("AllowedEntityAttack")) {
                allowedEntryObj.add(ClaimAllowListKey.ENTITY_ATTACK.id().toString(), (JsonElement)ConfigHandler.arrayFromJson(obj, "AllowedEntityAttack"));
            }
            if (obj.has("AllowedEntityUse")) {
                allowedEntryObj.add(ClaimAllowListKey.ENTITY_USE.id().toString(), (JsonElement)ConfigHandler.arrayFromJson(obj, "AllowedEntityUse"));
            }
            this.allowedEntries.load((JsonElement)allowedEntryObj);
            this.globalPerm.clear();
            this.permissions.clear();
            this.subClaims.clear();
            if (obj.has("Parent")) {
                this.parent = UUID.fromString(obj.get("Parent").getAsString());
            }
            if (obj.has("GlobalPerms")) {
                if (this.parent == null) {
                    obj.getAsJsonArray("GlobalPerms").forEach(perm -> this.globalPerm.put(BuiltinPermission.tryLegacy(perm.getAsString()), true));
                } else {
                    obj.getAsJsonObject("GlobalPerms").entrySet().forEach(entry -> this.globalPerm.put(BuiltinPermission.tryLegacy((String)entry.getKey()), ((JsonElement)entry.getValue()).getAsBoolean()));
                }
            }
            ConfigHandler.fromJson(obj, "PermGroup").entrySet().forEach(key -> {
                HashMap map = new HashMap();
                JsonObject group = ((JsonElement)key.getValue()).getAsJsonObject();
                group.entrySet().forEach(gkey -> map.put(BuiltinPermission.tryLegacy((String)gkey.getKey()), ((JsonElement)gkey.getValue()).getAsBoolean()));
                this.permissions.put((String)key.getKey(), map);
            });
            ConfigHandler.fromJson(obj, "PlayerPerms").entrySet().forEach(key -> this.playersGroups.put(UUID.fromString((String)key.getKey()), ((JsonElement)key.getValue()).getAsString()));
            ConfigHandler.arrayFromJson(obj, "SubClaims").forEach(sub -> this.subClaims.add(Claim.fromJson(sub.getAsJsonObject(), this.owner, this.level)));
            ConfigHandler.arrayFromJson(obj, "FakePlayers").forEach(e -> {
                try {
                    this.fakePlayers.add(UUID.fromString(e.getAsString()));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            });
        }
        catch (Exception e2) {
            throw new IllegalStateException("Error reading claim data for claim " + String.valueOf(uuid));
        }
    }

    private class_2561 readComponent(JsonObject obj, String name, DynamicOps<JsonElement> ops) {
        if (!obj.has(name)) {
            return null;
        }
        JsonElement message = obj.get(name);
        if (message.isJsonPrimitive()) {
            String legacy = message.getAsString();
            if (!legacy.startsWith("{")) {
                return null;
            }
            message = (JsonElement)ConfigHandler.GSON.fromJson(legacy, JsonObject.class);
            Flan.LOGGER.info("Converted legacy component {}", (Object)message);
        }
        return class_8824.field_46597.parse(ops, (Object)message).ifError(arg_0 -> ((Logger)Flan.LOGGER).error(arg_0)).result().orElse(null);
    }

    public JsonObject toJson(JsonObject obj) {
        JsonArray list;
        obj.addProperty("ID", this.claimID.toString());
        obj.addProperty("Name", this.claimName);
        JsonArray pos = new JsonArray();
        pos.add((Number)this.minX);
        pos.add((Number)this.maxX);
        pos.add((Number)this.minZ);
        pos.add((Number)this.maxZ);
        pos.add((Number)this.minY);
        obj.add("PosxXzZY", (JsonElement)pos);
        if (this.maxY != null) {
            obj.addProperty("MaxY", (Number)this.maxY);
        }
        JsonArray home = new JsonArray();
        home.add((Number)this.homePos.method_10263());
        home.add((Number)this.homePos.method_10264());
        home.add((Number)this.homePos.method_10260());
        obj.add("Home", (JsonElement)home);
        class_6903 ops = this.level.method_30349().method_57093((DynamicOps)JsonOps.INSTANCE);
        obj.add("EnterTitle", (JsonElement)(this.enterTitle == null ? JsonNull.INSTANCE : (JsonElement)class_8824.field_46597.encodeStart((DynamicOps)ops, (Object)this.enterTitle).getOrThrow()));
        obj.add("EnterSubtitle", (JsonElement)(this.enterSubtitle == null ? JsonNull.INSTANCE : (JsonElement)class_8824.field_46597.encodeStart((DynamicOps)ops, (Object)this.enterSubtitle).getOrThrow()));
        obj.add("LeaveTitle", (JsonElement)(this.leaveTitle == null ? JsonNull.INSTANCE : (JsonElement)class_8824.field_46597.encodeStart((DynamicOps)ops, (Object)this.leaveTitle).getOrThrow()));
        obj.add("LeaveSubtitle", (JsonElement)(this.leaveSubtitle == null ? JsonNull.INSTANCE : (JsonElement)class_8824.field_46597.encodeStart((DynamicOps)ops, (Object)this.leaveSubtitle).getOrThrow()));
        JsonObject potions = new JsonObject();
        this.potions.forEach((effect, meta) -> {
            JsonObject potionObj = new JsonObject();
            potionObj.addProperty("Duration", (Number)meta.getFirst());
            potionObj.addProperty("Amplifier", (Number)meta.getSecond());
            potions.add(effect.method_55840(), (JsonElement)potionObj);
        });
        obj.add("Potions", (JsonElement)potions);
        if (this.parent != null) {
            obj.addProperty("Parent", this.parent.toString());
        }
        obj.add("AllowedEntries", this.allowedEntries.save());
        if (!this.globalPerm.isEmpty()) {
            JsonArray gPerm;
            if (this.parent == null) {
                gPerm = new JsonArray();
                this.globalPerm.forEach((arg_0, arg_1) -> Claim.lambda$toJson$27((JsonElement)gPerm, arg_0, arg_1));
            } else {
                gPerm = new JsonObject();
                this.globalPerm.forEach((arg_0, arg_1) -> Claim.lambda$toJson$28((JsonElement)gPerm, arg_0, arg_1));
            }
            obj.add("GlobalPerms", (JsonElement)gPerm);
        }
        if (!this.permissions.isEmpty()) {
            JsonObject perms = new JsonObject();
            this.permissions.forEach((s, pmap) -> {
                JsonObject group = new JsonObject();
                pmap.forEach((perm, bool) -> group.addProperty(perm.toString(), bool));
                perms.add(s, (JsonElement)group);
            });
            obj.add("PermGroup", (JsonElement)perms);
        }
        if (!this.playersGroups.isEmpty()) {
            JsonObject pl = new JsonObject();
            this.playersGroups.forEach((uuid, s) -> pl.addProperty(uuid.toString(), s));
            obj.add("PlayerPerms", (JsonElement)pl);
        }
        if (!this.subClaims.isEmpty()) {
            list = new JsonArray();
            this.subClaims.forEach(p -> list.add((JsonElement)p.toJson(new JsonObject())));
            obj.add("SubClaims", (JsonElement)list);
        }
        if (!this.fakePlayers.isEmpty()) {
            list = new JsonArray();
            this.fakePlayers.forEach(uuid -> list.add(uuid.toString()));
            obj.add("FakePlayers", (JsonElement)list);
        }
        return obj;
    }

    public int hashCode() {
        return this.claimID == null ? this.getDimensions().hashCode() : this.claimID.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Claim) {
            Claim other = (Claim)obj;
            if (this.claimID == null && other.claimID == null) {
                return this.getDimensions().equals(other.getDimensions());
            }
            if (this.claimID != null) {
                return this.claimID.equals(other.claimID);
            }
        }
        return false;
    }

    public String toString() {
        return String.format("Claim:[ID=%s, Owner=%s, from: [x=%d,z=%d], to: [x=%d,z=%d]", this.claimID != null ? this.claimID.toString() : "null", this.owner != null ? this.owner.toString() : "Admin", this.minX, this.minZ, this.maxX, this.maxZ);
    }

    public String nameAndPosition() {
        String name = this.getClaimName();
        if (name.isEmpty()) {
            return String.format("[x=%d,z=%d]-[x=%d,z=%d]", this.minX, this.minZ, this.maxX, this.maxZ);
        }
        return String.format("%s:[x=%d,z=%d]-[x=%d,z=%d]", name, this.minX, this.minZ, this.maxX, this.maxZ);
    }

    public String formattedClaim() {
        String name = this.getClaimName();
        if (name.isEmpty()) {
            return String.format("[x=%d,z=%d] - [x=%d,z=%d] = %d blocks", this.minX, this.minZ, this.maxX, this.maxZ, this.getPlane());
        }
        return String.format("%s:[x=%d,z=%d] - [x=%d,z=%d] = %d blocks", name, this.minX, this.minZ, this.maxX, this.maxZ, this.getPlane());
    }

    public List<class_2561> infoString(class_3222 player, InfoType infoType) {
        boolean perms = this.canInteract(player, BuiltinPermission.EDITPERMS, player.method_24515());
        ArrayList<class_2561> l = new ArrayList<class_2561>();
        l.add((class_2561)ClaimUtils.translatedText("=============================================", class_124.field_1060));
        String ownerName = this.isAdminClaim() ? "Admin" : ClaimUtils.fetchUsername(this.owner, this.level.method_8503(), true).orElse(this.owner.toString());
        String claimName = this.getClaimName();
        if (this.parent == null) {
            if (claimName.isEmpty()) {
                l.add((class_2561)ClaimUtils.translatedText("flan.claimBasicInfo", ownerName, this.minX, this.minZ, this.maxX, this.maxZ, this.subClaims.size(), class_124.field_1065));
            } else {
                l.add((class_2561)ClaimUtils.translatedText("flan.claimBasicInfoNamed", ownerName, this.minX, this.minZ, this.maxX, this.maxZ, this.subClaims.size(), claimName, class_124.field_1065));
            }
        } else if (claimName.isEmpty()) {
            l.add((class_2561)ClaimUtils.translatedText("flan.claimBasicInfoSub", ownerName, this.minX, this.minZ, this.maxX, this.maxZ, class_124.field_1065));
        } else {
            l.add((class_2561)ClaimUtils.translatedText("flan.claimBasicInfoSubNamed", ownerName, this.minX, this.minZ, this.maxX, this.maxZ, claimName, class_124.field_1065));
        }
        if (perms) {
            if (infoType == InfoType.ALL || infoType == InfoType.GLOBAL) {
                l.add(Claim.fromPermissionMap("flan.claimInfoPerms", this.globalPerm));
            }
            if (infoType == InfoType.ALL || infoType == InfoType.GROUP) {
                l.add((class_2561)ClaimUtils.translatedText("flan.claimGroupInfoHeader", class_124.field_1065));
                HashMap nameToGroup = new HashMap();
                for (Map.Entry<UUID, String> entry : this.playersGroups.entrySet()) {
                    ClaimUtils.fetchUsername(entry.getKey(), this.level.method_8503(), true).ifPresent(name -> nameToGroup.merge((String)e.getValue(), Lists.newArrayList((Object[])new String[]{name}), (old, val) -> {
                        old.add(name);
                        return old;
                    }));
                }
                for (Map.Entry<Object, Object> entry : this.permissions.entrySet()) {
                    l.add((class_2561)ClaimUtils.translatedText(String.format("  %s:", entry.getKey()), class_124.field_1054));
                    l.add(Claim.fromPermissionMap("flan.claimGroupPerms", (Map)entry.getValue()));
                    l.add((class_2561)ClaimUtils.translatedText("flan.claimGroupPlayers", nameToGroup.getOrDefault(entry.getKey(), new ArrayList()), class_124.field_1061));
                }
            }
        }
        l.add((class_2561)ClaimUtils.translatedText("=============================================", class_124.field_1060));
        return l;
    }

    private static class_2561 fromPermissionMap(String lang, Map<class_2960, Boolean> map) {
        class_5250 mapComp = class_2561.method_43470((String)"[").method_27692(class_124.field_1080);
        int i = 0;
        for (Map.Entry<class_2960, Boolean> entry : map.entrySet()) {
            class_5250 pComp = class_2561.method_43470((String)((i != 0 ? ", " : "") + String.valueOf(entry.getKey()) + "=")).method_27692(class_124.field_1080);
            pComp.method_10852((class_2561)class_2561.method_43470((String)entry.getValue().toString()).method_27692(entry.getValue() != false ? class_124.field_1060 : class_124.field_1061));
            mapComp.method_10852((class_2561)pComp);
            ++i;
        }
        mapComp.method_27693("]");
        return class_2561.method_43469((String)lang, (Object[])new Object[]{mapComp}).method_27692(class_124.field_1058);
    }

    public DisplayBox display() {
        return new ClaimDisplayBox(this, this::getDimensions, this::isRemoved);
    }

    private static /* synthetic */ void lambda$toJson$28(JsonElement gPerm, class_2960 perm, Boolean bool) {
        ((JsonObject)gPerm).addProperty(perm.toString(), bool);
    }

    private static /* synthetic */ void lambda$toJson$27(JsonElement gPerm, class_2960 perm, Boolean bool) {
        if (bool.booleanValue()) {
            ((JsonArray)gPerm).add(perm.toString());
        }
    }

    static interface ClaimUpdater {
        public static final Map<Integer, ClaimUpdater> UPDATER = Config.createHashMap(map -> {
            map.put(7, claim -> {
                Map<class_2960, Boolean> visitors;
                Map<class_2960, Boolean> coowner = claim.permissions.get("Co-Owner");
                if (coowner != null && coowner.isEmpty()) {
                    coowner.putAll(ConfigHandler.CONFIG.defaultGroups.getOrDefault("Co-Owner", new HashMap()));
                }
                if ((visitors = claim.permissions.get("Visitor")) != null && visitors.isEmpty()) {
                    visitors.putAll(ConfigHandler.CONFIG.defaultGroups.getOrDefault("Visitor", new HashMap()));
                }
            });
            map.put(2, claim -> claim.globalPerm.put(BuiltinPermission.LOCKITEMS, true));
        });

        public static void updateClaim(Claim claim) {
            UPDATER.entrySet().stream().filter(e -> (Integer)e.getKey() > ConfigHandler.CONFIG.preConfigVersion).map(Map.Entry::getValue).forEach(up -> up.update(claim));
        }

        public void update(Claim var1);
    }

    public static enum InfoType {
        ALL,
        SIMPLE,
        GLOBAL,
        GROUP;

    }
}

