/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.claim.attachment.ClaimAllowListKey;
import io.github.flemmli97.flan.commands.CommandClaim;
import io.github.flemmli97.flan.commands.CommandHelpers;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7066;

public class AllowListCommand {
    public static <T extends ArgumentBuilder<class_2168, T>> void register(ArgumentBuilder<class_2168, T> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"ignoreList").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.claim.ignore", false))).then(AllowListCommand.buildClaimEntryCommand(false))).then(AllowListCommand.buildClaimEntryCommand(true)));
    }

    private static LiteralArgumentBuilder<class_2168> buildClaimEntryCommand(boolean remove) {
        LiteralArgumentBuilder base = class_2170.method_9247((String)(remove ? "remove" : "add"));
        ClaimAllowListKey.keys().entrySet().stream().sorted(Map.Entry.comparingByKey(ClaimPermission.NAMESPACE_FIRST)).forEach(entry -> {
            if (remove) {
                base.then(class_2170.method_9247((String)((class_2960)entry.getKey()).toString()).then(class_2170.method_9244((String)"entry", (ArgumentType)class_7066.method_41170(((ClaimAllowListKey)entry.getValue()).registry())).suggests((src, b) -> CommandHelpers.claimEntryListSuggestion((CommandContext<class_2168>)src, b, (ClaimAllowListKey)entry.getValue())).executes(src -> AllowListCommand.removeClaimListEntries((CommandContext<class_2168>)src, (ClaimAllowListKey)entry.getValue()))));
            } else {
                base.then(class_2170.method_9247((String)((class_2960)entry.getKey()).toString()).then(class_2170.method_9244((String)"entry", (ArgumentType)class_7066.method_41170(((ClaimAllowListKey)entry.getValue()).registry())).executes(src -> AllowListCommand.addClaimListEntries((CommandContext<class_2168>)src, (ClaimAllowListKey)entry.getValue()))));
            }
        });
        return base;
    }

    private static int addClaimListEntries(CommandContext<class_2168> context, ClaimAllowListKey<?> key) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        Claim claim = CommandClaim.getClaimFromMode(context, player, BuiltinPermission.EDITCLAIM);
        if (claim == null) {
            return 0;
        }
        String result = AllowListCommand.addClaimListEntry(context, key, claim);
        class_5250 cmdFeed = ClaimUtils.translatedText("flan.addIgnoreEntry", result, key.id().toString()).method_27692(class_124.field_1065);
        ((class_2168)context.getSource()).method_9226(() -> cmdFeed, false);
        return 1;
    }

    private static int removeClaimListEntries(CommandContext<class_2168> context, ClaimAllowListKey<?> key) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        Claim claim = CommandClaim.getClaimFromMode(context, player, BuiltinPermission.EDITCLAIM);
        if (claim == null) {
            return 0;
        }
        String value = ((class_7066.class_7068)context.getArgument("entry", class_7066.class_7068.class)).method_41176();
        claim.allowedEntries.get(key).removeAllowedItem(value);
        class_5250 cmdFeed = ClaimUtils.translatedText("flan.removeIgnoreEntry", value, key.id().toString()).method_27692(class_124.field_1065);
        ((class_2168)context.getSource()).method_9226(() -> cmdFeed, false);
        return 1;
    }

    private static <T> String addClaimListEntry(CommandContext<class_2168> context, ClaimAllowListKey<T> key, Claim claim) throws CommandSyntaxException {
        class_7066.class_7068<T> value = CommandHelpers.getRegistryType(context, "entry", key.registry());
        class_2378 registry = ((class_2168)context.getSource()).method_30497().method_30530(key.registry());
        value.method_41173().ifRight(tag -> claim.allowedEntries.get(key).addAllowedItem(Either.right((Object)tag))).ifLeft(id -> registry.method_31189(id).ifPresent(entry -> claim.allowedEntries.get(key).addAllowedItem(Either.left((Object)entry))));
        return value.method_41176();
    }
}

