/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.ArrayList;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_3222;

public class ClaimBlocksCommand {
    public static <T extends ArgumentBuilder<class_2168, T>> void register(ArgumentBuilder<class_2168, T> builder) {
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"giveClaimBlocks").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.admin.give", true))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2191.method_9329()).then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(ClaimBlocksCommand::giveClaimBlocks))).then(class_2170.method_9247((String)"base").then(class_2170.method_9244((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> ClaimBlocksCommand.giveClaimBlocks((CommandContext<class_2168>)ctx, true))))));
    }

    private static int giveClaimBlocks(CommandContext<class_2168> context) throws CommandSyntaxException {
        return ClaimBlocksCommand.giveClaimBlocks(context, false);
    }

    private static int giveClaimBlocks(CommandContext<class_2168> context, boolean base) throws CommandSyntaxException {
        class_2168 src = (class_2168)context.getSource();
        ArrayList<String> players = new ArrayList<String>();
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        for (GameProfile prof : class_2191.method_9330(context, (String)"players")) {
            class_3222 player = src.method_9211().method_3760().method_14602(prof.getId());
            if (player != null) {
                PlayerClaimData data = PlayerClaimData.get(player);
                if (base) {
                    data.addClaimBlocksDirect(amount);
                } else {
                    data.setAdditionalClaims(data.getAdditionalClaims() + amount);
                }
            } else {
                PlayerClaimData.editForOfflinePlayer(src.method_9211(), prof.getId(), amount, base);
            }
            players.add(prof.getName());
        }
        src.method_9226(() -> ClaimUtils.translatedText(base ? "flan.giveClaimBlocks" : "flan.giveClaimBlocksBonus", players, amount, class_124.field_1065), true);
        return players.size();
    }
}

