/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.commands.CommandClaim;
import io.github.flemmli97.flan.commands.CommandHelpers;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2191;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class ClaimGroupCommand {
    public static <T extends ArgumentBuilder<class_2168, T>> void register(ArgumentBuilder<class_2168, T> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"group").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.group"))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"group", (ArgumentType)StringArgumentType.string()).executes(ClaimGroupCommand::addGroup)))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"group", (ArgumentType)StringArgumentType.string()).suggests(CommandHelpers::groupSuggestion).executes(ClaimGroupCommand::removeGroup)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"players").then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"group", (ArgumentType)StringArgumentType.word()).suggests(CommandHelpers::groupSuggestion).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"players", (ArgumentType)class_2191.method_9329()).executes(ClaimGroupCommand::addPlayer)).then(class_2170.method_9247((String)"overwrite").executes(ClaimGroupCommand::forceAddPlayer)))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"group", (ArgumentType)StringArgumentType.word()).suggests(CommandHelpers::groupSuggestion).then(class_2170.method_9244((String)"players", (ArgumentType)class_2191.method_9329()).suggests((context, build) -> {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            String group = StringArgumentType.getString((CommandContext)context, (String)"group");
            List<Object> list = new ArrayList();
            class_2168 src = (class_2168)context.getSource();
            ClaimStorage storage = ClaimStorage.get(src.method_9225());
            Claim claim = storage.getClaimAt(src.method_9207().method_24515());
            if (claim != null && claim.canInteract(src.method_9207(), BuiltinPermission.EDITPERMS, src.method_9207().method_24515())) {
                list = claim.playersFromGroup(player.method_5682(), group).stream().map(GameProfile::getName).toList();
            }
            return class_2172.method_9265(list, (SuggestionsBuilder)build);
        }).executes(ClaimGroupCommand::removePlayer))))));
    }

    private static int addGroup(CommandContext<class_2168> context) throws CommandSyntaxException {
        return ClaimGroupCommand.modifyGroup(context, false);
    }

    private static int removeGroup(CommandContext<class_2168> context) throws CommandSyntaxException {
        return ClaimGroupCommand.modifyGroup(context, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int modifyGroup(CommandContext<class_2168> context, boolean remove) throws CommandSyntaxException {
        Claim sub;
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String group = StringArgumentType.getString(context, (String)"group");
        Claim claim = CommandClaim.fromContext(context);
        if (claim == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)ClaimUtils.translatedText("flan.noClaim", class_124.field_1079));
            return 0;
        }
        class_2338 pos = CommandClaim.pos(context);
        if (PlayerClaimData.get((class_3222)player).getClaimMode().isSubclaim && (sub = claim.getSubClaim(pos)) != null) {
            claim = sub;
        }
        if (remove) {
            if (claim.removePermGroup(player, group)) {
                ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.groupRemove", group, class_124.field_1065), false);
                return 1;
            }
            ((class_2168)context.getSource()).method_9213((class_2561)ClaimUtils.translatedText("flan.noPermission", class_124.field_1079));
            return 0;
        }
        if (claim.groups().contains(group)) {
            ((class_2168)context.getSource()).method_9213((class_2561)ClaimUtils.translatedText("flan.groupExist", group, class_124.field_1061));
            return 0;
        }
        if (claim.editPerms(player, group, BuiltinPermission.EDITPERMS, -1)) {
            ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.groupAdd", group, class_124.field_1065), false);
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)ClaimUtils.translatedText("flan.noPermission", class_124.field_1079));
        return 0;
    }

    private static int forceAddPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        String group = StringArgumentType.getString(context, (String)"group");
        return ClaimGroupCommand.modifyPlayer(context, group, true);
    }

    private static int addPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        String group = StringArgumentType.getString(context, (String)"group");
        return ClaimGroupCommand.modifyPlayer(context, group, false);
    }

    private static int removePlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        return ClaimGroupCommand.modifyPlayer(context, null, false);
    }

    private static int modifyPlayer(CommandContext<class_2168> context, String group, boolean force) throws CommandSyntaxException {
        Claim sub;
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        Claim claim = CommandClaim.fromContext(context);
        if (claim == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)ClaimUtils.translatedText("flan.noClaim", class_124.field_1079));
            return 0;
        }
        class_2338 pos = CommandClaim.pos(context);
        if (PlayerClaimData.get((class_3222)player).getClaimMode().isSubclaim && (sub = claim.getSubClaim(pos)) != null) {
            claim = sub;
        }
        if (!claim.canInteract(player, BuiltinPermission.EDITPERMS, player.method_24515())) {
            ((class_2168)context.getSource()).method_9213((class_2561)ClaimUtils.translatedText("flan.noPermission", class_124.field_1079));
            return 0;
        }
        ArrayList<String> modified = new ArrayList<String>();
        for (GameProfile prof : class_2191.method_9330(context, (String)"players")) {
            if (!claim.setPlayerGroup(prof.getId(), group, force)) continue;
            modified.add(prof.getName());
        }
        if (group == null) {
            if (!modified.isEmpty()) {
                ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.playerRemove", modified, class_124.field_1065), false);
            } else {
                ((class_2168)context.getSource()).method_9213((class_2561)ClaimUtils.translatedText("flan.playerRemoveNo", class_124.field_1061));
            }
        } else if (!modified.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.playerModify", group, modified, class_124.field_1065), false);
        } else {
            ((class_2168)context.getSource()).method_9213((class_2561)ClaimUtils.translatedText("flan.playerModifyNo", group, class_124.field_1061));
        }
        return modified.size();
    }
}

