/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.commands.CommandClaim;
import io.github.flemmli97.flan.commands.PendingCommand;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.ClaimMode;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class DeleteClaimCommand {
    public static <T extends ArgumentBuilder<class_2168, T>> void register(ArgumentBuilder<class_2168, T> builder) {
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"delete").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.delete"))).executes(DeleteClaimCommand::deleteClaim)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"deleteAll").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.delete.all"))).executes(DeleteClaimCommand::deleteAllClaim)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"deleteSubClaim").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.delete.sub"))).executes(DeleteClaimCommand::deleteSubClaim)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"deleteAllSubClaims").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.delete.sub.all"))).executes(DeleteClaimCommand::deleteAllSubClaim)).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"adminDelete").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.admin.delete", true))).executes(DeleteClaimCommand::adminDelete)).then(class_2170.method_9247((String)"all").then(class_2170.method_9244((String)"players", (ArgumentType)class_2191.method_9329()).executes(DeleteClaimCommand::adminDeleteAll))));
    }

    private static int deleteClaim(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        ClaimStorage storage = ClaimStorage.get(((class_2168)context.getSource()).method_9225());
        Claim claim = CommandClaim.fromContext(context);
        boolean check = CommandClaim.check(player, player.method_24515(), claim, BuiltinPermission.EDITCLAIM, b -> {
            if (b.isEmpty()) {
                ((class_2168)context.getSource()).method_9213((class_2561)ClaimUtils.translatedText("flan.noClaim", class_124.field_1079));
            } else if (!((Boolean)b.get()).booleanValue()) {
                ((class_2168)context.getSource()).method_9213((class_2561)ClaimUtils.translatedText("flan.deleteClaimError", class_124.field_1079));
            }
        });
        if (!check) {
            return 0;
        }
        if (!storage.deleteClaim(claim, true, PlayerClaimData.get(player).getClaimMode(), ((class_2168)context.getSource()).method_9225())) {
            ((class_2168)context.getSource()).method_9213((class_2561)ClaimUtils.translatedText("flan.deleteSubClaimError", class_124.field_1079));
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.deleteClaim", class_124.field_1061), false);
        return 1;
    }

    private static int deleteAllClaim(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        PlayerClaimData data = PlayerClaimData.get(((class_2168)context.getSource()).method_9207());
        data.deferCommand(new PendingCommand(context, () -> {
            for (class_3218 level : ((class_2168)context.getSource()).method_9211().method_3738()) {
                ClaimStorage storage = ClaimStorage.get(level);
                storage.allClaimsFromPlayer(player.method_5667()).forEach(claim -> storage.deleteClaim((Claim)claim, true, data.getClaimMode(), level));
            }
            ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.deleteAllClaim", class_124.field_1065), false);
            return 1;
        }));
        ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.confirmCommand", class_124.field_1065), true);
        return 1;
    }

    private static int deleteSubClaim(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        Claim claim = CommandClaim.fromContext(context);
        if (claim == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)ClaimUtils.translatedText("flan.noClaim", class_124.field_1061));
            return 0;
        }
        Claim sub = claim.getSubClaim(CommandClaim.pos(context));
        if (sub == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)ClaimUtils.translatedText("flan.noSubClaim", class_124.field_1061));
            return 0;
        }
        boolean check = CommandClaim.check(player, player.method_24515(), claim, BuiltinPermission.EDITCLAIM, b -> {
            if (b.isEmpty()) {
                ((class_2168)context.getSource()).method_9213((class_2561)ClaimUtils.translatedText("flan.noClaim", class_124.field_1079));
            } else if (!((Boolean)b.get()).booleanValue()) {
                ((class_2168)context.getSource()).method_9213((class_2561)ClaimUtils.translatedText("flan.deleteClaimError", class_124.field_1079));
            } else {
                ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.deleteSubClaim", class_124.field_1079), false);
            }
        });
        if (!check) {
            return 0;
        }
        claim.deleteSubClaim(sub);
        return 1;
    }

    private static int deleteAllSubClaim(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        Claim claim = CommandClaim.fromContext(context);
        boolean check = CommandClaim.check(player, CommandClaim.pos(context), claim, BuiltinPermission.EDITCLAIM, CommandClaim.genericNoPermMessage((class_2168)context.getSource()));
        if (!check) {
            return 0;
        }
        PlayerClaimData data = PlayerClaimData.get(((class_2168)context.getSource()).method_9207());
        data.deferCommand(new PendingCommand(context, () -> {
            List<Claim> subs = claim.getAllSubclaims();
            subs.forEach(claim::deleteSubClaim);
            ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.deleteSubClaimAll", class_124.field_1079), false);
            return 1;
        }));
        ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.confirmCommand", class_124.field_1065), true);
        return 1;
    }

    private static int adminDelete(CommandContext<class_2168> context) {
        class_2168 src = (class_2168)context.getSource();
        ClaimStorage storage = ClaimStorage.get(src.method_9225());
        Claim claim = CommandClaim.fromContext(context);
        if (claim == null) {
            src.method_9226(() -> ClaimUtils.translatedText("flan.noClaim", class_124.field_1061), false);
            return 0;
        }
        storage.deleteClaim(claim, true, ClaimMode.DEFAULT, src.method_9225());
        src.method_9226(() -> ClaimUtils.translatedText("flan.deleteClaim", class_124.field_1061), true);
        return 1;
    }

    private static int adminDeleteAll(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 src = (class_2168)context.getSource();
        Collection profiles = class_2191.method_9330(context, (String)"players");
        class_1297 class_12972 = src.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            PlayerClaimData data = PlayerClaimData.get(player);
            data.deferCommand(new PendingCommand(context, () -> {
                ArrayList<String> players = new ArrayList<String>();
                for (GameProfile prof : profiles) {
                    for (class_3218 level : src.method_9225().method_8503().method_3738()) {
                        ClaimStorage storage = ClaimStorage.get(level);
                        storage.allClaimsFromPlayer(prof.getId()).forEach(claim -> storage.deleteClaim((Claim)claim, true, ClaimMode.DEFAULT, level));
                    }
                    players.add(prof.getName());
                }
                src.method_9226(() -> ClaimUtils.translatedText("flan.adminDeleteAll", players, class_124.field_1065), true);
                return 1;
            }));
            ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.confirmCommand", class_124.field_1065), true);
            return 1;
        }
        ArrayList<String> players = new ArrayList<String>();
        for (GameProfile prof : profiles) {
            for (class_3218 level : src.method_9225().method_8503().method_3738()) {
                ClaimStorage storage = ClaimStorage.get(level);
                storage.allClaimsFromPlayer(prof.getId()).forEach(claim -> storage.deleteClaim((Claim)claim, true, ClaimMode.DEFAULT, level));
            }
            players.add(prof.getName());
        }
        src.method_9226(() -> ClaimUtils.translatedText("flan.adminDeleteAll", players, class_124.field_1065), true);
        return 1;
    }
}

