/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimBox;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.ClaimMode;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3545;

public class ExpandCommand {
    public static <T extends ArgumentBuilder<class_2168, T>> void register(ArgumentBuilder<class_2168, T> builder) {
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"expand").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.claim.create"))).then(class_2170.method_9244((String)"distance", (ArgumentType)IntegerArgumentType.integer()).executes(ExpandCommand::expandClaim)));
    }

    private static int expandClaim(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        ClaimStorage storage = ClaimStorage.get(player.method_51469());
        ClaimMode mode = PlayerClaimData.get(player).getClaimMode();
        int amount = IntegerArgumentType.getInteger(context, (String)"distance");
        Claim claim = ExpandCommand.findClaim((class_2168)context.getSource(), player, storage, mode);
        if (claim == null) {
            return 0;
        }
        if (!ExpandCommand.checkExpandPermission((class_2168)context.getSource(), player, claim, mode)) {
            return 0;
        }
        if (amount <= 0) {
            ExpandCommand.sendExpandError((class_2168)context.getSource(), "flan.invalidDistance", new Object[0]);
            return 0;
        }
        class_2350 facing = player.method_5735();
        if (!(claim.is3d() && mode.is3d || facing != class_2350.field_11036 && facing != class_2350.field_11033)) {
            ExpandCommand.sendExpandError((class_2168)context.getSource(), facing == class_2350.field_11036 ? "flan.expandUpDisabled" : "flan.expandDownDisabled", new Object[0]);
            return 0;
        }
        ClaimBox dims = claim.getDimensions();
        class_3545<class_2338, class_2338> corners = ExpandCommand.calculateCorners(dims, facing, amount, claim.parentClaim() != null ? claim.parentClaim().getDimensions() : null);
        boolean success = ExpandCommand.performExpansion(player, storage, claim, corners);
        if (!success) {
            ExpandCommand.sendExpandError((class_2168)context.getSource(), "flan.expandFailed", new Object[0]);
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.expandSuccess", amount, class_124.field_1060), false);
        return 1;
    }

    private static class_3545<class_2338, class_2338> calculateCorners(ClaimBox dims, class_2350 facing, int amount, ClaimBox restriction) {
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11035 -> new class_3545((Object)new class_2338(dims.maxX(), dims.minY(), dims.maxZ()), (Object)new class_2338(dims.maxX(), dims.maxY(), restriction != null ? Math.min(dims.maxZ() + amount, restriction.maxZ()) : dims.maxZ() + amount));
            case class_2350.field_11034 -> new class_3545((Object)new class_2338(dims.maxX(), dims.minY(), dims.maxZ()), (Object)new class_2338(restriction != null ? Math.min(dims.maxX() + amount, restriction.maxX()) : dims.maxX() + amount, dims.maxY(), dims.maxZ()));
            case class_2350.field_11043 -> new class_3545((Object)new class_2338(dims.minX(), dims.minY(), dims.minZ()), (Object)new class_2338(dims.minX(), dims.maxY(), restriction != null ? Math.max(dims.minZ() - amount, restriction.minZ()) : dims.minZ() - amount));
            case class_2350.field_11039 -> new class_3545((Object)new class_2338(dims.minX(), dims.minY(), dims.minZ()), (Object)new class_2338(restriction != null ? Math.max(dims.minX() - amount, restriction.minX()) : dims.minX() - amount, dims.maxY(), dims.minZ()));
            case class_2350.field_11036 -> new class_3545((Object)new class_2338(dims.minX(), dims.maxY(), dims.minZ()), (Object)new class_2338(dims.maxX(), restriction != null ? Math.min(dims.maxY() + amount, restriction.maxY()) : dims.maxY() + amount, dims.maxZ()));
            case class_2350.field_11033 -> new class_3545((Object)new class_2338(dims.minX(), dims.minY(), dims.minZ()), (Object)new class_2338(dims.maxX(), restriction != null ? Math.max(dims.minY() - amount, restriction.minY()) : dims.minY() - amount, dims.maxZ()));
        };
    }

    private static Claim findClaim(class_2168 source, class_3222 player, ClaimStorage storage, ClaimMode mode) {
        Claim claim = storage.getClaimAt(player.method_24515());
        if (claim == null) {
            source.method_9213((class_2561)ClaimUtils.translatedText("flan.noClaim", class_124.field_1079));
            return null;
        }
        if (mode.isSubclaim) {
            Claim subClaim = claim.getSubClaim(player.method_24515());
            if (subClaim == null) {
                source.method_9213((class_2561)ClaimUtils.translatedText("flan.noSubClaim", class_124.field_1061));
                return null;
            }
            return subClaim;
        }
        return claim;
    }

    private static boolean performExpansion(class_3222 player, ClaimStorage storage, Claim claim, class_3545<class_2338, class_2338> corners) {
        if (claim.isSubclaim()) {
            Claim parent = claim.parentClaim();
            if (parent == null) {
                return false;
            }
            Set<Claim> conflicts = parent.resizeSubclaim(claim, (class_2338)corners.method_15442(), (class_2338)corners.method_15441());
            return conflicts.isEmpty();
        }
        return storage.resizeClaim(claim, (class_2338)corners.method_15442(), (class_2338)corners.method_15441(), player);
    }

    private static boolean checkExpandPermission(class_2168 source, class_3222 player, Claim claim, ClaimMode mode) {
        if (mode.isSubclaim) {
            Claim parent = claim.parentClaim();
            if (parent == null || !claim.canInteract(player, BuiltinPermission.EDITCLAIM, player.method_24515()) || !parent.canInteract(player, BuiltinPermission.EDITCLAIM, player.method_24515())) {
                source.method_9213((class_2561)ClaimUtils.translatedText("flan.noPermission", class_124.field_1079));
                return false;
            }
        } else if (!claim.canInteract(player, BuiltinPermission.EDITCLAIM, player.method_24515())) {
            source.method_9213((class_2561)ClaimUtils.translatedText("flan.noPermission", class_124.field_1079));
            return false;
        }
        return true;
    }

    private static void sendExpandError(class_2168 source, String key, Object ... args) {
        source.method_9213((class_2561)ClaimUtils.translatedText("flan.expandError", ClaimUtils.translatedText(key, args)).method_27692(class_124.field_1061));
    }
}

