/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.commands.CommandClaim;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5242;

public class FakePlayerCommand {
    public static <T extends ArgumentBuilder<class_2168, T>> void register(ArgumentBuilder<class_2168, T> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"fakePlayer").executes(FakePlayerCommand::toggleFakePlayer)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.fakeplayer"))).then(class_2170.method_9244((String)"uuid", (ArgumentType)class_5242.method_27643()).executes(FakePlayerCommand::addFakePlayer)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.fakeplayer"))).then(class_2170.method_9244((String)"uuid", (ArgumentType)class_5242.method_27643()).suggests((context, build) -> {
            List<Object> list = new ArrayList();
            class_2168 src = (class_2168)context.getSource();
            ClaimStorage storage = ClaimStorage.get(src.method_9225());
            Claim claim = storage.getClaimAt(src.method_9207().method_24515());
            if (claim != null && claim.canInteract(src.method_9207(), BuiltinPermission.EDITPERMS, src.method_9207().method_24515())) {
                list = claim.getAllowedFakePlayerUUID();
            }
            return class_2172.method_9265(list, (SuggestionsBuilder)build);
        }).executes(FakePlayerCommand::removeFakePlayer))));
    }

    private static int toggleFakePlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        PlayerClaimData data;
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        data.setFakePlayerNotif(!(data = PlayerClaimData.get(player)).hasFakePlayerNotificationOn());
        ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.fakePlayerNotification", data.hasFakePlayerNotificationOn(), class_124.field_1065), false);
        return 1;
    }

    private static int addFakePlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        return FakePlayerCommand.modifyFakePlayer(context, false);
    }

    private static int removeFakePlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
        return FakePlayerCommand.modifyFakePlayer(context, true);
    }

    private static int modifyFakePlayer(CommandContext<class_2168> context, boolean remove) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        Claim claim = CommandClaim.getClaimFromMode(context, player, BuiltinPermission.EDITPERMS);
        if (claim == null) {
            return 0;
        }
        UUID uuid = class_5242.method_27645(context, (String)"uuid");
        if (claim.modifyFakePlayerUUID(uuid, remove)) {
            if (!remove) {
                ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.uuidFakeAdd", uuid, class_124.field_1065), false);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.uuidFakeRemove", uuid, class_124.field_1065), false);
            }
            return 1;
        }
        ((class_2168)context.getSource()).method_9213((class_2561)ClaimUtils.translatedText("flan.uuidFakeModifyNo", class_124.field_1061));
        return 0;
    }
}

