/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.commands.CommandHelpers;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2338;
import net.minecraft.class_3222;

public class TeleportCommand {
    public static <T extends ArgumentBuilder<class_2168, T>> void register(ArgumentBuilder<class_2168, T> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"teleport").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.teleport"))).then(class_2170.method_9247((String)"self").then(class_2170.method_9244((String)"claim", (ArgumentType)StringArgumentType.string()).suggests((ctx, b) -> CommandHelpers.claimSuggestions((CommandContext<class_2168>)ctx, b, ((class_2168)ctx.getSource()).method_9207().method_5667())).executes(TeleportCommand::teleport)))).then(class_2170.method_9247((String)"global").then(class_2170.method_9244((String)"claim", (ArgumentType)StringArgumentType.string()).suggests((ctx, b) -> CommandHelpers.claimSuggestions((CommandContext<class_2168>)ctx, b, null)).executes(TeleportCommand::teleportAdminClaims)))).then(class_2170.method_9247((String)"other").then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).then(class_2170.method_9244((String)"claim", (ArgumentType)StringArgumentType.string()).suggests((ctx, b) -> CommandHelpers.claimSuggestions((CommandContext<class_2168>)ctx, b, CommandHelpers.singleProfile((CommandContext<class_2168>)ctx, "player").getId())).executes(src -> TeleportCommand.teleport((CommandContext<class_2168>)src, CommandHelpers.singleProfile((CommandContext<class_2168>)src, "player").getId()))))));
    }

    private static int teleport(CommandContext<class_2168> context) throws CommandSyntaxException {
        return TeleportCommand.teleport(context, ((class_2168)context.getSource()).method_9207().method_5667());
    }

    private static int teleportAdminClaims(CommandContext<class_2168> context) throws CommandSyntaxException {
        return TeleportCommand.teleport(context, null);
    }

    private static int teleport(CommandContext<class_2168> context, UUID owner) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String name = StringArgumentType.getString(context, (String)"claim");
        Optional<Claim> claims = ClaimStorage.get(((class_2168)context.getSource()).method_9225()).allClaimsFromPlayer(owner).stream().filter(claim -> {
            if (claim.getClaimName().isEmpty()) {
                return claim.getClaimID().toString().equals(name);
            }
            return claim.getClaimName().equals(name);
        }).findFirst();
        if (claims.isEmpty()) {
            ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.teleportNoClaim", class_124.field_1061), false);
            return 0;
        }
        return claims.map(claim -> {
            class_2338 pos = claim.getHomePos();
            if (claim.canInteract(player, BuiltinPermission.TELEPORT, pos, false)) {
                PlayerClaimData data = PlayerClaimData.get(player);
                if (data.setTeleportTo(pos)) {
                    ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.teleportHome", class_124.field_1065), false);
                    return 1;
                }
                ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.teleportHomeFail", class_124.field_1061), false);
            } else {
                ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.noPermissionSimple", class_124.field_1079), false);
            }
            return 0;
        }).orElse(0);
    }
}

