/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.platform.integration.currency.CommandCurrency;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2073;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import net.minecraft.class_6903;
import net.minecraft.class_7923;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class BuySellHandler {
    public static final Codec<class_1799> ITEM_STACK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41178.method_39673().fieldOf("id").forGetter(class_1799::method_7909), (App)class_9326.field_49589.optionalFieldOf("components").forGetter(stack -> stack.method_57380().method_57848() ? Optional.empty() : Optional.of(stack.method_57380()))).apply((Applicative)instance, (item, components) -> {
        class_1799 stack = new class_1799((class_1935)item, 1);
        components.ifPresent(arg_0 -> ((class_1799)stack).method_57366(arg_0));
        return stack;
    }));
    private static int[] xpCalc;
    private Type buyType = Type.MONEY;
    private Type sellType = Type.MONEY;
    private float buyAmount = -1.0f;
    private final List<BuyItem> buyItems = new ArrayList<BuyItem>();
    private float sellAmount = -1.0f;
    private final List<SellItem> sellItems = new ArrayList<SellItem>();

    private static class_1799 fromResults(List<ItemResult> stacks) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8687);
        stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43471((String)"flan.buy_sell.item").method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1075)));
        ArrayList<class_2561> stackComp = new ArrayList<class_2561>();
        for (ItemResult r : stacks) {
            stackComp.add((class_2561)class_2561.method_43469((String)"flan.buy_sell.item.amount", (Object[])new Object[]{r.stack().method_63693(), r.amount(), Float.valueOf(r.value())}).method_10862(class_2583.field_24360.method_10978(Boolean.valueOf(false)).method_27706(class_124.field_1060)));
        }
        ServerScreenHelper.addLore(stack, stackComp);
        return stack;
    }

    public boolean buy(class_3222 player, int blocks, Consumer<class_2561> message) {
        if (this.buyAmount == -1.0f && this.buyType != Type.ITEM) {
            message.accept((class_2561)ClaimUtils.translatedText("flan.buyDisabled", class_124.field_1079));
            return false;
        }
        PlayerClaimData data = PlayerClaimData.get(player);
        if (ConfigHandler.CONFIG.maxBuyBlocks >= 0 && data.getAdditionalClaims() + blocks > ConfigHandler.CONFIG.maxBuyBlocks) {
            message.accept((class_2561)ClaimUtils.translatedText("flan.buyLimit", class_124.field_1079));
            return false;
        }
        switch (this.buyType.ordinal()) {
            case 0: {
                return CommandCurrency.INSTANCE.buyClaimBlocks(player, blocks, this.buyAmount, message);
            }
            case 1: {
                if (this.buyItems.isEmpty()) {
                    message.accept((class_2561)ClaimUtils.translatedText("flan.buyDisabled", class_124.field_1079));
                    return false;
                }
                int payed = 0;
                ArrayList<ItemResult> bought = new ArrayList<ItemResult>();
                ArrayList<Pair> matching = new ArrayList<Pair>();
                block5: for (BuyItem ing : this.buyItems) {
                    for (class_1799 stack : player.method_31548()) {
                        if (!this.matches(ing.predicate(), stack) || stack.method_7963() && stack.method_7919() != 0) continue;
                        float toPay = blocks - payed;
                        int count = Math.min(stack.method_7947(), (int)(toPay / ing.amount()));
                        float amount = (float)count * ing.amount();
                        payed = (int)((float)payed + amount);
                        if (count > 0) {
                            bought.add(new ItemResult(stack.method_7972(), count, ing.amount()));
                            matching.add(Pair.of((Object)stack, (Object)count));
                        }
                        if (payed < blocks) continue;
                        break block5;
                    }
                }
                if (payed == 0 || matching.isEmpty()) {
                    message.accept((class_2561)ClaimUtils.translatedText("flan.buyFailItem", class_124.field_1079));
                    return false;
                }
                for (Pair stack : matching) {
                    ((class_1799)stack.getFirst()).method_7934(((Integer)stack.getSecond()).intValue());
                }
                class_5250 items = class_2561.method_43471((String)"flan.buy_sell.items").method_27696(class_2583.field_24360.method_27706(class_124.field_1075).method_10949((class_2568)new class_2568.class_10612(BuySellHandler.fromResults(bought))));
                data.setAdditionalClaims(data.getAdditionalClaims() + payed);
                message.accept((class_2561)ClaimUtils.translatedText("flan.buySuccessItem", payed, items));
                return true;
            }
            case 2: {
                int deduct = class_3532.method_15386((float)((float)blocks * this.buyAmount));
                if ((float)deduct < (float)BuySellHandler.totalXpPointsForLevel(player.field_7520) + player.field_7510 * (float)BuySellHandler.xpForLevel(player.field_7520 + 1)) {
                    player.method_7255(-deduct);
                    data.setAdditionalClaims(data.getAdditionalClaims() + blocks);
                    message.accept((class_2561)ClaimUtils.translatedText("flan.buySuccessXP", blocks, deduct));
                    return true;
                }
                message.accept((class_2561)ClaimUtils.translatedText("flan.buyFailXP", class_124.field_1079));
                return false;
            }
        }
        return false;
    }

    public boolean sell(class_3222 player, int blocks, Consumer<class_2561> message) {
        if (this.sellAmount == -1.0f && this.sellType != Type.ITEM) {
            message.accept((class_2561)ClaimUtils.translatedText("flan.sellDisabled", class_124.field_1079));
            return false;
        }
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.getAdditionalClaims() - Math.max(0, data.usedClaimBlocks() - data.getClaimBlocks()) < blocks) {
            message.accept((class_2561)ClaimUtils.translatedText("flan.sellFail", class_124.field_1079));
            return false;
        }
        switch (this.sellType.ordinal()) {
            case 0: {
                return CommandCurrency.INSTANCE.sellClaimBlocks(player, blocks, this.sellAmount, message);
            }
            case 1: {
                if (this.sellItems.isEmpty()) {
                    message.accept((class_2561)ClaimUtils.translatedText("flan.sellDisabled", class_124.field_1079));
                    return false;
                }
                int toSell = blocks;
                ArrayList<ItemResult> soldStacks = new ArrayList<ItemResult>();
                for (SellItem item : this.sellItems) {
                    int count = (int)((float)toSell / item.amount());
                    float amount = (float)count * item.amount();
                    toSell = (int)((float)toSell - amount);
                    while (count > 0) {
                        class_1542 itemEntity;
                        class_1799 toGive = item.item().method_7972();
                        if (count > 64) {
                            toGive.method_7939(64);
                            count -= 64;
                        } else {
                            toGive.method_7939(count);
                            count = 0;
                        }
                        soldStacks.add(new ItemResult(toGive.method_7972(), toGive.method_7947(), item.amount()));
                        boolean bl = player.method_31548().method_7394(toGive);
                        if (bl && toGive.method_7960() || (itemEntity = player.method_7328(toGive, false)) == null) continue;
                        itemEntity.method_6975();
                        itemEntity.method_48349(player.method_5667());
                    }
                    if (toSell > 0) continue;
                    break;
                }
                int sold = blocks - toSell;
                class_5250 items = class_2561.method_43471((String)"flan.buy_sell.items").method_27696(class_2583.field_24360.method_27706(class_124.field_1075).method_10949((class_2568)new class_2568.class_10612(BuySellHandler.fromResults(soldStacks))));
                data.setAdditionalClaims(data.getAdditionalClaims() - sold);
                message.accept((class_2561)ClaimUtils.translatedText("flan.sellSuccessItem", sold, items));
                return true;
            }
            case 2: {
                int amount = class_3532.method_15375((float)((float)blocks * this.buyAmount));
                player.method_7255(amount);
                data.setAdditionalClaims(data.getAdditionalClaims() - blocks);
                message.accept((class_2561)ClaimUtils.translatedText("flan.sellSuccessXP", blocks, amount));
                return false;
            }
        }
        return false;
    }

    private boolean matches(class_2073 predicate, class_1799 stack) {
        if ((predicate.comp_2374().comp_3833().method_57867() || predicate.comp_2374().method_68680()) && stack.method_57380().method_57846().stream().anyMatch(e -> e.getKey() != class_9334.field_49631 && e.getKey() != class_9334.field_49639 && e.getKey() != class_9334.field_49629)) {
            return false;
        }
        return predicate.method_8970(stack);
    }

    private static int totalXpPointsForLevel(int level) {
        if (xpCalc == null || level > xpCalc.length) {
            xpCalc = new int[level + 50];
            BuySellHandler.xpCalc[0] = 0;
            for (int i = 1; i < xpCalc.length; ++i) {
                BuySellHandler.xpCalc[i] = BuySellHandler.xpForLevel(i) + xpCalc[i - 1];
            }
        }
        return xpCalc[level];
    }

    private static int xpForLevel(int level) {
        if (--level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    public JsonObject toJson(MinecraftServer server) {
        JsonObject obj = new JsonObject();
        obj.addProperty("buyType", this.buyType.toString());
        obj.addProperty("buyValue", (Number)Float.valueOf(this.buyAmount));
        JsonArray buyArr = new JsonArray();
        class_6903 ops = server.method_30611().method_57093((DynamicOps)JsonOps.INSTANCE);
        this.buyItems.forEach(arg_0 -> BuySellHandler.lambda$toJson$4((DynamicOps)ops, buyArr, arg_0));
        obj.add("buyItems", (JsonElement)buyArr);
        obj.addProperty("sellType", this.sellType.toString());
        obj.addProperty("sellValue", (Number)Float.valueOf(this.sellAmount));
        JsonArray sellArr = new JsonArray();
        this.sellItems.forEach(arg_0 -> BuySellHandler.lambda$toJson$5((DynamicOps)ops, sellArr, arg_0));
        obj.add("sellItems", (JsonElement)sellArr);
        return obj;
    }

    public void fromJson(JsonObject object, MinecraftServer server) {
        this.buyType = Type.valueOf(ConfigHandler.fromJson(object, "buyType", this.buyType.toString()));
        this.buyAmount = object.has("buyValue") ? object.get("buyValue").getAsFloat() : this.buyAmount;
        this.buyItems.clear();
        JsonArray buyArr = ConfigHandler.arrayFromJson(object, "buyItems");
        class_6903 ops = server.method_30611().method_57093((DynamicOps)JsonOps.INSTANCE);
        buyArr.forEach(arg_0 -> this.lambda$fromJson$6((DynamicOps)ops, arg_0));
        this.buyItems.sort(BuyItem::compareTo);
        this.sellType = Type.valueOf(ConfigHandler.fromJson(object, "sellType", this.sellType.toString()));
        this.sellAmount = object.has("sellValue") ? object.get("sellValue").getAsFloat() : this.sellAmount;
        this.sellItems.clear();
        JsonArray sellArr = ConfigHandler.arrayFromJson(object, "sellItems");
        sellArr.forEach(arg_0 -> this.lambda$fromJson$7((DynamicOps)ops, arg_0));
        this.sellItems.sort(SellItem::compareTo);
    }

    private /* synthetic */ void lambda$fromJson$7(DynamicOps ops, JsonElement k) {
        JsonObject o = k.getAsJsonObject();
        this.sellItems.add(new SellItem(o.get("amount").getAsFloat(), (class_1799)ITEM_STACK_CODEC.parse(ops, (Object)o.get("item")).getOrThrow()));
    }

    private /* synthetic */ void lambda$fromJson$6(DynamicOps ops, JsonElement k) {
        JsonObject o = k.getAsJsonObject();
        this.buyItems.add(new BuyItem(o.get("amount").getAsFloat(), (class_2073)class_2073.field_45754.parse(ops, (Object)o.get("predicate")).getOrThrow()));
    }

    private static /* synthetic */ void lambda$toJson$5(DynamicOps ops, JsonArray sellArr, SellItem b) {
        JsonObject buyObj = new JsonObject();
        buyObj.addProperty("amount", (Number)Float.valueOf(b.amount()));
        buyObj.add("item", (JsonElement)ITEM_STACK_CODEC.encodeStart(ops, (Object)b.item).getOrThrow());
        sellArr.add((JsonElement)buyObj);
    }

    private static /* synthetic */ void lambda$toJson$4(DynamicOps ops, JsonArray buyArr, BuyItem b) {
        JsonObject buyObj = new JsonObject();
        buyObj.addProperty("amount", (Number)Float.valueOf(b.amount()));
        buyObj.add("predicate", (JsonElement)class_2073.field_45754.encodeStart(ops, (Object)b.predicate()).getOrThrow());
        buyArr.add((JsonElement)buyObj);
    }

    static enum Type {
        MONEY,
        ITEM,
        XP;

    }

    record ItemResult(class_1799 stack, int amount, float value) {
    }

    record BuyItem(float amount, class_2073 predicate) implements Comparable<BuyItem>
    {
        @Override
        public int compareTo(@NotNull BuyItem buyItem) {
            return Float.compare(buyItem.amount, this.amount);
        }
    }

    record SellItem(float amount, class_1799 item) implements Comparable<SellItem>
    {
        @Override
        public int compareTo(@NotNull SellItem item) {
            return Float.compare(item.amount, this.amount);
        }
    }
}

