/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.event;

import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.InteractionOverrideManager;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.attachment.ClaimAllowListKey;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.mixin.IPersistentProjectileVars;
import io.github.flemmli97.flan.utils.TeleportUtils;
import io.github.flemmli97.flan.utils.VehiclePositionTracker;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.class_10599;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1473;
import net.minecraft.class_1528;
import net.minecraft.class_1531;
import net.minecraft.class_1533;
import net.minecraft.class_1560;
import net.minecraft.class_1569;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1676;
import net.minecraft.class_1684;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_1693;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_3988;
import net.minecraft.class_6025;
import net.minecraft.class_7923;
import net.minecraft.class_8103;

public class EntityInteractEvents {
    public static class_1269 useAtEntity(class_1657 player, class_1937 level, class_1268 hand, class_1297 entity, class_3966 hitResult) {
        class_2338 pos;
        class_3222 serverPlayer;
        block11: {
            block10: {
                if (!(player instanceof class_3222)) break block10;
                serverPlayer = (class_3222)player;
                if (!player.method_7325() && !EntityInteractEvents.canInteract(entity)) break block11;
            }
            return class_1269.field_5811;
        }
        if (entity instanceof class_1569) {
            return class_1269.field_5811;
        }
        ClaimStorage storage = ClaimStorage.get((class_3218)level);
        IPermissionContainer claim = storage.getForPermissionCheck(pos = entity.method_24515());
        if (claim != null) {
            class_2960 perm;
            if (claim instanceof Claim) {
                Claim real = (Claim)claim;
                if (real.allowedEntries.isAllowed(ClaimAllowListKey.ENTITY_USE, type -> type == entity.method_5864(), arg_0 -> ((class_1299)entity.method_5864()).method_20210(arg_0))) {
                    return class_1269.field_5811;
                }
            }
            if ((perm = InteractionOverrideManager.getInstance().getEntityInteract(entity.method_5864())) != null) {
                return claim.canInteract(serverPlayer, perm, pos, true) ? class_1269.field_5811 : class_1269.field_5814;
            }
            if (entity instanceof class_1531 && !claim.canInteract(serverPlayer, BuiltinPermission.ARMORSTAND, pos, true)) {
                return class_1269.field_5814;
            }
            if (entity instanceof class_1308) {
                return claim.canInteract(serverPlayer, BuiltinPermission.ANIMALINTERACT, pos, true) ? class_1269.field_5811 : class_1269.field_5814;
            }
        }
        return class_1269.field_5811;
    }

    public static class_1269 useEntity(class_1657 p, class_1937 level, class_1268 hand, class_1297 entity) {
        class_2338 pos;
        class_3222 player;
        block17: {
            block16: {
                if (!(p instanceof class_3222)) break block16;
                player = (class_3222)p;
                if (!p.method_7325() && !EntityInteractEvents.canInteract(entity)) break block17;
            }
            return class_1269.field_5811;
        }
        if (entity instanceof class_1569) {
            return class_1269.field_5811;
        }
        ClaimStorage storage = ClaimStorage.get((class_3218)level);
        IPermissionContainer claim = storage.getForPermissionCheck(pos = entity.method_24515());
        if (claim != null) {
            class_2960 perm;
            if (claim instanceof Claim) {
                Claim real = (Claim)claim;
                if (real.allowedEntries.isAllowed(ClaimAllowListKey.ENTITY_USE, type -> type == entity.method_5864(), arg_0 -> ((class_1299)entity.method_5864()).method_20210(arg_0))) {
                    return class_1269.field_5811;
                }
            }
            if ((perm = InteractionOverrideManager.getInstance().getEntityInteract(entity.method_5864())) != null) {
                return claim.canInteract(player, perm, pos, true) ? class_1269.field_5811 : class_1269.field_5814;
            }
            class_1297 class_12972 = entity;
            Objects.requireNonNull(class_12972);
            class_1297 class_12973 = class_12972;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1690.class, class_1688.class, class_3988.class, class_1533.class, class_6025.class}, (Object)class_12973, n)) {
                case 0: {
                    class_1690 boat = (class_1690)class_12973;
                    return claim.canInteract(player, BuiltinPermission.BOAT, pos, true) ? class_1269.field_5811 : class_1269.field_5814;
                }
                case 1: {
                    class_1688 minecart = (class_1688)class_12973;
                    if (entity instanceof class_1693) {
                        return claim.canInteract(player, BuiltinPermission.OPENCONTAINER, pos, true) ? class_1269.field_5811 : class_1269.field_5814;
                    }
                    return claim.canInteract(player, BuiltinPermission.MINECART, pos, true) ? class_1269.field_5811 : class_1269.field_5814;
                }
                case 2: {
                    class_3988 villager = (class_3988)class_12973;
                    return claim.canInteract(player, BuiltinPermission.TRADING, pos, true) ? class_1269.field_5811 : class_1269.field_5814;
                }
                case 3: {
                    class_1533 itemFrame = (class_1533)class_12973;
                    return claim.canInteract(player, BuiltinPermission.ITEMFRAMEROTATE, pos, true) ? class_1269.field_5811 : class_1269.field_5814;
                }
                case 4: {
                    class_6025 ownable = (class_6025)class_12973;
                    if (ownable.method_66287() == null || !ownable.method_66287().method_66256((class_10599)player)) break;
                    return class_1269.field_5811;
                }
            }
            return claim.canInteract(player, BuiltinPermission.ANIMALINTERACT, pos, true) ? class_1269.field_5811 : class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canInteract(class_1297 entity) {
        class_2960 id = class_7923.field_41177.method_10221((Object)entity.method_5864());
        if (ConfigHandler.CONFIG.ignoredEntityTypes.contains(id.method_12836())) return true;
        if (ConfigHandler.CONFIG.ignoredEntityTypes.contains(id.toString())) return true;
        if (!entity.method_5752().stream().anyMatch(ConfigHandler.CONFIG.entityTagIgnore::contains)) return false;
        return true;
    }

    public static boolean projectileHit(class_1676 proj, class_239 res) {
        if (proj.method_37908().field_9236) {
            return false;
        }
        class_1297 owner = proj.method_24921();
        if (owner instanceof class_3222) {
            class_3222 player = (class_3222)owner;
            class_2960 id = class_7923.field_41177.method_10221((Object)proj.method_5864());
            if (ConfigHandler.CONFIG.ignoredProjectileTypes.contains(id.method_12836()) || ConfigHandler.CONFIG.ignoredProjectileTypes.contains(id.toString())) {
                return false;
            }
            if (res.method_17783() == class_239.class_240.field_1332) {
                boolean fail;
                class_3965 blockRes = (class_3965)res;
                class_2338 pos = blockRes.method_17777();
                class_2680 state = proj.method_37908().method_8320(pos);
                class_2960 perm = InteractionOverrideManager.getInstance().getProjectileEntityInteract(proj);
                if (perm == null) {
                    perm = InteractionOverrideManager.getInstance().getProjectileBlockInteract(state.method_26204());
                }
                if (perm == null) {
                    return false;
                }
                ClaimStorage storage = ClaimStorage.get((class_3218)proj.method_37908());
                IPermissionContainer claim = storage.getForPermissionCheck(pos);
                if (claim == null) {
                    return false;
                }
                boolean bl = fail = !claim.canInteract(player, perm, pos, true);
                if (fail) {
                    if (proj instanceof class_1665) {
                        class_1665 pers = (class_1665)proj;
                        ((IPersistentProjectileVars)pers).setInBlockState(pers.method_37908().method_8320(pos));
                        class_243 vec3d = blockRes.method_17784().method_1023(pers.method_23317(), pers.method_23318(), pers.method_23321());
                        pers.method_18799(vec3d);
                        class_243 vec3d2 = vec3d.method_1029().method_1021(0.05);
                        pers.method_23327(pers.method_23317() - vec3d2.field_1352, pers.method_23318() - vec3d2.field_1351, pers.method_23321() - vec3d2.field_1350);
                        pers.method_5783(((IPersistentProjectileVars)pers).getSoundEvent(), 1.0f, 1.2f / (pers.method_37908().field_9229.method_43057() * 0.2f + 0.9f));
                        ((IPersistentProjectileVars)pers).setInGroundState(true);
                        pers.field_7574 = 7;
                        pers.method_7439(false);
                        ((IPersistentProjectileVars)pers).setPiercingLevel((byte)0);
                        pers.method_7444(class_3417.field_15151);
                        ((IPersistentProjectileVars)pers).resetPiercingStatus();
                    } else {
                        proj.method_31472();
                    }
                }
                return fail;
            }
            if (res.method_17783() == class_239.class_240.field_1331) {
                class_1665 pers;
                boolean fail;
                if (proj instanceof class_1684) {
                    ClaimStorage storage = ClaimStorage.get((class_3218)proj.method_37908());
                    IPermissionContainer claim = storage.getForPermissionCheck(proj.method_24515());
                    return claim.canInteract(player, BuiltinPermission.ENDERPEARL, proj.method_24515(), true);
                }
                class_1297 hit = ((class_3966)res).method_17782();
                boolean bl = fail = EntityInteractEvents.attackSimple((class_1657)player, hit, true) != class_1269.field_5811;
                if (fail && proj instanceof class_1665 && (pers = (class_1665)proj).method_7447() > 0) {
                    IntOpenHashSet pierced = ((IPersistentProjectileVars)pers).getPiercedEntities();
                    if (pierced == null) {
                        pierced = new IntOpenHashSet(5);
                    }
                    pierced.add(hit.method_5628());
                    ((IPersistentProjectileVars)pers).setPiercedEntities(pierced);
                    ((IPersistentProjectileVars)pers).setPiercingLevel((byte)(pers.method_7447() + 1));
                }
                proj.field_6037 = true;
                return fail;
            }
        }
        return false;
    }

    public static boolean preventDamage(class_1297 entity, class_1282 source) {
        if (source.method_5529() instanceof class_3222) {
            return EntityInteractEvents.attackSimple((class_1657)((class_3222)source.method_5529()), entity, true) != class_1269.field_5811;
        }
        if (source.method_48789(class_8103.field_42249) && !entity.method_37908().field_9236 && !(entity instanceof class_3222) && !(entity instanceof class_1569)) {
            IPermissionContainer claim = ClaimStorage.get((class_3218)entity.method_37908()).getForPermissionCheck(entity.method_24515());
            return claim != null && !claim.canInteract(null, BuiltinPermission.EXPLOSIONS, entity.method_24515());
        }
        return false;
    }

    public static class_1269 attackSimple(class_1657 p, class_1297 entity, boolean message) {
        class_2338 pos;
        class_3222 player;
        block12: {
            block11: {
                if (!(p instanceof class_3222)) break block11;
                player = (class_3222)p;
                if (!p.method_7325() && !EntityInteractEvents.canInteract(entity)) break block12;
            }
            return class_1269.field_5811;
        }
        if (entity instanceof class_1569) {
            return class_1269.field_5811;
        }
        ClaimStorage storage = ClaimStorage.get(player.method_51469());
        IPermissionContainer claim = storage.getForPermissionCheck(pos = entity.method_24515());
        if (claim != null) {
            if (claim instanceof Claim) {
                Claim real = (Claim)claim;
                if (real.allowedEntries.isAllowed(ClaimAllowListKey.ENTITY_ATTACK, type -> type == entity.method_5864(), arg_0 -> ((class_1299)entity.method_5864()).method_20210(arg_0))) {
                    return class_1269.field_5811;
                }
            }
            if (entity.method_16914() && !claim.canInteract(player, BuiltinPermission.HURTNAMED, pos, message)) {
                return class_1269.field_5814;
            }
            class_2960 perm = InteractionOverrideManager.getInstance().getEntityAttack(entity.method_5864());
            if (perm != null) {
                return claim.canInteract(player, perm, pos, message) ? class_1269.field_5811 : class_1269.field_5814;
            }
            if (entity instanceof class_1531 || !(entity instanceof class_1309)) {
                return claim.canInteract(player, BuiltinPermission.BREAKNONLIVING, pos, message) ? class_1269.field_5811 : class_1269.field_5814;
            }
            if (entity instanceof class_1657) {
                return claim.canInteract(player, BuiltinPermission.HURTPLAYER, pos, message) ? class_1269.field_5811 : class_1269.field_5814;
            }
            return claim.canInteract(player, BuiltinPermission.HURTANIMAL, pos, message) ? class_1269.field_5811 : class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public static boolean witherCanDestroy(class_1528 wither) {
        if (wither.method_37908().field_9236) {
            return true;
        }
        ClaimStorage storage = ClaimStorage.get((class_3218)wither.method_37908());
        class_2338.class_2339 pos = new class_2338.class_2339();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                pos.method_25504((class_2382)wither.method_24515(), x, 3, z);
                IPermissionContainer claim = storage.getForPermissionCheck((class_2338)pos);
                if (claim.canInteract(null, BuiltinPermission.WITHER, (class_2338)pos, false)) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean canEndermanInteract(class_1560 enderman, class_2338 pos) {
        if (enderman.method_37908().field_9236) {
            return true;
        }
        ClaimStorage storage = ClaimStorage.get((class_3218)enderman.method_37908());
        IPermissionContainer claim = storage.getForPermissionCheck(pos);
        return claim.canInteract(null, BuiltinPermission.ENDERMAN, pos, false);
    }

    public static boolean canSnowGolemInteract(class_1473 snowgolem) {
        if (snowgolem.method_37908().field_9236) {
            return true;
        }
        for (int l = 0; l < 4; ++l) {
            int x = class_3532.method_15357((double)(snowgolem.method_23317() + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
            int y = class_3532.method_15357((double)snowgolem.method_23318());
            int z = class_3532.method_15357((double)(snowgolem.method_23321() + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f)));
            class_2338 pos = new class_2338(x, y, z);
            IPermissionContainer claim = ClaimStorage.get((class_3218)snowgolem.method_37908()).getForPermissionCheck(pos);
            if (claim.canInteract(null, BuiltinPermission.SNOWGOLEM, pos, false)) continue;
            return false;
        }
        return true;
    }

    public static boolean canFrostwalkerFreeze(class_3218 level, class_2338 pos, class_1309 entity) {
        if (entity instanceof class_3222) {
            IPermissionContainer claim = ClaimStorage.get(level).getForPermissionCheck(pos);
            return claim.canInteract((class_3222)entity, BuiltinPermission.PLACE, pos, false);
        }
        return true;
    }

    public static boolean preventLightningConvert(class_1297 entity) {
        if (entity.method_37908().field_9236 || entity instanceof class_1569) {
            return false;
        }
        ClaimStorage storage = ClaimStorage.get((class_3218)entity.method_37908());
        IPermissionContainer claim = storage.getForPermissionCheck(entity.method_24515());
        return !claim.canInteract(null, BuiltinPermission.LIGHTNING, entity.method_24515(), false);
    }

    public static void handleVehiclePass(class_1297 entity) {
        class_2338 oldPos;
        Claim claimOld;
        if (entity.method_37908().field_9236) {
            return;
        }
        ClaimStorage storage = ClaimStorage.get((class_3218)entity.method_37908());
        Claim claim = storage.getClaimAt(entity.method_24515());
        class_243 last = null;
        if (entity instanceof VehiclePositionTracker) {
            VehiclePositionTracker tracker = (VehiclePositionTracker)entity;
            last = tracker.flan$updateAndGetLastPosition();
        }
        if (claim == null) {
            return;
        }
        Claim sub = claim.getSubClaim(entity.method_24515());
        if (sub != null) {
            claim = sub;
        }
        if ((claimOld = storage.getClaimAt(oldPos = last != null ? EntityInteractEvents.ofPos(last) : class_2338.method_49637((double)entity.field_6014, (double)entity.field_6036, (double)entity.field_5969))) != null && (sub = claimOld.getSubClaim(entity.method_24515())) != null) {
            claimOld = sub;
        }
        if (claimOld != claim && !claim.canInteract(null, BuiltinPermission.VEHICLE_PASS, entity.method_24515(), false)) {
            class_2338 rounded = TeleportUtils.roundedBlockPos(entity.method_19538());
            class_243 tp = TeleportUtils.getTeleportPos(entity, entity.method_19538(), storage, new TeleportUtils.Area2D(claim.getDimensions()), true, rounded.method_25503(), (c, nPos) -> c.canInteract(null, BuiltinPermission.VEHICLE_PASS, (class_2338)nPos, false));
            if (!entity.method_66247()) {
                entity.method_5772();
            }
            entity.method_5859(tp.method_10216(), tp.method_10214(), tp.method_10215());
        }
    }

    private static class_2338 ofPos(class_243 pos) {
        return class_2338.method_49637((double)pos.method_10216(), (double)pos.method_10214(), (double)pos.method_10215());
    }
}

