/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.event;

import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.mixin.StructureManagerAccessor;
import io.github.flemmli97.flan.player.LogoutTracker;
import java.util.List;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1538;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3233;
import net.minecraft.class_3341;
import net.minecraft.class_3449;
import net.minecraft.class_5138;
import net.minecraft.server.MinecraftServer;

public class WorldEvents {
    public static void modifyExplosion(List<class_2338> toExplode, class_3218 level) {
        ClaimStorage storage = ClaimStorage.get(level);
        toExplode.removeIf(pos -> {
            IPermissionContainer claim = storage.getForPermissionCheck((class_2338)pos);
            if (claim != null) {
                return !claim.canInteract(null, BuiltinPermission.EXPLOSIONS, (class_2338)pos);
            }
            return false;
        });
    }

    public static boolean pistonCanPush(class_2680 state, class_1937 level, class_2338 blockPos, class_2350 direction, class_2350 pistonDir) {
        if (level.field_9236) {
            return true;
        }
        class_2338 dirPos = blockPos.method_10093(direction);
        ClaimStorage storage = ClaimStorage.get((class_3218)level);
        IPermissionContainer from = storage.getForPermissionCheck(blockPos);
        IPermissionContainer to = storage.getForPermissionCheck(dirPos);
        boolean flag = true;
        if (from.equals(to)) {
            class_2338 oppPoos = blockPos.method_10093(direction.method_10153());
            IPermissionContainer opp = storage.getForPermissionCheck(oppPoos);
            if (!from.equals(opp)) {
                flag = from.canInteract(null, BuiltinPermission.PISTONBORDER, oppPoos);
            }
        } else if (!state.method_26215()) {
            boolean bl = flag = from.canInteract(null, BuiltinPermission.PISTONBORDER, blockPos) && to.canInteract(null, BuiltinPermission.PISTONBORDER, dirPos);
        }
        if (!flag) {
            level.method_8413(blockPos, state, state, 20);
            class_2680 toState = level.method_8320(dirPos);
            level.method_8413(dirPos, toState, toState, 20);
        }
        return flag;
    }

    public static boolean canFlow(class_2680 fluidBlockState, class_1922 level, class_2338 blockPos, class_2350 direction) {
        IPermissionContainer to;
        if (!(level instanceof class_3218) || direction == class_2350.field_11036 || direction == class_2350.field_11033) {
            return true;
        }
        ClaimStorage storage = ClaimStorage.get((class_3218)level);
        IPermissionContainer from = storage.getForPermissionCheck(blockPos);
        return from.equals(to = storage.getForPermissionCheck(blockPos.method_10093(direction))) || to.canInteract(null, BuiltinPermission.WATERBORDER, blockPos);
    }

    public static boolean canStartRaid(class_3222 player, class_2338 pos) {
        IPermissionContainer claim = ClaimStorage.get(player.method_51469()).getForPermissionCheck(pos);
        return claim.canInteract(player, BuiltinPermission.RAID, pos);
    }

    public static boolean canFireSpread(class_3218 level, class_2338 pos) {
        IPermissionContainer claim = ClaimStorage.get(level).getForPermissionCheck(pos);
        return claim.canInteract(null, BuiltinPermission.FIRESPREAD, pos);
    }

    public static boolean preventMobSpawn(class_3218 level, class_1308 entity) {
        return WorldEvents.preventMobSpawn(level, entity.method_24515(), entity.method_5864().method_5891());
    }

    public static boolean preventMobSpawn(class_3218 level, class_2338 pos, class_1311 category) {
        IPermissionContainer claim = ClaimStorage.get(level).getForPermissionCheck(pos);
        if (category == class_1311.field_6302) {
            return claim.canInteract(null, BuiltinPermission.MONSTERSPAWN, pos);
        }
        return claim.canInteract(null, BuiltinPermission.MOBSPAWN, pos);
    }

    public static boolean lightningFire(class_1538 lightning) {
        class_1937 class_19372 = lightning.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return true;
        }
        class_3218 level = (class_3218)class_19372;
        class_2338.class_2339 mutable = lightning.method_24515().method_25503();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                mutable.method_10103(mutable.method_10263() + x, mutable.method_10264(), mutable.method_10260() + z);
                IPermissionContainer claim = ClaimStorage.get(level).getForPermissionCheck((class_2338)mutable);
                if (claim.canInteract(null, BuiltinPermission.LIGHTNING, (class_2338)mutable)) continue;
                return false;
            }
        }
        return true;
    }

    public static void serverTick(MinecraftServer server) {
        LogoutTracker.getInstance(server).tick();
    }

    public static void onStructureGen(class_3449 structureStart, class_5138 structureManager) {
        if (!ConfigHandler.CONFIG.autoClaimStructures) {
            return;
        }
        class_1936 acc = ((StructureManagerAccessor)structureManager).getLevel();
        class_3218 level = null;
        if (acc instanceof class_3233) {
            class_3233 region = (class_3233)acc;
            level = region.method_8410();
        } else if (acc instanceof class_3218) {
            class_3218 serverLevel;
            level = serverLevel = (class_3218)acc;
        }
        if (level == null) {
            return;
        }
        class_3341 bb = structureStart.method_14969();
        ClaimStorage.get(level).createAdminClaim(new class_2338(bb.method_35415(), bb.method_35416(), bb.method_35417()), new class_2338(bb.method_35418(), bb.method_35419(), bb.method_35420()), level, true);
    }
}

