/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.fabric.platform.integration.claiming;

import com.mojang.authlib.GameProfile;
import eu.pb4.common.protection.api.CommonProtection;
import eu.pb4.common.protection.api.ProtectionProvider;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.InteractionOverrideManager;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.platform.CrossPlatformStuff;
import net.fabricmc.fabric.api.entity.FakePlayer;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1531;
import net.minecraft.class_1657;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class FlanProtectionProvider
implements ProtectionProvider {
    public static final class_2960 ID = class_2960.method_60655((String)"flan", (String)"provider");

    public static void register() {
        CommonProtection.register((class_2960)ID, (ProtectionProvider)new FlanProtectionProvider());
    }

    public boolean isProtected(class_1937 level, class_2338 pos) {
        if (!(level instanceof class_3218)) {
            return false;
        }
        class_3218 sl = (class_3218)level;
        return ClaimStorage.get(sl).getClaimAt(pos) != null;
    }

    public boolean isAreaProtected(class_1937 level, class_238 area) {
        if (!(level instanceof class_3218)) {
            return false;
        }
        class_3218 sl = (class_3218)level;
        int minChunkX = (int)Math.floor(area.field_1323);
        int minChunkZ = (int)Math.floor(area.field_1321);
        int maxChunkX = (int)Math.floor(area.field_1320);
        int maxChunkZ = (int)Math.floor(area.field_1324);
        ClaimStorage storage = ClaimStorage.get(sl);
        for (int chunkX = minChunkX; chunkX < maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ < maxChunkZ; ++chunkZ) {
                for (Claim claim : storage.getClaimsAt(chunkX, chunkZ)) {
                    if (!claim.intersects(area)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean canBreakBlock(class_1937 level, class_2338 pos, GameProfile profile, @Nullable class_1657 player) {
        if (!(level instanceof class_3218)) {
            return true;
        }
        class_3218 sl = (class_3218)level;
        class_3222 sp = FlanProtectionProvider.tryResolvePlayer(sl, profile);
        return ClaimStorage.get(sl).getForPermissionCheck(pos).canInteract(sp, BuiltinPermission.BREAK, pos);
    }

    public boolean canExplodeBlock(class_1937 level, class_2338 pos, class_1927 explosion, GameProfile profile, @Nullable class_1657 player) {
        if (!(level instanceof class_3218)) {
            return true;
        }
        class_3218 sl = (class_3218)level;
        class_3222 sp = FlanProtectionProvider.tryResolvePlayer(sl, profile);
        return ClaimStorage.get(sl).getForPermissionCheck(pos).canInteract(sp, BuiltinPermission.EXPLOSIONS, pos);
    }

    public boolean canPlaceBlock(class_1937 level, class_2338 pos, GameProfile profile, @Nullable class_1657 player) {
        if (!(level instanceof class_3218)) {
            return true;
        }
        class_3218 sl = (class_3218)level;
        class_3222 sp = FlanProtectionProvider.tryResolvePlayer(sl, profile);
        return ClaimStorage.get(sl).getForPermissionCheck(pos).canInteract(sp, BuiltinPermission.PLACE, pos);
    }

    public boolean canInteractBlock(class_1937 level, class_2338 pos, GameProfile profile, @Nullable class_1657 player) {
        if (!(level instanceof class_3218)) {
            return true;
        }
        class_3218 sl = (class_3218)level;
        class_3222 sp = FlanProtectionProvider.tryResolvePlayer(sl, profile);
        class_2960 perm = InteractionOverrideManager.getInstance().getBlockInteract(sl.method_8320(pos).method_26204());
        if (perm != null && perm.equals((Object)BuiltinPermission.PROJECTILES)) {
            perm = BuiltinPermission.OPENCONTAINER;
        }
        if (perm == null) {
            class_2586 be = level.method_8321(pos);
            perm = be != null && CrossPlatformStuff.INSTANCE.isInventoryTile(be) ? BuiltinPermission.OPENCONTAINER : BuiltinPermission.INTERACTBLOCK;
        }
        return ClaimStorage.get(sl).getForPermissionCheck(pos).canInteract(sp, perm, pos);
    }

    public boolean canInteractEntity(class_1937 level, class_1297 entity, GameProfile profile, @Nullable class_1657 player) {
        class_2960 permission;
        if (!(level instanceof class_3218)) {
            return true;
        }
        class_3218 sl = (class_3218)level;
        class_3222 sp = FlanProtectionProvider.tryResolvePlayer(sl, profile);
        if (entity instanceof class_1531) {
            permission = BuiltinPermission.ARMORSTAND;
        } else if (entity instanceof class_1308) {
            permission = BuiltinPermission.ANIMALINTERACT;
        } else {
            return true;
        }
        return ClaimStorage.get(sl).getForPermissionCheck(entity.method_24515()).canInteract(sp, permission, entity.method_24515());
    }

    public boolean canDamageEntity(class_1937 level, class_1297 entity, GameProfile profile, @Nullable class_1657 player) {
        if (!(level instanceof class_3218)) {
            return true;
        }
        class_3218 sl = (class_3218)level;
        class_3222 sp = FlanProtectionProvider.tryResolvePlayer(sl, profile);
        class_2960 permission = entity instanceof class_1531 || !(entity instanceof class_1309) ? BuiltinPermission.BREAKNONLIVING : (entity instanceof class_1657 ? BuiltinPermission.HURTPLAYER : BuiltinPermission.HURTANIMAL);
        if (entity.method_16914() && !ClaimStorage.get(sl).getForPermissionCheck(entity.method_24515()).canInteract(sp, BuiltinPermission.HURTNAMED, entity.method_24515())) {
            return false;
        }
        return ClaimStorage.get(sl).getForPermissionCheck(entity.method_24515()).canInteract(sp, permission, entity.method_24515());
    }

    private static class_3222 tryResolvePlayer(class_3218 l, GameProfile profile) {
        if (profile.equals((Object)UNKNOWN)) {
            return null;
        }
        class_3222 online = l.method_8503().method_3760().method_14602(profile.getId());
        if (online != null) {
            return online;
        }
        return FakePlayer.get((class_3218)l, (GameProfile)profile);
    }
}

