/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.api.permission;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import io.github.flemmli97.flan.api.permission.ObjectToPermissionMap;
import io.github.flemmli97.flan.api.permission.interactions.InteractionType;
import io.github.flemmli97.flan.api.permission.interactions.ResolvableEntry;
import io.github.flemmli97.flan.api.permission.interactions.ResolvableHolderSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public class InteractionOverrideManager
extends SimpleJsonResourceReloadListener<InteractionEntry<?>> {
    public static final ResourceKey<? extends Registry<InteractionEntry<?>>> ID = ResourceKey.createRegistryKey((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"flan", (String)"claim_interactions_override"));
    public static final Codec<ResolvableEntry<Block>> BLOCK_CODEC = ResolvableHolderSet.codec(BuiltInRegistries.BLOCK);
    public static final Codec<ResolvableEntry<Item>> ITEM_CODEC = ResolvableHolderSet.codec(BuiltInRegistries.ITEM);
    public static final Codec<ResolvableEntry<EntityType<?>>> ENTITY_CODEC = ResolvableHolderSet.codec(BuiltInRegistries.ENTITY_TYPE);
    public static final InteractionType<Block> BLOCK_LEFT_CLICK = new InteractionType<Block>(ResourceLocation.fromNamespaceAndPath((String)"flan", (String)"block_left_click"), BLOCK_CODEC, InteractionHolder::new);
    public static final InteractionType<Block> BLOCK_INTERACT = new InteractionType<Block>(ResourceLocation.fromNamespaceAndPath((String)"flan", (String)"block_interact"), BLOCK_CODEC, InteractionHolder::new);
    public static final InteractionType<Item> ITEM_USE = new InteractionType<Item>(ResourceLocation.fromNamespaceAndPath((String)"flan", (String)"item_use"), ITEM_CODEC, InteractionHolder::new);
    public static final InteractionType<EntityType<?>> ENTITY_ATTACK = new InteractionType(ResourceLocation.fromNamespaceAndPath((String)"flan", (String)"entity_attack"), ENTITY_CODEC, InteractionHolder::new);
    public static final InteractionType<EntityType<?>> ENTITY_INTERACT = new InteractionType(ResourceLocation.fromNamespaceAndPath((String)"flan", (String)"entity_interact"), ENTITY_CODEC, InteractionHolder::new);
    public static final InteractionType<Block> PROJECTILE_BLOCK_INTERACT = new InteractionType<Block>(ResourceLocation.fromNamespaceAndPath((String)"flan", (String)"projectile_block_interact"), BLOCK_CODEC, InteractionHolder::new);
    public static final InteractionType<EntityType<?>> PROJECTILE_ENTITY_INTERACT = new InteractionType(ResourceLocation.fromNamespaceAndPath((String)"flan", (String)"projectile_entity_interact"), ENTITY_CODEC, InteractionHolder::new);
    private static InteractionOverrideManager INSTANCE;
    private final Map<InteractionType<?>, InteractionHolder<?>> overrides = new HashMap();

    private InteractionOverrideManager(HolderLookup.Provider provider) {
        super(provider, InteractionEntry.CODEC, ID);
    }

    public static InteractionOverrideManager create(HolderLookup.Provider provider) {
        INSTANCE = new InteractionOverrideManager(provider);
        return InteractionOverrideManager.getInstance();
    }

    public static InteractionOverrideManager getInstance() {
        return INSTANCE;
    }

    public ResourceLocation getBlockLeftClick(Block block) {
        return this.getOverride(BLOCK_LEFT_CLICK, block);
    }

    public ResourceLocation getBlockInteract(Block block) {
        return this.getOverride(BLOCK_INTERACT, block);
    }

    public ResourceLocation getItemUse(Item item) {
        return this.getOverride(ITEM_USE, item);
    }

    public ResourceLocation getEntityAttack(EntityType<?> entity) {
        return this.getOverride(ENTITY_ATTACK, entity);
    }

    public ResourceLocation getEntityInteract(EntityType<?> entity) {
        return this.getOverride(ENTITY_INTERACT, entity);
    }

    public ResourceLocation getProjectileBlockInteract(Block block) {
        return this.getOverride(PROJECTILE_BLOCK_INTERACT, block);
    }

    public ResourceLocation getProjectileEntityInteract(Projectile entity) {
        InteractionHolder<EntityType<?>> holder = this.getHolder(PROJECTILE_ENTITY_INTERACT);
        if (!holder.unresolved()) {
            for (EntityType type : BuiltInRegistries.ENTITY_TYPE) {
                InteractionHolder<EntityType<?>> map = this.getHolder(PROJECTILE_ENTITY_INTERACT);
                ObjectToPermissionMap.PROJECTILE_PERMISSION_BUILDER.entrySet().stream().filter(e -> {
                    Entity dummy = type.create(entity.level(), EntitySpawnReason.TRIGGERED);
                    return ((Predicate)e.getKey()).test(dummy);
                }).map(Map.Entry::getValue).findFirst().ifPresent(sub -> map.defaults.put(type, (ResourceLocation)sub.get()));
            }
        }
        return this.getOverride(PROJECTILE_ENTITY_INTERACT, entity.getType());
    }

    public <T> ResourceLocation getOverride(InteractionType<T> type, T entry) {
        return this.getHolder(type).get(entry);
    }

    private <T> InteractionHolder<T> getHolder(InteractionType<T> type) {
        return this.overrides.computeIfAbsent(type, k -> type.getGen().get());
    }

    protected void apply(Map<ResourceLocation, InteractionEntry<?>> data, ResourceManager manager, ProfilerFiller profiler) {
        InteractionHolder<Block> map;
        this.overrides.clear();
        for (Block block : BuiltInRegistries.BLOCK) {
            map = this.getHolder(BLOCK_INTERACT);
            ObjectToPermissionMap.BLOCK_PERMISSION_BUILDER.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(block)).map(Map.Entry::getValue).findFirst().ifPresent(sub -> map.defaults.put(block, (ResourceLocation)sub.get()));
        }
        for (Item item : BuiltInRegistries.ITEM) {
            map = this.getHolder(ITEM_USE);
            ObjectToPermissionMap.ITEM_PERMISSION_BUILDER.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(item)).map(Map.Entry::getValue).findFirst().ifPresent(sub -> map.defaults.put(item, (ResourceLocation)sub.get()));
        }
        for (Block block : BuiltInRegistries.BLOCK) {
            map = this.getHolder(PROJECTILE_BLOCK_INTERACT);
            ObjectToPermissionMap.PROJECTILE_BLOCK_PERMISSION_BUILDER.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(block)).map(Map.Entry::getValue).findFirst().ifPresent(sub -> map.defaults.put(block, (ResourceLocation)sub.get()));
        }
        data.forEach((res, entry) -> this.appendTo((InteractionEntry)entry));
    }

    private <T> void appendTo(InteractionEntry<T> entry) {
        InteractionHolder<T> map = this.getHolder(entry.type());
        entry.elements().forEach(pair -> map.unresolvedTags.put((ResolvableEntry)pair.getFirst(), (ResourceLocation)pair.getSecond()));
    }

    public record InteractionEntry<T>(InteractionType<T> type, List<Pair<ResolvableEntry<T>, ResourceLocation>> elements) {
        public static final Codec<InteractionEntry<?>> CODEC = ResourceLocation.CODEC.dispatch(e -> e.type().getId(), t -> InteractionType.get(t).getCodec());
    }

    public static class InteractionHolder<T> {
        private final Map<T, ResourceLocation> direct = new HashMap<T, ResourceLocation>();
        private final Map<ResolvableEntry<T>, ResourceLocation> unresolvedTags = new HashMap<ResolvableEntry<T>, ResourceLocation>();
        private final Map<T, ResourceLocation> defaults = new HashMap<T, ResourceLocation>();

        public ResourceLocation get(T val) {
            if (this.unresolved()) {
                this.resolve();
            }
            return this.direct.get(val);
        }

        public boolean unresolved() {
            return !this.unresolvedTags.isEmpty() || !this.defaults.isEmpty();
        }

        private void resolve() {
            this.unresolvedTags.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> ((ResolvableEntry)entry.getKey()).resolve().forEach(item -> {
                if (!this.direct.containsKey(item)) {
                    this.direct.put(item, (ResourceLocation)entry.getValue());
                }
            }));
            this.unresolvedTags.clear();
            this.defaults.forEach((key, value) -> {
                if (!this.direct.containsKey(key)) {
                    this.direct.put((T)key, (ResourceLocation)value);
                }
            });
            this.defaults.clear();
        }
    }
}

