/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.api.permission;

import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.AbstractThrownPotion;
import net.minecraft.world.entity.projectile.ThrownEgg;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.entity.projectile.windcharge.WindCharge;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.BasePressurePlateBlock;
import net.minecraft.world.level.block.BeaconBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.BellBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.ChorusFlowerBlock;
import net.minecraft.world.level.block.DaylightDetectorBlock;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.EnchantingTableBlock;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.NetherPortalBlock;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.TurtleEggBlock;

public class ObjectToPermissionMap {
    public static final Map<Predicate<Block>, Supplier<ResourceLocation>> BLOCK_PERMISSION_BUILDER = new HashMap<Predicate<Block>, Supplier<ResourceLocation>>();
    public static final Map<Predicate<Item>, Supplier<ResourceLocation>> ITEM_PERMISSION_BUILDER = new HashMap<Predicate<Item>, Supplier<ResourceLocation>>();
    public static final Map<Predicate<Block>, Supplier<ResourceLocation>> PROJECTILE_BLOCK_PERMISSION_BUILDER = new HashMap<Predicate<Block>, Supplier<ResourceLocation>>();
    public static final Map<Predicate<Entity>, Supplier<ResourceLocation>> PROJECTILE_PERMISSION_BUILDER = new HashMap<Predicate<Entity>, Supplier<ResourceLocation>>();

    public static void registerBlockPredicateMap(Predicate<Block> pred, Supplier<ResourceLocation> perm) {
        BLOCK_PERMISSION_BUILDER.put(pred, perm);
    }

    public static void registerItemPredicateMap(Predicate<Item> pred, Supplier<ResourceLocation> perm) {
        ITEM_PERMISSION_BUILDER.put(pred, perm);
    }

    public static void registerProjectileBlockPredicateMap(Predicate<Block> pred, Supplier<ResourceLocation> perm) {
        PROJECTILE_BLOCK_PERMISSION_BUILDER.put(pred, perm);
    }

    public static void registerProjectilePredicateMap(Predicate<Entity> pred, Supplier<ResourceLocation> perm) {
        PROJECTILE_PERMISSION_BUILDER.put(pred, perm);
    }

    static {
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof AnvilBlock, () -> BuiltinPermission.ANVIL);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof BedBlock, () -> BuiltinPermission.BED);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof BeaconBlock, () -> BuiltinPermission.BEACON);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof DoorBlock, () -> BuiltinPermission.DOOR);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof FenceGateBlock, () -> BuiltinPermission.FENCEGATE);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof TrapDoorBlock, () -> BuiltinPermission.TRAPDOOR);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof LeverBlock || block instanceof ButtonBlock, () -> BuiltinPermission.BUTTONLEVER);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof NoteBlock, () -> BuiltinPermission.NOTEBLOCK);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof DiodeBlock || block instanceof RedStoneWireBlock || block instanceof DaylightDetectorBlock, () -> BuiltinPermission.REDSTONE);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof JukeboxBlock, () -> BuiltinPermission.JUKEBOX);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof BasePressurePlateBlock, () -> BuiltinPermission.PRESSUREPLATE);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof NetherPortalBlock, () -> BuiltinPermission.PORTAL);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof TurtleEggBlock || block instanceof FarmBlock, () -> BuiltinPermission.TRAMPLE);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof EnderChestBlock, () -> BuiltinPermission.ENDERCHEST);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof EnchantingTableBlock, () -> BuiltinPermission.ENCHANTMENTTABLE);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof BrushableBlock, () -> BuiltinPermission.ARCHAEOLOGY);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item instanceof EnderpearlItem, () -> BuiltinPermission.ENDERPEARL);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item instanceof BucketItem, () -> BuiltinPermission.BUCKET);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item == Items.END_CRYSTAL, () -> BuiltinPermission.ENDCRYSTALPLACE);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item == Items.CHORUS_FRUIT, () -> BuiltinPermission.CHORUSFRUIT);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item == Items.LILY_PAD, () -> BuiltinPermission.PLACE);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item instanceof BoneMealItem, () -> BuiltinPermission.PLACE);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item instanceof BoatItem, () -> BuiltinPermission.BOAT);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item instanceof BrushItem, () -> BuiltinPermission.ARCHAEOLOGY);
        ObjectToPermissionMap.registerItemPredicateMap(item -> item == Items.WIND_CHARGE, () -> BuiltinPermission.WIND_CHARGE);
        ObjectToPermissionMap.registerBlockPredicateMap(block -> block instanceof TargetBlock, () -> BuiltinPermission.TARGETBLOCK);
        ObjectToPermissionMap.registerProjectileBlockPredicateMap(block -> block instanceof BellBlock || block instanceof CampfireBlock || block instanceof TntBlock || block instanceof ChorusFlowerBlock || block instanceof DecoratedPotBlock, () -> BuiltinPermission.PROJECTILES);
        ObjectToPermissionMap.registerProjectilePredicateMap(entity -> entity instanceof ThrownEnderpearl, () -> BuiltinPermission.ENDERPEARL);
        ObjectToPermissionMap.registerProjectilePredicateMap(entity -> entity instanceof WindCharge, () -> BuiltinPermission.WIND_CHARGE);
        ObjectToPermissionMap.registerProjectilePredicateMap(entity -> entity instanceof ThrownEgg || entity instanceof AbstractThrownPotion, () -> BuiltinPermission.PROJECTILES);
        ObjectToPermissionMap.registerProjectilePredicateMap(entity -> entity instanceof ThrownEnderpearl, () -> BuiltinPermission.ENDERPEARL);
    }
}

