/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.api.permission.interactions;

import com.mojang.serialization.Codec;
import io.github.flemmli97.flan.api.permission.interactions.ResolvableEntry;
import java.util.Iterator;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.ResourceKey;
import org.jetbrains.annotations.NotNull;

public record ResolvableHolderSet<T>(HolderSet<T> holders) implements ResolvableEntry<T>
{
    public static <T> Codec<ResolvableEntry<T>> codec(Registry<T> registry) {
        return RegistryCodecs.homogeneousList((ResourceKey)registry.key()).xmap(ResolvableHolderSet::new, h -> ((ResolvableHolderSet)h).holders());
    }

    @Override
    public Iterable<T> resolve() {
        return new Iterable<T>(){

            @Override
            @NotNull
            public Iterator<T> iterator() {
                final Iterator it = ResolvableHolderSet.this.holders.iterator();
                return new Iterator<T>(this){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public T next() {
                        return ((Holder)it.next()).value();
                    }
                };
            }
        };
    }

    @Override
    public int compareTo(@NotNull ResolvableEntry<T> o) {
        if (o instanceof ResolvableHolderSet) {
            ResolvableHolderSet other = (ResolvableHolderSet)o;
            String key = this.holders().unwrapKey().map(t -> t.location().toString()).orElse("");
            String otherKey = other.holders().unwrapKey().map(t -> t.location().toString()).orElse("");
            return key.compareTo(otherKey);
        }
        return 0;
    }
}

