/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.api.permission.provider;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.flan.api.permission.InteractionOverrideManager;
import io.github.flemmli97.flan.api.permission.interactions.InteractionType;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public abstract class InteractionOverrideProvider
implements DataProvider {
    private final Map<ResourceLocation, Builder<?>> data = new HashMap();
    private final PackOutput output;

    public InteractionOverrideProvider(PackOutput output) {
        this.output = output;
    }

    protected abstract void add();

    public CompletableFuture<?> run(CachedOutput cache) {
        this.add();
        return CompletableFuture.allOf((CompletableFuture[])this.data.entrySet().stream().map(entry -> {
            Path path = this.output.getOutputFolder(PackOutput.Target.DATA_PACK).resolve(((ResourceLocation)entry.getKey()).getNamespace()).resolve(Registries.elementsDirPath(InteractionOverrideManager.ID)).resolve(((ResourceLocation)entry.getKey()).getPath() + ".json");
            JsonObject obj = new JsonObject();
            obj.addProperty("type", ((Builder)entry.getValue()).type.getId().toString());
            obj.add("values", ((Builder)entry.getValue()).values());
            return DataProvider.saveStable((CachedOutput)cache, (JsonElement)obj, (Path)path);
        }).toArray(CompletableFuture[]::new));
    }

    public String getName() {
        return "Interaction Overrides";
    }

    public <T> void override(ResourceLocation res, Builder<T> permission) {
        if (this.data.put(res, permission) != null) {
            throw new IllegalStateException("Override already exists" + String.valueOf(res));
        }
    }

    public static class Builder<T> {
        private static final Codec<List<Pair<Either<TagKey<Block>, ResourceLocation>, ResourceLocation>>> BLOCK_CODEC = Builder.idBasedCodec(Registries.BLOCK);
        private static final Codec<List<Pair<Either<TagKey<Item>, ResourceLocation>, ResourceLocation>>> ITEM_CODEC = Builder.idBasedCodec(Registries.ITEM);
        private static final Codec<List<Pair<Either<TagKey<EntityType<?>>, ResourceLocation>, ResourceLocation>>> ENTITY_CODEC = Builder.idBasedCodec(Registries.ENTITY_TYPE);
        public final InteractionType<T> type;
        private final Registry<T> registry;
        private final Codec<List<Pair<Either<TagKey<T>, ResourceLocation>, ResourceLocation>>> codec;
        private final List<Pair<Either<TagKey<T>, ResourceLocation>, ResourceLocation>> entries = new ArrayList<Pair<Either<TagKey<T>, ResourceLocation>, ResourceLocation>>();

        private Builder(InteractionType<T> type, Registry<T> registry, Codec<List<Pair<Either<TagKey<T>, ResourceLocation>, ResourceLocation>>> codec) {
            this.type = type;
            this.registry = registry;
            this.codec = codec;
        }

        public static <T> Codec<List<Pair<Either<TagKey<T>, ResourceLocation>, ResourceLocation>>> idBasedCodec(ResourceKey<? extends Registry<T>> registry) {
            Codec tagOrEntry = Codec.either((Codec)TagKey.hashedCodec(registry), (Codec)ResourceLocation.CODEC);
            return InteractionType.valueCodec(tagOrEntry);
        }

        public static Builder<Block> blockInteractions(InteractionType<Block> type) {
            return new Builder<Block>(type, (Registry<Block>)BuiltInRegistries.BLOCK, BLOCK_CODEC);
        }

        public static Builder<Item> itemInteractions(InteractionType<Item> type) {
            return new Builder<Item>(type, (Registry<Item>)BuiltInRegistries.ITEM, ITEM_CODEC);
        }

        public static Builder<EntityType<?>> entityInteractions(InteractionType<EntityType<?>> type) {
            return new Builder(type, (Registry<EntityType<?>>)BuiltInRegistries.ENTITY_TYPE, ENTITY_CODEC);
        }

        public Builder<T> addEntry(T value, ResourceLocation permission) {
            this.entries.add(Pair.of((Object)Either.right((Object)this.registry.getKey(value)), (Object)permission));
            return this;
        }

        public Builder<T> addEntry(ResourceLocation value, ResourceLocation permission) {
            this.entries.add(Pair.of((Object)Either.right((Object)value), (Object)permission));
            return this;
        }

        public Builder<T> addEntry(TagKey<T> value, ResourceLocation permission) {
            this.entries.add(Pair.of((Object)Either.left(value), (Object)permission));
            return this;
        }

        protected JsonElement values() {
            return (JsonElement)this.codec.encodeStart((DynamicOps)JsonOps.INSTANCE, this.entries).getOrThrow();
        }
    }
}

