/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.claim.attachment.ClaimAllowListKey;
import io.github.flemmli97.flan.commands.CommandClaim;
import io.github.flemmli97.flan.commands.CommandHelpers;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class AllowListCommand {
    public static <T extends ArgumentBuilder<CommandSourceStack, T>> void register(ArgumentBuilder<CommandSourceStack, T> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ignoreList").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.claim.ignore", false))).then(AllowListCommand.buildClaimEntryCommand(false))).then(AllowListCommand.buildClaimEntryCommand(true)));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> buildClaimEntryCommand(boolean remove) {
        LiteralArgumentBuilder base = Commands.literal((String)(remove ? "remove" : "add"));
        ClaimAllowListKey.keys().entrySet().stream().sorted(Map.Entry.comparingByKey(ClaimPermission.NAMESPACE_FIRST)).forEach(entry -> {
            if (remove) {
                base.then(Commands.literal((String)((ResourceLocation)entry.getKey()).toString()).then(Commands.argument((String)"entry", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey(((ClaimAllowListKey)entry.getValue()).registry())).suggests((src, b) -> CommandHelpers.claimEntryListSuggestion((CommandContext<CommandSourceStack>)src, b, (ClaimAllowListKey)entry.getValue())).executes(src -> AllowListCommand.removeClaimListEntries((CommandContext<CommandSourceStack>)src, (ClaimAllowListKey)entry.getValue()))));
            } else {
                base.then(Commands.literal((String)((ResourceLocation)entry.getKey()).toString()).then(Commands.argument((String)"entry", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey(((ClaimAllowListKey)entry.getValue()).registry())).executes(src -> AllowListCommand.addClaimListEntries((CommandContext<CommandSourceStack>)src, (ClaimAllowListKey)entry.getValue()))));
            }
        });
        return base;
    }

    private static int addClaimListEntries(CommandContext<CommandSourceStack> context, ClaimAllowListKey<?> key) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Claim claim = CommandClaim.getClaimFromMode(context, player, BuiltinPermission.EDITCLAIM);
        if (claim == null) {
            return 0;
        }
        String result = AllowListCommand.addClaimListEntry(context, key, claim);
        MutableComponent cmdFeed = ClaimUtils.translatedText("flan.addIgnoreEntry", result, key.id().toString()).withStyle(ChatFormatting.GOLD);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> cmdFeed, false);
        return 1;
    }

    private static int removeClaimListEntries(CommandContext<CommandSourceStack> context, ClaimAllowListKey<?> key) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Claim claim = CommandClaim.getClaimFromMode(context, player, BuiltinPermission.EDITCLAIM);
        if (claim == null) {
            return 0;
        }
        String value = ((ResourceOrTagKeyArgument.Result)context.getArgument("entry", ResourceOrTagKeyArgument.Result.class)).asPrintable();
        claim.allowedEntries.get(key).removeAllowedItem(value);
        MutableComponent cmdFeed = ClaimUtils.translatedText("flan.removeIgnoreEntry", value, key.id().toString()).withStyle(ChatFormatting.GOLD);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> cmdFeed, false);
        return 1;
    }

    private static <T> String addClaimListEntry(CommandContext<CommandSourceStack> context, ClaimAllowListKey<T> key, Claim claim) throws CommandSyntaxException {
        ResourceOrTagKeyArgument.Result<T> value = CommandHelpers.getRegistryType(context, "entry", key.registry());
        Registry registry = ((CommandSourceStack)context.getSource()).registryAccess().lookupOrThrow(key.registry());
        value.unwrap().ifRight(tag -> claim.allowedEntries.get(key).addAllowedItem(Either.right((Object)tag))).ifLeft(id -> registry.getOptional(id).ifPresent(entry -> claim.allowedEntries.get(key).addAllowedItem(Either.left((Object)entry))));
        return value.asPrintable();
    }
}

