/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.commands.CommandClaim;
import io.github.flemmli97.flan.commands.CommandHelpers;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class ClaimInfoCommand {
    public static <T extends ArgumentBuilder<CommandSourceStack, T>> void register(ArgumentBuilder<CommandSourceStack, T> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"info").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.info"))).executes(ctx -> ClaimInfoCommand.claimInfo((CommandContext<CommandSourceStack>)ctx, Claim.InfoType.ALL))).then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests((src, b) -> CommandHelpers.enumSuggestion(Claim.InfoType.class, b)).executes(ClaimInfoCommand::claimInfo)));
    }

    private static int claimInfo(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return ClaimInfoCommand.claimInfo(context, CommandHelpers.parseEnum(Claim.InfoType.class, StringArgumentType.getString(context, (String)"type"), Claim.InfoType.ALL));
    }

    private static int claimInfo(CommandContext<CommandSourceStack> context, Claim.InfoType infoType) throws CommandSyntaxException {
        Claim sub;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Claim claim = CommandClaim.fromContext(context);
        if (claim == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.noClaim", ChatFormatting.RED));
            return 0;
        }
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.getClaimMode().isSubclaim && (sub = claim.getSubClaim(BlockPos.containing((Position)((CommandSourceStack)context.getSource()).getPosition()))) != null) {
            List<Component> info = sub.infoString(player, infoType);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.claimSubHeader", ChatFormatting.AQUA), false);
            for (Component text : info) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> text, false);
            }
            return 1;
        }
        List<Component> info = claim.infoString(player, infoType);
        for (Component text : info) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> text, false);
        }
        return 1;
    }
}

