/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.commands.CommandClaim;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;

public class ClaimMessageCommand {
    public static <T extends ArgumentBuilder<CommandSourceStack, T>> void register(ArgumentBuilder<CommandSourceStack, T> builder, CommandBuildContext buildContext) {
        builder.then(Commands.literal((String)"claimMessage").then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> SharedSuggestionProvider.suggest((String[])new String[]{"enter", "leave"}, (SuggestionsBuilder)b)).then(((RequiredArgumentBuilder)Commands.argument((String)"title", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> SharedSuggestionProvider.suggest((String[])new String[]{"title", "subtitle"}, (SuggestionsBuilder)b)).then(Commands.literal((String)"text").then(Commands.argument((String)"component", (ArgumentType)ComponentArgument.textComponent((CommandBuildContext)buildContext)).executes(ctx -> ClaimMessageCommand.editClaimMessages((CommandContext<CommandSourceStack>)ctx, ComponentArgument.getResolvedComponent((CommandContext)ctx, (String)"component")))))).then(Commands.literal((String)"string").then(Commands.argument((String)"message", (ArgumentType)StringArgumentType.string()).executes(ClaimMessageCommand::editClaimMessages))))));
    }

    private static int editClaimMessages(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return ClaimMessageCommand.editClaimMessages(context, (Component)Component.literal((String)StringArgumentType.getString(context, (String)"message")));
    }

    private static int editClaimMessages(CommandContext<CommandSourceStack> context, Component text) throws CommandSyntaxException {
        String feedback;
        ServerPlayer player;
        Claim claim;
        if (text instanceof MutableComponent) {
            Style style = text.getStyle();
            if (style.isEmpty()) {
                style = style.applyFormat(ChatFormatting.WHITE);
            }
            if (!style.isItalic()) {
                style = style.withItalic(Boolean.valueOf(false));
            }
            ((MutableComponent)text).setStyle(style);
        }
        if ((claim = CommandClaim.getClaimFromMode(context, player = ((CommandSourceStack)context.getSource()).getPlayerOrException(), BuiltinPermission.CLAIMMESSAGE)) == null) {
            return 0;
        }
        boolean sub = StringArgumentType.getString(context, (String)"title").equals("subtitle");
        boolean enter = StringArgumentType.getString(context, (String)"type").equals("enter");
        if (enter) {
            if (sub) {
                claim.setEnterTitle(claim.enterTitle, text);
                feedback = "flan.setEnterSubMessage";
            } else {
                claim.setEnterTitle(text, claim.enterSubtitle);
                feedback = "flan.setEnterMessage";
            }
        } else if (sub) {
            claim.setLeaveTitle(claim.leaveTitle, text);
            feedback = "flan.setLeaveSubMessage";
        } else {
            claim.setLeaveTitle(text, claim.leaveSubtitle);
            feedback = "flan.setLeaveMessage";
        }
        MutableComponent cmdFeed = ClaimUtils.translatedText(feedback, text).withStyle(ChatFormatting.GOLD);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> cmdFeed, false);
        return 1;
    }
}

