/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.OfflinePlayerData;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;

public class ListClaimCommand {
    public static <T extends ArgumentBuilder<CommandSourceStack, T>> void register(ArgumentBuilder<CommandSourceStack, T> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"list").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.list"))).executes(ListClaimCommand::listClaims)).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.list.all", true))).executes(cmd -> ListClaimCommand.listClaims((CommandContext<CommandSourceStack>)cmd, GameProfileArgument.getGameProfiles((CommandContext)cmd, (String)"player"))))).then(((LiteralArgumentBuilder)Commands.literal((String)"listAdminClaims").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.admin.list", true))).executes(ListClaimCommand::listAdminClaims));
    }

    private static int listClaims(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return ListClaimCommand.listClaimsFromUUID(context, null);
    }

    private static int listClaims(CommandContext<CommandSourceStack> context, Collection<GameProfile> profs) throws CommandSyntaxException {
        if (profs.size() != 1) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.onlyOnePlayer", ChatFormatting.RED), false);
            return 0;
        }
        GameProfile prof = profs.iterator().next();
        if (prof == null || prof.getId() == null) {
            return 0;
        }
        return ListClaimCommand.listClaimsFromUUID(context, prof.getId());
    }

    private static int listClaimsFromUUID(CommandContext<CommandSourceStack> context, UUID of) throws CommandSyntaxException {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        ServerPlayer player = of == null ? ((CommandSourceStack)context.getSource()).getPlayerOrException() : server.getPlayerList().getPlayer(of);
        HashMap<ServerLevel, Collection<Claim>> claims = new HashMap<ServerLevel, Collection<Claim>>();
        for (ServerLevel serverLevel : server.getAllLevels()) {
            ClaimStorage storage = ClaimStorage.get(serverLevel);
            claims.put(serverLevel, storage.allClaimsFromPlayer(player != null ? player.getUUID() : of));
        }
        if (ConfigHandler.CONFIG.maxClaimBlocks != -1) {
            if (player != null) {
                data = PlayerClaimData.get(player);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> ListClaimCommand.lambda$listClaimsFromUUID$5((PlayerClaimData)data), false);
            } else {
                data = new OfflinePlayerData(server, of);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> ListClaimCommand.lambda$listClaimsFromUUID$6((OfflinePlayerData)data), false);
            }
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.listClaims", ChatFormatting.GOLD), false);
        for (Map.Entry entry : claims.entrySet()) {
            for (Claim claim : (Collection)entry.getValue()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText(String.valueOf(((Level)entry.getKey()).dimension().location()) + " # " + claim.formattedClaim(), ChatFormatting.YELLOW), false);
            }
        }
        return 1;
    }

    private static int listAdminClaims(CommandContext<CommandSourceStack> context) {
        CommandSourceStack src = (CommandSourceStack)context.getSource();
        HashMap<ServerLevel, Collection<Claim>> claims = new HashMap<ServerLevel, Collection<Claim>>();
        for (ServerLevel serverLevel : src.getServer().getAllLevels()) {
            claims.put(serverLevel, ClaimStorage.get(serverLevel).getAdminClaims());
        }
        src.sendSuccess(() -> ClaimUtils.translatedText("flan.listAdminClaims", src.getLevel().dimension().location(), ChatFormatting.GOLD), false);
        for (Map.Entry entry : claims.entrySet()) {
            for (Claim claim : (Collection)entry.getValue()) {
                src.sendSuccess(() -> ClaimUtils.translatedText(String.valueOf(((Level)entry.getKey()).dimension().location()) + " # " + claim.formattedClaim(), ChatFormatting.YELLOW), false);
            }
        }
        return 1;
    }

    private static /* synthetic */ Component lambda$listClaimsFromUUID$6(OfflinePlayerData data) {
        return ClaimUtils.translatedText("flan.claimBlocksFormat", data.claimBlocks, data.getAdditionalClaims(), data.usedClaimBlocks(), data.remainingClaimBlocks(), ChatFormatting.GOLD);
    }

    private static /* synthetic */ Component lambda$listClaimsFromUUID$5(PlayerClaimData data) {
        return ClaimUtils.translatedText("flan.claimBlocksFormat", data.getClaimBlocks(), data.getAdditionalClaims(), data.usedClaimBlocks(), data.remainingClaimBlocks(), ChatFormatting.GOLD);
    }
}

