/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.PermissionManager;
import io.github.flemmli97.flan.config.BuySellHandler;
import io.github.flemmli97.flan.config.Config;
import io.github.flemmli97.flan.config.ConfigHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.HolderSet;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class ConfigUpdater {
    private static final Map<Integer, Updater> UPDATER = Config.createHashMap(map -> {
        map.put(7, new Updater(){

            @Override
            public JsonObject configUpdater(MinecraftServer server, JsonObject oldVals) {
                return oldVals;
            }

            @Override
            public void postUpdater(MinecraftServer server, Config config) {
                config.defaultGroups.computeIfPresent("Co-Owner", (k, v) -> {
                    if (v.isEmpty()) {
                        PermissionManager.getInstance().getAll().forEach(p -> v.put(p.getId(), true));
                    }
                    return v;
                });
                config.defaultGroups.computeIfPresent("Visitor", (k, v) -> {
                    if (v.isEmpty()) {
                        v.put(BuiltinPermission.BED, true);
                        v.put(BuiltinPermission.DOOR, true);
                        v.put(BuiltinPermission.FENCEGATE, true);
                        v.put(BuiltinPermission.TRAPDOOR, true);
                        v.put(BuiltinPermission.BUTTONLEVER, true);
                        v.put(BuiltinPermission.PRESSUREPLATE, true);
                        v.put(BuiltinPermission.ENDERCHEST, true);
                        v.put(BuiltinPermission.ENCHANTMENTTABLE, true);
                        v.put(BuiltinPermission.ITEMFRAMEROTATE, true);
                        v.put(BuiltinPermission.PORTAL, true);
                        v.put(BuiltinPermission.TRADING, true);
                    }
                    return v;
                });
            }
        });
        map.put(6, new Updater(){

            @Override
            public JsonObject configUpdater(MinecraftServer server, JsonObject oldVals) {
                return oldVals;
            }

            @Override
            public void postUpdater(MinecraftServer server, Config config) {
                config.globalDefaultPerms.computeIfPresent("*", (k, v) -> {
                    v.put(BuiltinPermission.ALLOW_FLIGHT, Config.GlobalType.ALLTRUE);
                    v.put(BuiltinPermission.MAY_FLIGHT, Config.GlobalType.ALLFALSE);
                    return v;
                });
            }
        });
        map.put(5, (server, config) -> {
            Flan.debug("Updating config to version 5", new Object[0]);
            JsonObject buySellHandler = ConfigHandler.fromJson(config, "buySellHandler");
            JsonArray buyItems = ConfigHandler.arrayFromJson(buySellHandler, "buyIngredients");
            ArrayList toRemove = new ArrayList();
            RegistryOps ops = server.registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE);
            buyItems.forEach(arg_0 -> ConfigUpdater.lambda$static$0((DynamicOps)ops, buySellHandler, toRemove, arg_0));
            toRemove.forEach(arg_0 -> ((JsonArray)buyItems).remove(arg_0));
            buySellHandler.add("buyItems", (JsonElement)buyItems);
            if (buySellHandler.has("ingredient") || buySellHandler.has("sellIngredient")) {
                Ingredient legacy = buySellHandler.has("ingredient") ? (Ingredient)Ingredient.CODEC.parse((DynamicOps)ops, (Object)buySellHandler.get("ingredient")).getOrThrow() : Ingredient.of((ItemLike[])new ItemLike[0]);
                legacy = buySellHandler.has("sellIngredient") ? (Ingredient)Ingredient.CODEC.parse((DynamicOps)ops, (Object)buySellHandler.get("sellIngredient")).getOrThrow() : legacy;
                Optional<ItemStack> stack = legacy.items().map(ItemStack::new).findFirst();
                if (stack.isPresent()) {
                    buySellHandler.add("sellItems", (JsonElement)BuySellHandler.ITEM_STACK_CODEC.encodeStart((DynamicOps)ops, (Object)stack.get()).result().map(e -> {
                        JsonArray arr = new JsonArray();
                        JsonObject val = new JsonObject();
                        val.add("amount", buySellHandler.get("sellValue"));
                        val.add("item", e);
                        arr.add((JsonElement)val);
                        return arr;
                    }).orElse(new JsonArray()));
                } else {
                    buySellHandler.add("sellItems", (JsonElement)new JsonArray());
                }
            }
            return config;
        });
    });

    public static JsonObject updateConfig(int preVersion, MinecraftServer server, JsonObject config) {
        for (Map.Entry<Integer, Updater> updater : UPDATER.entrySet()) {
            if (updater.getKey() <= preVersion) continue;
            config = updater.getValue().configUpdater(server, config);
        }
        return config;
    }

    public static void postUpdateConfig(int preVersion, MinecraftServer server, Config config) {
        for (Map.Entry<Integer, Updater> updater : UPDATER.entrySet()) {
            if (updater.getKey() <= preVersion) continue;
            updater.getValue().postUpdater(server, config);
        }
    }

    private static /* synthetic */ void lambda$static$0(DynamicOps ops, JsonObject buySellHandler, List toRemove, JsonElement k) {
        JsonObject o = k.getAsJsonObject();
        if (o.has("ingredient")) {
            try {
                Ingredient ingredient = (Ingredient)Ingredient.CODEC.parse(ops, (Object)buySellHandler.get("ingredient")).getOrThrow();
                ItemPredicate pred = new ItemPredicate(Optional.of(HolderSet.direct(ingredient.items().toList())), MinMaxBounds.Ints.ANY, DataComponentMatchers.ANY);
                o.add("predicate", (JsonElement)ItemPredicate.CODEC.encodeStart(ops, (Object)pred).getOrThrow());
                o.remove("ingredient");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!o.has("predicate") || !o.has("amount")) {
            Flan.error("Unable to update buy handler ", o);
            toRemove.add(k);
        }
    }

    static interface Updater {
        public JsonObject configUpdater(MinecraftServer var1, JsonObject var2);

        default public void postUpdater(MinecraftServer server, Config config) {
        }
    }
}

