/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.event;

import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.InteractionOverrideManager;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.attachment.ClaimAllowListKey;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.event.ItemInteractEvents;
import io.github.flemmli97.flan.gui.LockedLecternScreenHandler;
import io.github.flemmli97.flan.platform.CrossPlatformStuff;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.player.display.EnumDisplayType;
import io.github.flemmli97.flan.utils.BlockBreakAttemptHandler;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.LecternBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class BlockInteractEvents {
    public static InteractionResult startBreakBlocks(Player player, Level level, InteractionHand hand, BlockPos pos, Direction direction) {
        InteractionResult.Pass result;
        BlockState state = level.getBlockState(pos);
        Object object = result = BlockInteractEvents.breakBlocks(level, player, pos, state, level.getBlockEntity(pos), true) ? InteractionResult.PASS : InteractionResult.FAIL;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            boolean failed = result == InteractionResult.FAIL;
            ((BlockBreakAttemptHandler)serverPlayer.gameMode).flan$setBlockBreakAttemptFail((BlockPos)(failed ? pos : null), failed && state.getDestroyProgress(player, (BlockGetter)level, pos) >= 1.0f);
        }
        return result;
    }

    public static boolean breakBlocks(Level level, Player p, BlockPos pos, BlockState state, BlockEntity tile) {
        if (!BlockInteractEvents.breakBlocks(level, p, pos, level.getBlockState(pos), level.getBlockEntity(pos), false)) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (p instanceof ServerPlayer) {
                Packet updatePacket;
                ServerPlayer player = (ServerPlayer)p;
                if (blockEntity != null && (updatePacket = blockEntity.getUpdatePacket()) != null) {
                    player.connection.send(updatePacket);
                }
            }
            return false;
        }
        return true;
    }

    public static boolean breakBlocks(Level level, Player p, BlockPos pos, BlockState state, BlockEntity tile, boolean attempt) {
        ServerPlayer player;
        block11: {
            block10: {
                if (!(p instanceof ServerPlayer)) break block10;
                player = (ServerPlayer)p;
                if (!p.isSpectator()) break block11;
            }
            return true;
        }
        ClaimStorage storage = ClaimStorage.get((ServerLevel)level);
        IPermissionContainer claim = storage.getForPermissionCheck(pos);
        if (claim != null) {
            ResourceLocation perm;
            ResourceLocation id;
            if (claim instanceof Claim) {
                Claim real = (Claim)claim;
                if (real.allowedEntries.isAllowed(ClaimAllowListKey.BLOCK_BREAK, arg_0 -> ((BlockState)state).is(arg_0), arg_0 -> ((BlockState)state).is(arg_0))) {
                    return true;
                }
            }
            if (BlockInteractEvents.contains(id = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()), level.getBlockEntity(pos), ConfigHandler.CONFIG.breakBlockBlacklist, ConfigHandler.CONFIG.breakBlockEntityTagBlacklist)) {
                return true;
            }
            if (attempt && (perm = InteractionOverrideManager.getInstance().getBlockLeftClick(state.getBlock())) != null) {
                if (!claim.canInteract(player, perm, pos, true)) {
                    PlayerClaimData.get(player).addDisplayClaim(claim, EnumDisplayType.MAIN, player.blockPosition().getY());
                    return false;
                }
                return true;
            }
            if (!claim.canInteract(player, BuiltinPermission.BREAK, pos, true)) {
                PlayerClaimData.get(player).addDisplayClaim(claim, EnumDisplayType.MAIN, player.blockPosition().getY());
                return false;
            }
        }
        return true;
    }

    public static InteractionResult useBlocks(Player p, Level level, InteractionHand hand, BlockHitResult hitResult) {
        if (!(p instanceof ServerPlayer)) {
            return InteractionResult.PASS;
        }
        ServerPlayer player = (ServerPlayer)p;
        ItemStack stack = player.getItemInHand(hand);
        if (ConfigHandler.isClaimingTool(stack)) {
            ItemInteractEvents.claimLandHandling(player, hitResult.getBlockPos());
            return InteractionResult.SUCCESS;
        }
        if (ConfigHandler.isInspectionTool(stack)) {
            ItemInteractEvents.inspect(player, hitResult.getBlockPos());
            return InteractionResult.SUCCESS;
        }
        ClaimStorage storage = ClaimStorage.get((ServerLevel)level);
        IPermissionContainer claim = storage.getForPermissionCheck(hitResult.getBlockPos());
        if (claim != null) {
            BlockEntity blockEntity;
            ResourceLocation id;
            BlockState state = level.getBlockState(hitResult.getBlockPos());
            if (claim instanceof Claim) {
                Claim real = (Claim)claim;
                if (real.allowedEntries.isAllowed(ClaimAllowListKey.BLOCK_USE, arg_0 -> ((BlockState)state).is(arg_0), arg_0 -> ((BlockState)state).is(arg_0))) {
                    return InteractionResult.PASS;
                }
            }
            if (BlockInteractEvents.contains(id = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()), blockEntity = level.getBlockEntity(hitResult.getBlockPos()), ConfigHandler.CONFIG.interactBlockBlacklist, ConfigHandler.CONFIG.interactBlockEntityTagBlacklist)) {
                return InteractionResult.PASS;
            }
            ResourceLocation perm = InteractionOverrideManager.getInstance().getBlockInteract(state.getBlock());
            if (perm != null && perm.equals((Object)BuiltinPermission.PROJECTILES)) {
                perm = BuiltinPermission.OPENCONTAINER;
            }
            if (perm != null && !perm.equals((Object)BuiltinPermission.PRESSUREPLATE)) {
                if (claim.canInteract(player, perm, hitResult.getBlockPos(), true)) {
                    return InteractionResult.PASS;
                }
                if (state.getBlock() instanceof DoorBlock) {
                    DoubleBlockHalf half = (DoubleBlockHalf)state.getValue((Property)DoorBlock.HALF);
                    if (half == DoubleBlockHalf.LOWER) {
                        BlockState other = level.getBlockState(hitResult.getBlockPos().above());
                        player.connection.send((Packet)new ClientboundBlockUpdatePacket(hitResult.getBlockPos().above(), other));
                    } else {
                        BlockState other = level.getBlockState(hitResult.getBlockPos().below());
                        player.connection.send((Packet)new ClientboundBlockUpdatePacket(hitResult.getBlockPos().below(), other));
                    }
                }
                PlayerClaimData.get(player).addDisplayClaim(claim, EnumDisplayType.MAIN, player.blockPosition().getY());
                BlockInteractEvents.executeSignCommand(blockEntity, hitResult.getBlockPos(), player);
                return InteractionResult.FAIL;
            }
            if (blockEntity != null && (!player.isSecondaryUseActive() || stack.isEmpty())) {
                if (blockEntity instanceof LecternBlockEntity) {
                    if (claim.canInteract(player, BuiltinPermission.LECTERNTAKE, hitResult.getBlockPos(), false)) {
                        return InteractionResult.PASS;
                    }
                    if (((Boolean)state.getValue((Property)LecternBlock.HAS_BOOK)).booleanValue()) {
                        LockedLecternScreenHandler.create(player, (LecternBlockEntity)blockEntity);
                    }
                    return InteractionResult.FAIL;
                }
                if (blockEntity instanceof SignBlockEntity) {
                    if (claim.canInteract(player, BuiltinPermission.INTERACTSIGN, hitResult.getBlockPos(), false)) {
                        return InteractionResult.PASS;
                    }
                    return InteractionResult.FAIL;
                }
                if (!ConfigHandler.CONFIG.lenientBlockEntityCheck || CrossPlatformStuff.INSTANCE.isInventoryTile(blockEntity)) {
                    if (claim.canInteract(player, BuiltinPermission.OPENCONTAINER, hitResult.getBlockPos(), true)) {
                        return InteractionResult.PASS;
                    }
                    PlayerClaimData.get(player).addDisplayClaim(claim, EnumDisplayType.MAIN, player.blockPosition().getY());
                    return InteractionResult.FAIL;
                }
            }
            boolean shift = player.isSecondaryUseActive() || stack.isEmpty();
            boolean res = claim.canInteract(player, BuiltinPermission.INTERACTBLOCK, hitResult.getBlockPos(), shift);
            if (!res) {
                if (shift) {
                    PlayerClaimData.get(player).addDisplayClaim(claim, EnumDisplayType.MAIN, player.blockPosition().getY());
                }
                BlockInteractEvents.executeSignCommand(blockEntity, hitResult.getBlockPos(), player);
            }
            return res ? InteractionResult.PASS : InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    private static void executeSignCommand(BlockEntity blockEntity, BlockPos pos, ServerPlayer player) {
        if (blockEntity instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)blockEntity;
            sign.executeClickCommandsIfPresent(player.level(), (Player)player, pos, sign.isFacingFrontText((Player)player));
        }
    }

    public static boolean contains(ResourceLocation id, BlockEntity blockEntity, List<String> idList, List<String> tagList) {
        if (idList.contains(id.getNamespace()) || idList.contains(id.toString())) {
            return true;
        }
        if (blockEntity != null && !tagList.isEmpty()) {
            CompoundTag nbt = blockEntity.saveWithoutMetadata((HolderLookup.Provider)blockEntity.getLevel().registryAccess());
            return tagList.stream().anyMatch(tag -> CrossPlatformStuff.INSTANCE.blockDataContains(nbt, (String)tag));
        }
        return false;
    }

    public static boolean cancelEntityBlockCollision(BlockState state, Level level, BlockPos pos, Entity entity) {
        Entity owner;
        if (level.isClientSide || state.is(Blocks.AIR)) {
            return false;
        }
        ServerPlayer player = null;
        if (entity instanceof ServerPlayer) {
            player = (ServerPlayer)entity;
        } else if (entity instanceof Projectile) {
            owner = ((Projectile)entity).getOwner();
            if (owner instanceof ServerPlayer) {
                player = (ServerPlayer)owner;
            }
        } else if (entity instanceof ItemEntity && (owner = ((ItemEntity)entity).getOwner()) instanceof ServerPlayer) {
            player = (ServerPlayer)owner;
        }
        if (player == null) {
            return false;
        }
        ResourceLocation perm = InteractionOverrideManager.getInstance().getBlockInteract(state.getBlock());
        if (perm == null) {
            return false;
        }
        if (!perm.equals((Object)BuiltinPermission.PRESSUREPLATE) && !perm.equals((Object)BuiltinPermission.PORTAL)) {
            return false;
        }
        ClaimStorage storage = ClaimStorage.get((ServerLevel)level);
        IPermissionContainer claim = storage.getForPermissionCheck(pos);
        if (claim != null) {
            return !claim.canInteract(player, perm, pos, false);
        }
        return false;
    }

    public static boolean preventFallOn(Entity entity, double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
        Entity owner;
        if (entity.level().isClientSide) {
            return false;
        }
        if (entity instanceof ServerPlayer) {
            ResourceLocation perm = InteractionOverrideManager.getInstance().getBlockInteract(landedState.getBlock());
            if (perm == null || !perm.equals((Object)BuiltinPermission.TRAMPLE)) {
                return false;
            }
            ClaimStorage storage = ClaimStorage.get((ServerLevel)entity.level());
            IPermissionContainer claim = storage.getForPermissionCheck(landedPosition);
            if (claim == null) {
                return false;
            }
            return !claim.canInteract((ServerPlayer)entity, perm, landedPosition, true);
        }
        if (entity instanceof Projectile && (owner = ((Projectile)entity).getOwner()) instanceof ServerPlayer) {
            ResourceLocation perm = InteractionOverrideManager.getInstance().getBlockInteract(landedState.getBlock());
            if (perm == null || !perm.equals((Object)BuiltinPermission.TRAMPLE)) {
                return false;
            }
            ClaimStorage storage = ClaimStorage.get((ServerLevel)entity.level());
            IPermissionContainer claim = storage.getForPermissionCheck(landedPosition);
            return !claim.canInteract((ServerPlayer)owner, perm, landedPosition, true);
        }
        return false;
    }

    public static boolean canBreakTurtleEgg(Level level, BlockPos pos, Entity entity) {
        Entity owner;
        if (level.isClientSide) {
            return false;
        }
        ServerLevel serverWorld = (ServerLevel)level;
        if (entity instanceof ServerPlayer) {
            ClaimStorage storage = ClaimStorage.get(serverWorld);
            IPermissionContainer claim = storage.getForPermissionCheck(pos);
            if (claim == null) {
                return false;
            }
            return !claim.canInteract((ServerPlayer)entity, BuiltinPermission.TRAMPLE, pos, true);
        }
        if (entity instanceof Projectile) {
            Entity owner2 = ((Projectile)entity).getOwner();
            if (owner2 instanceof ServerPlayer) {
                ClaimStorage storage = ClaimStorage.get(serverWorld);
                IPermissionContainer claim = storage.getForPermissionCheck(pos);
                if (claim == null) {
                    return false;
                }
                return !claim.canInteract((ServerPlayer)owner2, BuiltinPermission.TRAMPLE, pos, true);
            }
        } else if (entity instanceof ItemEntity && (owner = ((ItemEntity)entity).getOwner()) instanceof ServerPlayer) {
            ClaimStorage storage = ClaimStorage.get(serverWorld);
            IPermissionContainer claim = storage.getForPermissionCheck(pos);
            if (claim == null) {
                return false;
            }
            return !claim.canInteract((ServerPlayer)owner, BuiltinPermission.TRAMPLE, pos, true);
        }
        return false;
    }
}

