/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.event;

import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.InteractionOverrideManager;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.claim.attachment.ClaimAllowListKey;
import io.github.flemmli97.flan.mixin.BonemealableBlockAccess;
import io.github.flemmli97.flan.mixin.IHungerAccessor;
import io.github.flemmli97.flan.platform.CrossPlatformStuff;
import io.github.flemmli97.flan.player.LogoutTracker;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.utils.IOwnedItem;
import io.github.flemmli97.flan.utils.PlayerDropHandler;
import io.github.flemmli97.flan.utils.TeleportUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.data.worldgen.features.NetherFeatures;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetContentPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableFeaturePlacerBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NetherForestVegetationConfig;
import net.minecraft.world.level.levelgen.feature.configurations.TwistingVinesConfig;
import net.minecraft.world.level.levelgen.feature.configurations.VegetationPatchConfiguration;
import net.minecraft.world.phys.Vec3;

public class PlayerEvents {
    public static void saveClaimData(Player player) {
        if (player instanceof ServerPlayer) {
            PlayerClaimData.get((ServerPlayer)player).save(player.getServer());
        }
    }

    public static void readClaimData(Player player) {
        if (player instanceof ServerPlayer) {
            PlayerClaimData.get((ServerPlayer)player).read(player.getServer());
        }
    }

    public static void onLogout(Player player) {
        if (player.getServer() != null) {
            LogoutTracker.getInstance(player.getServer()).track(player.getUUID());
        }
    }

    public static boolean growBonemeal(UseOnContext context) {
        Player player = context.getPlayer();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockState state = serverPlayer.level().getBlockState(context.getClickedPos());
            BlockPos.MutableBlockPos pos = context.getClickedPos().mutable();
            ResourceLocation perm = InteractionOverrideManager.getInstance().getItemUse(context.getItemInHand().getItem());
            if (perm != null && !ClaimStorage.get(serverPlayer.level()).getForPermissionCheck((BlockPos)pos).canInteract(serverPlayer, perm, (BlockPos)pos, false)) {
                return false;
            }
            int range = 0;
            RegistryAccess registry = serverPlayer.level().registryAccess();
            Block block = state.getBlock();
            if (block instanceof BonemealableFeaturePlacerBlock) {
                BonemealableFeaturePlacerBlock bonemealable = (BonemealableFeaturePlacerBlock)block;
                cfg = PlayerEvents.featureRange(registry, ((BonemealableBlockAccess)bonemealable).getFeature(), VegetationPatchConfiguration.class);
                if (cfg != null) {
                    range = cfg.xzRadius.getMaxValue() + 1;
                    pos.set(pos.getX(), pos.getY() + cfg.verticalRange + 1, pos.getZ());
                }
            } else if (state.getBlock() instanceof GrassBlock) {
                range = 4;
            } else if (state.is(Blocks.CRIMSON_NYLIUM)) {
                cfg = PlayerEvents.featureRange(registry, NetherFeatures.CRIMSON_FOREST_VEGETATION_BONEMEAL, NetherForestVegetationConfig.class);
                if (cfg != null) {
                    range = cfg.spreadWidth;
                    pos.set(pos.getX(), pos.getY() + cfg.spreadHeight + 1, pos.getZ());
                }
            } else if (state.is(Blocks.WARPED_NYLIUM)) {
                cfg = PlayerEvents.featureRange(registry, NetherFeatures.WARPED_FOREST_VEGETATION_BONEMEAL, NetherForestVegetationConfig.class);
                NetherForestVegetationConfig cfg2 = PlayerEvents.featureRange(registry, NetherFeatures.NETHER_SPROUTS_BONEMEAL, NetherForestVegetationConfig.class);
                TwistingVinesConfig cfg3 = PlayerEvents.featureRange(registry, NetherFeatures.TWISTING_VINES_BONEMEAL, TwistingVinesConfig.class);
                int w1 = cfg == null ? 0 : cfg.spreadWidth;
                int w2 = cfg2 == null ? 0 : cfg2.spreadWidth;
                int w3 = cfg3 == null ? 0 : cfg3.spreadWidth();
                int h1 = cfg == null ? 0 : cfg.spreadHeight;
                int h2 = cfg2 == null ? 0 : cfg2.spreadHeight;
                int h3 = cfg3 == null ? 0 : cfg3.spreadHeight();
                range = Math.max(Math.max(w1, w2), w3);
                int y = Math.max(Math.max(h1, h2), h3);
                pos.set(pos.getX(), pos.getY() + y + 1, pos.getZ());
            }
            if (range > 0 && perm != null && !ClaimStorage.get(serverPlayer.level()).canInteract((BlockPos)pos, range, serverPlayer, perm, false)) {
                serverPlayer.displayClientMessage((Component)ClaimUtils.translatedText("flan.tooCloseClaim", ChatFormatting.DARK_RED), true);
                return true;
            }
        }
        return false;
    }

    public static float canSpawnFromPlayer(Entity entity, float old) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            BlockPos pos = player.blockPosition();
            if (!ClaimStorage.get(player.level()).getForPermissionCheck(pos).canInteract(player, BuiltinPermission.PLAYERMOBSPAWN, pos, false)) {
                return -1.0f;
            }
        }
        return old;
    }

    public static boolean canWardenSpawnTrigger(BlockPos pos, ServerPlayer player) {
        return ClaimStorage.get(player.level()).getForPermissionCheck(pos).canInteract(player, BuiltinPermission.PLAYERMOBSPAWN, pos, false);
    }

    public static boolean canSculkTrigger(BlockPos pos, ServerPlayer player) {
        return ClaimStorage.get(player.level()).getForPermissionCheck(pos).canInteract(player, BuiltinPermission.SCULK, pos, false);
    }

    public static <T extends FeatureConfiguration> T featureRange(RegistryAccess registry, ResourceKey<ConfiguredFeature<?, ?>> key, Class<T> clss) {
        return (T)((FeatureConfiguration)registry.get(key).map(r -> {
            if (clss.isInstance(((ConfiguredFeature)r.value()).config())) {
                return ((ConfiguredFeature)r.value()).config();
            }
            return null;
        }).orElse(null));
    }

    public static boolean xpAbsorb(Player player) {
        BlockPos pos;
        ClaimStorage storage;
        IPermissionContainer claim;
        if (player instanceof ServerPlayer && (claim = (storage = ClaimStorage.get((ServerLevel)player.level())).getForPermissionCheck(pos = player.blockPosition())) != null) {
            return !claim.canInteract((ServerPlayer)player, BuiltinPermission.XP, pos, false);
        }
        return false;
    }

    public static boolean canCollideWith(Player player, Entity entity) {
        if (player instanceof ServerPlayer) {
            ServerPlayer sPlayer = (ServerPlayer)player;
            if (entity instanceof ItemEntity) {
                BlockPos pos;
                ItemEntity itemEntity = (ItemEntity)entity;
                IOwnedItem ownedItem = (IOwnedItem)entity;
                if (ownedItem.flan$getDeathPlayer() != null) {
                    ServerPlayer other = sPlayer.getServer().getPlayerList().getPlayer(ownedItem.flan$getDeathPlayer());
                    if (other == null) {
                        return false;
                    }
                    return ownedItem.flan$getDeathPlayer().equals(player.getUUID()) || PlayerClaimData.get(other).deathItemsUnlocked();
                }
                if (sPlayer.getUUID().equals(ownedItem.flan$getPlayerOrigin())) {
                    return true;
                }
                ClaimStorage storage = ClaimStorage.get(sPlayer.level());
                IPermissionContainer claim = storage.getForPermissionCheck(pos = sPlayer.blockPosition());
                if (claim != null) {
                    if (claim instanceof Claim) {
                        Claim real = (Claim)claim;
                        if (real.allowedEntries.isAllowed(ClaimAllowListKey.ITEM_PICKUP, arg_0 -> ((ItemStack)itemEntity.getItem()).is(arg_0), arg_0 -> ((ItemStack)itemEntity.getItem()).is(arg_0))) {
                            return true;
                        }
                    }
                    return claim.canInteract(sPlayer, BuiltinPermission.PICKUP, pos, false);
                }
            }
        }
        return true;
    }

    public static boolean canDropItem(Player player, ItemStack stack) {
        block7: {
            boolean allow;
            PlayerDropHandler dropHandler;
            block8: {
                IPermissionContainer claim;
                BlockPos pos;
                block9: {
                    if (player.isDeadOrDying() || !(player instanceof ServerPlayer) || (dropHandler = (PlayerDropHandler)player).flan$forcedDropState()) break block7;
                    ClaimStorage storage = ClaimStorage.get((ServerLevel)player.level());
                    pos = player.blockPosition();
                    claim = storage.getForPermissionCheck(pos);
                    allow = true;
                    if (claim == null) break block8;
                    if (!(claim instanceof Claim)) break block9;
                    Claim real = (Claim)claim;
                    if (real.allowedEntries.isAllowed(ClaimAllowListKey.ITEM_DROP, arg_0 -> ((ItemStack)stack).is(arg_0), arg_0 -> ((ItemStack)stack).is(arg_0))) break block8;
                }
                allow = claim.canInteract((ServerPlayer)player, BuiltinPermission.DROP, pos, false);
            }
            if (!allow) {
                if (player.getInventory().add(stack) && !stack.isEmpty()) {
                    dropHandler.flan$setForcedDrop(true);
                    ItemEntity itemEntity = player.drop(stack, false);
                    dropHandler.flan$setForcedDrop(false);
                    if (itemEntity != null) {
                        itemEntity.setNoPickUpDelay();
                        itemEntity.setTarget(player.getUUID());
                    }
                }
                NonNullList stacks = NonNullList.create();
                for (int j = 0; j < player.containerMenu.slots.size(); ++j) {
                    ItemStack itemStack2 = ((Slot)player.containerMenu.slots.get(j)).getItem();
                    stacks.add((Object)(itemStack2.isEmpty() ? ItemStack.EMPTY : itemStack2));
                }
                ((ServerPlayer)player).connection.send((Packet)new ClientboundContainerSetContentPacket(player.containerMenu.containerId, 0, (List)stacks, player.inventoryMenu.getCarried()));
            }
            return allow;
        }
        return true;
    }

    public static void updateDroppedItem(Player player, ItemEntity entity) {
        ((IOwnedItem)entity).flan$setOriginPlayer(player);
    }

    public static Claim currentClaimTick(ServerPlayer player, Claim currentClaim) {
        Claim permissionContainer;
        Vec3 pos = player.position();
        BlockPos rounded = TeleportUtils.roundedBlockPos(pos.add(0.0, (double)player.getEyeHeight(player.getPose()), 0.0));
        ClaimStorage storage = ClaimStorage.get(player.level());
        Claim newClaim = currentClaim;
        if (currentClaim != null) {
            if (!currentClaim.intersects(player.getBoundingBox())) {
                Claim claim2;
                boolean isSub = currentClaim.parentClaim() != null;
                Claim claim3 = claim2 = isSub ? storage.getClaimAt(rounded) : currentClaim.parentClaim();
                if (claim2 == null) {
                    currentClaim.displayLeaveTitle(player);
                    if (!PlayerEvents.gameModeCanFly(player.gameMode.getGameModeForPlayer())) {
                        CrossPlatformStuff.INSTANCE.toggleCreativeFlight(player, false);
                    }
                } else {
                    Claim sub = claim2.getSubClaim(rounded);
                    boolean display = true;
                    if (sub != null) {
                        claim2 = sub;
                    } else {
                        boolean bl = display = currentClaim.enterTitle != null;
                        if (claim2.enterTitle == null) {
                            currentClaim.displayLeaveTitle(player);
                        }
                    }
                    if (display) {
                        claim2.displayEnterTitle(player);
                    }
                }
                newClaim = claim2;
            } else {
                Claim sub;
                if (currentClaim.parentClaim() == null && (sub = currentClaim.getSubClaim(rounded)) != null) {
                    currentClaim = sub;
                    currentClaim.displayEnterTitle(player);
                    newClaim = currentClaim;
                }
                if (!player.isSpectator()) {
                    BlockPos.MutableBlockPos bPos = rounded.mutable();
                    boolean isSub = currentClaim.parentClaim() != null;
                    Claim mainClaim = isSub ? currentClaim.parentClaim() : currentClaim;
                    Entity vehicle = player.getVehicle();
                    if (!mainClaim.canInteract(player, BuiltinPermission.CANSTAY, (BlockPos)bPos, true)) {
                        Claim sub2 = isSub ? currentClaim : null;
                        Vec3 tp = TeleportUtils.getTeleportPos((Entity)player, pos, storage, new TeleportUtils.Area2D(sub2 != null ? sub2.getDimensions() : mainClaim.getDimensions()), true, bPos, (claim, nPos) -> claim.canInteract(player, BuiltinPermission.CANSTAY, (BlockPos)nPos, false));
                        if (vehicle != null) {
                            if (!vehicle.isLocalInstanceAuthoritative()) {
                                player.stopRiding();
                            }
                            vehicle.teleportTo(tp.x(), tp.y(), tp.z());
                        }
                        player.teleportTo(tp.x(), tp.y(), tp.z());
                    }
                    rounded = bPos;
                    currentClaim.applyEffects(player);
                }
            }
        } else if (player.tickCount % 3 == 0) {
            Claim sub;
            Claim claim4 = storage.getClaimAt(rounded);
            Claim claim5 = sub = claim4 != null ? claim4.getSubClaim(rounded) : null;
            if (sub != null) {
                claim4 = sub;
            }
            if (claim4 != null) {
                claim4.displayEnterTitle(player);
            }
            newClaim = claim4;
        }
        IPermissionContainer iPermissionContainer = permissionContainer = newClaim != null ? newClaim : storage.getForPermissionCheck(rounded);
        if (player.getAbilities().flying && !PlayerEvents.gameModeCanFly(player.gameMode.getGameModeForPlayer()) && !permissionContainer.canInteract(player, BuiltinPermission.ALLOW_FLIGHT, rounded, true)) {
            player.getAbilities().flying = false;
            player.setDeltaMovement(Vec3.ZERO);
            player.connection.send((Packet)new ClientboundSetEntityMotionPacket((Entity)player));
            player.connection.send((Packet)new ClientboundPlayerAbilitiesPacket(player.getAbilities()));
        } else if (!PlayerEvents.gameModeCanFly(player.gameMode.getGameModeForPlayer())) {
            CrossPlatformStuff.INSTANCE.toggleCreativeFlight(player, permissionContainer.canInteract(player, BuiltinPermission.MAY_FLIGHT, rounded, false));
        }
        if (player.getFoodData().getSaturationLevel() < 2.0f && permissionContainer.canInteract(player, BuiltinPermission.NOHUNGER, rounded, false)) {
            ((IHungerAccessor)player.getFoodData()).setSaturation(2.0f);
        }
        return newClaim;
    }

    protected static boolean gameModeCanFly(GameType gameType) {
        return gameType == GameType.CREATIVE || gameType == GameType.SPECTATOR;
    }
}

