/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.gui.ClaimAllowListEntryScreenHandler;
import io.github.flemmli97.flan.gui.ClaimTextHandler;
import io.github.flemmli97.flan.gui.ConfirmScreenHandler;
import io.github.flemmli97.flan.gui.FakePlayerScreenHandler;
import io.github.flemmli97.flan.gui.GroupScreenHandler;
import io.github.flemmli97.flan.gui.PermissionScreenHandler;
import io.github.flemmli97.flan.gui.PotionEditScreenHandler;
import io.github.flemmli97.flan.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.player.PlayerClaimData;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ClaimMenuScreenHandler
extends ServerOnlyScreenHandler<Claim> {
    private ClaimMenuScreenHandler(int syncId, Inventory playerInventory, Claim claim) {
        super(syncId, playerInventory, 2, claim);
    }

    public static void openClaimMenu(ServerPlayer player, final Claim claim) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                return new ClaimMenuScreenHandler(syncId, inv, claim);
            }

            public Component getDisplayName() {
                return ClaimUtils.translatedText(claim.parentClaim() != null ? "flan.screenMenuSub" : "flan.screenMenu", new Object[0]);
            }
        };
        player.openMenu(fac);
    }

    @Override
    protected void fillInventoryWith() {
        block10: for (int i = 0; i < 18; ++i) {
            switch (i) {
                case 0: {
                    ItemStack stack = ServerScreenHelper.createStack(Items.TNT, (Component)ServerScreenHelper.coloredGuiText("flan.screenClose", ChatFormatting.DARK_RED));
                    ((Slot)this.slots.get(i)).set(stack);
                    continue block10;
                }
                case 2: {
                    ItemStack stack = ServerScreenHelper.createStack(Items.BEACON, (Component)ServerScreenHelper.coloredGuiText("flan.screenMenuGlobal", ChatFormatting.GOLD));
                    if (!this.hasEditPerm((Claim)this.data, this.player)) {
                        ServerScreenHelper.addLore(stack, (Component)ServerScreenHelper.coloredGuiText("flan.screenNoPerm", ChatFormatting.DARK_RED));
                    }
                    ((Slot)this.slots.get(i)).set(stack);
                    continue block10;
                }
                case 3: {
                    ItemStack stack = ServerScreenHelper.createStack(Items.WRITABLE_BOOK, (Component)ServerScreenHelper.coloredGuiText("flan.screenMenuGroup", ChatFormatting.GOLD));
                    if (!this.hasEditPerm((Claim)this.data, this.player)) {
                        ServerScreenHelper.addLore(stack, (Component)ServerScreenHelper.coloredGuiText("flan.screenNoPerm", ChatFormatting.DARK_RED));
                    }
                    ((Slot)this.slots.get(i)).set(stack);
                    continue block10;
                }
                case 4: {
                    ItemStack stack = ServerScreenHelper.createStack(Items.POTION, (Component)ServerScreenHelper.coloredGuiText("flan.screenMenuPotion", ChatFormatting.GOLD));
                    if (!this.hasPerm((Claim)this.data, this.player, BuiltinPermission.EDITPOTIONS)) {
                        ServerScreenHelper.addLore(stack, (Component)ServerScreenHelper.coloredGuiText("flan.screenNoPerm", ChatFormatting.DARK_RED));
                    }
                    ((Slot)this.slots.get(i)).set(stack);
                    continue block10;
                }
                case 5: {
                    ItemStack stack = ServerScreenHelper.createStack(Items.OAK_SIGN, (Component)ServerScreenHelper.coloredGuiText("flan.screenMenuClaimText", ChatFormatting.GOLD));
                    if (!this.hasPerm((Claim)this.data, this.player, BuiltinPermission.CLAIMMESSAGE)) {
                        ServerScreenHelper.addLore(stack, (Component)ServerScreenHelper.coloredGuiText("flan.screenNoPerm", ChatFormatting.DARK_RED));
                    }
                    ((Slot)this.slots.get(i)).set(stack);
                    continue block10;
                }
                case 6: {
                    ItemStack stack = ServerScreenHelper.createStack(Items.ZOMBIE_HEAD, (Component)ServerScreenHelper.coloredGuiText("flan.screenMenuFakePlayers", ChatFormatting.GOLD));
                    if (!this.hasPerm((Claim)this.data, this.player, BuiltinPermission.EDITPERMS)) {
                        ServerScreenHelper.addLore(stack, (Component)ServerScreenHelper.coloredGuiText("flan.screenNoPerm", ChatFormatting.DARK_RED));
                    }
                    ((Slot)this.slots.get(i)).set(stack);
                    continue block10;
                }
                case 8: {
                    ItemStack stack = ServerScreenHelper.createStack(Items.BARRIER, (Component)ServerScreenHelper.coloredGuiText("flan.screenMenuDelete", ChatFormatting.RED));
                    if (!this.hasPerm((Claim)this.data, this.player, BuiltinPermission.EDITCLAIM)) {
                        ServerScreenHelper.addLore(stack, (Component)ServerScreenHelper.coloredGuiText("flan.screenNoPerm", ChatFormatting.DARK_RED));
                    }
                    ((Slot)this.slots.get(i)).set(stack);
                    continue block10;
                }
                case 11: {
                    ItemStack stack = ServerScreenHelper.createStack(Items.BOOKSHELF, (Component)ServerScreenHelper.coloredGuiText("flan.screenAllowList", ChatFormatting.GOLD));
                    if (!this.hasPerm((Claim)this.data, this.player, BuiltinPermission.EDITCLAIM)) {
                        ServerScreenHelper.addLore(stack, (Component)ServerScreenHelper.coloredGuiText("flan.screenNoPerm", ChatFormatting.DARK_RED));
                    }
                    ((Slot)this.slots.get(i)).set(stack);
                    continue block10;
                }
                default: {
                    ((Slot)this.slots.get(i)).set(ServerScreenHelper.emptyFiller());
                }
            }
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 2 || slot == 3 || slot == 4 || slot == 5 || slot == 6 || slot == 8 || slot >= 11 && slot <= 15;
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        switch (index) {
            case 0: {
                player.closeContainer();
                ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
                break;
            }
            case 2: {
                if (this.hasEditPerm((Claim)this.data, player)) {
                    player.closeContainer();
                    player.getServer().execute(() -> PermissionScreenHandler.openClaimMenu((Player)player, (Claim)this.data, null));
                    ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
                break;
            }
            case 3: {
                if (this.hasEditPerm((Claim)this.data, player)) {
                    player.closeContainer();
                    player.getServer().execute(() -> GroupScreenHandler.openGroupMenu((Player)player, (Claim)this.data));
                    ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
                break;
            }
            case 4: {
                if (this.hasPerm((Claim)this.data, player, BuiltinPermission.EDITPOTIONS)) {
                    player.closeContainer();
                    player.getServer().execute(() -> PotionEditScreenHandler.openPotionMenu((Player)player, (Claim)this.data));
                    ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
                break;
            }
            case 5: {
                if (this.hasPerm((Claim)this.data, player, BuiltinPermission.CLAIMMESSAGE)) {
                    player.closeContainer();
                    player.getServer().execute(() -> ClaimTextHandler.openClaimMenu(player, (Claim)this.data));
                    ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
                break;
            }
            case 6: {
                if (this.hasPerm((Claim)this.data, player, BuiltinPermission.EDITPERMS)) {
                    player.closeContainer();
                    player.getServer().execute(() -> FakePlayerScreenHandler.open((Player)player, (Claim)this.data));
                    ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
                break;
            }
            case 8: {
                if (this.hasPerm((Claim)this.data, player, BuiltinPermission.EDITCLAIM)) {
                    player.closeContainer();
                    player.getServer().execute(() -> ConfirmScreenHandler.openConfirmScreen(player, bool -> {
                        if (bool.booleanValue()) {
                            ClaimStorage storage = ClaimStorage.get(player.level());
                            storage.deleteClaim((Claim)this.data, true, PlayerClaimData.get(player).getClaimMode(), player.level());
                            player.closeContainer();
                            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.deleteClaim", ChatFormatting.RED), false);
                            ServerScreenHelper.playSongToPlayer(player, SoundEvents.ANVIL_PLACE, 1.0f, 1.0f);
                        } else {
                            player.closeContainer();
                            player.getServer().execute(() -> ClaimMenuScreenHandler.openClaimMenu(player, (Claim)this.data));
                            ServerScreenHelper.playSongToPlayer(player, SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
                        }
                    }));
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
                break;
            }
            case 11: {
                if (this.hasPerm((Claim)this.data, player, BuiltinPermission.EDITPERMS)) {
                    player.closeContainer();
                    player.getServer().execute(() -> ClaimAllowListEntryScreenHandler.openScreen(player, (Claim)this.data));
                    ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
                    break;
                }
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
            }
        }
        return true;
    }

    private boolean hasEditPerm(Claim claim, ServerPlayer player) {
        return claim.parentClaim() != null && claim.parentClaim().canInteract(player, BuiltinPermission.EDITPERMS, player.blockPosition()) || claim.canInteract(player, BuiltinPermission.EDITPERMS, player.blockPosition());
    }

    private boolean hasPerm(Claim claim, ServerPlayer player, ResourceLocation perm) {
        if (claim.parentClaim() != null) {
            return claim.parentClaim().canInteract(player, perm, player.blockPosition());
        }
        return claim.canInteract(player, perm, player.blockPosition());
    }
}

