/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.claim.attachment.ClaimAllowListKey;
import io.github.flemmli97.flan.gui.ClaimAllowListEntryScreenHandler;
import io.github.flemmli97.flan.gui.PagedServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.StringResultScreenHandler;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;

public class CustomInteractListScreenHandler
extends PagedServerOnlyScreenHandler<Data> {
    private boolean removeMode;

    private CustomInteractListScreenHandler(int syncId, Inventory playerInventory, Data data) {
        super(syncId, playerInventory, 6, data);
    }

    public static void openMenu(Player player, final ClaimAllowListKey<?> key, final Claim claim) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                return new CustomInteractListScreenHandler(syncId, inv, new Data(claim, key));
            }

            public Component getDisplayName() {
                return ClaimUtils.translatedText(key.translationKey(), new Object[0]);
            }
        };
        player.openMenu(fac);
    }

    @Override
    protected void fillInventoryWith() {
        for (int i = 0; i < 54; ++i) {
            ItemStack stack;
            if (i == 0) {
                stack = ServerScreenHelper.createStack(Items.TNT, (Component)ServerScreenHelper.coloredGuiText("flan.screenBack", ChatFormatting.DARK_RED));
                ((Slot)this.slots.get(i)).set(stack);
                continue;
            }
            if (i == 3) {
                stack = ServerScreenHelper.createStack(Items.ANVIL, (Component)ServerScreenHelper.coloredGuiText("flan.screenAdd", ChatFormatting.DARK_GREEN));
                ((Slot)this.slots.get(i)).set(stack);
                continue;
            }
            if (i == 4) {
                stack = ServerScreenHelper.createStack(Items.REDSTONE_BLOCK, (Component)ServerScreenHelper.coloredGuiText("flan.screenRemoveMode", this.removeMode, ChatFormatting.DARK_RED));
                ((Slot)this.slots.get(i)).set(stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                ((Slot)this.slots.get(i)).set(ServerScreenHelper.emptyFiller());
                continue;
            }
            List<ItemStack> stacks = ((Data)this.data).claim.allowedEntries.get(((Data)this.data).key).asStacks();
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1 + this.getPage() * 28;
            if (id < stacks.size()) {
                ItemStack stack2 = stacks.get(id);
                CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack2, tag -> tag.putInt("Index", id));
                ((Slot)this.slots.get(i)).set(stack2);
                continue;
            }
            ((Slot)this.slots.get(i)).set(ItemStack.EMPTY);
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 3 || slot == 4 || slot < 45 && slot > 8 && slot % 9 != 0 && slot % 9 != 8;
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        if (index == 0) {
            player.closeContainer();
            player.getServer().execute(() -> ClaimAllowListEntryScreenHandler.openScreen(player, ((Data)this.data).claim));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
            return true;
        }
        if (index == 3) {
            player.closeContainer();
            player.getServer().execute(() -> StringResultScreenHandler.createNewStringResult((Player)player, s -> {
                ((Data)this.data).claim.allowedEntries.get(((Data)this.data).key).addAllowedItem((String)s);
                player.closeContainer();
                player.getServer().execute(() -> CustomInteractListScreenHandler.openMenu((Player)player, ((Data)this.data).key, ((Data)this.data).claim));
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.ANVIL_USE, 1.0f, 1.0f);
            }, () -> {
                player.closeContainer();
                player.getServer().execute(() -> CustomInteractListScreenHandler.openMenu((Player)player, ((Data)this.data).key, ((Data)this.data).claim));
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
            }));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
            return true;
        }
        if (index == 4) {
            this.removeMode = !this.removeMode;
            ItemStack stack = ServerScreenHelper.createStack(Items.REDSTONE_BLOCK, (Component)ServerScreenHelper.coloredGuiText("flan.screenRemoveMode", this.removeMode, ChatFormatting.DARK_RED));
            slot.set(stack);
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
            return true;
        }
        ItemStack stack = slot.getItem();
        if (!stack.isEmpty()) {
            int idx;
            CustomData nbt = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            int n = idx = nbt != null ? nbt.copyTag().getIntOr("Index", 0) : 0;
            if (this.removeMode) {
                ((Data)this.data).claim.allowedEntries.get(((Data)this.data).key).removeAllowedItem(idx);
                slot.set(ItemStack.EMPTY);
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.BAT_DEATH, 1.0f, 1.0f);
            }
        }
        return false;
    }

    @Override
    protected PagedServerOnlyScreenHandler.PageSettings pageSettings() {
        int size = ((Data)this.data).claim.allowedEntries.get(((Data)this.data).key).size();
        return new PagedServerOnlyScreenHandler.PageSettings((size - 1) / 28, 47, 51);
    }

    public record Data(Claim claim, ClaimAllowListKey<?> key) {
    }
}

