/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.gui.PagedServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.StringResultScreenHandler;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;

public class FakePlayerScreenHandler
extends PagedServerOnlyScreenHandler<Claim> {
    private boolean removeMode;

    private FakePlayerScreenHandler(int syncId, Inventory playerInventory, Claim claim) {
        super(syncId, playerInventory, 6, claim);
    }

    public static void open(Player player, final Claim claim) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                return new FakePlayerScreenHandler(syncId, inv, claim);
            }

            public Component getDisplayName() {
                return ClaimUtils.translatedText("flan.screenMenuFakePlayers", new Object[0]);
            }
        };
        player.openMenu(fac);
    }

    @Override
    protected void fillInventoryWith() {
        List<String> players = ((Claim)this.data).getAllowedFakePlayerUUID();
        for (int i = 0; i < 54; ++i) {
            if (i == 0) {
                ItemStack stack = ServerScreenHelper.createStack(Items.TNT, (Component)ServerScreenHelper.coloredGuiText("flan.screenBack", ChatFormatting.DARK_RED));
                ((Slot)this.slots.get(i)).set(stack);
                continue;
            }
            if (i == 3) {
                ItemStack stack = ServerScreenHelper.createStack(Items.ANVIL, (Component)ServerScreenHelper.coloredGuiText("flan.screenAdd", ChatFormatting.DARK_GREEN));
                ((Slot)this.slots.get(i)).set(stack);
                continue;
            }
            if (i == 4) {
                ItemStack stack = ServerScreenHelper.createStack(Items.REDSTONE_BLOCK, (Component)ServerScreenHelper.coloredGuiText("flan.screenRemoveMode", this.removeMode, ChatFormatting.DARK_RED));
                ((Slot)this.slots.get(i)).set(stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                ((Slot)this.slots.get(i)).set(ServerScreenHelper.emptyFiller());
                continue;
            }
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1 + this.getPage() * 28;
            if (id < players.size()) {
                ItemStack stack = ServerScreenHelper.createStack(Items.ZOMBIE_HEAD, null);
                CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, t -> t.putString("FlanFakePlayer", (String)players.get(id)));
                stack.set(DataComponents.CUSTOM_NAME, (Object)ServerScreenHelper.coloredGuiText("flan.screenFakePlayerNameUUID", players.get(id), ChatFormatting.YELLOW));
                ((Slot)this.slots.get(i)).set(stack);
                continue;
            }
            ((Slot)this.slots.get(i)).set(ItemStack.EMPTY);
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 3 || slot == 4 || slot < 45 && slot > 8 && slot % 9 != 0 && slot % 9 != 8;
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        if (index == 0) {
            player.closeContainer();
            player.getServer().execute(() -> ClaimMenuScreenHandler.openClaimMenu(player, (Claim)this.data));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
            return true;
        }
        if (index == 3) {
            player.closeContainer();
            player.getServer().execute(() -> StringResultScreenHandler.createNewStringResult((Player)player, s -> {
                boolean fl = player.getServer().getProfileCache().get(s).map(prof -> ((Claim)this.data).modifyFakePlayerUUID(prof.getId(), false)).orElse(true);
                player.closeContainer();
                player.getServer().execute(() -> FakePlayerScreenHandler.open((Player)player, (Claim)this.data));
                if (fl) {
                    ServerScreenHelper.playSongToPlayer(player, SoundEvents.ANVIL_USE, 1.0f, 1.0f);
                } else {
                    player.displayClientMessage((Component)ClaimUtils.translatedText("flan.playerGroupAddFail", ChatFormatting.RED), false);
                    ServerScreenHelper.playSongToPlayer(player, SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
                }
            }, () -> {
                player.closeContainer();
                player.getServer().execute(() -> FakePlayerScreenHandler.open((Player)player, (Claim)this.data));
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
            }));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
            return true;
        }
        if (index == 4) {
            this.removeMode = !this.removeMode;
            ItemStack stack = ServerScreenHelper.createStack(Items.REDSTONE_BLOCK, (Component)ServerScreenHelper.coloredGuiText("flan.screenRemoveMode", this.removeMode, ChatFormatting.DARK_RED));
            slot.set(stack);
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
            return true;
        }
        ItemStack stack = slot.getItem();
        if (!stack.isEmpty()) {
            UUID uuid = null;
            try {
                uuid = UUID.fromString(((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getStringOr("FlanFakePlayer", ""));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (this.removeMode && uuid != null) {
                ((Claim)this.data).modifyFakePlayerUUID(uuid, true);
                slot.set(ItemStack.EMPTY);
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.BAT_DEATH, 1.0f, 1.0f);
            }
        }
        return false;
    }

    @Override
    protected PagedServerOnlyScreenHandler.PageSettings pageSettings() {
        return new PagedServerOnlyScreenHandler.PageSettings((((Claim)this.data).getAllowedFakePlayerUUID().size() - 1) / 28, 47, 51);
    }
}

