/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.api.permission.PermissionManager;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.gui.ClaimGroup;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.gui.GroupScreenHandler;
import io.github.flemmli97.flan.gui.PagedServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;

public class PermissionScreenHandler
extends PagedServerOnlyScreenHandler<ClaimGroup> {
    private List<ClaimPermission> perms;

    private PermissionScreenHandler(int syncId, Inventory playerInventory, final Claim claim, final String group) {
        super(syncId, playerInventory, 6, new ClaimGroup(){

            @Override
            public Claim getClaim() {
                return claim;
            }

            @Override
            public String getGroup() {
                return group;
            }
        });
    }

    public static void openClaimMenu(Player player, final Claim claim, final String group) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                return new PermissionScreenHandler(syncId, inv, claim, group);
            }

            public Component getDisplayName() {
                return group == null ? ClaimUtils.translatedText("flan.screenGlobalPerms", new Object[0]) : ClaimUtils.translatedText("flan.screenGroupPerms", group);
            }
        };
        player.openMenu(fac);
    }

    @Override
    protected void fillInventoryWith() {
        this.perms = new ArrayList<ClaimPermission>(PermissionManager.getInstance().getAll());
        if (((ClaimGroup)this.data).getGroup() != null) {
            this.perms.removeIf(p -> p.global);
        }
        for (int i = 0; i < 54; ++i) {
            if (i == 0) {
                ItemStack stack = ServerScreenHelper.createStack(Items.TNT, (Component)ServerScreenHelper.coloredGuiText("flan.screenBack", ChatFormatting.DARK_RED));
                ((Slot)this.slots.get(i)).set(stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                ((Slot)this.slots.get(i)).set(ServerScreenHelper.emptyFiller());
                continue;
            }
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1 + this.getPage() * 28;
            if (id < this.perms.size()) {
                ((Slot)this.slots.get(i)).set(ServerScreenHelper.fromPermission(((ClaimGroup)this.data).getClaim(), this.player, this.perms.get(id), ((ClaimGroup)this.data).getGroup() == null ? null : ((ClaimGroup)this.data).getGroup()));
                continue;
            }
            ((Slot)this.slots.get(i)).set(ItemStack.EMPTY);
        }
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        boolean success;
        ClaimPermission perm;
        if (index == 0) {
            if (((ClaimGroup)this.data).getGroup() == null) {
                player.closeContainer();
                player.getServer().execute(() -> ClaimMenuScreenHandler.openClaimMenu(player, ((ClaimGroup)this.data).getClaim()));
            } else {
                player.closeContainer();
                player.getServer().execute(() -> GroupScreenHandler.openGroupMenu((Player)player, ((ClaimGroup)this.data).getClaim()));
            }
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
            return true;
        }
        ItemStack stack = slot.getItem();
        try {
            perm = PermissionManager.getInstance().get(ResourceLocation.parse((String)((CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getStringOr("flan.permission", "")));
            if (perm == null) {
                return false;
            }
        }
        catch (NullPointerException e) {
            return false;
        }
        if (((ClaimGroup)this.data).getGroup() == null) {
            int mode = ((ClaimGroup)this.data).getClaim().parentClaim() == null ? (((ClaimGroup)this.data).getClaim().permEnabled(perm.getId()) == 1 ? -1 : 1) : ((ClaimGroup)this.data).getClaim().permEnabled(perm.getId()) + 1;
            success = ((ClaimGroup)this.data).getClaim().editGlobalPerms(player, perm.getId(), mode);
        } else {
            success = ((ClaimGroup)this.data).getClaim().editPerms(player, ((ClaimGroup)this.data).getGroup(), perm.getId(), ((ClaimGroup)this.data).getClaim().groupHasPerm(((ClaimGroup)this.data).getGroup(), perm.getId()) + 1);
        }
        slot.set(ServerScreenHelper.fromPermission(((ClaimGroup)this.data).getClaim(), this.player, perm, ((ClaimGroup)this.data).getGroup()));
        if (success) {
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.NOTE_BLOCK_PLING, 1.0f, 1.2f);
        } else {
            ServerScreenHelper.playSongToPlayer(player, SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
        }
        return true;
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot < 45 && slot > 8 && slot % 9 != 0 && slot % 9 != 8;
    }

    @Override
    protected PagedServerOnlyScreenHandler.PageSettings pageSettings() {
        return new PagedServerOnlyScreenHandler.PageSettings((this.perms.size() - 1) / 28, 47, 51);
    }
}

