/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.config.Config;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.linguabib.api.LanguageAPI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.level.ItemLike;

public class ServerScreenHelper {
    public static final String PERMISSION_KEY = "flan.permission";

    public static ItemStack emptyFiller() {
        return ServerScreenHelper.createStack(Items.GRAY_STAINED_GLASS_PANE, (Component)ClaimUtils.translatedText("", new Object[0]));
    }

    public static ItemStack createStack(Item item, Component name) {
        return ServerScreenHelper.createStack(new ItemStack((ItemLike)item), name);
    }

    public static ItemStack createStack(ItemStack stack, Component name) {
        Set types = stack.getComponents().keySet();
        types.stream().filter(t -> t != DataComponents.ITEM_MODEL).forEach(arg_0 -> ((ItemStack)stack).remove(arg_0));
        if (name != null) {
            stack.set(DataComponents.CUSTOM_NAME, (Object)name);
        }
        return stack;
    }

    public static ItemStack fromPermission(Claim claim, ServerPlayer player, ClaimPermission perm, String group) {
        ItemStack stack = ServerScreenHelper.createStack(perm.getItem(), (Component)ServerScreenHelper.coloredGuiText(perm.translationKey(), ChatFormatting.GOLD));
        ArrayList<Component> lore = new ArrayList<Component>();
        for (String pdesc : LanguageAPI.getFormattedKeys((ServerPlayer)player, (String)perm.translationKeyDescription())) {
            MutableComponent trans = ServerScreenHelper.coloredGuiText(pdesc, ChatFormatting.YELLOW);
            lore.add((Component)trans);
        }
        Config.GlobalType global = ConfigHandler.CONFIG.getGlobal(claim.getLevel(), perm.getId());
        if (!claim.isAdminClaim() && !global.canModify()) {
            MutableComponent text = ServerScreenHelper.coloredGuiText("flan.screenUneditable", ChatFormatting.DARK_RED);
            lore.add((Component)text);
            String permFlag = global.getValue() ? "flan.generic.true" : "flan.generic.false";
            MutableComponent text2 = ServerScreenHelper.coloredGuiText("flan.screenEnableText", ServerScreenHelper.coloredGuiText(permFlag, new Object[0]), permFlag.equals("flan.generic.true") ? ChatFormatting.GREEN : ChatFormatting.RED);
            lore.add((Component)text2);
        } else {
            String permFlag;
            if (group == null) {
                if (claim.parentClaim() == null) {
                    permFlag = claim.permEnabled(perm.getId()) == 1 ? "flan.generic.true" : "flan.generic.false";
                } else {
                    permFlag = switch (claim.permEnabled(perm.getId())) {
                        case -1 -> "flan.screenDefault";
                        case 1 -> "flan.generic.true";
                        default -> "flan.generic.false";
                    };
                }
            } else {
                permFlag = switch (claim.groupHasPerm(group, perm.getId())) {
                    case -1 -> "flan.screenDefault";
                    case 1 -> "flan.generic.true";
                    default -> "flan.generic.false";
                };
            }
            MutableComponent text = ServerScreenHelper.coloredGuiText("flan.screenEnableText", ServerScreenHelper.coloredGuiText(permFlag, new Object[0]), permFlag.equals("flan.generic.true") ? ChatFormatting.GREEN : ChatFormatting.RED);
            lore.add((Component)text);
        }
        ServerScreenHelper.addLore(stack, lore);
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> tag.putString(PERMISSION_KEY, perm.getId().toString()));
        return stack;
    }

    public static ItemStack getFromPersonal(ServerPlayer player, ClaimPermission perm, String group) {
        ItemStack stack = ServerScreenHelper.createStack(perm.getItem(), (Component)ServerScreenHelper.coloredGuiText(perm.translationKey(), ChatFormatting.GOLD));
        ArrayList<MutableComponent> lore = new ArrayList<MutableComponent>();
        for (String pdesc : LanguageAPI.getFormattedKeys((ServerPlayer)player, (String)perm.translationKeyDescription())) {
            MutableComponent trans = ServerScreenHelper.coloredGuiText(pdesc, ChatFormatting.YELLOW);
            lore.add(trans);
        }
        Config.GlobalType global = ConfigHandler.CONFIG.getGlobal(player.level(), perm.getId());
        if (!global.canModify()) {
            MutableComponent text = ServerScreenHelper.coloredGuiText("flan.screenUneditable", ChatFormatting.DARK_RED);
            lore.add(text);
            boolean permFlag = global.getValue();
            MutableComponent text2 = ServerScreenHelper.coloredGuiText("flan.screenEnableText", ServerScreenHelper.coloredGuiText(permFlag ? "flan.generic.true" : "flan.generic.false", new Object[0]), permFlag ? ChatFormatting.GREEN : ChatFormatting.RED);
            lore.add(text2);
        } else {
            Map map = PlayerClaimData.get(player).playerDefaultGroups().getOrDefault(group, new HashMap());
            String permFlag = map.containsKey(perm.getId()) ? ((Boolean)map.get(perm.getId()) != false ? "flan.generic.true" : "flan.generic.false") : "flan.screenDefault";
            MutableComponent text = ServerScreenHelper.coloredGuiText("flan.screenEnableText", ServerScreenHelper.coloredGuiText(permFlag, new Object[0]), permFlag.equals("flan.generic.true") ? ChatFormatting.GREEN : ChatFormatting.RED);
            lore.add(text);
        }
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack, tag -> tag.putString(PERMISSION_KEY, perm.getId().toString()));
        stack.set(DataComponents.LORE, (Object)new ItemLore(lore));
        return stack;
    }

    public static void playSongToPlayer(ServerPlayer player, SoundEvent event, float vol, float pitch) {
        player.connection.send((Packet)new ClientboundSoundPacket(BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)event), SoundSource.PLAYERS, player.position().x, player.position().y, player.position().z, vol, pitch, player.level().getRandom().nextLong()));
    }

    public static void playSongToPlayer(ServerPlayer player, Holder<SoundEvent> event, float vol, float pitch) {
        player.connection.send((Packet)new ClientboundSoundPacket(event, SoundSource.PLAYERS, player.position().x, player.position().y, player.position().z, vol, pitch, player.level().getRandom().nextLong()));
    }

    public static MutableComponent coloredGuiText(String key, Object ... compArgs) {
        ArrayList<ChatFormatting> formattings = new ArrayList<ChatFormatting>();
        ArrayList<Object> args = new ArrayList<Object>();
        for (Object obj : compArgs) {
            if (obj instanceof ChatFormatting) {
                ChatFormatting formatting = (ChatFormatting)obj;
                formattings.add(formatting);
                continue;
            }
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                args.add(b != false ? Component.translatable((String)"flan.generic.true") : Component.translatable((String)"flan.generic.false"));
            }
            if (obj instanceof Component || TranslatableContents.isAllowedPrimitiveArgument((Object)obj)) {
                args.add(obj);
                continue;
            }
            args.add(obj.toString());
        }
        return Component.translatable((String)key, (Object[])args.toArray()).setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormats((ChatFormatting[])formattings.toArray(ChatFormatting[]::new)));
    }

    public static void addLore(ItemStack stack, Component text) {
        stack.set(DataComponents.LORE, (Object)new ItemLore(List.of(text)));
    }

    public static void addLore(ItemStack stack, List<Component> texts) {
        stack.set(DataComponents.LORE, (Object)new ItemLore(texts));
    }
}

