/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.utils;

import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimBox;
import io.github.flemmli97.flan.claim.ClaimStorage;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class TeleportUtils {
    public static BlockPos roundedBlockPos(Vec3 pos) {
        return BlockPos.containing((Position)pos);
    }

    public static Vec3 getTeleportPos(Entity entity, Vec3 playerPos, ClaimStorage storage, Area2D dim, BlockPos.MutableBlockPos bPos, BiFunction<Claim, BlockPos, Boolean> check) {
        return TeleportUtils.getTeleportPos(entity, playerPos, storage, dim, false, bPos, check);
    }

    public static Vec3 getTeleportPos(Entity entity, Vec3 entityPos, ClaimStorage storage, Area2D dim, boolean checkSub, BlockPos.MutableBlockPos bPos, BiFunction<Claim, BlockPos, Boolean> check) {
        Tuple<Direction, Vec3> pos = TeleportUtils.nearestOutside(dim, entityPos);
        bPos.set(((Vec3)pos.getB()).x(), ((Vec3)pos.getB()).y(), ((Vec3)pos.getB()).z());
        Claim claim = storage.getClaimAt((BlockPos)bPos);
        if (checkSub) {
            Claim sub;
            Claim claim2 = sub = claim != null ? claim.getSubClaim((BlockPos)bPos) : null;
            if (sub != null) {
                claim = sub;
            }
        }
        if (claim == null || check.apply(claim, (BlockPos)bPos).booleanValue()) {
            Vec3 ret = (Vec3)pos.getB();
            BlockPos rounded = TeleportUtils.roundedBlockPos(ret);
            int y = entity.level().getChunk(rounded.getX() >> 4, rounded.getZ() >> 4).getHeight(Heightmap.Types.MOTION_BLOCKING, rounded.getX() & 0xF, rounded.getZ() & 0xF);
            Vec3 dest = new Vec3(ret.x, (double)(y + 1), ret.z);
            if (entity.level().noCollision(entity, entity.getBoundingBox().move(dest.subtract(entity.position())))) {
                return dest;
            }
            return new Vec3((double)rounded.getX() + 0.5, (double)(y + 1), (double)rounded.getZ() + 0.5);
        }
        ClaimBox newDim = claim.getDimensions();
        switch ((Direction)pos.getA()) {
            case NORTH: {
                dim.minZ = newDim.minZ();
                break;
            }
            case SOUTH: {
                dim.maxZ = newDim.maxZ();
                break;
            }
            case EAST: {
                dim.maxX = newDim.maxX();
                break;
            }
            default: {
                dim.minX = newDim.minX();
            }
        }
        return TeleportUtils.getTeleportPos(entity, entityPos, storage, dim, checkSub, bPos, check);
    }

    private static Tuple<Direction, Vec3> nearestOutside(Area2D dim, Vec3 from) {
        double northDist = Math.abs(from.z() - (double)dim.minZ);
        double southDist = Math.abs((double)dim.maxZ - from.z());
        double westDist = Math.abs(from.x() - (double)dim.minX);
        double eastDist = Math.abs((double)dim.maxX - from.x());
        if (northDist > southDist) {
            if (eastDist > westDist) {
                if (southDist > westDist) {
                    return new Tuple((Object)Direction.WEST, (Object)new Vec3((double)dim.minX - 1.5, from.y(), from.z()));
                }
                return new Tuple((Object)Direction.SOUTH, (Object)new Vec3(from.x(), from.y(), (double)dim.maxZ + 1.5));
            }
            if (southDist > eastDist) {
                return new Tuple((Object)Direction.EAST, (Object)new Vec3((double)dim.maxX + 1.5, from.y(), from.z()));
            }
            return new Tuple((Object)Direction.SOUTH, (Object)new Vec3(from.x(), from.y(), (double)dim.maxZ + 1.5));
        }
        if (eastDist > westDist) {
            if (northDist > westDist) {
                return new Tuple((Object)Direction.WEST, (Object)new Vec3((double)dim.minX - 1.5, from.y(), from.z()));
            }
            return new Tuple((Object)Direction.NORTH, (Object)new Vec3(from.x(), from.y(), (double)dim.minZ - 1.5));
        }
        if (northDist > eastDist) {
            return new Tuple((Object)Direction.EAST, (Object)new Vec3((double)dim.maxX + 1.5, from.y(), from.z()));
        }
        return new Tuple((Object)Direction.NORTH, (Object)new Vec3(from.x(), from.y(), (double)dim.minZ - 1.5));
    }

    public static class Area2D {
        public int minX;
        public int minZ;
        public int maxX;
        public int maxZ;

        public Area2D(int minX, int minZ, int maxX, int maxZ) {
            this.minX = minX;
            this.maxX = maxX;
            this.minZ = minZ;
            this.maxZ = maxZ;
        }

        public Area2D(ClaimBox box) {
            this.minX = box.minX();
            this.maxX = box.maxX();
            this.minZ = box.minZ();
            this.maxZ = box.maxZ();
        }
    }
}

