/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.api.permission;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.flan.api.permission.ObjectToPermissionMap;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class InteractionOverrideManager
extends class_4309<InteractionEntry<?>> {
    public static final class_5321<? extends class_2378<InteractionEntry<?>>> ID = class_5321.method_29180((class_2960)class_2960.method_60655((String)"flan", (String)"claim_interactions_override"));
    public static final Codec<List<Pair<Either<class_6862<class_2248>, class_2248>, class_2960>>> BLOCK_CODEC = InteractionOverrideManager.tagOrEntryCodec(class_7923.field_41175).listOf();
    public static final Codec<List<Pair<Either<class_6862<class_1792>, class_1792>, class_2960>>> ITEM_CODEC = InteractionOverrideManager.tagOrEntryCodec(class_7923.field_41178).listOf();
    public static final Codec<List<Pair<Either<class_6862<class_1299<?>>, class_1299<?>>, class_2960>>> ENTITY_CODEC = InteractionOverrideManager.tagOrEntryCodec(class_7923.field_41177).listOf();
    public static final InteractionType<class_2248> BLOCK_LEFT_CLICK = new InteractionType<class_2248>(class_2960.method_60655((String)"flan", (String)"block_left_click"), BLOCK_CODEC, () -> new InteractionHolder(class_7923.field_41175));
    public static final InteractionType<class_2248> BLOCK_INTERACT = new InteractionType<class_2248>(class_2960.method_60655((String)"flan", (String)"block_interact"), BLOCK_CODEC, () -> new InteractionHolder(class_7923.field_41175));
    public static final InteractionType<class_1792> ITEM_USE = new InteractionType<class_1792>(class_2960.method_60655((String)"flan", (String)"item_use"), ITEM_CODEC, () -> new InteractionHolder(class_7923.field_41178));
    public static final InteractionType<class_1299<?>> ENTITY_ATTACK = new InteractionType(class_2960.method_60655((String)"flan", (String)"entity_attack"), ENTITY_CODEC, () -> new InteractionHolder(class_7923.field_41177));
    public static final InteractionType<class_1299<?>> ENTITY_INTERACT = new InteractionType(class_2960.method_60655((String)"flan", (String)"entity_interact"), ENTITY_CODEC, () -> new InteractionHolder(class_7923.field_41177));
    private static InteractionOverrideManager INSTANCE;
    private final Map<InteractionType<?>, InteractionHolder<?>> overrides = new HashMap();

    private InteractionOverrideManager(class_7225.class_7874 provider) {
        super(provider, InteractionEntry.CODEC, ID);
    }

    public static InteractionOverrideManager create(class_7225.class_7874 provider) {
        INSTANCE = new InteractionOverrideManager(provider);
        return InteractionOverrideManager.getInstance();
    }

    public static InteractionOverrideManager getInstance() {
        return INSTANCE;
    }

    public static <T> Codec<Pair<Either<class_6862<T>, T>, class_2960>> tagOrEntryCodec(class_2378<T> registry) {
        return InteractionOverrideManager.tagOrEntryCodec(registry.method_46765(), registry.method_39673());
    }

    public static <T, O> Codec<Pair<Either<class_6862<T>, O>, class_2960>> tagOrEntryCodec(class_5321<? extends class_2378<T>> key, Codec<O> codec) {
        Codec tagOrEntry = Codec.either((Codec)Codec.STRING.flatXmap(r -> {
            if (r.startsWith("#")) {
                return DataResult.success((Object)class_6862.method_40092((class_5321)key, (class_2960)class_2960.method_60654((String)r.substring(1))));
            }
            return DataResult.error(() -> "Not a tag value" + r);
        }, l -> DataResult.success((Object)("#" + String.valueOf(l.comp_327())))), codec);
        return RecordCodecBuilder.create((T builder) -> builder.group((App)tagOrEntry.fieldOf("entry").forGetter(Pair::getFirst), (App)class_2960.field_25139.fieldOf("permission").forGetter(Pair::getSecond)).apply((Applicative)builder, Pair::of));
    }

    public static <T> List<T> expandTag(class_2378<T> registry, class_6862<T> tag) {
        ArrayList elements = new ArrayList();
        registry.method_46733(tag).ifPresent(n -> n.forEach(h -> elements.add(h.comp_349())));
        return elements;
    }

    public class_2960 getBlockLeftClick(class_2248 block) {
        return this.getOverride(BLOCK_LEFT_CLICK, block);
    }

    public class_2960 getBlockInteract(class_2248 block) {
        return this.getOverride(BLOCK_INTERACT, block);
    }

    public class_2960 getItemUse(class_1792 item) {
        return this.getOverride(ITEM_USE, item);
    }

    public class_2960 getEntityAttack(class_1299<?> entity) {
        return this.getOverride(ENTITY_ATTACK, entity);
    }

    public class_2960 getEntityInteract(class_1299<?> entity) {
        return this.getOverride(ENTITY_INTERACT, entity);
    }

    public <T> class_2960 getOverride(InteractionType<T> type, T entry) {
        return this.getHolder(type).get(entry);
    }

    private <T> InteractionHolder<T> getHolder(InteractionType<T> type) {
        return this.overrides.computeIfAbsent(type, k -> type.getGen().get());
    }

    protected void apply(Map<class_2960, InteractionEntry<?>> data, class_3300 manager, class_3695 profiler) {
        InteractionHolder<class_2248> map;
        this.overrides.clear();
        for (class_2248 block : class_7923.field_41175) {
            map = this.getHolder(BLOCK_INTERACT);
            ObjectToPermissionMap.BLOCK_PERMISSION_BUILDER.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(block)).map(Map.Entry::getValue).findFirst().ifPresent(sub -> map.defaults.put(block, (class_2960)sub.get()));
        }
        for (class_1792 item : class_7923.field_41178) {
            map = this.getHolder(ITEM_USE);
            ObjectToPermissionMap.ITEM_PERMISSION_BUILDER.entrySet().stream().filter(e -> ((Predicate)e.getKey()).test(item)).map(Map.Entry::getValue).findFirst().ifPresent(sub -> map.defaults.put(item, (class_2960)sub.get()));
        }
        data.forEach((res, entry) -> this.appendTo((InteractionEntry)entry));
    }

    private <T> void appendTo(InteractionEntry<T> entry) {
        InteractionHolder<T> map = this.getHolder(entry.type());
        entry.elements().forEach(pair -> ((Either)pair.getFirst()).ifLeft(tag -> map.unresolvedTags.put(tag, (class_2960)pair.getSecond())).ifRight(val -> map.direct.put(val, (class_2960)pair.getSecond())));
    }

    public record InteractionEntry<T>(InteractionType<T> type, List<Pair<Either<class_6862<T>, T>, class_2960>> elements) {
        public static final Codec<InteractionEntry<?>> CODEC = class_2960.field_25139.dispatch(e -> e.type().getId(), t -> InteractionType.LOOKUP.get(t).getCodec());
    }

    public static class InteractionType<T> {
        static final Map<class_2960, InteractionType<?>> LOOKUP = new HashMap();
        private final class_2960 id;
        private final MapCodec<InteractionEntry<T>> codec;
        private final Supplier<InteractionHolder<T>> gen;

        public InteractionType(class_2960 id, Codec<List<Pair<Either<class_6862<T>, T>, class_2960>>> codec, Supplier<InteractionHolder<T>> gen) {
            this.id = id;
            this.codec = codec.fieldOf("values").xmap(l -> new InteractionEntry(this, l), InteractionEntry::elements);
            this.gen = gen;
            if (LOOKUP.put(id, this) != null) {
                throw new IllegalStateException("Type already registered");
            }
        }

        public class_2960 getId() {
            return this.id;
        }

        public MapCodec<InteractionEntry<T>> getCodec() {
            return this.codec;
        }

        public Supplier<InteractionHolder<T>> getGen() {
            return this.gen;
        }
    }

    public static class InteractionHolder<T> {
        private final class_2378<T> registry;
        private final Map<T, class_2960> direct = new HashMap<T, class_2960>();
        private final Map<class_6862<T>, class_2960> unresolvedTags = new HashMap<class_6862<T>, class_2960>();
        private final Map<T, class_2960> defaults = new HashMap<T, class_2960>();

        public InteractionHolder(class_2378<T> registry) {
            this.registry = registry;
        }

        public class_2960 get(T val) {
            if (!this.unresolvedTags.isEmpty() || !this.defaults.isEmpty()) {
                this.resolve();
            }
            return this.direct.get(val);
        }

        private void resolve() {
            this.unresolvedTags.entrySet().stream().sorted(Comparator.comparing(e -> ((class_6862)e.getKey()).comp_327())).forEach(entry -> InteractionOverrideManager.expandTag(this.registry, (class_6862)entry.getKey()).forEach(item -> {
                if (!this.direct.containsKey(item)) {
                    this.direct.put(item, (class_2960)entry.getValue());
                }
            }));
            this.unresolvedTags.clear();
            this.defaults.forEach((key, value) -> {
                if (!this.direct.containsKey(key)) {
                    this.direct.put((T)key, (class_2960)value);
                }
            });
            this.defaults.clear();
        }
    }
}

