/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.claim;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.data.IPermissionStorage;
import io.github.flemmli97.flan.api.data.IPlayerData;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.PermissionManager;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimBox;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.claim.GlobalClaim;
import io.github.flemmli97.flan.claim.IClaimStorage;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.platform.integration.claiming.OtherClaimingModCheck;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.platform.integration.webmap.WebmapCalls;
import io.github.flemmli97.flan.player.ClaimMode;
import io.github.flemmli97.flan.player.OfflinePlayerData;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.player.PlayerDataHandler;
import io.github.flemmli97.flan.player.display.DisplayBox;
import io.github.flemmli97.flan.player.display.EnumDisplayType;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_4076;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import org.yaml.snakeyaml.Yaml;

public class ClaimStorage
implements IPermissionStorage {
    public static final String ADMIN_CLAIMS = "!AdminClaims";
    private final Long2ObjectMap<List<Claim>> claims = new Long2ObjectOpenHashMap();
    private final Map<UUID, Claim> claimUUIDMap = new HashMap<UUID, Claim>();
    private final Map<UUID, Set<Claim>> playerClaimMap = new HashMap<UUID, Set<Claim>>();
    private final Set<UUID> dirty = new HashSet<UUID>();
    private final GlobalClaim globalClaim;

    public static ClaimStorage get(class_3218 level) {
        return ((IClaimStorage)level).flan$get();
    }

    public ClaimStorage(MinecraftServer server, class_3218 level) {
        this.globalClaim = new GlobalClaim(level);
        this.read(server, level);
        PlayerDataHandler.deleteUnusedClaims(server, this, level);
    }

    public UUID generateUUID() {
        UUID uuid = UUID.randomUUID();
        if (this.claimUUIDMap.containsKey(uuid)) {
            return this.generateUUID();
        }
        return uuid;
    }

    public Claim createAdminClaim(class_2338 pos1, class_2338 pos2, class_3218 level, boolean is3d) {
        Set<DisplayBox> conflicts;
        if (!is3d) {
            if (pos1.method_10264() < pos2.method_10264()) {
                pos1 = pos1.method_10087(ConfigHandler.CONFIG.defaultClaimDepth);
            } else {
                pos2 = pos2.method_10087(ConfigHandler.CONFIG.defaultClaimDepth);
            }
        }
        Claim claim = new Claim(pos1, pos2, null, level);
        if (is3d) {
            claim.withHeight(Math.max(pos1.method_10264(), pos2.method_10264()));
        }
        if ((conflicts = this.conflicts(claim, null)).isEmpty()) {
            claim.setClaimID(this.generateUUID());
            Flan.log("Creating new admin claim {}", claim);
            this.addClaim(claim);
            return claim;
        }
        return null;
    }

    public boolean createClaim(class_2338 pos1, class_2338 pos2, class_3222 player) {
        PlayerClaimData data;
        Set<DisplayBox> conflicts;
        boolean use3D = PlayerClaimData.get((class_3222)player).getClaimMode().is3d;
        if (!use3D) {
            if (pos1.method_10264() < pos2.method_10264()) {
                pos1 = pos1.method_10087(ConfigHandler.CONFIG.defaultClaimDepth);
            } else {
                pos2 = pos2.method_10087(ConfigHandler.CONFIG.defaultClaimDepth);
            }
        } else if (Math.abs(pos1.method_10264() - pos2.method_10264()) < ConfigHandler.CONFIG.minHeight3d) {
            player.method_7353((class_2561)ClaimUtils.translatedText("flan.minClaimHeight", ConfigHandler.CONFIG.minHeight3d, class_124.field_1061), false);
            return false;
        }
        Claim claim = new Claim(pos1, pos2, player);
        if (use3D) {
            claim.withHeight(Math.max(pos1.method_10264(), pos2.method_10264()));
        }
        if (ConfigHandler.CONFIG.noSpawnClaim && player.method_51469().method_27983() == class_1937.field_25179 && player.method_5682().method_3841() > 0) {
            class_238 aabb = new class_238(player.method_51469().method_43126()).method_1014((double)player.method_5682().method_3841());
            ClaimBox dim = claim.getDimensions();
            if ((double)dim.minX() <= aabb.field_1320 && (double)dim.maxX() >= aabb.field_1323 && (double)dim.minZ() <= aabb.field_1324 && (double)dim.maxZ() >= aabb.field_1321) {
                player.method_7353((class_2561)ClaimUtils.translatedText("flan.conflictSpawn", class_124.field_1061), false);
                return false;
            }
        }
        if ((conflicts = this.conflicts(claim, null)).isEmpty()) {
            data = PlayerClaimData.get(player);
            long cooldown = data.nextClaimCooldown();
            if (cooldown > 0L) {
                player.method_7353((class_2561)ClaimUtils.translatedText("flan.claimCooldown", cooldown, class_124.field_1061), false);
                return false;
            }
            if (claim.getPlane() < ConfigHandler.CONFIG.minClaimsize) {
                player.method_7353((class_2561)ClaimUtils.translatedText("flan.minClaimSize", ConfigHandler.CONFIG.minClaimsize, class_124.field_1061), false);
                return false;
            }
            if (!data.isAdminIgnoreClaim() && ConfigHandler.CONFIG.maxClaims != -1 && !PermissionNodeHandler.INSTANCE.permBelowEqVal(player, "flan.claims.amount", this.playerClaimMap.getOrDefault(player.method_5667(), Sets.newHashSet()).size() + 1, ConfigHandler.CONFIG.maxClaims)) {
                player.method_7353((class_2561)ClaimUtils.translatedText("flan.maxClaims", class_124.field_1061), false);
                return false;
            }
            if (!data.isAdminIgnoreClaim() && !data.canUseClaimBlocks(claim.getPlane())) {
                player.method_7353((class_2561)ClaimUtils.translatedText("flan.notEnoughBlocks", claim.getPlane(), data.remainingClaimBlocks(), class_124.field_1061), false);
                return false;
            }
            claim.setClaimID(this.generateUUID());
            Flan.log("Creating new claim {}", claim);
            this.addClaim(claim);
            data.updateLastClaim();
            data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.method_24515().method_10264());
            data.updateScoreboard();
            player.method_7353((class_2561)ClaimUtils.translatedText("flan.claimCreateSuccess", class_124.field_1065), false);
            player.method_7353((class_2561)ClaimUtils.translatedText("flan.claimBlocksFormat", data.getClaimBlocks(), data.getAdditionalClaims(), data.usedClaimBlocks(), data.remainingClaimBlocks(), class_124.field_1065), false);
            return true;
        }
        data = PlayerClaimData.get(player);
        conflicts.forEach(conf -> data.addDisplayClaim((DisplayBox)conf, EnumDisplayType.CONFLICT, player.method_24515().method_10264()));
        player.method_7353((class_2561)ClaimUtils.translatedText("flan.conflictOther", class_124.field_1061), false);
        return false;
    }

    private Set<DisplayBox> conflicts(Claim claim, Claim except) {
        HashSet<DisplayBox> conflicted = new HashSet<DisplayBox>();
        int[] chunks = ClaimStorage.getChunkPos(claim);
        for (int x = chunks[0]; x <= chunks[1]; ++x) {
            for (int z = chunks[2]; z <= chunks[3]; ++z) {
                List claims = (List)this.claims.get(class_1923.method_8331((int)x, (int)z));
                if (claims == null) continue;
                for (Claim other : claims) {
                    if (!claim.intersects(other) || other.equals(except)) continue;
                    conflicted.add(other.display());
                }
            }
        }
        if (!claim.isAdminClaim()) {
            OtherClaimingModCheck.INSTANCE.findConflicts(claim, conflicted);
        }
        return conflicted;
    }

    public boolean deleteClaim(Claim claim, boolean updateClaim, ClaimMode mode, class_3218 level) {
        if (mode.isSubclaim) {
            if (claim.parentClaim() != null) {
                return claim.parentClaim().deleteSubClaim(claim);
            }
            return false;
        }
        Flan.log("Try deleting claim {}", claim);
        int[] pos = ClaimStorage.getChunkPos(claim);
        for (int x = pos[0]; x <= pos[1]; ++x) {
            for (int z = pos[2]; z <= pos[3]; ++z) {
                this.claims.compute(class_1923.method_8331((int)x, (int)z), (key, val) -> {
                    if (val == null) {
                        return null;
                    }
                    val.remove(claim);
                    return val.isEmpty() ? null : val;
                });
            }
        }
        ((Set)this.playerClaimMap.getOrDefault(claim.getOwner(), new HashSet())).remove(claim);
        this.dirty.add(claim.getOwner());
        if (updateClaim) {
            claim.remove();
            claim.getOwnerPlayer().ifPresent(o -> PlayerClaimData.get(o).updateScoreboard());
        }
        WebmapCalls.removeMarker(claim);
        return this.claimUUIDMap.remove(claim.getClaimID()) != null;
    }

    public void toggleAdminClaim(class_3222 player, Claim claim, boolean toggle) {
        Flan.log("Set claim {} to an admin claim", claim);
        this.deleteClaim(claim, false, ClaimMode.DEFAULT, player.method_51469());
        if (toggle) {
            claim.getOwnerPlayer().ifPresent(o -> PlayerClaimData.get(o).updateScoreboard());
        }
        claim.toggleAdminClaim(player, toggle);
        if (!toggle) {
            PlayerClaimData.get(player).updateScoreboard();
        }
        this.addClaim(claim);
    }

    public boolean resizeClaim(Claim claim, class_2338 from, class_2338 to, class_3222 player) {
        boolean enoughBlocks;
        ClaimBox dims = claim.getDimensions();
        int minY = claim.is3d() && dims.minY() == from.method_10264() ? dims.maxY() : dims.minY();
        class_2338 opposite = new class_2338(dims.minX() == from.method_10263() ? dims.maxX() : dims.minX(), minY, dims.minZ() == from.method_10260() ? dims.maxZ() : dims.minZ());
        Claim newClaim = new Claim(opposite, to, player.method_5667(), player.method_51469());
        if (claim.is3d()) {
            if (Math.abs(minY - to.method_10264()) < ConfigHandler.CONFIG.minHeight3d) {
                player.method_7353((class_2561)ClaimUtils.translatedText("flan.minClaimHeight", ConfigHandler.CONFIG.minHeight3d, class_124.field_1061), false);
                return false;
            }
            newClaim.withHeight(Math.max(minY, to.method_10264()));
        }
        if (newClaim.getPlane() < ConfigHandler.CONFIG.minClaimsize) {
            player.method_7353((class_2561)ClaimUtils.translatedText("flan.minClaimSize", ConfigHandler.CONFIG.minClaimsize, class_124.field_1061), false);
            return false;
        }
        Set<DisplayBox> conflicts = this.conflicts(newClaim, claim);
        if (!conflicts.isEmpty()) {
            conflicts.forEach(conf -> PlayerClaimData.get(player).addDisplayClaim((DisplayBox)conf, EnumDisplayType.CONFLICT, player.method_24515().method_10264()));
            player.method_7353((class_2561)ClaimUtils.translatedText("flan.conflictOther", class_124.field_1061), false);
            return false;
        }
        int diff = newClaim.getPlane() - claim.getPlane();
        PlayerClaimData data = PlayerClaimData.get(player);
        IPlayerData newData = claim.getOwnerPlayer().map(o -> {
            if (o == player || claim.isAdminClaim()) {
                return data;
            }
            return PlayerClaimData.get(o);
        }).orElse(new OfflinePlayerData(player.method_5682(), claim.getOwner()));
        boolean bl = enoughBlocks = claim.isAdminClaim() || data.isAdminIgnoreClaim() || newData.canUseClaimBlocks(diff);
        if (enoughBlocks) {
            Flan.log("Resizing claim {}", claim);
            this.deleteClaim(claim, false, ClaimMode.DEFAULT, player.method_51469());
            claim.copySizes(newClaim);
            this.addClaim(claim);
            data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.method_24515().method_10264());
            if (newData instanceof PlayerClaimData) {
                ((PlayerClaimData)newData).updateScoreboard();
            }
            player.method_7353((class_2561)ClaimUtils.translatedText("flan.resizeSuccess", class_124.field_1065), false);
            player.method_7353((class_2561)ClaimUtils.translatedText("flan.claimBlocksFormat", newData.getClaimBlocks(), newData.getAdditionalClaims(), newData.usedClaimBlocks(), data.remainingClaimBlocks(), class_124.field_1065), false);
            return true;
        }
        player.method_7353((class_2561)ClaimUtils.translatedText("flan.notEnoughBlocks", claim.getPlane(), data.remainingClaimBlocks(), class_124.field_1061), false);
        return false;
    }

    public Claim getClaimAt(class_2338 pos) {
        long chunk = class_1923.method_8331((int)(pos.method_10263() >> 4), (int)(pos.method_10260() >> 4));
        List list = (List)this.claims.get(chunk);
        if (list != null) {
            for (Claim claim : list) {
                if (!claim.insideClaim(pos)) continue;
                return claim;
            }
        }
        return null;
    }

    public List<Claim> getClaimsAt(int chunkX, int chunkZ) {
        return (List)this.claims.getOrDefault(class_1923.method_8331((int)chunkX, (int)chunkZ), Collections.emptyList());
    }

    @Override
    public IPermissionContainer getForPermissionCheck(class_2338 pos) {
        Claim claim = this.getClaimAt(pos);
        if (claim != null) {
            return claim;
        }
        return this.globalClaim;
    }

    public Set<Claim> getNearbyClaims(class_3218 level, class_2338 pos, int rX, int rZ) {
        int posX;
        class_1923 c = new class_1923(new class_2338(pos.method_10263() - rX, pos.method_10264(), pos.method_10260() - rZ));
        HashSet<Claim> affected = new HashSet<Claim>();
        int x = 0;
        while ((posX = class_4076.method_18688((int)(c.field_9181 + x))) <= pos.method_10263() + rX) {
            int posZ;
            int z = 0;
            while ((posZ = class_4076.method_18688((int)(c.field_9180 + z))) <= pos.method_10260() + rZ) {
                List list = (List)this.claims.get(class_1923.method_8331((int)(c.field_9181 + x), (int)(c.field_9180 + z)));
                if (list != null) {
                    int minX = Math.max(posX, pos.method_10263() - rX);
                    int minZ = Math.max(posZ, pos.method_10260() - rZ);
                    int maxX = Math.min(posX + 15, pos.method_10263() + rX);
                    int maxZ = Math.min(posZ + 15, pos.method_10260() + rZ);
                    class_238 bb = new class_238((double)minX, (double)level.method_31607(), (double)minZ, (double)maxX, (double)level.method_31600(), (double)maxZ);
                    list.stream().filter(claim -> claim.intersects(bb)).forEach(affected::add);
                }
                ++z;
            }
            ++x;
        }
        return affected;
    }

    public boolean canInteract(class_2338 pos, int radius, class_3222 player, class_2960 perm, boolean message) {
        boolean realPlayer = player != null && player.getClass().equals(class_3222.class);
        message = message && realPlayer;
        Set<Claim> affected = this.getNearbyClaims(player.method_51469(), pos, radius, radius);
        affected.remove(this.getClaimAt(pos));
        for (class_2338 ipos : class_2338.method_10094((int)(pos.method_10263() - radius), (int)pos.method_10264(), (int)(pos.method_10260() - radius), (int)(pos.method_10263() + radius), (int)pos.method_10264(), (int)(pos.method_10260() + radius))) {
            for (Claim claim : affected) {
                if (!claim.insideClaim(ipos) || claim.canInteract(player, perm, ipos, message)) continue;
                if (message) {
                    player.method_7353((class_2561)ClaimUtils.translatedText("flan.noPermissionTooClose", class_124.field_1079), true);
                }
                return false;
            }
        }
        return true;
    }

    public Claim getFromUUID(UUID uuid) {
        return this.claimUUIDMap.get(uuid);
    }

    private void addClaim(Claim claim) {
        int[] pos = ClaimStorage.getChunkPos(claim);
        for (int x = pos[0]; x <= pos[1]; ++x) {
            for (int z = pos[2]; z <= pos[3]; ++z) {
                this.claims.merge(class_1923.method_8331((int)x, (int)z), (Object)Lists.newArrayList((Object[])new Claim[]{claim}), (old, val) -> {
                    old.add(claim);
                    return old;
                });
            }
        }
        this.claimUUIDMap.put(claim.getClaimID(), claim);
        this.playerClaimMap.merge(claim.getOwner(), Sets.newHashSet((Object[])new Claim[]{claim}), (old, val) -> {
            old.add(claim);
            return old;
        });
        WebmapCalls.addClaimMarker(claim);
    }

    public boolean transferOwner(Claim claim, class_3222 player, UUID newOwner) {
        if (!PlayerClaimData.get(player).isAdminIgnoreClaim() && !player.method_5667().equals(claim.getOwner())) {
            return false;
        }
        return this.transferOwner(claim, newOwner);
    }

    public boolean transferOwner(Claim claim, UUID newOwner) {
        this.playerClaimMap.merge(claim.getOwner(), new HashSet(), (old, val) -> {
            old.remove(claim);
            return old;
        });
        this.dirty.add(claim.getOwner());
        claim.getOwnerPlayer().ifPresent(o -> PlayerClaimData.get(o).updateScoreboard());
        claim.transferOwner(newOwner);
        this.playerClaimMap.merge(claim.getOwner(), Sets.newHashSet((Object[])new Claim[]{claim}), (old, val) -> {
            old.add(claim);
            return old;
        });
        this.dirty.add(claim.getOwner());
        WebmapCalls.changeClaimOwner(claim);
        return true;
    }

    public Collection<Claim> allClaimsFromPlayer(UUID player) {
        return this.playerClaimMap.containsKey(player) ? ImmutableSet.copyOf((Collection)this.playerClaimMap.get(player)) : ImmutableSet.of();
    }

    public Collection<Claim> getAdminClaims() {
        return ImmutableSet.copyOf((Collection)this.playerClaimMap.get(null));
    }

    public Map<UUID, Set<Claim>> getClaims() {
        return this.playerClaimMap;
    }

    public static int[] getChunkPos(Claim claim) {
        ClaimBox dim = claim.getDimensions();
        int[] pos = new int[]{dim.minX() >> 4, dim.maxX() >> 4, dim.minZ() >> 4, dim.maxZ() >> 4};
        return pos;
    }

    public void read(MinecraftServer server, class_3218 level) {
        Flan.log("Loading claim data for world {}", level.method_27983());
        Path dir = ConfigHandler.getClaimSavePath(server, (class_5321<class_1937>)level.method_27983());
        if (Files.exists(dir, new LinkOption[0])) {
            try (Stream<Path> files = Files.walk(dir, new FileVisitOption[0]).filter(p -> Files.isRegularFile(p, new LinkOption[0]) && p.toString().endsWith(".json"));){
                files.forEach(file -> {
                    String realName = file.getFileName().toString().replace(".json", "");
                    try (JsonReader reader = ConfigHandler.GSON.newJsonReader((Reader)Files.newBufferedReader(file, StandardCharsets.UTF_8));){
                        UUID uuid = realName.equals(ADMIN_CLAIMS) ? null : UUID.fromString(realName);
                        JsonArray arr = (JsonArray)ConfigHandler.GSON.fromJson(reader, JsonArray.class);
                        Flan.debug("Reading claim data from json {} for player uuid {}", arr, uuid);
                        arr.forEach(el -> {
                            if (el.isJsonObject()) {
                                this.addClaim(Claim.fromJson((JsonObject)el, uuid, level));
                            }
                        });
                    }
                    catch (IOException e) {
                        Flan.LOGGER.error((Object)e);
                    }
                });
            }
            catch (IOException e) {
                Flan.LOGGER.error((Object)e);
            }
        }
    }

    public void save(MinecraftServer server, class_5321<class_1937> reg) {
        Flan.log("Saving claims for world {}", reg);
        Path dir = ConfigHandler.getClaimSavePath(server, reg);
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
            for (Map.Entry<UUID, Set<Claim>> e : this.playerClaimMap.entrySet()) {
                String owner = e.getKey() == null ? ADMIN_CLAIMS : e.getKey().toString();
                Path file = dir.resolve(owner + ".json");
                Flan.debug("Attempting saving claim data for player uuid {}", owner);
                boolean dirty = false;
                if (!Files.exists(file, new LinkOption[0])) {
                    if (e.getValue().isEmpty()) continue;
                    Files.createFile(file, new FileAttribute[0]);
                    dirty = true;
                } else {
                    if (e.getValue().isEmpty()) {
                        Files.delete(file);
                        continue;
                    }
                    if (this.dirty.remove(owner.equals(ADMIN_CLAIMS) ? null : e.getKey())) {
                        dirty = true;
                    } else {
                        for (Claim claim2 : e.getValue()) {
                            if (!claim2.isDirty()) continue;
                            dirty = true;
                            claim2.setDirty(false);
                        }
                    }
                }
                if (!dirty) continue;
                JsonArray arr = new JsonArray();
                e.getValue().forEach(claim -> arr.add((JsonElement)claim.toJson(new JsonObject())));
                Flan.debug("Attempting saving changed claim data {} for player uuid {}", arr, owner);
                JsonWriter jsonWriter = ConfigHandler.GSON.newJsonWriter((Writer)Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]));
                ConfigHandler.GSON.toJson((JsonElement)arr, jsonWriter);
                jsonWriter.close();
            }
        }
        catch (IOException e) {
            Flan.LOGGER.error((Object)e);
        }
    }

    public static boolean readGriefPreventionData(MinecraftServer server, class_2168 src) {
        Yaml yml = new Yaml();
        File griefPrevention = server.method_27050(class_5218.field_24188).resolve("plugins/GriefPreventionData/ClaimData").toFile();
        if (!griefPrevention.exists()) {
            src.method_9226(() -> ClaimUtils.translatedText("flan.cantFindData", griefPrevention.getAbsolutePath(), class_124.field_1079), false);
            return false;
        }
        HashMap<File, List> subClaimMap = new HashMap<File, List>();
        HashMap<Integer, File> intFileMap = new HashMap<Integer, File>();
        Set<class_2960> managers = ClaimStorage.complementOf(BuiltinPermission.EDITCLAIM);
        Set<class_2960> builders = ClaimStorage.complementOf(BuiltinPermission.EDITPERMS, BuiltinPermission.EDITCLAIM);
        Set<class_2960> containers = ClaimStorage.complementOf(BuiltinPermission.EDITPERMS, BuiltinPermission.EDITCLAIM, BuiltinPermission.BREAK, BuiltinPermission.PLACE, BuiltinPermission.NOTEBLOCK, BuiltinPermission.REDSTONE, BuiltinPermission.JUKEBOX, BuiltinPermission.ITEMFRAMEROTATE, BuiltinPermission.LECTERNTAKE, BuiltinPermission.ENDCRYSTALPLACE, BuiltinPermission.PROJECTILES, BuiltinPermission.TRAMPLE, BuiltinPermission.RAID, BuiltinPermission.BUCKET, BuiltinPermission.ARMORSTAND, BuiltinPermission.BREAKNONLIVING);
        Set<class_2960> accessors = ClaimStorage.complementOf(BuiltinPermission.EDITPERMS, BuiltinPermission.EDITCLAIM, BuiltinPermission.BREAK, BuiltinPermission.PLACE, BuiltinPermission.OPENCONTAINER, BuiltinPermission.ANVIL, BuiltinPermission.BEACON, BuiltinPermission.NOTEBLOCK, BuiltinPermission.REDSTONE, BuiltinPermission.JUKEBOX, BuiltinPermission.ITEMFRAMEROTATE, BuiltinPermission.LECTERNTAKE, BuiltinPermission.ENDCRYSTALPLACE, BuiltinPermission.PROJECTILES, BuiltinPermission.TRAMPLE, BuiltinPermission.RAID, BuiltinPermission.BUCKET, BuiltinPermission.ANIMALINTERACT, BuiltinPermission.HURTANIMAL, BuiltinPermission.TRADING, BuiltinPermission.ARMORSTAND, BuiltinPermission.BREAKNONLIVING);
        HashMap<String, Set<class_2960>> perms = new HashMap<String, Set<class_2960>>();
        perms.put("managers", managers);
        perms.put("builders", builders);
        perms.put("containers", containers);
        perms.put("accessors", accessors);
        try {
            Object reader;
            Map values;
            for (File f : griefPrevention.listFiles()) {
                if (!f.getName().endsWith(".yml") || !(values = (Map)yml.load((Reader)(reader = new FileReader(f)))).get("Parent Claim ID").equals(-1)) continue;
                try {
                    intFileMap.put(Integer.valueOf(f.getName().replace(".yml", "")), f);
                }
                catch (NumberFormatException e) {
                    src.method_9226(() -> ClaimUtils.translatedText("flan.errorFile", f.getName(), class_124.field_1061), false);
                }
            }
            for (File f : griefPrevention.listFiles()) {
                if (!f.getName().endsWith(".yml") || (values = (Map)yml.load((Reader)(reader = new FileReader(f)))).get("Parent Claim ID").equals(-1)) continue;
                subClaimMap.merge((File)intFileMap.get(Integer.valueOf(values.get("Parent Claim ID").toString())), Lists.newArrayList((Object[])new File[]{f}), (key, val) -> {
                    key.add(f);
                    return key;
                });
            }
            for (File parent : intFileMap.values()) {
                try {
                    ClaimStorage storage;
                    Set<DisplayBox> conflicts;
                    class_3545<class_3218, Claim> parentClaim = ClaimStorage.parseFromYaml(parent, yml, server, perms);
                    List childs = (List)subClaimMap.get(parent);
                    if (childs != null && !childs.isEmpty()) {
                        for (File childF : childs) {
                            ((Claim)parentClaim.method_15441()).addSubClaimGriefprevention((Claim)ClaimStorage.parseFromYaml(childF, yml, server, perms).method_15441());
                        }
                    }
                    if ((conflicts = (storage = ClaimStorage.get((class_3218)parentClaim.method_15442())).conflicts((Claim)parentClaim.method_15441(), null)).isEmpty()) {
                        ((Claim)parentClaim.method_15441()).setClaimID(storage.generateUUID());
                        storage.addClaim((Claim)parentClaim.method_15441());
                        continue;
                    }
                    src.method_9226(() -> ClaimUtils.translatedText("flan.readConflict", parent.getName(), conflicts, class_124.field_1079), false);
                    for (DisplayBox claim : conflicts) {
                        ClaimBox dim = claim.box();
                        class_5250 text = ClaimUtils.translatedText(String.format("@[x=%d;z=%d]", dim.minX(), dim.minZ()), class_124.field_1061);
                        text.method_10862(text.method_10866().method_10958((class_2558)new class_2558.class_10610("/tp @s " + dim.minX() + " ~ " + dim.minZ())).method_10949((class_2568)new class_2568.class_10613((class_2561)ClaimUtils.translatedText("chat.coordinates.tooltip", new Object[0]))));
                        src.method_9226(() -> text, false);
                    }
                }
                catch (Exception e) {
                    src.method_9226(() -> ClaimUtils.translatedText("flan.errorFile", parent.getName(), class_124.field_1061), false);
                    Flan.LOGGER.error((Object)e);
                }
            }
        }
        catch (IOException e) {
            Flan.LOGGER.error((Object)e);
        }
        return true;
    }

    private static Set<class_2960> complementOf(class_2960 ... perms) {
        HashSet set = Sets.newHashSet(PermissionManager.getInstance().getIds());
        for (class_2960 perm : perms) {
            set.remove(perm);
        }
        return set;
    }

    private static class_3545<class_3218, Claim> parseFromYaml(File file, Yaml yml, MinecraftServer server, Map<String, Set<class_2960>> perms) throws IOException {
        FileReader reader = new FileReader(file);
        Map values = (Map)yml.load((Reader)reader);
        reader.close();
        String ownerString = (String)values.get("Owner");
        UUID owner = ownerString.isEmpty() ? null : UUID.fromString(ownerString);
        List<String> builders = ClaimStorage.readList(values, "Builders");
        List<String> managers = ClaimStorage.readList(values, "Managers");
        List<String> containers = ClaimStorage.readList(values, "Containers");
        List<String> accessors = ClaimStorage.readList(values, "Accessors");
        String[] lesserCorner = values.get("Lesser Boundary Corner").toString().split(";");
        String[] greaterCorner = values.get("Greater Boundary Corner").toString().split(";");
        class_3218 level = server.method_3847(ClaimStorage.worldRegFromString(lesserCorner[0]));
        Claim claim = new Claim(Integer.parseInt(lesserCorner[1]), Integer.parseInt(greaterCorner[1]), Integer.parseInt(lesserCorner[3]), Integer.parseInt(greaterCorner[3]), ConfigHandler.CONFIG.defaultClaimDepth == 255 ? 0 : Integer.parseInt(lesserCorner[2]), owner, level);
        if (!builders.isEmpty() && !builders.contains(ownerString)) {
            if (builders.contains("public")) {
                perms.get("builders").forEach(perm -> {
                    if (PermissionManager.getInstance().isGlobalPermission((class_2960)perm)) {
                        claim.editGlobalPerms(null, (class_2960)perm, 1);
                    }
                });
            } else {
                perms.get("builders").forEach(perm -> claim.editPerms(null, "Builders", (class_2960)perm, 1, true));
                builders.forEach(s -> claim.setPlayerGroup(UUID.fromString(s), "Builders", true));
            }
        }
        if (!managers.isEmpty() && !managers.contains(ownerString)) {
            if (managers.contains("public")) {
                perms.get("managers").forEach(perm -> {
                    if (PermissionManager.getInstance().isGlobalPermission((class_2960)perm)) {
                        claim.editGlobalPerms(null, (class_2960)perm, 1);
                    }
                });
            } else {
                perms.get("managers").forEach(perm -> claim.editPerms(null, "Managers", (class_2960)perm, 1, true));
                managers.forEach(s -> claim.setPlayerGroup(UUID.fromString(s), "Managers", true));
            }
        }
        if (!containers.isEmpty() && !containers.contains(ownerString)) {
            if (containers.contains("public")) {
                perms.get("containers").forEach(perm -> {
                    if (PermissionManager.getInstance().isGlobalPermission((class_2960)perm)) {
                        claim.editGlobalPerms(null, (class_2960)perm, 1);
                    }
                });
            } else {
                perms.get("containers").forEach(perm -> claim.editPerms(null, "Containers", (class_2960)perm, 1, true));
                containers.forEach(s -> claim.setPlayerGroup(UUID.fromString(s), "Containers", true));
            }
        }
        if (!accessors.isEmpty() && !accessors.contains(ownerString)) {
            if (accessors.contains("public")) {
                perms.get("accessors").forEach(perm -> {
                    if (PermissionManager.getInstance().isGlobalPermission((class_2960)perm)) {
                        claim.editGlobalPerms(null, (class_2960)perm, 1);
                    }
                });
            } else {
                perms.get("accessors").forEach(perm -> claim.editPerms(null, "Accessors", (class_2960)perm, 1, true));
                accessors.forEach(s -> claim.setPlayerGroup(UUID.fromString(s), "Accessors", true));
            }
        }
        return new class_3545((Object)level, (Object)claim);
    }

    private static <T> List<T> readList(Map<String, Object> values, String key) {
        Object obj = values.get(key);
        if (obj instanceof List) {
            return (List)obj;
        }
        return new ArrayList();
    }

    public static class_5321<class_1937> worldRegFromString(String spigot) {
        if (spigot.equals("world_the_end")) {
            return class_1937.field_25181;
        }
        if (spigot.equals("world_nether")) {
            return class_1937.field_25180;
        }
        return class_1937.field_25179;
    }
}

