/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.PermissionManager;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.commands.CommandClaim;
import io.github.flemmli97.flan.commands.CommandHelpers;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.PlayerClaimData;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ClaimPermissionCommand {
    public static <T extends ArgumentBuilder<class_2168, T>> void register(ArgumentBuilder<class_2168, T> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"permission").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.permission"))).then(class_2170.method_9247((String)"personal").then(class_2170.method_9244((String)"group", (ArgumentType)StringArgumentType.string()).suggests(CommandHelpers::personalGroupSuggestion).then(class_2170.method_9244((String)"permission", (ArgumentType)class_2232.method_9441()).suggests((ctx, b) -> CommandHelpers.permSuggestions((CommandContext<class_2168>)ctx, b, true)).then(class_2170.method_9244((String)"toggle", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> class_2172.method_9253((String[])new String[]{"default", "true", "false"}, (SuggestionsBuilder)b)).executes(ClaimPermissionCommand::editPersonalPerm)))))).then(class_2170.method_9247((String)"global").then(class_2170.method_9244((String)"permission", (ArgumentType)class_2232.method_9441()).suggests((ctx, b) -> CommandHelpers.permSuggestions((CommandContext<class_2168>)ctx, b, false)).then(class_2170.method_9244((String)"toggle", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> class_2172.method_9253((String[])new String[]{"default", "true", "false"}, (SuggestionsBuilder)b)).executes(ClaimPermissionCommand::editGlobalPerm))))).then(class_2170.method_9247((String)"group").then(class_2170.method_9244((String)"group", (ArgumentType)StringArgumentType.string()).suggests(CommandHelpers::groupSuggestion).then(class_2170.method_9244((String)"permission", (ArgumentType)class_2232.method_9441()).suggests((ctx, b) -> CommandHelpers.permSuggestions((CommandContext<class_2168>)ctx, b, true)).then(class_2170.method_9244((String)"toggle", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> class_2172.method_9253((String[])new String[]{"default", "true", "false"}, (SuggestionsBuilder)b)).executes(ClaimPermissionCommand::editGroupPerm))))));
    }

    private static int editGlobalPerm(CommandContext<class_2168> context) throws CommandSyntaxException {
        int mode = switch (StringArgumentType.getString(context, (String)"toggle")) {
            case "true" -> 1;
            case "default" -> -1;
            default -> 0;
        };
        return ClaimPermissionCommand.editPerms(context, null, mode);
    }

    private static int editGroupPerm(CommandContext<class_2168> context) throws CommandSyntaxException {
        int mode = switch (StringArgumentType.getString(context, (String)"toggle")) {
            case "true" -> 1;
            case "default" -> -1;
            default -> 0;
        };
        return ClaimPermissionCommand.editPerms(context, StringArgumentType.getString(context, (String)"group"), mode);
    }

    private static int editPerms(CommandContext<class_2168> context, String group, int mode) throws CommandSyntaxException {
        String setPerm;
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        Claim claim = CommandClaim.getClaimFromMode(context, player, BuiltinPermission.EDITPERMS);
        if (claim == null) {
            return 0;
        }
        class_2960 perm = class_2232.method_9443(context, (String)"permission");
        if (group != null && PermissionManager.getInstance().isGlobalPermission(perm)) {
            ((class_2168)context.getSource()).method_9213((class_2561)ClaimUtils.translatedText("flan.nonGlobalOnly", perm, class_124.field_1079));
            return 0;
        }
        if (PermissionManager.getInstance().get(perm) == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)ClaimUtils.translatedText("flan.noSuchPerm", perm, class_124.field_1079));
            return 0;
        }
        String string = mode == 1 ? "true" : (setPerm = mode == 0 ? "false" : "default");
        if (group == null) {
            claim.editGlobalPerms(player, perm, mode);
            ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.editPerm", perm, setPerm, class_124.field_1065), false);
        } else {
            claim.editPerms(player, group, perm, mode);
            ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.editPermGroup", perm, group, setPerm, class_124.field_1065), false);
        }
        return 1;
    }

    private static int editPersonalPerm(CommandContext<class_2168> context) throws CommandSyntaxException {
        String setPerm;
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        String group = StringArgumentType.getString(context, (String)"group");
        int mode = switch (StringArgumentType.getString(context, (String)"toggle")) {
            case "true" -> 1;
            case "default" -> -1;
            default -> 0;
        };
        class_2960 perm = class_2232.method_9443(context, (String)"permission");
        if (PermissionManager.getInstance().isGlobalPermission(perm)) {
            ((class_2168)context.getSource()).method_9213((class_2561)ClaimUtils.translatedText("flan.nonGlobalOnly", perm, class_124.field_1079));
            return 0;
        }
        if (PermissionManager.getInstance().get(perm) == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)ClaimUtils.translatedText("flan.noSuchPerm", perm, class_124.field_1079));
            return 0;
        }
        String string = mode == 1 ? "true" : (setPerm = mode == 0 ? "false" : "default");
        if (PlayerClaimData.get(player).editDefaultPerms(group, perm, mode)) {
            ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.editPersonalGroup", group, perm, setPerm, class_124.field_1065), false);
        }
        return 1;
    }
}

