/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.OfflinePlayerData;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class ListClaimCommand {
    public static <T extends ArgumentBuilder<class_2168, T>> void register(ArgumentBuilder<class_2168, T> builder) {
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.list"))).executes(ListClaimCommand::listClaims)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.list.all", true))).executes(cmd -> ListClaimCommand.listClaims((CommandContext<class_2168>)cmd, class_2191.method_9330((CommandContext)cmd, (String)"player"))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"listAdminClaims").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.admin.list", true))).executes(ListClaimCommand::listAdminClaims));
    }

    private static int listClaims(CommandContext<class_2168> context) throws CommandSyntaxException {
        return ListClaimCommand.listClaimsFromUUID(context, null);
    }

    private static int listClaims(CommandContext<class_2168> context, Collection<GameProfile> profs) throws CommandSyntaxException {
        if (profs.size() != 1) {
            ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.onlyOnePlayer", class_124.field_1061), false);
            return 0;
        }
        GameProfile prof = profs.iterator().next();
        if (prof == null || prof.getId() == null) {
            return 0;
        }
        return ListClaimCommand.listClaimsFromUUID(context, prof.getId());
    }

    private static int listClaimsFromUUID(CommandContext<class_2168> context, UUID of) throws CommandSyntaxException {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        class_3222 player = of == null ? ((class_2168)context.getSource()).method_9207() : server.method_3760().method_14602(of);
        HashMap<class_3218, Collection<Claim>> claims = new HashMap<class_3218, Collection<Claim>>();
        for (class_3218 class_32182 : server.method_3738()) {
            ClaimStorage storage = ClaimStorage.get(class_32182);
            claims.put(class_32182, storage.allClaimsFromPlayer(player != null ? player.method_5667() : of));
        }
        if (ConfigHandler.CONFIG.maxClaimBlocks != -1) {
            if (player != null) {
                data = PlayerClaimData.get(player);
                ((class_2168)context.getSource()).method_9226(() -> ListClaimCommand.lambda$listClaimsFromUUID$5((PlayerClaimData)data), false);
            } else {
                data = new OfflinePlayerData(server, of);
                ((class_2168)context.getSource()).method_9226(() -> ListClaimCommand.lambda$listClaimsFromUUID$6((OfflinePlayerData)data), false);
            }
        }
        ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.listClaims", class_124.field_1065), false);
        for (Map.Entry entry : claims.entrySet()) {
            for (Claim claim : (Collection)entry.getValue()) {
                ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText(String.valueOf(((class_1937)entry.getKey()).method_27983().method_29177()) + " # " + claim.formattedClaim(), class_124.field_1054), false);
            }
        }
        return 1;
    }

    private static int listAdminClaims(CommandContext<class_2168> context) {
        class_2168 src = (class_2168)context.getSource();
        HashMap<class_3218, Collection<Claim>> claims = new HashMap<class_3218, Collection<Claim>>();
        for (class_3218 class_32182 : src.method_9211().method_3738()) {
            claims.put(class_32182, ClaimStorage.get(class_32182).getAdminClaims());
        }
        src.method_9226(() -> ClaimUtils.translatedText("flan.listAdminClaims", src.method_9225().method_27983().method_29177(), class_124.field_1065), false);
        for (Map.Entry entry : claims.entrySet()) {
            for (Claim claim : (Collection)entry.getValue()) {
                src.method_9226(() -> ClaimUtils.translatedText(String.valueOf(((class_1937)entry.getKey()).method_27983().method_29177()) + " # " + claim.formattedClaim(), class_124.field_1054), false);
            }
        }
        return 1;
    }

    private static /* synthetic */ class_2561 lambda$listClaimsFromUUID$6(OfflinePlayerData data) {
        return ClaimUtils.translatedText("flan.claimBlocksFormat", data.claimBlocks, data.getAdditionalClaims(), data.usedClaimBlocks(), data.remainingClaimBlocks(), class_124.field_1065);
    }

    private static /* synthetic */ class_2561 lambda$listClaimsFromUUID$5(PlayerClaimData data) {
        return ClaimUtils.translatedText("flan.claimBlocksFormat", data.getClaimBlocks(), data.getAdditionalClaims(), data.usedClaimBlocks(), data.remainingClaimBlocks(), class_124.field_1065);
    }
}

