/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands.sub;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.flemmli97.flan.api.data.IPlayerData;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.commands.CommandClaim;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.OfflinePlayerData;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.Collection;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2191;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class TransferClaimCommand {
    public static <T extends ArgumentBuilder<class_2168, T>> void register(ArgumentBuilder<class_2168, T> builder) {
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"transferClaim").requires(src -> PermissionNodeHandler.INSTANCE.perm((class_2168)src, "flan.command.transfer"))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).executes(TransferClaimCommand::transferClaim)));
    }

    private static int transferClaim(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_3222 player = ((class_2168)context.getSource()).method_9207();
        Collection profs = class_2191.method_9330(context, (String)"player");
        if (profs.size() != 1) {
            ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.onlyOnePlayer", class_124.field_1061), false);
            return 0;
        }
        GameProfile prof = (GameProfile)profs.iterator().next();
        ClaimStorage storage = ClaimStorage.get(((class_2168)context.getSource()).method_9225());
        Claim claim = CommandClaim.fromContext(context);
        if (claim == null) {
            ((class_2168)context.getSource()).method_9213((class_2561)ClaimUtils.translatedText("flan.noClaim", class_124.field_1061));
            return 0;
        }
        PlayerClaimData data = PlayerClaimData.get(player);
        boolean enoughBlocks = true;
        if (!data.isAdminIgnoreClaim()) {
            MinecraftServer server = ((class_2168)context.getSource()).method_9211();
            class_3222 newOwner = server.method_3760().method_14602(prof.getId());
            IPlayerData newData = newOwner != null ? PlayerClaimData.get(newOwner) : new OfflinePlayerData(server, prof.getId());
            enoughBlocks = newData.canUseClaimBlocks(claim.getPlane());
        }
        if (!enoughBlocks) {
            ((class_2168)context.getSource()).method_9213((class_2561)ClaimUtils.translatedText("flan.ownerTransferNoBlocks", class_124.field_1061));
            if (PermissionNodeHandler.INSTANCE.perm((class_2168)context.getSource(), "flan.command.bypass.claim", true)) {
                ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.ownerTransferNoBlocksAdmin", class_124.field_1061), false);
            }
            return 0;
        }
        if (!storage.transferOwner(claim, player, prof.getId())) {
            ((class_2168)context.getSource()).method_9213((class_2561)ClaimUtils.translatedText("flan.ownerTransferFail", class_124.field_1061));
            return 0;
        }
        ((class_2168)context.getSource()).method_9226(() -> ClaimUtils.translatedText("flan.ownerTransferSuccess", prof.getName(), class_124.field_1065), false);
        return 1;
    }
}

