/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.event;

import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.InteractionOverrideManager;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.attachment.ClaimAllowListKey;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.event.ItemInteractEvents;
import io.github.flemmli97.flan.gui.LockedLecternScreenHandler;
import io.github.flemmli97.flan.platform.CrossPlatformStuff;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.player.display.EnumDisplayType;
import io.github.flemmli97.flan.utils.BlockBreakAttemptHandler;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2625;
import net.minecraft.class_2626;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3715;
import net.minecraft.class_3722;
import net.minecraft.class_3965;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class BlockInteractEvents {
    public static class_1269 startBreakBlocks(class_1657 player, class_1937 level, class_1268 hand, class_2338 pos, class_2350 direction) {
        class_1269.class_9859 result;
        class_2680 state = level.method_8320(pos);
        Object object = result = BlockInteractEvents.breakBlocks(level, player, pos, state, level.method_8321(pos), true) ? class_1269.field_5811 : class_1269.field_5814;
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            boolean failed = result == class_1269.field_5814;
            ((BlockBreakAttemptHandler)serverPlayer.field_13974).flan$setBlockBreakAttemptFail((class_2338)(failed ? pos : null), failed && state.method_26165(player, (class_1922)level, pos) >= 1.0f);
        }
        return result;
    }

    public static boolean breakBlocks(class_1937 level, class_1657 p, class_2338 pos, class_2680 state, class_2586 tile) {
        if (!BlockInteractEvents.breakBlocks(level, p, pos, level.method_8320(pos), level.method_8321(pos), false)) {
            class_2586 blockEntity = level.method_8321(pos);
            if (p instanceof class_3222) {
                class_2596 updatePacket;
                class_3222 player = (class_3222)p;
                if (blockEntity != null && (updatePacket = blockEntity.method_38235()) != null) {
                    player.field_13987.method_14364(updatePacket);
                }
            }
            return false;
        }
        return true;
    }

    public static boolean breakBlocks(class_1937 level, class_1657 p, class_2338 pos, class_2680 state, class_2586 tile, boolean attempt) {
        class_3222 player;
        block11: {
            block10: {
                if (!(p instanceof class_3222)) break block10;
                player = (class_3222)p;
                if (!p.method_7325()) break block11;
            }
            return true;
        }
        ClaimStorage storage = ClaimStorage.get((class_3218)level);
        IPermissionContainer claim = storage.getForPermissionCheck(pos);
        if (claim != null) {
            class_2960 perm;
            class_2960 id;
            if (claim instanceof Claim) {
                Claim real = (Claim)claim;
                if (real.allowedEntries.isAllowed(ClaimAllowListKey.BLOCK_BREAK, arg_0 -> ((class_2680)state).method_27852(arg_0), arg_0 -> ((class_2680)state).method_26164(arg_0))) {
                    return true;
                }
            }
            if (BlockInteractEvents.contains(id = class_7923.field_41175.method_10221((Object)state.method_26204()), level.method_8321(pos), ConfigHandler.CONFIG.breakBlockBlacklist, ConfigHandler.CONFIG.breakBlockEntityTagBlacklist)) {
                return true;
            }
            if (attempt && (perm = InteractionOverrideManager.getInstance().getBlockLeftClick(state.method_26204())) != null) {
                if (!claim.canInteract(player, perm, pos, true)) {
                    PlayerClaimData.get(player).addDisplayClaim(claim, EnumDisplayType.MAIN, player.method_24515().method_10264());
                    return false;
                }
                return true;
            }
            if (!claim.canInteract(player, BuiltinPermission.BREAK, pos, true)) {
                PlayerClaimData.get(player).addDisplayClaim(claim, EnumDisplayType.MAIN, player.method_24515().method_10264());
                return false;
            }
        }
        return true;
    }

    public static class_1269 useBlocks(class_1657 p, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (!(p instanceof class_3222)) {
            return class_1269.field_5811;
        }
        class_3222 player = (class_3222)p;
        class_1799 stack = player.method_5998(hand);
        if (ConfigHandler.isClaimingTool(stack)) {
            ItemInteractEvents.claimLandHandling(player, hitResult.method_17777());
            return class_1269.field_5812;
        }
        if (ConfigHandler.isInspectionTool(stack)) {
            ItemInteractEvents.inspect(player, hitResult.method_17777());
            return class_1269.field_5812;
        }
        ClaimStorage storage = ClaimStorage.get((class_3218)level);
        IPermissionContainer claim = storage.getForPermissionCheck(hitResult.method_17777());
        if (claim != null) {
            class_2586 blockEntity;
            class_2960 id;
            class_2680 state = level.method_8320(hitResult.method_17777());
            if (claim instanceof Claim) {
                Claim real = (Claim)claim;
                if (real.allowedEntries.isAllowed(ClaimAllowListKey.BLOCK_USE, arg_0 -> ((class_2680)state).method_27852(arg_0), arg_0 -> ((class_2680)state).method_26164(arg_0))) {
                    return class_1269.field_5811;
                }
            }
            if (BlockInteractEvents.contains(id = class_7923.field_41175.method_10221((Object)state.method_26204()), blockEntity = level.method_8321(hitResult.method_17777()), ConfigHandler.CONFIG.interactBlockBlacklist, ConfigHandler.CONFIG.interactBlockEntityTagBlacklist)) {
                return class_1269.field_5811;
            }
            class_2960 perm = InteractionOverrideManager.getInstance().getBlockInteract(state.method_26204());
            if (perm != null && perm.equals((Object)BuiltinPermission.PROJECTILES)) {
                perm = BuiltinPermission.OPENCONTAINER;
            }
            if (perm != null && !perm.equals((Object)BuiltinPermission.PRESSUREPLATE)) {
                if (claim.canInteract(player, perm, hitResult.method_17777(), true)) {
                    return class_1269.field_5811;
                }
                if (state.method_26204() instanceof class_2323) {
                    class_2756 half = (class_2756)state.method_11654((class_2769)class_2323.field_10946);
                    if (half == class_2756.field_12607) {
                        class_2680 other = level.method_8320(hitResult.method_17777().method_10084());
                        player.field_13987.method_14364((class_2596)new class_2626(hitResult.method_17777().method_10084(), other));
                    } else {
                        class_2680 other = level.method_8320(hitResult.method_17777().method_10074());
                        player.field_13987.method_14364((class_2596)new class_2626(hitResult.method_17777().method_10074(), other));
                    }
                }
                PlayerClaimData.get(player).addDisplayClaim(claim, EnumDisplayType.MAIN, player.method_24515().method_10264());
                BlockInteractEvents.executeSignCommand(blockEntity, hitResult.method_17777(), player);
                return class_1269.field_5814;
            }
            if (blockEntity != null && (!player.method_21823() || stack.method_7960())) {
                if (blockEntity instanceof class_3722) {
                    if (claim.canInteract(player, BuiltinPermission.LECTERNTAKE, hitResult.method_17777(), false)) {
                        return class_1269.field_5811;
                    }
                    if (((Boolean)state.method_11654((class_2769)class_3715.field_17366)).booleanValue()) {
                        LockedLecternScreenHandler.create(player, (class_3722)blockEntity);
                    }
                    return class_1269.field_5814;
                }
                if (blockEntity instanceof class_2625) {
                    if (claim.canInteract(player, BuiltinPermission.INTERACTSIGN, hitResult.method_17777(), false)) {
                        return class_1269.field_5811;
                    }
                    return class_1269.field_5814;
                }
                if (!ConfigHandler.CONFIG.lenientBlockEntityCheck || CrossPlatformStuff.INSTANCE.isInventoryTile(blockEntity)) {
                    if (claim.canInteract(player, BuiltinPermission.OPENCONTAINER, hitResult.method_17777(), true)) {
                        return class_1269.field_5811;
                    }
                    PlayerClaimData.get(player).addDisplayClaim(claim, EnumDisplayType.MAIN, player.method_24515().method_10264());
                    return class_1269.field_5814;
                }
            }
            boolean shift = player.method_21823() || stack.method_7960();
            boolean res = claim.canInteract(player, BuiltinPermission.INTERACTBLOCK, hitResult.method_17777(), shift);
            if (!res) {
                if (shift) {
                    PlayerClaimData.get(player).addDisplayClaim(claim, EnumDisplayType.MAIN, player.method_24515().method_10264());
                }
                BlockInteractEvents.executeSignCommand(blockEntity, hitResult.method_17777(), player);
            }
            return res ? class_1269.field_5811 : class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    private static void executeSignCommand(class_2586 blockEntity, class_2338 pos, class_3222 player) {
        if (blockEntity instanceof class_2625) {
            class_2625 sign = (class_2625)blockEntity;
            sign.method_50007(player.method_51469(), (class_1657)player, pos, sign.method_49834((class_1657)player));
        }
    }

    public static boolean contains(class_2960 id, class_2586 blockEntity, List<String> idList, List<String> tagList) {
        if (idList.contains(id.method_12836()) || idList.contains(id.toString())) {
            return true;
        }
        if (blockEntity != null && !tagList.isEmpty()) {
            class_2487 nbt = blockEntity.method_38244((class_7225.class_7874)blockEntity.method_10997().method_30349());
            return tagList.stream().anyMatch(tag -> CrossPlatformStuff.INSTANCE.blockDataContains(nbt, (String)tag));
        }
        return false;
    }

    public static boolean cancelEntityBlockCollision(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        class_1297 owner;
        if (level.field_9236 || state.method_27852(class_2246.field_10124)) {
            return false;
        }
        class_3222 player = null;
        if (entity instanceof class_3222) {
            player = (class_3222)entity;
        } else if (entity instanceof class_1676) {
            owner = ((class_1676)entity).method_24921();
            if (owner instanceof class_3222) {
                player = (class_3222)owner;
            }
        } else if (entity instanceof class_1542 && (owner = ((class_1542)entity).method_24921()) instanceof class_3222) {
            player = (class_3222)owner;
        }
        if (player == null) {
            return false;
        }
        class_2960 perm = InteractionOverrideManager.getInstance().getBlockInteract(state.method_26204());
        if (perm == null) {
            return false;
        }
        if (!perm.equals((Object)BuiltinPermission.PRESSUREPLATE) && !perm.equals((Object)BuiltinPermission.PORTAL)) {
            return false;
        }
        ClaimStorage storage = ClaimStorage.get((class_3218)level);
        IPermissionContainer claim = storage.getForPermissionCheck(pos);
        if (claim != null) {
            return !claim.canInteract(player, perm, pos, false);
        }
        return false;
    }

    public static boolean preventFallOn(class_1297 entity, double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPosition) {
        class_1297 owner;
        if (entity.method_37908().field_9236) {
            return false;
        }
        if (entity instanceof class_3222) {
            class_2960 perm = InteractionOverrideManager.getInstance().getBlockInteract(landedState.method_26204());
            if (perm == null || !perm.equals((Object)BuiltinPermission.TRAMPLE)) {
                return false;
            }
            ClaimStorage storage = ClaimStorage.get((class_3218)entity.method_37908());
            IPermissionContainer claim = storage.getForPermissionCheck(landedPosition);
            if (claim == null) {
                return false;
            }
            return !claim.canInteract((class_3222)entity, perm, landedPosition, true);
        }
        if (entity instanceof class_1676 && (owner = ((class_1676)entity).method_24921()) instanceof class_3222) {
            class_2960 perm = InteractionOverrideManager.getInstance().getBlockInteract(landedState.method_26204());
            if (perm == null || !perm.equals((Object)BuiltinPermission.TRAMPLE)) {
                return false;
            }
            ClaimStorage storage = ClaimStorage.get((class_3218)entity.method_37908());
            IPermissionContainer claim = storage.getForPermissionCheck(landedPosition);
            return !claim.canInteract((class_3222)owner, perm, landedPosition, true);
        }
        return false;
    }

    public static boolean canBreakTurtleEgg(class_1937 level, class_2338 pos, class_1297 entity) {
        class_1297 owner;
        if (level.field_9236) {
            return false;
        }
        class_3218 serverWorld = (class_3218)level;
        if (entity instanceof class_3222) {
            ClaimStorage storage = ClaimStorage.get(serverWorld);
            IPermissionContainer claim = storage.getForPermissionCheck(pos);
            if (claim == null) {
                return false;
            }
            return !claim.canInteract((class_3222)entity, BuiltinPermission.TRAMPLE, pos, true);
        }
        if (entity instanceof class_1676) {
            class_1297 owner2 = ((class_1676)entity).method_24921();
            if (owner2 instanceof class_3222) {
                ClaimStorage storage = ClaimStorage.get(serverWorld);
                IPermissionContainer claim = storage.getForPermissionCheck(pos);
                if (claim == null) {
                    return false;
                }
                return !claim.canInteract((class_3222)owner2, BuiltinPermission.TRAMPLE, pos, true);
            }
        } else if (entity instanceof class_1542 && (owner = ((class_1542)entity).method_24921()) instanceof class_3222) {
            ClaimStorage storage = ClaimStorage.get(serverWorld);
            IPermissionContainer claim = storage.getForPermissionCheck(pos);
            if (claim == null) {
                return false;
            }
            return !claim.canInteract((class_3222)owner, BuiltinPermission.TRAMPLE, pos, true);
        }
        return false;
    }
}

