/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.event;

import com.google.common.collect.Sets;
import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.InteractionOverrideManager;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.claim.attachment.ClaimAllowListKey;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.player.display.EnumDisplayType;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2626;
import net.minecraft.class_2653;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import net.minecraft.class_9334;

public class ItemInteractEvents {
    private static final Set<class_1792> BLACK_LISTED_ITEMS = Sets.newHashSet((Object[])new class_1792[]{class_1802.field_8251, class_1802.field_8204, class_1802.field_8639});

    public static class_1269 useItem(class_1657 p, class_1937 level, class_1268 hand) {
        class_2960 perm;
        IPermissionContainer claim;
        class_3222 player;
        block16: {
            block15: {
                if (!(p instanceof class_3222)) break block15;
                player = (class_3222)p;
                if (!p.method_7325()) break block16;
            }
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_5998(hand);
        if (ConfigHandler.isClaimingTool(stack)) {
            class_2338 pos = ItemInteractEvents.rayTargetPos(player);
            if (pos != null) {
                ItemInteractEvents.claimLandHandling(player, pos);
                return class_1269.field_52422;
            }
            return class_1269.field_5811;
        }
        if (ConfigHandler.isInspectionTool(stack)) {
            class_2338 pos = ItemInteractEvents.rayTargetPos(player, 32, false);
            if (pos != null) {
                ItemInteractEvents.inspect(player, pos);
                return class_1269.field_52422;
            }
            return class_1269.field_5811;
        }
        ClaimStorage storage = ClaimStorage.get((class_3218)level);
        class_2338 pos = player.method_24515();
        class_3965 hitResult = ItemInteractEvents.getPlayerHitResult(level, (class_1657)player, class_3959.class_242.field_1345);
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            pos = new class_1750((class_1657)player, hand, stack, hitResult).method_8037();
        }
        if ((claim = storage.getForPermissionCheck(pos)) == null) {
            return class_1269.field_5811;
        }
        if (claim instanceof Claim) {
            Claim real = (Claim)claim;
            if (real.allowedEntries.isAllowed(ClaimAllowListKey.ITEM_USE, arg_0 -> ((class_1799)stack).method_31574(arg_0), arg_0 -> ((class_1799)stack).method_31573(arg_0))) {
                return class_1269.field_5811;
            }
        }
        if ((perm = InteractionOverrideManager.getInstance().getItemUse(stack.method_7909())) != null) {
            boolean success = claim.canInteract(player, perm, pos, true);
            if (success) {
                return class_1269.field_5811;
            }
            if (perm.equals((Object)BuiltinPermission.PLACE)) {
                class_2338 update = pos;
                if (stack.method_7909() == class_1802.field_17524) {
                    class_3965 upResult = hitResult.method_29328(hitResult.method_17777().method_10084());
                    update = new class_1750(new class_1838((class_1657)player, hand, upResult)).method_8037();
                }
                player.field_13987.method_14364((class_2596)new class_2626(update, level.method_8320(update)));
                PlayerClaimData.get(player).addDisplayClaim(claim, EnumDisplayType.MAIN, player.method_24515().method_10264());
                ItemInteractEvents.updateHeldItem(player);
            }
            ItemInteractEvents.updateHeldItem(player);
            return class_1269.field_5814;
        }
        return class_1269.field_5811;
    }

    public static class_1269 onItemUseBlock(class_1838 context, boolean hadBlockSuccess) {
        class_3222 player;
        block5: {
            block4: {
                class_1657 class_16572 = context.method_8036();
                if (!(class_16572 instanceof class_3222)) break block4;
                player = (class_3222)class_16572;
                if (!context.method_8041().method_7960()) break block5;
            }
            return class_1269.field_5811;
        }
        ClaimStorage storage = ClaimStorage.get((class_3218)context.method_8045());
        class_2338 interactPos = context.method_8037();
        class_1269 interact = ItemInteractEvents.itemUseOn(context.method_8045(), player, storage, interactPos, context.method_8041(), hadBlockSuccess);
        if (interact != class_1269.field_5811) {
            return interact;
        }
        class_2338 placePos = new class_1750(context).method_8037();
        return ItemInteractEvents.itemUseOn(context.method_8045(), player, storage, placePos, context.method_8041(), hadBlockSuccess);
    }

    private static class_1269 itemUseOn(class_1937 level, class_3222 player, ClaimStorage storage, class_2338 placePos, class_1799 stack, boolean hadBlockSuccess) {
        class_2960 perm;
        Claim real;
        Claim column;
        IPermissionContainer claim = storage.getForPermissionCheck(placePos);
        IPermissionContainer iPermissionContainer = storage.getForPermissionCheck(new class_2338(placePos.method_10263(), level.method_31600(), placePos.method_10260()));
        Claim claim2 = column = iPermissionContainer instanceof Claim ? (real = (Claim)iPermissionContainer) : null;
        if (claim == null) {
            return class_1269.field_5811;
        }
        if (BLACK_LISTED_ITEMS.contains(stack.method_7909())) {
            return class_1269.field_5811;
        }
        if (claim instanceof Claim) {
            real = (Claim)claim;
            if (real.allowedEntries.isAllowed(ClaimAllowListKey.ITEM_USE, arg_0 -> ((class_1799)stack).method_31574(arg_0), arg_0 -> ((class_1799)stack).method_31573(arg_0))) {
                return class_1269.field_5811;
            }
        }
        if ((perm = InteractionOverrideManager.getInstance().getItemUse(stack.method_7909())) == null) {
            perm = stack.method_57826(class_9334.field_52175) ? BuiltinPermission.JUKEBOX : BuiltinPermission.PLACE;
        }
        if (claim.canInteract(player, perm, placePos, false)) {
            if (column != null && stack.method_7909() instanceof class_1747) {
                column.extendDownwards(placePos);
            }
            return class_1269.field_5811;
        }
        if (!hadBlockSuccess) {
            player.method_7353((class_2561)ClaimUtils.translatedText("flan.noPermissionSimple", class_124.field_1079), true);
            PlayerClaimData.get(player).addDisplayClaim(claim, EnumDisplayType.MAIN, player.method_24515().method_10264());
        }
        class_2680 other = level.method_8320(placePos.method_10084());
        player.field_13987.method_14364((class_2596)new class_2626(placePos.method_10084(), other));
        ItemInteractEvents.updateHeldItem(player);
        return class_1269.field_5814;
    }

    private static void updateHeldItem(class_3222 player) {
        player.field_13987.method_14364((class_2596)new class_2653(-2, 0, player.method_31548().method_67532(), player.method_31548().method_7391()));
        player.field_13987.method_14364((class_2596)new class_2653(-2, 0, 40, player.method_31548().method_5438(40)));
    }

    private static boolean cantClaimInWorld(class_3218 level) {
        for (String s : ConfigHandler.CONFIG.blacklistedWorlds) {
            if (!s.equals(level.method_27983().method_29177().toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean canClaimWorld(class_3218 level, class_3222 player) {
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.isAdminIgnoreClaim()) {
            return true;
        }
        if (ConfigHandler.CONFIG.worldWhitelist) {
            if (!ItemInteractEvents.cantClaimInWorld(level)) {
                player.method_7353((class_2561)ClaimUtils.translatedText("flan.landClaimDisabledWorld", class_124.field_1079), false);
                return false;
            }
        } else if (ItemInteractEvents.cantClaimInWorld(level)) {
            player.method_7353((class_2561)ClaimUtils.translatedText("flan.landClaimDisabledWorld", class_124.field_1079), false);
            return false;
        }
        return true;
    }

    public static class_2338 rayTargetPos(class_3222 player) {
        PlayerClaimData data = PlayerClaimData.get(player);
        return ItemInteractEvents.rayTargetPos(player, data.claimingRange, data.getClaimMode().is3d && data.editingCorner() != null);
    }

    public static class_2338 rayTargetPos(class_3222 player, int range, boolean allowMiss) {
        class_239 ray = player.method_5745((double)range, 0.0f, false);
        if (ray instanceof class_3965) {
            class_3965 res = (class_3965)ray;
            if (allowMiss) {
                return res.method_17777();
            }
            return res.method_17783() != class_239.class_240.field_1333 ? res.method_17777() : null;
        }
        return null;
    }

    public static boolean canPlayerClaim(class_3218 level, class_3222 player) {
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.isAdminIgnoreClaim()) {
            return true;
        }
        if (!PermissionNodeHandler.INSTANCE.perm(player, "flan.claim.create", false)) {
            return false;
        }
        if (ConfigHandler.CONFIG.worldWhitelist) {
            return ItemInteractEvents.cantClaimInWorld(level);
        }
        return !ItemInteractEvents.cantClaimInWorld(level);
    }

    public static void claimLandHandling(class_3222 player, class_2338 target) {
        PlayerClaimData data;
        if (!PermissionNodeHandler.INSTANCE.perm(player, "flan.claim.create", false)) {
            player.method_7353((class_2561)ClaimUtils.translatedText("flan.noPermission", class_124.field_1079), true);
            return;
        }
        if (!ItemInteractEvents.canClaimWorld(player.method_51469(), player)) {
            return;
        }
        ClaimStorage storage = ClaimStorage.get(player.method_51469());
        Claim claim = storage.getClaimAt(target);
        if (claim == null) {
            claim = storage.getClaimAt(new class_2338(target.method_10263(), player.method_51469().method_31600(), target.method_10260()));
        }
        if ((data = PlayerClaimData.get(player)).claimCooldown()) {
            return;
        }
        data.setClaimActionCooldown();
        if (claim != null) {
            if (claim.canInteract(player, BuiltinPermission.EDITCLAIM, target)) {
                if (data.getClaimMode().isSubclaim) {
                    Claim subClaim = claim.getSubClaim(target);
                    if (subClaim != null && data.currentEdit() == null) {
                        if (subClaim.isCorner(target)) {
                            data.setEditClaim(subClaim, player.method_24515().method_10264());
                            data.setEditingCorner(target);
                            player.method_7353((class_2561)ClaimUtils.translatedText("flan.resizeClaim", class_124.field_1065), false);
                        } else {
                            player.method_7353((class_2561)ClaimUtils.translatedText("flan.cantClaimHere", class_124.field_1061), false);
                        }
                        data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.method_24515().method_10264());
                    } else if (data.currentEdit() != null) {
                        if (!data.editingCorner().equals((Object)target)) {
                            Set<Claim> fl = claim.resizeSubclaim(data.currentEdit(), data.editingCorner(), target);
                            if (!fl.isEmpty()) {
                                fl.forEach(confl -> data.addDisplayClaim((IPermissionContainer)confl, EnumDisplayType.MAIN, player.method_24515().method_10264()));
                                player.method_7353((class_2561)ClaimUtils.translatedText("flan.conflictOther", class_124.field_1061), false);
                            }
                            data.setEditClaim(null, 0);
                            data.setEditingCorner(null);
                        }
                    } else if (data.editingCorner() != null) {
                        if (!data.editingCorner().equals((Object)target)) {
                            Set<Claim> fl = claim.tryCreateSubClaim(data.editingCorner(), target, data.getClaimMode().is3d);
                            data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.method_24515().method_10264());
                            if (!fl.isEmpty()) {
                                fl.forEach(confl -> data.addDisplayClaim((IPermissionContainer)confl, EnumDisplayType.CONFLICT, player.method_24515().method_10264()));
                                player.method_7353((class_2561)ClaimUtils.translatedText("flan.conflictOther", class_124.field_1061), false);
                            } else {
                                player.method_7353((class_2561)ClaimUtils.translatedText("flan.subClaimCreateSuccess", class_124.field_1065), false);
                            }
                            data.setEditingCorner(null);
                        }
                    } else {
                        data.setEditingCorner(target);
                    }
                } else if (claim.isCorner(target)) {
                    data.setEditClaim(claim, player.method_24515().method_10264());
                    data.setEditingCorner(target);
                    player.method_7353((class_2561)ClaimUtils.translatedText("flan.resizeClaim", class_124.field_1065), false);
                } else if (data.currentEdit() != null) {
                    storage.resizeClaim(data.currentEdit(), data.editingCorner(), target, player);
                    data.setEditClaim(null, 0);
                    data.setEditingCorner(null);
                } else {
                    data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.method_24515().method_10264());
                    player.method_7353((class_2561)ClaimUtils.translatedText("flan.cantClaimHere", class_124.field_1061), false);
                }
            } else {
                data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.method_24515().method_10264());
                player.method_7353((class_2561)ClaimUtils.translatedText("flan.cantClaimHere", class_124.field_1061), false);
            }
        } else if (data.getClaimMode().isSubclaim) {
            player.method_7353((class_2561)ClaimUtils.translatedText("flan.wrongMode", class_2561.method_43471((String)data.getClaimMode().translationKey).method_27692(class_124.field_1075), class_124.field_1061), false);
        } else if (data.currentEdit() != null) {
            storage.resizeClaim(data.currentEdit(), data.editingCorner(), target, player);
            data.setEditClaim(null, 0);
            data.setEditingCorner(null);
        } else if (data.editingCorner() != null) {
            storage.createClaim(data.editingCorner(), target, player);
            data.setEditingCorner(null);
        } else {
            data.setEditingCorner(target);
        }
    }

    public static void inspect(class_3222 player, class_2338 target) {
        Claim claim = ClaimStorage.get(player.method_51469()).getClaimAt(target);
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.claimCooldown()) {
            return;
        }
        data.setClaimActionCooldown();
        if (claim != null) {
            String owner = claim.isAdminClaim() ? "<Admin>" : ClaimUtils.fetchUsername(claim.getOwner(), player.method_51469().method_8503()).orElse(claim.getOwner().toString());
            class_5250 text = ClaimUtils.translatedText("flan.inspectBlockOwner", owner, target.method_10263(), target.method_10264(), target.method_10260(), class_124.field_1060);
            player.method_7353((class_2561)text, false);
            data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.method_24515().method_10264());
        } else {
            player.method_7353((class_2561)ClaimUtils.translatedText("flan.inspectNoClaim", class_124.field_1061), false);
        }
    }

    protected static class_3965 getPlayerHitResult(class_1937 level, class_1657 player, class_3959.class_242 fluidMode) {
        float xRot = player.method_36455();
        float yRot = player.method_36454();
        class_243 eye = player.method_33571();
        float h = class_3532.method_15362((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float i = class_3532.method_15374((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float j = -class_3532.method_15362((float)(-xRot * ((float)Math.PI / 180)));
        float k = class_3532.method_15374((float)(-xRot * ((float)Math.PI / 180)));
        float l = i * j;
        float n = h * j;
        class_243 vec32 = eye.method_1031((double)l * 5.0, (double)k * 5.0, (double)n * 5.0);
        return level.method_17742(new class_3959(eye, vec32, class_3959.class_3960.field_17559, fluidMode, (class_1297)player));
    }
}

