/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.fabric;

import com.mojang.brigadier.CommandDispatcher;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.api.fabric.ItemUseBlockFlags;
import io.github.flemmli97.flan.api.permission.InteractionOverrideManager;
import io.github.flemmli97.flan.api.permission.PermissionManager;
import io.github.flemmli97.flan.commands.CommandClaim;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.event.BlockInteractEvents;
import io.github.flemmli97.flan.event.EntityInteractEvents;
import io.github.flemmli97.flan.event.ItemInteractEvents;
import io.github.flemmli97.flan.event.PlayerEvents;
import io.github.flemmli97.flan.event.WorldEvents;
import io.github.flemmli97.flan.fabric.integration.HarvestWithEase;
import io.github.flemmli97.flan.fabric.platform.integration.claiming.FlanProtectionProvider;
import io.github.flemmli97.flan.fabric.platform.integration.playerability.PlayerAbilityEvents;
import io.github.flemmli97.flan.platform.integration.webmap.BluemapIntegration;
import io.github.flemmli97.flan.platform.integration.webmap.DynmapIntegration;
import io.github.flemmli97.flan.player.PlayerDataHandler;
import io.github.flemmli97.flan.scoreboard.ClaimCriterias;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Function;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3965;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class FlanFabric
implements ModInitializer {
    public static final class_2960 EVENT_PHASE = class_2960.method_60655((String)"flan", (String)"events");

    public void onInitialize() {
        FlanFabric.applyPriorityListener(PlayerBlockBreakEvents.BEFORE, BlockInteractEvents::breakBlocks);
        FlanFabric.applyPriorityListener(AttackBlockCallback.EVENT, BlockInteractEvents::startBreakBlocks);
        FlanFabric.applyPriorityListener(UseBlockCallback.EVENT, FlanFabric::useBlocks);
        FlanFabric.applyPriorityListener(UseEntityCallback.EVENT, (player, world, hand, entity, hitResult) -> {
            if (hitResult != null) {
                return EntityInteractEvents.useAtEntity(player, world, hand, entity, null);
            }
            return EntityInteractEvents.useEntity(player, world, hand, entity);
        });
        FlanFabric.applyPriorityListener(UseItemCallback.EVENT, ItemInteractEvents::useItem);
        ServerLifecycleEvents.SERVER_STARTING.register(FlanFabric::serverLoad);
        ServerLifecycleEvents.SERVER_STARTED.register(FlanFabric::serverFinishLoad);
        ServerTickEvents.START_SERVER_TICK.register(WorldEvents::serverTick);
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> PlayerEvents.onLogout((class_1657)handler.field_14140));
        CommandRegistrationCallback.EVENT.register((dispatcher, reg, env) -> CommandClaim.register((CommandDispatcher<class_2168>)dispatcher, reg, env == class_2170.class_5364.field_25420));
        FlanFabric.registerListener(PermissionManager.ID.method_29177(), PermissionManager::create);
        FlanFabric.registerListener(InteractionOverrideManager.ID.method_29177(), InteractionOverrideManager::create);
        Flan.permissionAPI = FabricLoader.getInstance().isModLoaded("fabric-permissions-api-v0");
        Flan.playerAbilityLib = FabricLoader.getInstance().isModLoaded("playerabilitylib");
        Flan.ftbRanks = FabricLoader.getInstance().isModLoaded("ftbranks");
        Flan.octoEconomy = FabricLoader.getInstance().isModLoaded("octo-economy-api");
        Flan.diamondCurrency = FabricLoader.getInstance().isModLoaded("diamondeconomy");
        Flan.ftbChunks = FabricLoader.getInstance().isModLoaded("ftbchunks");
        Flan.gomlServer = FabricLoader.getInstance().isModLoaded("goml");
        Flan.commonProtApi = FabricLoader.getInstance().isModLoaded("common-protection-api");
        Flan.impactor = FabricLoader.getInstance().isModLoaded("impactor");
        Flan.create = FabricLoader.getInstance().isModLoaded("create");
        if (Flan.playerAbilityLib) {
            PlayerAbilityEvents.register();
        }
        if (FabricLoader.getInstance().isModLoaded("dynmap")) {
            DynmapIntegration.reg();
        }
        if (FabricLoader.getInstance().isModLoaded("harvestwithease")) {
            HarvestWithEase.init();
        }
        if (Flan.commonProtApi) {
            FlanProtectionProvider.register();
        }
        ClaimCriterias.init();
    }

    private static <T> void applyPriorityListener(Event<T> event, T listener) {
        event.addPhaseOrdering(EVENT_PHASE, Event.DEFAULT_PHASE);
        event.register(EVENT_PHASE, listener);
    }

    public static void serverLoad(MinecraftServer server) {
        ConfigHandler.reloadConfigs(server);
        if (FabricLoader.getInstance().isModLoaded("bluemap")) {
            BluemapIntegration.reg(server);
        }
    }

    public static void serverFinishLoad(MinecraftServer server) {
        PlayerDataHandler.deleteInactivePlayerData(server);
    }

    public static class_1269 useBlocks(class_1657 p, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (p instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)p;
            ItemUseBlockFlags flags = ItemUseBlockFlags.fromPlayer(serverPlayer);
            class_1269 res = BlockInteractEvents.useBlocks(p, level, hand, hitResult);
            if (res == class_1269.field_5812) {
                return res;
            }
            flags.flan$stopCanUseBlocks(res == class_1269.field_5814);
            flags.flan$stopCanUseItems(ItemInteractEvents.onItemUseBlock(new class_1838(p, hand, hitResult), res != class_1269.field_5814) == class_1269.field_5814);
            if (!flags.flan$allowUseBlocks() && !flags.flan$allowUseItems()) {
                return class_1269.field_5814;
            }
        }
        return class_1269.field_5811;
    }

    private static void registerListener(class_2960 id, final Function<class_7225.class_7874, class_3302> factory) {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener(id, provider -> new IdentifiableResourceReloadListener(){
            private final class_3302 listener;
            final /* synthetic */ class_7225.class_7874 val$provider;
            final /* synthetic */ class_2960 val$id;
            {
                this.val$provider = class_78742;
                this.val$id = class_29602;
                this.listener = (class_3302)factory.apply(this.val$provider);
            }

            public CompletableFuture<Void> method_25931(class_3302.class_4045 barrier, class_3300 manager, Executor backgroundExecutor, Executor gameExecutor) {
                return this.listener.method_25931(barrier, manager, backgroundExecutor, gameExecutor);
            }

            public class_2960 getFabricId() {
                return this.val$id;
            }
        });
    }
}

