/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.gui.PagedServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.StringResultScreenHandler;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3908;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;

public class PotionEditScreenHandler
extends PagedServerOnlyScreenHandler<Claim> {
    private boolean removeMode;

    protected PotionEditScreenHandler(int syncId, class_1661 playerInventory, Claim claim) {
        super(syncId, playerInventory, 6, claim);
    }

    public static void openPotionMenu(class_1657 player, final Claim claim) {
        class_3908 fac = new class_3908(){

            public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                return new PotionEditScreenHandler(syncId, inv, claim);
            }

            public class_2561 method_5476() {
                return ClaimUtils.translatedText("flan.screenEffects", new Object[0]);
            }
        };
        player.method_17355(fac);
    }

    @Override
    protected void fillInventoryWith() {
        Map<class_6880<class_1291>, Pair<Integer, Integer>> potions = ((Claim)this.data).getPotions();
        ArrayList key = Lists.newArrayList(potions.keySet());
        key.sort(Comparator.comparing(class_6880::method_55840));
        for (int i = 0; i < 54; ++i) {
            if (i == 0) {
                class_1799 stack = ServerScreenHelper.createStack(class_1802.field_8626, (class_2561)ServerScreenHelper.coloredGuiText("flan.screenBack", class_124.field_1079));
                ((class_1735)this.field_7761.get(i)).method_7673(stack);
                continue;
            }
            if (i == 3) {
                class_1799 stack = ServerScreenHelper.createStack(class_1802.field_8782, (class_2561)ServerScreenHelper.coloredGuiText("flan.screenAdd", class_124.field_1077));
                ((class_1735)this.field_7761.get(i)).method_7673(stack);
                continue;
            }
            if (i == 4) {
                class_1799 stack = ServerScreenHelper.createStack(class_1802.field_8793, (class_2561)ServerScreenHelper.coloredGuiText("flan.screenRemoveMode", this.removeMode, class_124.field_1079));
                ((class_1735)this.field_7761.get(i)).method_7673(stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                ((class_1735)this.field_7761.get(i)).method_7673(ServerScreenHelper.emptyFiller());
                continue;
            }
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1 + this.getPage() * 28;
            if (id < potions.size()) {
                class_6880 effect = (class_6880)key.get(id);
                class_1799 stack = ServerScreenHelper.createStack(class_1802.field_8574, (class_2561)ServerScreenHelper.coloredGuiText("flan.screenEffectText", class_124.field_1054));
                stack.method_57379(class_9334.field_49651, (Object)new class_1844(Optional.empty(), Optional.empty(), List.of(new class_1293(effect, ((Integer)potions.get(effect).getFirst()).intValue(), (Integer)potions.get(effect).getSecond() - 1)), Optional.empty()));
                class_9279.method_57452((class_9331)class_9334.field_49628, (class_1799)stack, tag -> tag.method_10582("FlanEffect", effect.method_55840()));
                ((class_1735)this.field_7761.get(i)).method_7673(stack);
                continue;
            }
            ((class_1735)this.field_7761.get(i)).method_7673(class_1799.field_8037);
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 3 || slot == 4 || slot < 45 && slot > 8 && slot % 9 != 0 && slot % 9 != 8;
    }

    @Override
    protected boolean handleSlotClicked(class_3222 player, int index, class_1735 slot, int clickType) {
        if (index == 0) {
            player.method_7346();
            player.method_5682().execute(() -> ClaimMenuScreenHandler.openClaimMenu(player, (Claim)this.data));
            ServerScreenHelper.playSongToPlayer(player, (class_6880<class_3414>)class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        if (index == 3) {
            player.method_7346();
            player.method_5682().execute(() -> StringResultScreenHandler.createNewStringResult((class_1657)player, s -> {
                int duration;
                String[] potion = s.contains("-") ? s.split("-") : s.split(";");
                int amp = 1;
                Optional holder = class_7923.field_41174.method_10223(class_2960.method_60654((String)potion[0]));
                if (holder.map(effect -> effect == class_1294.field_5926 && !potion[0].equals("minecraft:luck")).orElse(true).booleanValue()) {
                    ServerScreenHelper.playSongToPlayer(player, class_3417.field_15008, 1.0f, 1.0f);
                    return;
                }
                int n = duration = ((class_6880.class_6883)holder.get()).method_55838(class_1294.field_5925) ? 400 : 200;
                if (potion.length == 2) {
                    try {
                        amp = Integer.parseInt(potion[1]);
                    }
                    catch (NumberFormatException e) {
                        Flan.LOGGER.error((Object)e);
                    }
                } else if (potion.length == 3) {
                    try {
                        duration = Integer.parseInt(potion[1]);
                        amp = Integer.parseInt(potion[2]);
                    }
                    catch (NumberFormatException e) {
                        Flan.LOGGER.error((Object)e);
                    }
                }
                ((Claim)this.data).addPotion((class_6880<class_1291>)((class_6880)holder.get()), duration, amp);
                player.method_7346();
                player.method_5682().execute(() -> PotionEditScreenHandler.openPotionMenu((class_1657)player, (Claim)this.data));
                ServerScreenHelper.playSongToPlayer(player, class_3417.field_14559, 1.0f, 1.0f);
            }, () -> {
                player.method_7346();
                player.method_5682().execute(() -> PotionEditScreenHandler.openPotionMenu((class_1657)player, (Claim)this.data));
                ServerScreenHelper.playSongToPlayer(player, class_3417.field_15008, 1.0f, 1.0f);
            }));
            ServerScreenHelper.playSongToPlayer(player, (class_6880<class_3414>)class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        if (index == 4) {
            this.removeMode = !this.removeMode;
            class_1799 stack = ServerScreenHelper.createStack(class_1802.field_8793, (class_2561)ServerScreenHelper.coloredGuiText("flan.screenRemoveMode", this.removeMode, class_124.field_1079));
            slot.method_7673(stack);
            ServerScreenHelper.playSongToPlayer(player, (class_6880<class_3414>)class_3417.field_15015, 1.0f, 1.0f);
            return true;
        }
        class_1799 stack = slot.method_7677();
        if (!stack.method_7960() && this.removeMode) {
            String effect = ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461().method_68564("FlanEffect", "");
            if (!effect.isEmpty()) {
                class_7923.field_41174.method_10223(class_2960.method_60654((String)effect)).ifPresent(((Claim)this.data)::removePotion);
            }
            slot.method_7673(class_1799.field_8037);
            ServerScreenHelper.playSongToPlayer(player, class_3417.field_14911, 1.0f, 1.0f);
        }
        return false;
    }

    @Override
    protected PagedServerOnlyScreenHandler.PageSettings pageSettings() {
        return new PagedServerOnlyScreenHandler.PageSettings((((Claim)this.data).getPotions().size() - 1) / 28, 47, 51);
    }
}

