/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.player;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.github.flemmli97.flan.Flan;
import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.data.IPlayerData;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.PermissionManager;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.commands.PendingCommand;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.event.ItemInteractEvents;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.ClaimMode;
import io.github.flemmli97.flan.player.ClientBlockDisplayTracker;
import io.github.flemmli97.flan.player.display.ClaimDisplay;
import io.github.flemmli97.flan.player.display.DisplayBox;
import io.github.flemmli97.flan.player.display.EnumDisplayType;
import io.github.flemmli97.flan.scoreboard.ClaimCriterias;
import io.github.flemmli97.flan.utils.IPlayerClaimImpl;
import io.github.flemmli97.flan.utils.TeleportUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_274;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_9015;
import net.minecraft.server.MinecraftServer;

public class PlayerClaimData
implements IPlayerData {
    public static final class_2960 MINING_SPEED_MOD = class_2960.method_60655((String)"flan", (String)"mining_speed_modifier");
    private final UUID editDisplay = UUID.randomUUID();
    private final UUID display3D = UUID.randomUUID();
    private int claimBlocks;
    private int additionalClaimBlocks;
    private int confirmTick;
    private int actionCooldown;
    private int usedBlocks;
    private int lastBlockTick;
    private int trappedTick = -1;
    private int deathPickupTick;
    private class_243 trappedPos;
    private class_2338 tpPos;
    private ClaimMode editMode = ClaimMode.DEFAULT;
    private Claim editingClaim;
    private ClaimDisplay displayEditing;
    private class_2338 firstCorner;
    private final Set<ClaimDisplay> claimDisplayList = new HashSet<ClaimDisplay>();
    private final Set<ClaimDisplay> displayToAdd = new HashSet<ClaimDisplay>();
    private final class_3222 player;
    private boolean adminIgnoreClaim;
    private boolean claimBlockMessage;
    private PendingCommand pendingCommand;
    private final Map<String, Map<class_2960, Boolean>> defaultGroups = new HashMap<String, Map<class_2960, Boolean>>();
    private boolean shouldProtectDrop;
    private boolean calculateShouldDrop = true;
    private final Map<UUID, Map<UUID, Long>> fakePlayerNotif = new HashMap<UUID, Map<UUID, Long>>();
    private boolean fakePlayerNotification = true;
    private long lastClaimTime;
    public final ClientBlockDisplayTracker clientBlockDisplayTracker;
    public int claimingRange = 64;

    public PlayerClaimData(class_3222 player) {
        this.player = player;
        this.claimBlocks = ConfigHandler.CONFIG.startingBlocks;
        this.clientBlockDisplayTracker = new ClientBlockDisplayTracker(player);
    }

    public static PlayerClaimData get(class_3222 player) {
        return ((IPlayerClaimImpl)player).flan$get();
    }

    @Override
    public int getClaimBlocks() {
        return Math.min(this.claimBlocks, PermissionNodeHandler.INSTANCE.permVal(this.player, "flan.claim.blocks.cap", this.claimBlocks)) + PermissionNodeHandler.INSTANCE.permVal(this.player, "flan.claim.blocks.bonus", 0);
    }

    public void setClaimBlocks(int amount) {
        this.claimBlocks = amount;
        PlayerClaimData.updateScoreFor(this.player, ClaimCriterias.AMOUNT, this.claimBlocks + this.additionalClaimBlocks);
        PlayerClaimData.updateScoreFor(this.player, ClaimCriterias.FREE, this.claimBlocks + this.additionalClaimBlocks - this.usedBlocks);
    }

    public void addClaimBlocksDirect(int amount) {
        this.setClaimBlocks(this.claimBlocks + amount);
    }

    public boolean addClaimBlocks(int amount) {
        if (this.canIncrease(this.claimBlocks + amount)) {
            this.setClaimBlocks(this.claimBlocks + amount);
            return true;
        }
        return false;
    }

    private boolean canIncrease(int blocks) {
        return PermissionNodeHandler.INSTANCE.permBelowEqVal(this.player, "flan.claim.blocks.max", blocks, ConfigHandler.CONFIG.maxClaimBlocks);
    }

    @Override
    public int getAdditionalClaims() {
        return this.additionalClaimBlocks;
    }

    @Override
    public void setAdditionalClaims(int amount) {
        this.additionalClaimBlocks = Math.max(0, amount);
        PlayerClaimData.updateScoreFor(this.player, ClaimCriterias.AMOUNT, this.claimBlocks + this.additionalClaimBlocks);
        PlayerClaimData.updateScoreFor(this.player, ClaimCriterias.FREE, this.claimBlocks + this.additionalClaimBlocks - this.usedBlocks);
    }

    @Override
    public boolean canUseClaimBlocks(int amount) {
        if (ConfigHandler.CONFIG.maxClaimBlocks == -1) {
            return true;
        }
        return amount <= this.remainingClaimBlocks();
    }

    @Override
    public int usedClaimBlocks() {
        return this.calculateUsedClaimBlocks();
    }

    @Override
    public int remainingClaimBlocks() {
        return this.getClaimBlocks() + this.getAdditionalClaims() - this.usedClaimBlocks();
    }

    public long nextClaimCooldown() {
        return ConfigHandler.CONFIG.claimingCooldown <= 0 ? 0L : Math.max(0L, this.player.method_51469().method_8510() - this.lastClaimTime - (long)ConfigHandler.CONFIG.claimingCooldown);
    }

    public void updateLastClaim() {
        this.lastClaimTime = this.player.method_51469().method_8510();
    }

    public void setClaimActionCooldown() {
        this.actionCooldown = 10;
    }

    public boolean claimCooldown() {
        return this.actionCooldown > 0;
    }

    public Claim currentEdit() {
        return this.editingClaim;
    }

    public void setEditClaim(Claim claim, int height) {
        if (claim != null) {
            this.displayEditing = new ClaimDisplay(claim, EnumDisplayType.EDIT, height);
        } else if (this.displayEditing != null) {
            this.displayEditing.onRemoved(this.player);
            this.displayEditing = null;
        }
        this.editingClaim = claim;
    }

    public void addDisplayClaim(IPermissionContainer cont, EnumDisplayType type, int height) {
        this.addDisplayClaim(cont, type, height, true);
    }

    private void addDisplayClaim(IPermissionContainer cont, EnumDisplayType type, int height, boolean override) {
        if (cont instanceof Claim) {
            Claim claim = (Claim)cont;
            this.addDisplayClaim(new ClaimDisplay(claim, type, height), override);
            if (type == EnumDisplayType.MAIN) {
                for (Claim sub : claim.getAllSubclaims()) {
                    this.addDisplayClaim(new ClaimDisplay(sub, EnumDisplayType.SUB, height), override);
                }
            }
        }
    }

    public void addDisplayClaim(DisplayBox display, EnumDisplayType type, int height) {
        this.addDisplayClaim(new ClaimDisplay(display, (class_1937)this.player.method_51469(), type, height), true);
    }

    private void addDisplayClaim(ClaimDisplay display, boolean override) {
        if (override || !this.claimDisplayList.contains(display)) {
            this.displayToAdd.add(display);
        }
    }

    public ClaimMode getClaimMode() {
        if (this.editingClaim != null && this.editingClaim.is3d()) {
            return this.editMode.isSubclaim ? ClaimMode.SUBCLAIM_3D : ClaimMode.DEFAULT_3D;
        }
        if (!ConfigHandler.CONFIG.main3dClaims && !this.editMode.isSubclaim) {
            return ClaimMode.DEFAULT;
        }
        return this.editMode;
    }

    public void setEditMode(ClaimMode mode) {
        this.editMode = mode;
        this.setEditClaim(null, 0);
        this.setEditingCorner(null);
    }

    public class_2338 editingCorner() {
        return this.firstCorner;
    }

    public void setEditingCorner(class_2338 pos) {
        if (pos != null) {
            this.clientBlockDisplayTracker.resetFakeBlocks(this.display3D);
        } else {
            this.clientBlockDisplayTracker.resetFakeBlocks(this.editDisplay);
        }
        this.firstCorner = pos;
    }

    public int runPendingCommand(boolean deny) {
        int res = -1;
        if (this.pendingCommand != null) {
            if (deny) {
                res = this.pendingCommand.runCommand();
            } else {
                this.pendingCommand.deny();
                res = 0;
            }
        }
        this.pendingCommand = null;
        return res;
    }

    public void deferCommand(PendingCommand flag) {
        this.pendingCommand = flag;
        this.confirmTick = 400;
    }

    public void setAdminIgnoreClaim(boolean flag) {
        this.adminIgnoreClaim = flag;
    }

    public boolean isAdminIgnoreClaim() {
        return this.adminIgnoreClaim;
    }

    public Map<String, Map<class_2960, Boolean>> playerDefaultGroups() {
        return this.defaultGroups;
    }

    public boolean editDefaultPerms(String group, class_2960 perm, int mode) {
        boolean has;
        HashMap<class_2960, Boolean> perms;
        if (PermissionManager.getInstance().isGlobalPermission(perm) || ConfigHandler.CONFIG.globallyDefined(this.player.method_51469(), perm)) {
            return false;
        }
        if (mode > 1) {
            mode = -1;
        }
        Map<class_2960, Boolean> map = perms = (has = this.defaultGroups.containsKey(group)) ? this.defaultGroups.get(group) : new HashMap<class_2960, Boolean>();
        if (mode == -1) {
            perms.remove(perm);
        } else {
            perms.put(perm, mode == 1);
        }
        if (!has) {
            this.defaultGroups.put(group, perms);
        }
        return true;
    }

    public boolean setTrappedRescue() {
        Claim claim = ((IPlayerClaimImpl)this.player).flan$getCurrentClaim();
        if (this.trappedTick < 0 && claim != null && !this.player.method_5667().equals(claim.getOwner())) {
            this.trappedTick = 101;
            this.trappedPos = this.player.method_19538();
            return true;
        }
        return false;
    }

    public boolean setTeleportTo(class_2338 tp) {
        if (this.trappedTick < 0) {
            this.trappedTick = 101;
            this.trappedPos = this.player.method_19538();
            this.tpPos = tp;
            return true;
        }
        return false;
    }

    public void tick(Claim currentClaim) {
        boolean tool = ConfigHandler.isClaimingTool(this.player.method_6047()) || ConfigHandler.isClaimingTool(this.player.method_6079());
        boolean stick = ConfigHandler.isInspectionTool(this.player.method_6047()) || ConfigHandler.isInspectionTool(this.player.method_6079());
        this.claimDisplayList.removeIf(display -> {
            boolean remove;
            boolean bl = remove = display.display(this.player, !tool && !stick) || display.equals(this.displayEditing);
            if (remove) {
                display.onRemoved(this.player);
            }
            return remove || this.displayToAdd.contains(display);
        });
        this.displayToAdd.forEach(add -> {
            if (!add.equals(this.displayEditing)) {
                this.claimDisplayList.add((ClaimDisplay)add);
            }
        });
        this.displayToAdd.clear();
        if (++this.lastBlockTick > ConfigHandler.CONFIG.ticksForNextBlock) {
            this.addClaimBlocks(1);
            this.lastBlockTick = 0;
        }
        if (tool && ItemInteractEvents.canPlayerClaim(this.player.method_51469(), this.player)) {
            this.claimingRange = this.getClaimMode().is3d && this.editingCorner() != null ? 10 : 64;
            class_2338 pos = ItemInteractEvents.rayTargetPos(this.player);
            if (pos != null && !pos.equals((Object)this.firstCorner)) {
                this.clientBlockDisplayTracker.displayFakeBlocks(this.display3D, new ClientBlockDisplayTracker.DisplayData(pos, class_2246.field_10490.method_9564()));
            } else {
                this.clientBlockDisplayTracker.resetFakeBlocks(this.display3D);
            }
        } else {
            this.clientBlockDisplayTracker.resetFakeBlocks(this.display3D);
            this.claimingRange = 64;
        }
        if (this.firstCorner != null && this.player.field_6012 % 3 == 0) {
            this.clientBlockDisplayTracker.displayFakeBlocks(this.editDisplay, new ClientBlockDisplayTracker.DisplayData(this.firstCorner, class_2246.field_10174.method_9564()));
        }
        if (--this.confirmTick < 0) {
            this.pendingCommand = null;
        }
        if (this.displayEditing != null) {
            this.displayEditing.display(this.player, !tool && !stick);
        }
        if (!tool) {
            this.setEditingCorner(null);
            this.setEditClaim(null, 0);
        }
        if (!tool && !stick) {
            this.claimBlockMessage = false;
        } else if (!this.claimBlockMessage) {
            this.claimBlockMessage = true;
            if (tool && this.shouldDisplayClaimToolMessage()) {
                this.player.method_7353((class_2561)ClaimUtils.translatedText("flan.claimBlocksFormat", this.getClaimBlocks(), this.getAdditionalClaims(), this.usedClaimBlocks(), this.remainingClaimBlocks(), class_124.field_1065), false);
                this.player.method_7353((class_2561)ClaimUtils.translatedText("flan.claimModeFormat", class_2561.method_43471((String)this.getClaimMode().translationKey).method_27695(new class_124[]{class_124.field_1075, class_124.field_1067}), class_124.field_1065), true);
            }
            this.displayClaims(currentClaim);
        }
        if ((tool || stick) && this.player.field_6012 % 20 == 0) {
            this.displayClaims(currentClaim);
        }
        --this.actionCooldown;
        if (--this.trappedTick >= 0) {
            if (this.trappedTick == 0) {
                if (this.tpPos != null) {
                    class_2338.class_2339 tpTo = this.tpPos.method_25503();
                    class_243 offset = new class_243((double)this.tpPos.method_10263() + 0.5, (double)this.tpPos.method_10264() + 0.01, (double)this.tpPos.method_10260() + 0.5).method_1020(this.player.method_19538());
                    int yHighest = this.player.method_51469().method_8497(this.tpPos.method_10263() >> 4, this.tpPos.method_10260() >> 4).method_12005(class_2902.class_2903.field_13197, this.tpPos.method_10263() & 0xF, this.tpPos.method_10260() & 0xF);
                    class_238 box = this.player.method_5829().method_997(offset);
                    if (tpTo.method_10264() < yHighest) {
                        while (tpTo.method_10264() < yHighest && !this.player.method_51469().method_8587((class_1297)this.player, box)) {
                            tpTo.method_10103(tpTo.method_10263(), tpTo.method_10264() + 1, tpTo.method_10260());
                            box = box.method_989(0.0, 1.0, 0.0);
                        }
                        tpTo.method_10103(tpTo.method_10263(), tpTo.method_10264() + 1, tpTo.method_10260());
                    } else {
                        tpTo.method_10103(tpTo.method_10263(), yHighest, tpTo.method_10260());
                    }
                    if (this.player.method_5765()) {
                        this.player.method_5848();
                    }
                    this.player.method_5859((double)tpTo.method_10263() + 0.5, (double)tpTo.method_10264(), (double)tpTo.method_10260() + 0.5);
                    this.tpPos = null;
                } else {
                    class_243 tp = TeleportUtils.getTeleportPos((class_1297)this.player, this.player.method_19538(), ClaimStorage.get(this.player.method_51469()), new TeleportUtils.Area2D(((IPlayerClaimImpl)this.player).flan$getCurrentClaim().getDimensions()), TeleportUtils.roundedBlockPos(this.player.method_19538()).method_25503(), (claim, nPos) -> false);
                    if (this.player.method_5765()) {
                        this.player.method_5848();
                    }
                    this.player.method_5859(tp.method_10216(), tp.method_10214(), tp.method_10215());
                }
            } else if (this.player.method_19538().method_1025(this.trappedPos) > 0.15) {
                this.trappedTick = -1;
                this.trappedPos = null;
                this.player.method_7353((class_2561)ClaimUtils.translatedText("flan.trappedMove", class_124.field_1061), false);
            }
        }
        --this.deathPickupTick;
        if (!this.player.method_29504()) {
            this.calculateShouldDrop = true;
        }
    }

    private void displayClaims(Claim currentClaim) {
        if (ConfigHandler.CONFIG.nearbyClaimsToolDisplay > 0) {
            for (Claim claim : ClaimStorage.get(this.player.method_51469()).getNearbyClaims(this.player.method_51469(), this.player.method_24515(), ConfigHandler.CONFIG.nearbyClaimsToolDisplay, ConfigHandler.CONFIG.nearbyClaimsToolDisplay)) {
                this.addDisplayClaim(claim, EnumDisplayType.MAIN, this.player.method_24515().method_10264(), false);
            }
        } else {
            this.addDisplayClaim(currentClaim, EnumDisplayType.MAIN, this.player.method_24515().method_10264(), false);
        }
    }

    private boolean shouldDisplayClaimToolMessage() {
        return ItemInteractEvents.canClaimWorld(this.player.method_51469(), this.player) && ConfigHandler.CONFIG.maxClaimBlocks > 0;
    }

    public void unlockDeathItems() {
        this.deathPickupTick = 1200;
    }

    public boolean deathItemsUnlocked() {
        return this.deathPickupTick > 0;
    }

    public void clone(PlayerClaimData data) {
        this.claimBlocks = data.claimBlocks;
        this.additionalClaimBlocks = data.additionalClaimBlocks;
        this.defaultGroups.clear();
        this.defaultGroups.putAll(data.defaultGroups);
        if (data.setDeathItemOwner()) {
            this.player.method_7353((class_2561)ClaimUtils.translatedText("flan.unlockDropsCmd", "/flan unlockDrops", class_124.field_1065), false);
        }
    }

    public void updateScoreboard() {
        int claims = this.updateClaimScores();
        PlayerClaimData.updateScoreFor(this.player, ClaimCriterias.USED, this.usedBlocks);
        PlayerClaimData.updateScoreFor(this.player, ClaimCriterias.FREE, this.claimBlocks + this.additionalClaimBlocks - this.usedBlocks);
        PlayerClaimData.updateScoreFor(this.player, ClaimCriterias.CLAIMS, claims);
    }

    private int updateClaimScores() {
        int usedClaimsBlocks = 0;
        int claimsAmount = 0;
        for (class_3218 level : this.player.method_5682().method_3738()) {
            Collection<Claim> claims = ClaimStorage.get(level).allClaimsFromPlayer(this.player.method_5667());
            if (claims == null) continue;
            usedClaimsBlocks += claims.stream().filter(claim -> !claim.isAdminClaim()).mapToInt(Claim::getPlane).sum();
            claimsAmount += claims.size();
        }
        this.usedBlocks = usedClaimsBlocks;
        return claimsAmount;
    }

    private int calculateUsedClaimBlocks() {
        int usedClaimsBlocks = 0;
        for (class_3218 level : this.player.method_5682().method_3738()) {
            Collection<Claim> claims = ClaimStorage.get(level).allClaimsFromPlayer(this.player.method_5667());
            if (claims == null) continue;
            usedClaimsBlocks += claims.stream().filter(claim -> !claim.isAdminClaim()).mapToInt(Claim::getPlane).sum();
        }
        return usedClaimsBlocks;
    }

    public boolean setDeathItemOwner() {
        if (!this.player.method_29504()) {
            return false;
        }
        if (this.calculateShouldDrop) {
            class_2338 rounded = TeleportUtils.roundedBlockPos(this.player.method_19538().method_1031(0.0, (double)this.player.method_18381(this.player.method_18376()), 0.0));
            this.shouldProtectDrop = ClaimStorage.get(this.player.method_51469()).getForPermissionCheck(rounded).canInteract(this.player, BuiltinPermission.LOCKITEMS, rounded) && !this.player.method_5682().method_3767().method_8355(class_1928.field_19389);
            this.calculateShouldDrop = false;
        }
        return this.shouldProtectDrop;
    }

    public void setFakePlayerNotif(boolean on) {
        this.fakePlayerNotification = on;
    }

    public boolean hasFakePlayerNotificationOn() {
        return this.fakePlayerNotification;
    }

    public void notifyFakePlayerInteraction(class_3222 fakePlayer, class_2338 pos, Claim claim) {
        if (!this.fakePlayerNotification) {
            return;
        }
        Map map = this.fakePlayerNotif.computeIfAbsent(claim.getClaimID(), o -> new HashMap());
        Long last = (Long)map.get(fakePlayer.method_5667());
        if (last == null || this.player.method_51469().method_8510() - 1200L > last) {
            class_5250 claimMsg = ClaimUtils.translatedText("flan.fakePlayerNotification1", claim.getLevel().method_27983().method_29177().toString(), pos, class_124.field_1079);
            this.player.method_64398((class_2561)claimMsg);
            String cmdStr = String.format("/flan fakePlayer add %s", fakePlayer.method_5667());
            class_5250 cmd = ClaimUtils.translatedText("flan.clickableComponent", new Object[0]).method_27696(class_2583.field_24360.method_10977(class_124.field_1065).method_10958((class_2558)new class_2558.class_10609(cmdStr)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)cmdStr))));
            class_5250 msg = ClaimUtils.translatedText("flan.fakePlayerNotification2", cmd);
            this.player.method_64398((class_2561)msg);
            cmdStr = "/flan fakePlayer";
            cmd = ClaimUtils.translatedText("flan.clickableComponent", new Object[0]).method_27696(class_2583.field_24360.method_10977(class_124.field_1065).method_10958((class_2558)new class_2558.class_10609(cmdStr)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)cmdStr))));
            msg = ClaimUtils.translatedText("flan.fakePlayerNotification3", cmd);
            this.player.method_64398((class_2561)msg);
            map.put(fakePlayer.method_5667(), this.player.method_51469().method_8510());
        }
    }

    public void save(MinecraftServer server) {
        Flan.log("Saving player data for player {} with uuid {}", this.player.method_5477(), this.player.method_5667());
        Path dir = ConfigHandler.getPlayerSavePath(server);
        try {
            Path file = dir.resolve(String.valueOf(this.player.method_5667()) + ".json");
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
                Files.createFile(file, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            JsonObject obj = new JsonObject();
            obj.addProperty("ClaimBlocks", (Number)this.claimBlocks);
            obj.addProperty("AdditionalBlocks", (Number)this.additionalClaimBlocks);
            obj.addProperty("LastSeen", LocalDateTime.now().format(Flan.ONLINE_TIME_FORMATTER));
            JsonObject defPerm = new JsonObject();
            this.defaultGroups.forEach((key, value) -> {
                JsonObject perm = new JsonObject();
                value.forEach((key1, value1) -> perm.addProperty(key1.toString(), value1));
                defPerm.add(key, (JsonElement)perm);
            });
            obj.add("DefaultGroups", (JsonElement)defPerm);
            obj.addProperty("FakePlayerNotification", Boolean.valueOf(this.fakePlayerNotification));
            JsonWriter jsonWriter = ConfigHandler.GSON.newJsonWriter((Writer)Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]));
            ConfigHandler.GSON.toJson((JsonElement)obj, jsonWriter);
            jsonWriter.close();
        }
        catch (IOException e) {
            Flan.LOGGER.error((Object)e);
        }
    }

    public void read(MinecraftServer server) {
        Flan.log("Reading player data for player {} with uuid {}", this.player.method_5477(), this.player.method_5667());
        try {
            Path file = ConfigHandler.getPlayerSavePath(server).resolve(String.valueOf(this.player.method_5667()) + ".json");
            if (!Files.exists(file, new LinkOption[0])) {
                Flan.log("No player data found for player {} with uuid {}", this.player.method_5477(), this.player.method_5667());
                return;
            }
            JsonReader reader = ConfigHandler.GSON.newJsonReader((Reader)Files.newBufferedReader(file, StandardCharsets.UTF_8));
            JsonObject obj = (JsonObject)ConfigHandler.GSON.fromJson(reader, JsonObject.class);
            reader.close();
            Flan.debug("Read following json data {} from file {}", obj, file.getFileName());
            JsonElement claimBlockEl = obj.get("ClaimBlocks");
            if (claimBlockEl.isJsonPrimitive()) {
                this.claimBlocks = claimBlockEl.getAsInt();
            }
            this.additionalClaimBlocks = obj.get("AdditionalBlocks").getAsInt();
            JsonObject defP = ConfigHandler.fromJson(obj, "DefaultGroups");
            defP.entrySet().forEach(e -> {
                if (((JsonElement)e.getValue()).isJsonObject()) {
                    ((JsonElement)e.getValue()).getAsJsonObject().entrySet().forEach(p -> this.editDefaultPerms((String)e.getKey(), BuiltinPermission.tryLegacy((String)p.getKey()), ((JsonElement)p.getValue()).getAsBoolean() ? 1 : 0));
                }
            });
            this.fakePlayerNotification = ConfigHandler.fromJson(obj, "FakePlayerNotification", true);
            PlayerClaimData.updateScoreFor(this.player, ClaimCriterias.AMOUNT, this.claimBlocks + this.additionalClaimBlocks);
            this.updateClaimScores();
        }
        catch (IOException e2) {
            Flan.LOGGER.error((Object)e2);
        }
    }

    public static void updateScoreFor(class_3222 player, class_274 criterion, int val) {
        player.method_7327().method_1162(criterion, (class_9015)player, scoreboardPlayerScore -> scoreboardPlayerScore.method_55410(val));
    }

    public static void editForOfflinePlayer(MinecraftServer server, UUID uuid, int additionalClaimBlocks, boolean base) {
        Flan.log("Adding {} addional claimblocks for offline player with uuid {}", additionalClaimBlocks, uuid);
        Path dir = ConfigHandler.getPlayerSavePath(server);
        try {
            Path file = dir.resolve(uuid.toString() + ".json");
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
                Files.createFile(file, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            JsonReader reader = ConfigHandler.GSON.newJsonReader((Reader)Files.newBufferedReader(file, StandardCharsets.UTF_8));
            JsonObject obj = (JsonObject)ConfigHandler.GSON.fromJson(reader, JsonObject.class);
            reader.close();
            if (obj == null) {
                obj = new JsonObject();
            }
            if (base) {
                int blocks = ConfigHandler.fromJson(obj, "ClaimBlocks", 0);
                obj.addProperty("ClaimBlocks", (Number)(blocks + additionalClaimBlocks));
            } else {
                int additionalBlocks = ConfigHandler.fromJson(obj, "AdditionalBlocks", 0);
                obj.addProperty("AdditionalBlocks", (Number)(additionalBlocks + additionalClaimBlocks));
            }
            Flan.debug("Attempting to write following json data {} to file {}", obj, file.getFileName());
            JsonWriter jsonWriter = ConfigHandler.GSON.newJsonWriter((Writer)Files.newBufferedWriter(file, StandardCharsets.UTF_8, new OpenOption[0]));
            ConfigHandler.GSON.toJson((JsonElement)obj, jsonWriter);
            jsonWriter.close();
        }
        catch (IOException e) {
            Flan.LOGGER.error((Object)e);
        }
    }

    public static boolean readGriefPreventionPlayerData(MinecraftServer server, class_2168 src) {
        Flan.log("Reading grief prevention data", new Object[0]);
        File griefPrevention = server.method_27050(class_5218.field_24188).resolve("plugins/GriefPreventionData/PlayerData").toFile();
        if (!griefPrevention.exists()) {
            src.method_9226(() -> ClaimUtils.translatedText("flan.cantFindData", griefPrevention.getAbsolutePath(), class_124.field_1079), false);
            return false;
        }
        for (File f : griefPrevention.listFiles()) {
            try {
                if (f.getName().contains(".") || f.getName().startsWith("$")) continue;
                BufferedReader reader = new BufferedReader(new FileReader(f));
                class_3222 player = server.method_3760().method_14602(UUID.fromString(f.getName()));
                if (player != null) {
                    PlayerClaimData data = PlayerClaimData.get(player);
                    reader.readLine();
                    data.claimBlocks = Integer.parseInt(reader.readLine());
                    data.additionalClaimBlocks = Integer.parseInt(reader.readLine());
                } else {
                    File file;
                    File dir = new File(server.method_27050(class_5218.field_24182).toFile(), "/claimData/");
                    if (!dir.exists()) {
                        dir.mkdir();
                    }
                    if (!(file = new File(dir, f.getName() + ".json")).exists()) {
                        file.createNewFile();
                    }
                    reader.readLine();
                    FileWriter writer = new FileWriter(file);
                    JsonObject obj = new JsonObject();
                    obj.addProperty("ClaimBlocks", reader.readLine());
                    obj.addProperty("AdditionalBlocks", reader.readLine());
                    ConfigHandler.GSON.toJson((JsonElement)obj, (Appendable)writer);
                    writer.close();
                }
                reader.close();
            }
            catch (Exception e) {
                src.method_9226(() -> ClaimUtils.translatedText("flan.errorFile", f.getName(), class_124.field_1061), false);
            }
        }
        return true;
    }
}

