/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.api.permission;

import io.github.flemmli97.flan.api.permission.ClaimPermission;
import io.github.flemmli97.flan.platform.CrossPlatformStuff;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class BuiltinPermission {
    public static final Map<ResourceLocation, Function<HolderLookup.Provider, ClaimPermission.Builder>> DATAGEN_DATA = new LinkedHashMap<ResourceLocation, Function<HolderLookup.Provider, ClaimPermission.Builder>>();
    private static final HashMap<String, ResourceLocation> LEGACY_MIGRATION = new HashMap();
    public static int order = 0;
    public static final ResourceLocation EDITCLAIM = BuiltinPermission.register("edit_claim", new ItemStack((ItemLike)Items.GOLDEN_HOE), "Gives permission to edit (resize, delete...) the claim");
    public static final ResourceLocation EDITPERMS = BuiltinPermission.register("edit_perms", new ItemStack((ItemLike)Items.COMMAND_BLOCK), "Gives permission to change the claims permissions");
    public static final ResourceLocation EDITPOTIONS = BuiltinPermission.register("edit_potions", new ItemStack((ItemLike)Items.POTION), "Gives permission to edit the claims potion effect");
    public static final ResourceLocation BREAK = BuiltinPermission.register("break", new ItemStack((ItemLike)Items.DIAMOND_PICKAXE), "Permission to break blocks in the claim");
    public static final ResourceLocation PLACE = BuiltinPermission.register("place", new ItemStack((ItemLike)Items.GRASS_BLOCK), "Permission to place blocks in the claim");
    public static final ResourceLocation OPENCONTAINER = BuiltinPermission.register("open_container", new ItemStack((ItemLike)Items.CHEST), "Permission to open containers", "(chest, furnace etc.)");
    public static final ResourceLocation INTERACTBLOCK = BuiltinPermission.register("interact_block", new ItemStack((ItemLike)Items.GOLD_NUGGET), "Generic permission for block interaction.", "Fallback to OPENCONTAINER", "Gets used for all blocks OPENCONTAINER doesn't check for");
    public static final ResourceLocation INTERACTSIGN = BuiltinPermission.register("interact_sign", new ItemStack((ItemLike)Items.BIRCH_SIGN), "Permission to edit signs (e.g. dyeing them)");
    public static final ResourceLocation ANVIL = BuiltinPermission.register("anvil", new ItemStack((ItemLike)Items.ANVIL), "Permission to use anvils");
    public static final ResourceLocation BED = BuiltinPermission.register("bed", new ItemStack((ItemLike)Items.RED_BED), "Permission to use beds");
    public static final ResourceLocation BEACON = BuiltinPermission.register("beacon", new ItemStack((ItemLike)Items.BEACON), "Permission to use beacons");
    public static final ResourceLocation DOOR = BuiltinPermission.register("door", new ItemStack((ItemLike)Items.OAK_DOOR), "Permission to use doors");
    public static final ResourceLocation FENCEGATE = BuiltinPermission.register("fence_gate", new ItemStack((ItemLike)Items.OAK_FENCE_GATE), "Permission to use fence gates");
    public static final ResourceLocation TRAPDOOR = BuiltinPermission.register("trapdoor", new ItemStack((ItemLike)Items.OAK_TRAPDOOR), "Permission to use trapdoors");
    public static final ResourceLocation BUTTONLEVER = BuiltinPermission.register("button_lever", new ItemStack((ItemLike)Items.LEVER), "Permission to trigger levers and buttons");
    public static final ResourceLocation PRESSUREPLATE = BuiltinPermission.register("pressure_plate", new ItemStack((ItemLike)Items.STONE_PRESSURE_PLATE), "Permission to trigger pressure plates");
    public static final ResourceLocation NOTEBLOCK = BuiltinPermission.register("noteblock", new ItemStack((ItemLike)Items.NOTE_BLOCK), "Permission to change noteblocks");
    public static final ResourceLocation REDSTONE = BuiltinPermission.register("redstone", new ItemStack((ItemLike)Items.REDSTONE), "Permission to change redstone components");
    public static final ResourceLocation JUKEBOX = BuiltinPermission.register("jukebox", new ItemStack((ItemLike)Items.JUKEBOX), "Permission to insert/take music discs");
    public static final ResourceLocation ENDERCHEST = BuiltinPermission.register("enderchest", new ItemStack((ItemLike)Items.ENDER_CHEST), true, "Permission to use enderchests");
    public static final ResourceLocation ENCHANTMENTTABLE = BuiltinPermission.register("enchantment", new ItemStack((ItemLike)Items.ENCHANTING_TABLE), true, "Permission to use enchanting tables");
    public static final ResourceLocation ITEMFRAMEROTATE = BuiltinPermission.register("itemframe_rotate", new ItemStack((ItemLike)Items.ITEM_FRAME), "Permission to rotate items in item frames");
    public static final ResourceLocation LECTERNTAKE = BuiltinPermission.register("lectern_take", new ItemStack((ItemLike)Items.LECTERN), "Permission to change books in a lectern");
    public static final ResourceLocation ENDCRYSTALPLACE = BuiltinPermission.register("endcrystal_place", new ItemStack((ItemLike)Items.END_CRYSTAL), "Permission to place end crystals");
    public static final ResourceLocation TARGETBLOCK = BuiltinPermission.register("target_block", new ItemStack((ItemLike)Items.TARGET), "Permission to trigger target blocks");
    public static final ResourceLocation PROJECTILES = BuiltinPermission.register("projectiles", new ItemStack((ItemLike)Items.ARROW), "Permission to let shot projectiles", "interact with blocks (e.g. arrow on button)");
    public static final ResourceLocation TRAMPLE = BuiltinPermission.register("trample", new ItemStack((ItemLike)Items.FARMLAND), "Permission to enable block trampling", "(farmland, turtle eggs)");
    public static final ResourceLocation PORTAL = BuiltinPermission.register("portal", new ItemStack((ItemLike)Items.OBSIDIAN), true, "Permission to use nether portals");
    public static final ResourceLocation RAID = BuiltinPermission.register("raid", (HolderLookup.Provider holder) -> Raid.getLeaderBannerInstance((HolderGetter)holder.lookupOrThrow(Registries.BANNER_PATTERN)), false, false, "Permission to trigger raids in claim.", "Wont prevent raids (just) outside");
    public static final ResourceLocation BOAT = BuiltinPermission.register("boat", new ItemStack((ItemLike)Items.OAK_BOAT), "Permission to use boats");
    public static final ResourceLocation MINECART = BuiltinPermission.register("minecart", new ItemStack((ItemLike)Items.MINECART), "Permission to sit in minecarts");
    public static final ResourceLocation BUCKET = BuiltinPermission.register("bucket", new ItemStack((ItemLike)Items.BUCKET), "Permission to take liquids with buckets");
    public static final ResourceLocation ENDERPEARL = BuiltinPermission.register("ender_pearl", new ItemStack((ItemLike)Items.ENDER_PEARL), "Permission to use enderpearls");
    public static final ResourceLocation CHORUSFRUIT = BuiltinPermission.register("chorus_fruit", new ItemStack((ItemLike)Items.CHORUS_FRUIT), "Permission to eat chorus fruits");
    public static final ResourceLocation ANIMALINTERACT = BuiltinPermission.register("animal_interact", new ItemStack((ItemLike)Items.CHICKEN_SPAWN_EGG), "Permission to interact with animals", "(e.g. shearing sheeps)");
    public static final ResourceLocation HURTANIMAL = BuiltinPermission.register("hurt_animal", new ItemStack((ItemLike)Items.BEEF), "Permission to hurt animals");
    public static final ResourceLocation HURTNAMED = BuiltinPermission.register("hurt_named", new ItemStack((ItemLike)Items.NAME_TAG), false, "Permission to hurt named mobs");
    public static final ResourceLocation XP = BuiltinPermission.register("xp", new ItemStack((ItemLike)Items.EXPERIENCE_BOTTLE), "Permission to pick up xp orbs");
    public static final ResourceLocation TRADING = BuiltinPermission.register("trading", new ItemStack((ItemLike)Items.EMERALD), "Permission to trade with villagers");
    public static final ResourceLocation ARMORSTAND = BuiltinPermission.register("armorstand", new ItemStack((ItemLike)Items.ARMOR_STAND), "Permission to interact with armor stands");
    public static final ResourceLocation BREAKNONLIVING = BuiltinPermission.register("break_non_living", new ItemStack((ItemLike)Items.COMMAND_BLOCK_MINECART), "Permission to break things like minecarts or armor stands");
    public static final ResourceLocation DROP = BuiltinPermission.register("drop", new ItemStack((ItemLike)Items.BOWL), true, "Allow the drop of items");
    public static final ResourceLocation PICKUP = BuiltinPermission.register("pickup", new ItemStack((ItemLike)Items.BRICK), true, "Allow the pickup of items");
    public static final ResourceLocation ALLOW_FLIGHT = BuiltinPermission.register("flight", new ItemStack((ItemLike)Items.IRON_BLOCK), true, "Allows all non creative flight", "Does not grant flight!");
    public static final ResourceLocation MAY_FLIGHT = BuiltinPermission.register("may_flight", new ItemStack((ItemLike)Items.FEATHER), false, "Allows player to fly in this claim.", "Flight permission needs to be true!");
    public static final ResourceLocation CANSTAY = BuiltinPermission.register("can_stay", new ItemStack((ItemLike)Items.PAPER), true, "Allow players to enter your claim");
    public static final ResourceLocation TELEPORT = BuiltinPermission.register("teleport", new ItemStack((ItemLike)Items.END_PORTAL_FRAME), false, "Allow player to teleport to your claim home position");
    public static final ResourceLocation NOHUNGER = BuiltinPermission.register("no_hunger", new ItemStack((ItemLike)Items.COOKED_BEEF), false, "Disable hunger");
    public static final ResourceLocation CLAIMMESSAGE = BuiltinPermission.register("claim_message", new ItemStack((ItemLike)Items.OAK_SIGN), false, "Permission to edit the enter/leave message");
    public static final ResourceLocation ARCHAEOLOGY = BuiltinPermission.register("archeology", new ItemStack((ItemLike)Items.BRUSH), false, false, "Allow players to brush blocks in this claim");
    public static final ResourceLocation WIND_CHARGE = BuiltinPermission.register("wind_charge", new ItemStack((ItemLike)Items.WIND_CHARGE), "Permission to use wind charges");
    public static final ResourceLocation HURTPLAYER = BuiltinPermission.register("hurt_player", new ItemStack((ItemLike)Items.DIAMOND_SWORD), false, true, "Permission to hurt other players");
    public static final ResourceLocation EXPLOSIONS = BuiltinPermission.register("explosions", new ItemStack((ItemLike)Items.TNT), false, true, "Toggle explosions in claim");
    public static final ResourceLocation WITHER = BuiltinPermission.register("wither", new ItemStack((ItemLike)Items.WITHER_SKELETON_SKULL), false, true, "Toggle wither breaking blocks in claim");
    public static final ResourceLocation ENDERMAN = BuiltinPermission.register("enderman", new ItemStack((ItemLike)Items.ENDER_EYE), true, true, "Allow enderman picking and placing blocks");
    public static final ResourceLocation SNOWGOLEM = BuiltinPermission.register("snow_golem", new ItemStack((ItemLike)Items.SNOW_BLOCK), true, true, "Allow snowgolems snowlayer");
    public static final ResourceLocation FIRESPREAD = BuiltinPermission.register("fire_spread", new ItemStack((ItemLike)Items.BLAZE_POWDER), false, true, "Toggle firespread in claim");
    public static final ResourceLocation WATERBORDER = BuiltinPermission.register("water_border", new ItemStack((ItemLike)Items.WATER_BUCKET), false, true, "Toggle water crossing claim borders");
    public static final ResourceLocation PISTONBORDER = BuiltinPermission.register("piston_border", new ItemStack((ItemLike)Items.PISTON), false, true, "Toggle piston pull/push across claim borders");
    public static final ResourceLocation MOBSPAWN = BuiltinPermission.register("mob_spawn", new ItemStack((ItemLike)Items.ZOMBIE_SPAWN_EGG), false, true, "Prevent hostile mobspawn in claim");
    public static final ResourceLocation ANIMALSPAWN = BuiltinPermission.register("animal_spawn", new ItemStack((ItemLike)Items.PIG_SPAWN_EGG), false, true, "Prevent other spawn in claim");
    public static final ResourceLocation LIGHTNING = BuiltinPermission.register("lightning", new ItemStack((ItemLike)Items.TRIDENT), false, true, "Allow lightning to affect claims", "e.g. set blocks on fire", "or affect animals (mobs are excluded)");
    public static final ResourceLocation LOCKITEMS = BuiltinPermission.register("lock_items", new ItemStack((ItemLike)Items.FIREWORK_STAR), true, true, "If items should be locked on death");
    public static final ResourceLocation FAKEPLAYER = BuiltinPermission.register("fake_player", new ItemStack((ItemLike)Items.CARROT_ON_A_STICK), false, true, "Allow fakeplayers to interact in this claim", "Some mods fakeplayer has the users uuid", "For those mods this permission is not needed");
    public static final ResourceLocation PLAYERMOBSPAWN = BuiltinPermission.register("player_mob_spawn", new ItemStack((ItemLike)Items.WARDEN_SPAWN_EGG), false, true, "Permission for affected players to spawn mobs with interactions", "E.g. wardens, or endermites with enderpearls");
    public static final ResourceLocation SCULK = BuiltinPermission.register("sculk", new ItemStack((ItemLike)Items.SCULK_SENSOR), false, true, "Permission for sculk sensors.", "Shriekers are handled under PLAYERMOBSPAWN");

    private static ResourceLocation register(String id, ItemStack item, String ... description) {
        return BuiltinPermission.register(id, item, false, description);
    }

    private static ResourceLocation register(String id, ItemStack item, boolean defaultVal, String ... description) {
        return BuiltinPermission.register(id, item, defaultVal, false, description);
    }

    private static ResourceLocation register(String key, ItemStack item, boolean defaultVal, boolean global, String ... description) {
        return BuiltinPermission.register(key, (HolderLookup.Provider h) -> item, defaultVal, global, description);
    }

    private static ResourceLocation register(String key, Function<HolderLookup.Provider, ItemStack> item, boolean defaultVal, boolean global, String ... description) {
        ResourceLocation id = ResourceLocation.fromNamespaceAndPath((String)"flan", (String)key);
        if (CrossPlatformStuff.INSTANCE.isDataGen()) {
            DATAGEN_DATA.put(id, holder -> new ClaimPermission.Builder((ItemStack)item.apply((HolderLookup.Provider)holder), defaultVal, global, order++, List.of(description)));
        }
        LEGACY_MIGRATION.put(key.replace("_", "").toUpperCase(Locale.ROOT), id);
        return id;
    }

    public static void registerMapping(String key, ResourceLocation newId) {
        if (LEGACY_MIGRATION.containsKey(key)) {
            throw new IllegalArgumentException("A mapping with key " + key + " is already registered!");
        }
        LEGACY_MIGRATION.put(key, newId);
    }

    public static ResourceLocation tryLegacy(String key) {
        return LEGACY_MIGRATION.getOrDefault(key, ResourceLocation.parse((String)key.toLowerCase(Locale.ROOT)));
    }
}

