/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.api.permission;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.flan.platform.CrossPlatformStuff;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ClaimPermission
implements Comparable<ClaimPermission> {
    private final ItemStack guiItem;
    private final ResourceLocation id;
    public final boolean defaultVal;
    public final boolean global;
    public final int order;

    private ClaimPermission(ResourceLocation id, ItemStack guiItem, boolean defaultVal, boolean global, int order) {
        this.id = id;
        this.guiItem = guiItem;
        this.order = order;
        this.defaultVal = defaultVal;
        this.global = global;
    }

    public ItemStack getItem() {
        return this.guiItem.copy();
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String translationKey() {
        return String.format("flan.permission.%s", this.id);
    }

    public String translationKeyDescription() {
        return String.format("flan.permission.%s.desc", this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ClaimPermission) {
            return this.id.equals((Object)((ClaimPermission)obj).id);
        }
        return false;
    }

    public String toString() {
        return this.id.toString();
    }

    @Override
    public int compareTo(@NotNull ClaimPermission other) {
        if (this.order == other.order) {
            return this.id.compareTo(other.id);
        }
        return Integer.compare(this.order, other.order);
    }

    public static class Builder {
        public static final Codec<Builder> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("order").forGetter(d -> d.order), (App)Codec.STRING.optionalFieldOf("required_mod").forGetter(d -> Optional.ofNullable(d.requiredMod)), (App)ItemStackHolder.CODEC.fieldOf("gui_item").forGetter(d -> d.guiItem), (App)Codec.BOOL.fieldOf("default_value").forGetter(d -> d.defaultVal), (App)Codec.BOOL.fieldOf("global").forGetter(d -> d.global)).apply((Applicative)instance, (order, requiredMod, item, val, global) -> new Builder((ItemStackHolder)item, (boolean)val, (boolean)global, (int)order, requiredMod.orElse(null), null)));
        private final ItemStackHolder guiItem;
        public final List<String> desc;
        private final boolean defaultVal;
        private final boolean global;
        private final String requiredMod;
        private final int order;

        public Builder(ItemStack guiItem, boolean defaultVal, boolean global, int order, List<String> desc) {
            this(new ItemStackHolder(guiItem), defaultVal, global, order, desc);
        }

        public Builder(ItemStackHolder guiItem, boolean defaultVal, boolean global, int order, List<String> desc) {
            this(guiItem, defaultVal, global, order, null, desc);
        }

        public Builder(ItemStackHolder guiItem, boolean defaultVal, boolean global, int order, String requiredMod, List<String> desc) {
            this.guiItem = guiItem;
            this.desc = desc;
            this.defaultVal = defaultVal;
            this.global = global;
            this.order = order;
            this.requiredMod = requiredMod;
        }

        public boolean verify() {
            return !this.guiItem.toStack().isEmpty() && (this.requiredMod == null || CrossPlatformStuff.INSTANCE.isModLoaded(this.requiredMod));
        }

        public ClaimPermission build(ResourceLocation id) {
            return new ClaimPermission(id, this.guiItem.toStack(), this.defaultVal, this.global, this.order);
        }

        public record ItemStackHolder(ResourceLocation item, int count, DataComponentPatch components) {
            public static final Codec<ItemStackHolder> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(ItemStackHolder::item), (App)Codec.INT.optionalFieldOf("Count").forGetter(stack -> stack.count() == 1 ? Optional.empty() : Optional.of(stack.count())), (App)DataComponentPatch.CODEC.optionalFieldOf("components", (Object)DataComponentPatch.EMPTY).forGetter(stack -> stack.components)).apply((Applicative)instance, (item, count, tag) -> new ItemStackHolder((ResourceLocation)item, count.orElse(1), (DataComponentPatch)tag)));

            public ItemStackHolder(ResourceLocation item) {
                this(item, 1, DataComponentPatch.EMPTY);
            }

            public ItemStackHolder(ItemStack item) {
                this(BuiltInRegistries.ITEM.getKey((Object)item.getItem()), item.getCount(), item.getComponentsPatch());
            }

            private ItemStack toStack() {
                ItemStack stack = new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(this.item), this.count);
                stack.applyComponents(this.components);
                return stack;
            }
        }
    }
}

