/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.claim;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.ProfileResult;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import java.util.ArrayList;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class ClaimUtils {
    public static boolean check(ServerPlayer player, BlockPos pos, Claim claim, ResourceLocation perm, Consumer<Optional<Boolean>> cons) {
        if (claim == null) {
            cons.accept(Optional.empty());
            return false;
        }
        boolean hasPerm = claim.canInteract(player, perm, pos);
        cons.accept(Optional.of(hasPerm));
        return hasPerm;
    }

    public static Claim checkReturn(ServerPlayer player, ResourceLocation perm, Consumer<Optional<Boolean>> cons) {
        Claim claim;
        BlockPos pos = player.blockPosition();
        return ClaimUtils.check(player, pos, claim = ClaimStorage.get(player.serverLevel()).getClaimAt(pos), perm, cons) ? claim : null;
    }

    public static void noClaimMessage(ServerPlayer player) {
        player.displayClientMessage((Component)ClaimUtils.translatedText("flan.noClaim", ChatFormatting.DARK_RED), false);
    }

    public static Consumer<Optional<Boolean>> genericNoPermMessage(ServerPlayer player) {
        return b -> {
            if (b.isEmpty()) {
                ClaimUtils.noClaimMessage(player);
            } else if (!((Boolean)b.get()).booleanValue()) {
                player.displayClientMessage((Component)ClaimUtils.translatedText("flan.noPermission", ChatFormatting.DARK_RED), false);
            }
        };
    }

    public static MutableComponent translatedText(String key, Object ... compArgs) {
        ArrayList<ChatFormatting> formattings = new ArrayList<ChatFormatting>();
        ArrayList<Object> args = new ArrayList<Object>();
        for (Object obj : compArgs) {
            if (obj instanceof ChatFormatting) {
                ChatFormatting formatting = (ChatFormatting)obj;
                formattings.add(formatting);
                continue;
            }
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                args.add(b != false ? Component.translatable((String)"flan.generic.true") : Component.translatable((String)"flan.generic.false"));
                continue;
            }
            if (obj instanceof Component || TranslatableContents.isAllowedPrimitiveArgument((Object)obj)) {
                args.add(obj);
                continue;
            }
            args.add(obj.toString());
        }
        return Component.translatable((String)key, (Object[])args.toArray()).setStyle(Style.EMPTY.applyFormats((ChatFormatting[])formattings.toArray(ChatFormatting[]::new)));
    }

    public static Optional<String> fetchUsername(UUID uuid, MinecraftServer server) {
        return ClaimUtils.fetchUsername(uuid, server, false);
    }

    public static Optional<String> fetchUsername(UUID uuid, MinecraftServer server, boolean fetch) {
        String ownerName = server.getProfileCache().get(uuid).map(GameProfile::getName).orElse(null);
        if (ownerName == null && fetch) {
            ProfileResult res = server.getSessionService().fetchProfile(uuid, true);
            ownerName = res != null ? res.profile().getName() : null;
        }
        return Optional.ofNullable(ownerName);
    }
}

