/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.commands;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import io.github.flemmli97.flan.api.data.IPlayerData;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.PermissionManager;
import io.github.flemmli97.flan.claim.AllowedRegistryList;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimBox;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.commands.CommandHelp;
import io.github.flemmli97.flan.commands.CommandHelpers;
import io.github.flemmli97.flan.commands.PendingCommand;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.event.ItemInteractEvents;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.gui.CustomInteractListScreenHandler;
import io.github.flemmli97.flan.gui.PersonalGroupScreenHandler;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.ClaimMode;
import io.github.flemmli97.flan.player.OfflinePlayerData;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.player.display.EnumDisplayType;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.commands.arguments.GameProfileArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.commands.arguments.UuidArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class CommandClaim {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext buildContext, boolean dedicated) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"flan").then(((LiteralArgumentBuilder)Commands.literal((String)"reload").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.reload", true))).executes(CommandClaim::reloadConfig))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"add").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.claim.create"))).then(Commands.argument((String)"from", (ArgumentType)BlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)Commands.argument((String)"to", (ArgumentType)BlockPosArgument.blockPos()).executes(CommandClaim::addClaim)).then(((RequiredArgumentBuilder)Commands.argument((String)"dimension", (ArgumentType)ResourceLocationArgument.id()).requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.claim.admin.create", true))).suggests((src, build) -> SharedSuggestionProvider.suggest(((CommandSourceStack)src.getSource()).getServer().levelKeys().stream().map(k -> k.location().toString()).toList(), (SuggestionsBuilder)build)).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((src, build) -> SharedSuggestionProvider.suggest(Stream.concat(Stream.of("+Admin"), ((CommandSourceStack)src.getSource()).getServer().getPlayerList().getPlayers().stream().map(p -> p.getUUID().toString())).toList(), (SuggestionsBuilder)build)).executes(CommandClaim::addClaimAs)))))).then(Commands.literal((String)"all").executes(CommandClaim::addClaimAll))).then(Commands.literal((String)"rect").then(Commands.argument((String)"x", (ArgumentType)IntegerArgumentType.integer()).then(Commands.argument((String)"z", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> CommandClaim.addClaimRect((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"x"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"z")))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"expand").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.claim.create"))).then(Commands.argument((String)"distance", (ArgumentType)IntegerArgumentType.integer()).executes(CommandClaim::expandClaim)))).then(((LiteralArgumentBuilder)Commands.literal((String)"menu").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.menu"))).executes(CommandClaim::openMenu))).then(((LiteralArgumentBuilder)Commands.literal((String)"setHome").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.home"))).executes(CommandClaim::setClaimHome))).then(((LiteralArgumentBuilder)Commands.literal((String)"trapped").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.trapped"))).executes(CommandClaim::trapped))).then(((LiteralArgumentBuilder)Commands.literal((String)"name").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.name"))).then(Commands.argument((String)"name", (ArgumentType)StringArgumentType.string()).executes(CommandClaim::nameClaim)))).then(((LiteralArgumentBuilder)Commands.literal((String)"unlockDrops").executes(CommandClaim::unlockDrops)).then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)GameProfileArgument.gameProfile()).requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.unlock.all", true))).executes(CommandClaim::unlockDropsPlayers)))).then(((LiteralArgumentBuilder)Commands.literal((String)"personalGroups").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.personal"))).executes(CommandClaim::openPersonalGroups))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"info").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.info"))).executes(ctx -> CommandClaim.claimInfo((CommandContext<CommandSourceStack>)ctx, Claim.InfoType.ALL))).then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests((src, b) -> CommandHelpers.enumSuggestion(Claim.InfoType.class, b)).executes(CommandClaim::claimInfo)))).then(((LiteralArgumentBuilder)Commands.literal((String)"transferClaim").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.transfer"))).then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).executes(CommandClaim::transferClaim)))).then(((LiteralArgumentBuilder)Commands.literal((String)"delete").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.delete"))).executes(CommandClaim::deleteClaim))).then(((LiteralArgumentBuilder)Commands.literal((String)"deleteAll").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.delete.all"))).executes(CommandClaim::deleteAllClaim))).then(((LiteralArgumentBuilder)Commands.literal((String)"deleteSubClaim").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.delete.sub"))).executes(CommandClaim::deleteSubClaim))).then(((LiteralArgumentBuilder)Commands.literal((String)"deleteAllSubClaims").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.delete.sub.all"))).executes(CommandClaim::deleteAllSubClaim))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"list").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.list"))).executes(CommandClaim::listClaims)).then(((RequiredArgumentBuilder)Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.list.all", true))).executes(cmd -> CommandClaim.listClaims((CommandContext<CommandSourceStack>)cmd, GameProfileArgument.getGameProfiles((CommandContext)cmd, (String)"player")))))).then(((LiteralArgumentBuilder)Commands.literal((String)"switchMode").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.claim.mode"))).then(Commands.argument((String)"mode", (ArgumentType)StringArgumentType.word()).suggests((src, b) -> CommandHelpers.enumSuggestion(ClaimMode.class, b)).executes(CommandClaim::switchEditMode)))).then(((LiteralArgumentBuilder)Commands.literal((String)"bypass").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.bypass.claim", true))).executes(CommandClaim::switchAdminMode))).then(((LiteralArgumentBuilder)Commands.literal((String)"readGriefPrevention").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.read.griefprevention", true))).executes(CommandClaim::readGriefPreventionData))).then(((LiteralArgumentBuilder)Commands.literal((String)"setAdminClaim").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.admin.claim", true))).then(Commands.argument((String)"toggle", (ArgumentType)BoolArgumentType.bool()).executes(CommandClaim::toggleAdminClaim)))).then(((LiteralArgumentBuilder)Commands.literal((String)"listAdminClaims").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.admin.list", true))).executes(CommandClaim::listAdminClaims))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"adminDelete").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.admin.delete", true))).executes(CommandClaim::adminDelete)).then(Commands.literal((String)"all").then(Commands.argument((String)"players", (ArgumentType)GameProfileArgument.gameProfile()).executes(CommandClaim::adminDeleteAll))))).then(((LiteralArgumentBuilder)Commands.literal((String)"giveClaimBlocks").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.admin.give", true))).then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)GameProfileArgument.gameProfile()).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(CommandClaim::giveClaimBlocks))).then(Commands.literal((String)"base").then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> CommandClaim.giveClaimBlocks((CommandContext<CommandSourceStack>)ctx, true))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"buy").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.buy", false))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(CommandClaim::buyClaimBlocks)))).then(((LiteralArgumentBuilder)Commands.literal((String)"sell").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.sell", false))).then(Commands.argument((String)"amount", (ArgumentType)IntegerArgumentType.integer()).executes(CommandClaim::sellClaimBlocks)))).then(Commands.literal((String)"claimMessage").then(Commands.argument((String)"type", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> SharedSuggestionProvider.suggest((String[])new String[]{"enter", "leave"}, (SuggestionsBuilder)b)).then(((RequiredArgumentBuilder)Commands.argument((String)"title", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> SharedSuggestionProvider.suggest((String[])new String[]{"title", "subtitle"}, (SuggestionsBuilder)b)).then(Commands.literal((String)"text").then(Commands.argument((String)"component", (ArgumentType)ComponentArgument.textComponent((CommandBuildContext)buildContext)).executes(ctx -> CommandClaim.editClaimMessages((CommandContext<CommandSourceStack>)ctx, ComponentArgument.getComponent((CommandContext)ctx, (String)"component")))))).then(Commands.literal((String)"string").then(Commands.argument((String)"message", (ArgumentType)StringArgumentType.string()).executes(CommandClaim::editClaimMessages))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"group").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.group"))).then(Commands.literal((String)"add").then(Commands.argument((String)"group", (ArgumentType)StringArgumentType.string()).executes(CommandClaim::addGroup)))).then(Commands.literal((String)"remove").then(Commands.argument((String)"group", (ArgumentType)StringArgumentType.string()).suggests(CommandHelpers::groupSuggestion).executes(CommandClaim::removeGroup)))).then(((LiteralArgumentBuilder)Commands.literal((String)"players").then(Commands.literal((String)"add").then(Commands.argument((String)"group", (ArgumentType)StringArgumentType.word()).suggests(CommandHelpers::groupSuggestion).then(((RequiredArgumentBuilder)Commands.argument((String)"players", (ArgumentType)GameProfileArgument.gameProfile()).executes(CommandClaim::addPlayer)).then(Commands.literal((String)"overwrite").executes(CommandClaim::forceAddPlayer)))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"group", (ArgumentType)StringArgumentType.word()).suggests(CommandHelpers::groupSuggestion).then(Commands.argument((String)"players", (ArgumentType)GameProfileArgument.gameProfile()).suggests((context, build) -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
            String group = StringArgumentType.getString((CommandContext)context, (String)"group");
            List<Object> list = new ArrayList();
            CommandSourceStack src = (CommandSourceStack)context.getSource();
            ClaimStorage storage = ClaimStorage.get(src.getLevel());
            Claim claim = storage.getClaimAt(src.getPlayerOrException().blockPosition());
            if (claim != null && claim.canInteract(src.getPlayerOrException(), BuiltinPermission.EDITPERMS, src.getPlayerOrException().blockPosition())) {
                list = claim.playersFromGroup(player.getServer(), group).stream().map(GameProfile::getName).toList();
            }
            return SharedSuggestionProvider.suggest(list, (SuggestionsBuilder)build);
        }).executes(CommandClaim::removePlayer))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"fakePlayer").executes(CommandClaim::toggleFakePlayer)).then(((LiteralArgumentBuilder)Commands.literal((String)"add").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.fakeplayer"))).then(Commands.argument((String)"uuid", (ArgumentType)UuidArgument.uuid()).executes(CommandClaim::addFakePlayer)))).then(((LiteralArgumentBuilder)Commands.literal((String)"remove").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.fakeplayer"))).then(Commands.argument((String)"uuid", (ArgumentType)UuidArgument.uuid()).suggests((context, build) -> {
            List<Object> list = new ArrayList();
            CommandSourceStack src = (CommandSourceStack)context.getSource();
            ClaimStorage storage = ClaimStorage.get(src.getLevel());
            Claim claim = storage.getClaimAt(src.getPlayerOrException().blockPosition());
            if (claim != null && claim.canInteract(src.getPlayerOrException(), BuiltinPermission.EDITPERMS, src.getPlayerOrException().blockPosition())) {
                list = claim.getAllowedFakePlayerUUID();
            }
            return SharedSuggestionProvider.suggest(list, (SuggestionsBuilder)build);
        }).executes(CommandClaim::removeFakePlayer))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"teleport").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.teleport"))).then(Commands.literal((String)"self").then(Commands.argument((String)"claim", (ArgumentType)StringArgumentType.string()).suggests((ctx, b) -> CommandHelpers.claimSuggestions((CommandContext<CommandSourceStack>)ctx, b, ((CommandSourceStack)ctx.getSource()).getPlayerOrException().getUUID())).executes(CommandClaim::teleport)))).then(Commands.literal((String)"global").then(Commands.argument((String)"claim", (ArgumentType)StringArgumentType.string()).suggests((ctx, b) -> CommandHelpers.claimSuggestions((CommandContext<CommandSourceStack>)ctx, b, null)).executes(CommandClaim::teleportAdminClaims)))).then(Commands.literal((String)"other").then(Commands.argument((String)"player", (ArgumentType)GameProfileArgument.gameProfile()).then(Commands.argument((String)"claim", (ArgumentType)StringArgumentType.string()).suggests((ctx, b) -> CommandHelpers.claimSuggestions((CommandContext<CommandSourceStack>)ctx, b, CommandHelpers.singleProfile((CommandContext<CommandSourceStack>)ctx, "player").getId())).executes(src -> CommandClaim.teleport((CommandContext<CommandSourceStack>)src, CommandHelpers.singleProfile((CommandContext<CommandSourceStack>)src, "player").getId()))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"permission").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.permission"))).then(Commands.literal((String)"personal").then(Commands.argument((String)"group", (ArgumentType)StringArgumentType.string()).suggests(CommandHelpers::personalGroupSuggestion).then(Commands.argument((String)"permission", (ArgumentType)ResourceLocationArgument.id()).suggests((ctx, b) -> CommandHelpers.permSuggestions((CommandContext<CommandSourceStack>)ctx, b, true)).then(Commands.argument((String)"toggle", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> SharedSuggestionProvider.suggest((String[])new String[]{"default", "true", "false"}, (SuggestionsBuilder)b)).executes(CommandClaim::editPersonalPerm)))))).then(Commands.literal((String)"global").then(Commands.argument((String)"permission", (ArgumentType)ResourceLocationArgument.id()).suggests((ctx, b) -> CommandHelpers.permSuggestions((CommandContext<CommandSourceStack>)ctx, b, false)).then(Commands.argument((String)"toggle", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> SharedSuggestionProvider.suggest((String[])new String[]{"default", "true", "false"}, (SuggestionsBuilder)b)).executes(CommandClaim::editGlobalPerm))))).then(Commands.literal((String)"group").then(Commands.argument((String)"group", (ArgumentType)StringArgumentType.string()).suggests(CommandHelpers::groupSuggestion).then(Commands.argument((String)"permission", (ArgumentType)ResourceLocationArgument.id()).suggests((ctx, b) -> CommandHelpers.permSuggestions((CommandContext<CommandSourceStack>)ctx, b, true)).then(Commands.argument((String)"toggle", (ArgumentType)StringArgumentType.word()).suggests((ctx, b) -> SharedSuggestionProvider.suggest((String[])new String[]{"default", "true", "false"}, (SuggestionsBuilder)b)).executes(CommandClaim::editGroupPerm))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"ignoreList").requires(src -> PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)src, "flan.command.claim.ignore", false))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"add").then(Commands.literal((String)CustomInteractListScreenHandler.Type.ITEM.commandKey).then(Commands.argument((String)"entry", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)Registries.ITEM)).executes(src -> CommandClaim.addClaimListEntries((CommandContext<CommandSourceStack>)src, CustomInteractListScreenHandler.Type.ITEM))))).then(Commands.literal((String)CustomInteractListScreenHandler.Type.BLOCKBREAK.commandKey).then(Commands.argument((String)"entry", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)Registries.BLOCK)).executes(src -> CommandClaim.addClaimListEntries((CommandContext<CommandSourceStack>)src, CustomInteractListScreenHandler.Type.BLOCKBREAK))))).then(Commands.literal((String)CustomInteractListScreenHandler.Type.BLOCKUSE.commandKey).then(Commands.argument((String)"entry", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)Registries.BLOCK)).executes(src -> CommandClaim.addClaimListEntries((CommandContext<CommandSourceStack>)src, CustomInteractListScreenHandler.Type.BLOCKUSE))))).then(Commands.literal((String)CustomInteractListScreenHandler.Type.ENTITYATTACK.commandKey).then(Commands.argument((String)"entry", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)Registries.ENTITY_TYPE)).executes(src -> CommandClaim.addClaimListEntries((CommandContext<CommandSourceStack>)src, CustomInteractListScreenHandler.Type.ENTITYATTACK))))).then(Commands.literal((String)CustomInteractListScreenHandler.Type.ENTITYUSE.commandKey).then(Commands.argument((String)"entry", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)Registries.ENTITY_TYPE)).executes(src -> CommandClaim.addClaimListEntries((CommandContext<CommandSourceStack>)src, CustomInteractListScreenHandler.Type.ENTITYUSE)))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"remove").then(Commands.literal((String)CustomInteractListScreenHandler.Type.ITEM.commandKey).then(Commands.argument((String)"entry", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)Registries.ITEM)).suggests((src, b) -> CommandHelpers.claimEntryListSuggestion((CommandContext<CommandSourceStack>)src, b, CustomInteractListScreenHandler.Type.ITEM)).executes(src -> CommandClaim.removeClaimListEntries((CommandContext<CommandSourceStack>)src, CustomInteractListScreenHandler.Type.ITEM))))).then(Commands.literal((String)CustomInteractListScreenHandler.Type.BLOCKBREAK.commandKey).then(Commands.argument((String)"entry", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)Registries.BLOCK)).suggests((src, b) -> CommandHelpers.claimEntryListSuggestion((CommandContext<CommandSourceStack>)src, b, CustomInteractListScreenHandler.Type.BLOCKBREAK)).executes(src -> CommandClaim.removeClaimListEntries((CommandContext<CommandSourceStack>)src, CustomInteractListScreenHandler.Type.BLOCKBREAK))))).then(Commands.literal((String)CustomInteractListScreenHandler.Type.BLOCKUSE.commandKey).then(Commands.argument((String)"entry", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)Registries.BLOCK)).suggests((src, b) -> CommandHelpers.claimEntryListSuggestion((CommandContext<CommandSourceStack>)src, b, CustomInteractListScreenHandler.Type.BLOCKUSE)).executes(src -> CommandClaim.removeClaimListEntries((CommandContext<CommandSourceStack>)src, CustomInteractListScreenHandler.Type.BLOCKUSE))))).then(Commands.literal((String)CustomInteractListScreenHandler.Type.ENTITYATTACK.commandKey).then(Commands.argument((String)"entry", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)Registries.ENTITY_TYPE)).suggests((src, b) -> CommandHelpers.claimEntryListSuggestion((CommandContext<CommandSourceStack>)src, b, CustomInteractListScreenHandler.Type.ENTITYATTACK)).executes(src -> CommandClaim.removeClaimListEntries((CommandContext<CommandSourceStack>)src, CustomInteractListScreenHandler.Type.ENTITYATTACK))))).then(Commands.literal((String)CustomInteractListScreenHandler.Type.ENTITYUSE.commandKey).then(Commands.argument((String)"entry", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)Registries.ENTITY_TYPE)).suggests((src, b) -> CommandHelpers.claimEntryListSuggestion((CommandContext<CommandSourceStack>)src, b, CustomInteractListScreenHandler.Type.ENTITYUSE)).executes(src -> CommandClaim.removeClaimListEntries((CommandContext<CommandSourceStack>)src, CustomInteractListScreenHandler.Type.ENTITYUSE))))))).then(Commands.literal((String)"confirm").then(Commands.argument((String)"confirm", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> SharedSuggestionProvider.suggest(List.of("confirm", "deny"), (SuggestionsBuilder)sb)).executes(CommandClaim::confirmCommand)));
        builder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"help").executes(ctx -> CommandHelp.helpMessage((CommandContext<CommandSourceStack>)ctx, 0, builder.getArguments()))).then(Commands.argument((String)"page", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> CommandHelp.helpMessage((CommandContext<CommandSourceStack>)ctx, builder.getArguments())))).then(Commands.literal((String)"cmd").then(Commands.argument((String)"command", (ArgumentType)StringArgumentType.word()).suggests((ctx, sb) -> SharedSuggestionProvider.suggest(CommandHelp.registeredCommands((CommandContext<CommandSourceStack>)ctx, builder.getArguments()), (SuggestionsBuilder)sb)).executes(CommandHelp::helpCmd))));
        builder.then(Commands.literal((String)"?").executes(ctx -> CommandHelp.helpCmd((CommandContext<CommandSourceStack>)ctx, "help")));
        dispatcher.register(builder);
    }

    private static int reloadConfig(CommandContext<CommandSourceStack> context) {
        ConfigHandler.reloadConfigs(((CommandSourceStack)context.getSource()).getServer());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.configReload", new Object[0]), true);
        return 1;
    }

    private static int addClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        if (!ItemInteractEvents.canClaimWorld(player.serverLevel(), player)) {
            return 0;
        }
        ClaimStorage storage = ClaimStorage.get(player.serverLevel());
        BlockPos from = BlockPosArgument.getLoadedBlockPos(context, (String)"from");
        BlockPos to = BlockPosArgument.getLoadedBlockPos(context, (String)"to");
        storage.createClaim(from, to, player);
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    private static int addClaimAs(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        as = StringArgumentType.getString(context, (String)"player");
        levelID = ResourceLocationArgument.getId(context, (String)"dimension");
        level = ((CommandSourceStack)context.getSource()).getServer().getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)levelID));
        if (level == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess((Supplier<Component>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$addClaimAs$79(net.minecraft.resources.ResourceLocation ), ()Lnet/minecraft/network/chat/Component;)((ResourceLocation)levelID), true);
            return 0;
        }
        uuid = null;
        if (!as.equals("+Admin") && (uuid = (UUID)((CommandSourceStack)context.getSource()).getServer().getProfileCache().get(as).map((Function<GameProfile, UUID>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getId(), (Lcom/mojang/authlib/GameProfile;)Ljava/util/UUID;)()).orElse(null)) == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess((Supplier<Component>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$addClaimAs$80(java.lang.String ), ()Lnet/minecraft/network/chat/Component;)((String)as), true);
            return 0;
        }
        storage = ClaimStorage.get(level);
        from = BlockPosArgument.getLoadedBlockPos(context, (String)"from");
        to = BlockPosArgument.getLoadedBlockPos(context, (String)"to");
        var10_8 = ((CommandSourceStack)context.getSource()).getEntity();
        if (!(var10_8 instanceof ServerPlayer)) ** GOTO lbl-1000
        player = (ServerPlayer)var10_8;
        if (PlayerClaimData.get((ServerPlayer)player).getClaimMode().is3d) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        claim = storage.createAdminClaim(from, to, level, v0);
        if (claim == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess((Supplier<Component>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$addClaimAs$81(), ()Lnet/minecraft/network/chat/Component;)(), true);
            return 0;
        }
        if (uuid != null) {
            storage.transferOwner(claim, uuid);
        }
        ((CommandSourceStack)context.getSource()).sendSuccess((Supplier<Component>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$addClaimAs$82(), ()Lnet/minecraft/network/chat/Component;)(), false);
        return 1;
    }

    private static int addClaimAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        PlayerClaimData data = PlayerClaimData.get(player);
        int usable = data.getClaimBlocks() + data.getAdditionalClaims() - data.usedClaimBlocks();
        int size = (int)Math.floor(Math.sqrt(usable));
        return CommandClaim.addClaimRect(context, size, size);
    }

    private static int addClaimRect(CommandContext<CommandSourceStack> context, int x, int z) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        if (!ItemInteractEvents.canClaimWorld(player.serverLevel(), player)) {
            return 0;
        }
        ClaimStorage storage = ClaimStorage.get(player.serverLevel());
        boolean evenX = x % 2 == 0;
        boolean evenZ = z % 2 == 0;
        BlockPos from = player.blockPosition().offset(evenX ? -((int)((double)(x - 1) * 0.5)) : -((int)((double)x * 0.5)), -5, evenZ ? -((int)((double)(z - 1) * 0.5)) : -((int)((double)z * 0.5)));
        BlockPos to = player.blockPosition().offset((int)((double)x * 0.5), -5, (int)((double)z * 0.5));
        storage.createClaim(from, to, player);
        return 1;
    }

    private static int transferClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Collection profs = GameProfileArgument.getGameProfiles(context, (String)"player");
        if (profs.size() != 1) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.onlyOnePlayer", ChatFormatting.RED), false);
            return 0;
        }
        GameProfile prof = (GameProfile)profs.iterator().next();
        ClaimStorage storage = ClaimStorage.get(player.serverLevel());
        Claim claim = storage.getClaimAt(player.blockPosition());
        if (claim == null) {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.noClaim", ChatFormatting.RED), false);
            return 0;
        }
        PlayerClaimData data = PlayerClaimData.get(player);
        boolean enoughBlocks = true;
        if (!data.isAdminIgnoreClaim()) {
            MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
            ServerPlayer newOwner = server.getPlayerList().getPlayer(prof.getId());
            IPlayerData newData = newOwner != null ? PlayerClaimData.get(newOwner) : new OfflinePlayerData(server, prof.getId());
            enoughBlocks = newData.canUseClaimBlocks(claim.getPlane());
        }
        if (!enoughBlocks) {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.ownerTransferNoBlocks", ChatFormatting.RED), false);
            if (PermissionNodeHandler.INSTANCE.perm((CommandSourceStack)context.getSource(), "flan.command.bypass.claim", true)) {
                player.displayClientMessage((Component)ClaimUtils.translatedText("flan.ownerTransferNoBlocksAdmin", ChatFormatting.RED), false);
            }
            return 0;
        }
        if (!storage.transferOwner(claim, player, prof.getId())) {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.ownerTransferFail", ChatFormatting.RED), false);
            return 0;
        }
        player.displayClientMessage((Component)ClaimUtils.translatedText("flan.ownerTransferSuccess", prof.getName(), ChatFormatting.GOLD), false);
        return 1;
    }

    private static int openMenu(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        PlayerClaimData data = PlayerClaimData.get(player);
        Claim claim = ClaimStorage.get(player.serverLevel()).getClaimAt(player.blockPosition());
        if (claim == null) {
            ClaimUtils.noClaimMessage(player);
            return 0;
        }
        if (!data.getClaimMode().isSubclaim) {
            ClaimMenuScreenHandler.openClaimMenu(player, claim);
            data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.blockPosition().getY());
        } else {
            Claim sub = claim.getSubClaim(player.blockPosition());
            ClaimMenuScreenHandler.openClaimMenu(player, Objects.requireNonNullElse(sub, claim));
        }
        return 1;
    }

    private static int trapped(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.setTrappedRescue()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.trappedRescue", ChatFormatting.GOLD), false);
            return 1;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.trappedFail", ChatFormatting.RED), false);
        return 0;
    }

    private static int nameClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        PlayerClaimData data = PlayerClaimData.get(player);
        if (!data.getClaimMode().isSubclaim) {
            Claim claim = ClaimUtils.checkReturn(player, BuiltinPermission.EDITPERMS, ClaimUtils.genericNoPermMessage(player));
            if (claim == null) {
                return 0;
            }
            boolean nameUsed = ClaimStorage.get(player.serverLevel()).allClaimsFromPlayer(claim.getOwner()).stream().map(Claim::getClaimName).anyMatch(name -> name.equals(StringArgumentType.getString((CommandContext)context, (String)"name")));
            if (!nameUsed) {
                String name2 = StringArgumentType.getString(context, (String)"name");
                claim.setClaimName(name2);
                player.displayClientMessage((Component)ClaimUtils.translatedText("flan.claimNameSet", name2, ChatFormatting.GOLD), false);
            } else {
                player.displayClientMessage((Component)ClaimUtils.translatedText("flan.claimNameUsed", ChatFormatting.DARK_RED), false);
            }
        } else {
            Claim claim = ClaimStorage.get(player.serverLevel()).getClaimAt(player.blockPosition());
            Claim sub = claim.getSubClaim(player.blockPosition());
            if (sub != null && (claim.canInteract(player, BuiltinPermission.EDITPERMS, player.blockPosition()) || sub.canInteract(player, BuiltinPermission.EDITPERMS, player.blockPosition()))) {
                boolean nameUsed = claim.getAllSubclaims().stream().map(Claim::getClaimName).anyMatch(name -> name.equals(StringArgumentType.getString((CommandContext)context, (String)"name")));
                if (!nameUsed) {
                    String name3 = StringArgumentType.getString(context, (String)"name");
                    sub.setClaimName(name3);
                    player.displayClientMessage((Component)ClaimUtils.translatedText("flan.claimNameSet", name3, ChatFormatting.GOLD), false);
                } else {
                    player.displayClientMessage((Component)ClaimUtils.translatedText("flan.claimNameUsedSub", ChatFormatting.DARK_RED), false);
                }
            } else if (claim.canInteract(player, BuiltinPermission.EDITPERMS, player.blockPosition())) {
                boolean nameUsed = ClaimStorage.get(player.serverLevel()).allClaimsFromPlayer(claim.getOwner()).stream().map(Claim::getClaimName).anyMatch(name -> name.equals(StringArgumentType.getString((CommandContext)context, (String)"name")));
                if (!nameUsed) {
                    String name4 = StringArgumentType.getString(context, (String)"name");
                    claim.setClaimName(name4);
                    player.displayClientMessage((Component)ClaimUtils.translatedText("flan.claimNameSet", name4, ChatFormatting.GOLD), false);
                } else {
                    player.displayClientMessage((Component)ClaimUtils.translatedText("flan.claimNameUsed", ChatFormatting.DARK_RED), false);
                }
            } else {
                player.displayClientMessage((Component)ClaimUtils.translatedText("flan.noPermission", ChatFormatting.DARK_RED), false);
            }
        }
        return 1;
    }

    private static int unlockDrops(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        PlayerClaimData data = PlayerClaimData.get(player);
        data.unlockDeathItems();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.unlockDrops", ConfigHandler.CONFIG.dropTicks, ChatFormatting.GOLD), false);
        return 1;
    }

    private static int unlockDropsPlayers(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection profs = GameProfileArgument.getGameProfiles(context, (String)"players");
        ArrayList<String> success = new ArrayList<String>();
        for (GameProfile prof : profs) {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).getServer().getPlayerList().getPlayer(prof.getId());
            if (player == null) continue;
            PlayerClaimData data = PlayerClaimData.get(player);
            data.unlockDeathItems();
            success.add(prof.getName());
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.unlockDropsMulti", success, ChatFormatting.GOLD), false);
        return 1;
    }

    private static int openPersonalGroups(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        PersonalGroupScreenHandler.openGroupMenu((Player)player);
        return 1;
    }

    private static int claimInfo(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return CommandClaim.claimInfo(context, CommandHelpers.parseEnum(Claim.InfoType.class, StringArgumentType.getString(context, (String)"type"), Claim.InfoType.ALL));
    }

    private static int claimInfo(CommandContext<CommandSourceStack> context, Claim.InfoType infoType) throws CommandSyntaxException {
        Claim sub;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Claim claim = ClaimStorage.get(player.serverLevel()).getClaimAt(player.blockPosition());
        PlayerClaimData data = PlayerClaimData.get(player);
        if (claim == null) {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.noClaim", ChatFormatting.RED), false);
            return 0;
        }
        if (data.getClaimMode().isSubclaim && (sub = claim.getSubClaim(player.blockPosition())) != null) {
            List<Component> info = sub.infoString(player, infoType);
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.claimSubHeader", ChatFormatting.AQUA), false);
            for (Component text : info) {
                player.displayClientMessage(text, false);
            }
            return 1;
        }
        List<Component> info = claim.infoString(player, infoType);
        for (Component text : info) {
            player.displayClientMessage(text, false);
        }
        return 1;
    }

    private static int deleteClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ClaimStorage storage = ClaimStorage.get(player.serverLevel());
        Claim claim = storage.getClaimAt(player.blockPosition());
        boolean check = ClaimUtils.check(player, player.blockPosition(), claim, BuiltinPermission.EDITCLAIM, b -> {
            if (b.isEmpty()) {
                ClaimUtils.noClaimMessage(player);
            } else if (!((Boolean)b.get()).booleanValue()) {
                player.displayClientMessage((Component)ClaimUtils.translatedText("flan.deleteClaimError", ChatFormatting.DARK_RED), false);
            }
        });
        if (!check) {
            return 0;
        }
        if (!storage.deleteClaim(claim, true, PlayerClaimData.get(player).getClaimMode(), player.serverLevel())) {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.deleteSubClaimError", ChatFormatting.DARK_RED), false);
        } else {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.deleteClaim", ChatFormatting.RED), false);
        }
        return 1;
    }

    private static int deleteAllClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        PlayerClaimData data = PlayerClaimData.get(((CommandSourceStack)context.getSource()).getPlayerOrException());
        data.deferCommand(new PendingCommand(context, () -> {
            for (ServerLevel world : ((CommandSourceStack)context.getSource()).getServer().getAllLevels()) {
                ClaimStorage storage = ClaimStorage.get(world);
                storage.allClaimsFromPlayer(player.getUUID()).forEach(claim -> storage.deleteClaim((Claim)claim, true, data.getClaimMode(), player.serverLevel()));
            }
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.deleteAllClaim", ChatFormatting.GOLD), false);
            return 1;
        }));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.confirmCommand", ChatFormatting.GOLD), true);
        return 1;
    }

    private static int deleteSubClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ClaimStorage storage = ClaimStorage.get(player.serverLevel());
        Claim claim = storage.getClaimAt(player.blockPosition());
        if (claim == null) {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.noClaim", ChatFormatting.RED), false);
            return 0;
        }
        Claim sub = claim.getSubClaim(player.blockPosition());
        if (sub == null) {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.noClaim", ChatFormatting.RED), false);
            return 0;
        }
        boolean check = ClaimUtils.check(player, player.blockPosition(), claim, BuiltinPermission.EDITCLAIM, b -> {
            if (b.isEmpty()) {
                ClaimUtils.noClaimMessage(player);
            } else if (!((Boolean)b.get()).booleanValue()) {
                player.displayClientMessage((Component)ClaimUtils.translatedText("flan.deleteClaimError", ChatFormatting.DARK_RED), false);
            } else {
                player.displayClientMessage((Component)ClaimUtils.translatedText("flan.deleteSubClaim", ChatFormatting.DARK_RED), false);
            }
        });
        if (!check) {
            return 0;
        }
        claim.deleteSubClaim(sub);
        return 1;
    }

    private static int deleteAllSubClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Claim claim = ClaimUtils.checkReturn(player, BuiltinPermission.EDITCLAIM, ClaimUtils.genericNoPermMessage(player));
        if (claim == null) {
            return 0;
        }
        PlayerClaimData data = PlayerClaimData.get(((CommandSourceStack)context.getSource()).getPlayerOrException());
        data.deferCommand(new PendingCommand(context, () -> {
            List<Claim> subs = claim.getAllSubclaims();
            subs.forEach(claim::deleteSubClaim);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.deleteSubClaimAll", ChatFormatting.DARK_RED), false);
            return 1;
        }));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.confirmCommand", ChatFormatting.GOLD), true);
        return 1;
    }

    private static int listClaims(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return CommandClaim.listClaimsFromUUID(context, null);
    }

    private static int listClaims(CommandContext<CommandSourceStack> context, Collection<GameProfile> profs) throws CommandSyntaxException {
        if (profs.size() != 1) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.onlyOnePlayer", ChatFormatting.RED), false);
            return 0;
        }
        GameProfile prof = profs.iterator().next();
        if (prof == null || prof.getId() == null) {
            return 0;
        }
        return CommandClaim.listClaimsFromUUID(context, prof.getId());
    }

    private static int listClaimsFromUUID(CommandContext<CommandSourceStack> context, UUID of) throws CommandSyntaxException {
        MinecraftServer server = ((CommandSourceStack)context.getSource()).getServer();
        ServerPlayer player = of == null ? ((CommandSourceStack)context.getSource()).getPlayerOrException() : server.getPlayerList().getPlayer(of);
        HashMap<ServerLevel, Collection<Claim>> claims = new HashMap<ServerLevel, Collection<Claim>>();
        for (ServerLevel serverLevel : server.getAllLevels()) {
            ClaimStorage storage = ClaimStorage.get(serverLevel);
            claims.put(serverLevel, storage.allClaimsFromPlayer(player != null ? player.getUUID() : of));
        }
        if (ConfigHandler.CONFIG.maxClaimBlocks != -1) {
            if (player != null) {
                data = PlayerClaimData.get(player);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandClaim.lambda$listClaimsFromUUID$100((PlayerClaimData)data), false);
            } else {
                data = new OfflinePlayerData(server, of);
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> CommandClaim.lambda$listClaimsFromUUID$101((OfflinePlayerData)data), false);
            }
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.listClaims", ChatFormatting.GOLD), false);
        for (Map.Entry entry : claims.entrySet()) {
            for (Claim claim : (Collection)entry.getValue()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText(String.valueOf(((Level)entry.getKey()).dimension().location()) + " # " + claim.formattedClaim(), ChatFormatting.YELLOW), false);
            }
        }
        return 1;
    }

    private static int switchEditMode(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        String s = StringArgumentType.getString(context, (String)"mode");
        ClaimMode mode = CommandHelpers.parseEnum(ClaimMode.class, s, null);
        if (mode == null) {
            ((CommandSourceStack)context.getSource()).sendFailure((Component)ClaimUtils.translatedText("flan.claimMode", s, ChatFormatting.GOLD));
            return 0;
        }
        PlayerClaimData data = PlayerClaimData.get(player);
        data.setEditMode(mode);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.claimMode", Component.translatable((String)data.getClaimMode().translationKey).withStyle(ChatFormatting.AQUA), ChatFormatting.GOLD), false);
        return 1;
    }

    private static int switchAdminMode(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        PlayerClaimData data;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        data.setAdminIgnoreClaim(!(data = PlayerClaimData.get(player)).isAdminIgnoreClaim());
        player.displayClientMessage((Component)ClaimUtils.translatedText("flan.adminMode", data.isAdminIgnoreClaim(), ChatFormatting.GOLD), false);
        return 1;
    }

    private static int adminDelete(CommandContext<CommandSourceStack> context) {
        CommandSourceStack src = (CommandSourceStack)context.getSource();
        ClaimStorage storage = ClaimStorage.get(src.getLevel());
        Claim claim = storage.getClaimAt(BlockPos.containing((Position)src.getPosition()));
        if (claim == null) {
            src.sendSuccess(() -> ClaimUtils.translatedText("flan.noClaim", ChatFormatting.RED), false);
            return 0;
        }
        storage.deleteClaim(claim, true, ClaimMode.DEFAULT, src.getLevel());
        src.sendSuccess(() -> ClaimUtils.translatedText("flan.deleteClaim", ChatFormatting.RED), true);
        return 1;
    }

    private static int adminDeleteAll(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)context.getSource();
        Collection profiles = GameProfileArgument.getGameProfiles(context, (String)"players");
        Entity entity = src.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            PlayerClaimData data = PlayerClaimData.get(player);
            data.deferCommand(new PendingCommand(context, () -> {
                ArrayList<String> players = new ArrayList<String>();
                for (GameProfile prof : profiles) {
                    for (ServerLevel world : src.getLevel().getServer().getAllLevels()) {
                        ClaimStorage storage = ClaimStorage.get(world);
                        storage.allClaimsFromPlayer(prof.getId()).forEach(claim -> storage.deleteClaim((Claim)claim, true, ClaimMode.DEFAULT, world));
                    }
                    players.add(prof.getName());
                }
                src.sendSuccess(() -> ClaimUtils.translatedText("flan.adminDeleteAll", players, ChatFormatting.GOLD), true);
                return 1;
            }));
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.confirmCommand", ChatFormatting.GOLD), true);
            return 1;
        }
        ArrayList<String> players = new ArrayList<String>();
        for (GameProfile prof : profiles) {
            for (ServerLevel world : src.getLevel().getServer().getAllLevels()) {
                ClaimStorage storage = ClaimStorage.get(world);
                storage.allClaimsFromPlayer(prof.getId()).forEach(claim -> storage.deleteClaim((Claim)claim, true, ClaimMode.DEFAULT, world));
            }
            players.add(prof.getName());
        }
        src.sendSuccess(() -> ClaimUtils.translatedText("flan.adminDeleteAll", players, ChatFormatting.GOLD), true);
        return 1;
    }

    private static int toggleAdminClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ClaimStorage storage = ClaimStorage.get(player.serverLevel());
        Claim claim = storage.getClaimAt(player.blockPosition());
        if (claim == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.noClaim", ChatFormatting.RED), false);
            return 0;
        }
        storage.toggleAdminClaim(player, claim, BoolArgumentType.getBool(context, (String)"toggle"));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.setAdminClaim", claim.isAdminClaim(), ChatFormatting.GOLD), true);
        return 1;
    }

    private static int listAdminClaims(CommandContext<CommandSourceStack> context) {
        CommandSourceStack src = (CommandSourceStack)context.getSource();
        Collection<Claim> claims = ClaimStorage.get(src.getLevel()).getAdminClaims();
        src.sendSuccess(() -> ClaimUtils.translatedText("flan.listAdminClaims", src.getLevel().dimension().location(), ChatFormatting.GOLD), false);
        for (Claim claim : claims) {
            src.sendSuccess(() -> ClaimUtils.translatedText(claim.formattedClaim(), ChatFormatting.YELLOW), false);
        }
        return 1;
    }

    private static int readGriefPreventionData(CommandContext<CommandSourceStack> context) {
        CommandSourceStack src = (CommandSourceStack)context.getSource();
        src.sendSuccess(() -> ClaimUtils.translatedText("flan.readGriefpreventionData", ChatFormatting.GOLD), true);
        if (ClaimStorage.readGriefPreventionData(src.getServer(), src)) {
            src.sendSuccess(() -> ClaimUtils.translatedText("flan.readGriefpreventionClaimDataSuccess", ChatFormatting.GOLD), true);
        }
        if (PlayerClaimData.readGriefPreventionPlayerData(src.getServer(), src)) {
            src.sendSuccess(() -> ClaimUtils.translatedText("flan.readGriefpreventionPlayerDataSuccess", ChatFormatting.GOLD), true);
        }
        return 1;
    }

    private static int giveClaimBlocks(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return CommandClaim.giveClaimBlocks(context, false);
    }

    private static int giveClaimBlocks(CommandContext<CommandSourceStack> context, boolean base) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)context.getSource();
        ArrayList<String> players = new ArrayList<String>();
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        for (GameProfile prof : GameProfileArgument.getGameProfiles(context, (String)"players")) {
            ServerPlayer player = src.getServer().getPlayerList().getPlayer(prof.getId());
            if (player != null) {
                PlayerClaimData data = PlayerClaimData.get(player);
                if (base) {
                    data.addClaimBlocksDirect(amount);
                } else {
                    data.setAdditionalClaims(data.getAdditionalClaims() + amount);
                }
            } else {
                PlayerClaimData.editForOfflinePlayer(src.getServer(), prof.getId(), amount, base);
            }
            players.add(prof.getName());
        }
        src.sendSuccess(() -> ClaimUtils.translatedText(base ? "flan.giveClaimBlocks" : "flan.giveClaimBlocksBonus", players, amount, ChatFormatting.GOLD), true);
        return 1;
    }

    private static int addGroup(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return CommandClaim.modifyGroup(context, false);
    }

    private static int removeGroup(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return CommandClaim.modifyGroup(context, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int modifyGroup(CommandContext<CommandSourceStack> context, boolean remove) throws CommandSyntaxException {
        Claim sub;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        String group = StringArgumentType.getString(context, (String)"group");
        ClaimStorage storage = ClaimStorage.get(player.serverLevel());
        Claim claim = storage.getClaimAt(player.blockPosition());
        if (claim == null) {
            ClaimUtils.noClaimMessage(player);
            return 0;
        }
        if (PlayerClaimData.get((ServerPlayer)player).getClaimMode().isSubclaim && (sub = claim.getSubClaim(player.blockPosition())) != null) {
            claim = sub;
        }
        if (remove) {
            if (claim.removePermGroup(player, group)) {
                player.displayClientMessage((Component)ClaimUtils.translatedText("flan.groupRemove", group, ChatFormatting.GOLD), false);
                return 1;
            }
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.noPermission", ChatFormatting.DARK_RED), false);
            return 0;
        }
        if (claim.groups().contains(group)) {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.groupExist", group, ChatFormatting.RED), false);
            return 0;
        }
        if (claim.editPerms(player, group, BuiltinPermission.EDITPERMS, -1)) {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.groupAdd", group, ChatFormatting.GOLD), false);
            return 1;
        }
        player.displayClientMessage((Component)ClaimUtils.translatedText("flan.noPermission", ChatFormatting.DARK_RED), false);
        return 0;
    }

    private static int forceAddPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String group = StringArgumentType.getString(context, (String)"group");
        return CommandClaim.modifyPlayer(context, group, true);
    }

    private static int addPlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String group = StringArgumentType.getString(context, (String)"group");
        return CommandClaim.modifyPlayer(context, group, false);
    }

    private static int removePlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return CommandClaim.modifyPlayer(context, null, false);
    }

    private static int modifyPlayer(CommandContext<CommandSourceStack> context, String group, boolean force) throws CommandSyntaxException {
        Claim sub;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ClaimStorage storage = ClaimStorage.get(player.serverLevel());
        Claim claim = storage.getClaimAt(player.blockPosition());
        if (claim == null) {
            ClaimUtils.noClaimMessage(player);
            return 0;
        }
        if (PlayerClaimData.get((ServerPlayer)player).getClaimMode().isSubclaim && (sub = claim.getSubClaim(player.blockPosition())) != null) {
            claim = sub;
        }
        if (!claim.canInteract(player, BuiltinPermission.EDITPERMS, player.blockPosition())) {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.noPermission", ChatFormatting.DARK_RED), false);
            return 0;
        }
        ArrayList<String> modified = new ArrayList<String>();
        for (GameProfile prof : GameProfileArgument.getGameProfiles(context, (String)"players")) {
            if (!claim.setPlayerGroup(prof.getId(), group, force)) continue;
            modified.add(prof.getName());
        }
        if (group == null) {
            if (!modified.isEmpty()) {
                player.displayClientMessage((Component)ClaimUtils.translatedText("flan.playerRemove", modified, ChatFormatting.GOLD), false);
            } else {
                player.displayClientMessage((Component)ClaimUtils.translatedText("flan.playerRemoveNo", ChatFormatting.RED), false);
            }
        } else if (!modified.isEmpty()) {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.playerModify", group, modified, ChatFormatting.GOLD), false);
        } else {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.playerModifyNo", group, ChatFormatting.RED), false);
        }
        return modified.size();
    }

    private static int toggleFakePlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        PlayerClaimData data;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        data.setFakePlayerNotif(!(data = PlayerClaimData.get(player)).hasFakePlayerNotificationOn());
        player.displayClientMessage((Component)ClaimUtils.translatedText("flan.fakePlayerNotification", data.hasFakePlayerNotificationOn(), ChatFormatting.GOLD), false);
        return 1;
    }

    private static int addFakePlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return CommandClaim.modifyFakePlayer(context, false);
    }

    private static int removeFakePlayer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return CommandClaim.modifyFakePlayer(context, true);
    }

    private static int modifyFakePlayer(CommandContext<CommandSourceStack> context, boolean remove) throws CommandSyntaxException {
        Claim sub;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        ClaimStorage storage = ClaimStorage.get(player.serverLevel());
        Claim claim = storage.getClaimAt(player.blockPosition());
        if (claim == null) {
            ClaimUtils.noClaimMessage(player);
            return 0;
        }
        if (PlayerClaimData.get((ServerPlayer)player).getClaimMode().isSubclaim && (sub = claim.getSubClaim(player.blockPosition())) != null) {
            claim = sub;
        }
        if (!claim.canInteract(player, BuiltinPermission.EDITPERMS, player.blockPosition())) {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.noPermission", ChatFormatting.DARK_RED), false);
            return 0;
        }
        UUID uuid = UuidArgument.getUuid(context, (String)"uuid");
        if (claim.modifyFakePlayerUUID(uuid, remove)) {
            if (!remove) {
                player.displayClientMessage((Component)ClaimUtils.translatedText("flan.uuidFakeAdd", uuid, ChatFormatting.GOLD), false);
            } else {
                player.displayClientMessage((Component)ClaimUtils.translatedText("flan.uuidFakeRemove", uuid, ChatFormatting.GOLD), false);
            }
            return 1;
        }
        player.displayClientMessage((Component)ClaimUtils.translatedText("flan.uuidFakeModifyNo", ChatFormatting.RED), false);
        return 0;
    }

    private static int editGlobalPerm(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int mode = switch (StringArgumentType.getString(context, (String)"toggle")) {
            case "true" -> 1;
            case "default" -> -1;
            default -> 0;
        };
        return CommandClaim.editPerms(context, null, mode);
    }

    private static int editGroupPerm(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int mode = switch (StringArgumentType.getString(context, (String)"toggle")) {
            case "true" -> 1;
            case "default" -> -1;
            default -> 0;
        };
        return CommandClaim.editPerms(context, StringArgumentType.getString(context, (String)"group"), mode);
    }

    private static int editPerms(CommandContext<CommandSourceStack> context, String group, int mode) throws CommandSyntaxException {
        String setPerm;
        Claim sub;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Claim claim = ClaimStorage.get(player.serverLevel()).getClaimAt(player.blockPosition());
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.getClaimMode().isSubclaim && (sub = claim.getSubClaim(player.blockPosition())) != null) {
            claim = sub;
        }
        if (claim == null) {
            ClaimUtils.noClaimMessage(player);
            return 0;
        }
        if (!claim.canInteract(player, BuiltinPermission.EDITPERMS, player.blockPosition())) {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.noPermission", ChatFormatting.DARK_RED), false);
            return 0;
        }
        ResourceLocation perm = ResourceLocationArgument.getId(context, (String)"permission");
        if (group != null && PermissionManager.getInstance().isGlobalPermission(perm)) {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.nonGlobalOnly", perm, ChatFormatting.DARK_RED), false);
            return 0;
        }
        if (PermissionManager.getInstance().get(perm) == null) {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.noSuchPerm", perm, ChatFormatting.DARK_RED), false);
            return 0;
        }
        String string = mode == 1 ? "true" : (setPerm = mode == 0 ? "false" : "default");
        if (group == null) {
            claim.editGlobalPerms(player, perm, mode);
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.editPerm", perm, setPerm, ChatFormatting.GOLD), false);
        } else {
            claim.editPerms(player, group, perm, mode);
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.editPermGroup", perm, group, setPerm, ChatFormatting.GOLD), false);
        }
        return 1;
    }

    private static int editPersonalPerm(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String setPerm;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        String group = StringArgumentType.getString(context, (String)"group");
        int mode = switch (StringArgumentType.getString(context, (String)"toggle")) {
            case "true" -> 1;
            case "default" -> -1;
            default -> 0;
        };
        ResourceLocation perm = ResourceLocationArgument.getId(context, (String)"permission");
        if (PermissionManager.getInstance().isGlobalPermission(perm)) {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.nonGlobalOnly", perm, ChatFormatting.DARK_RED), false);
            return 0;
        }
        if (PermissionManager.getInstance().get(perm) == null) {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.noSuchPerm", perm, ChatFormatting.DARK_RED), false);
            return 0;
        }
        String string = mode == 1 ? "true" : (setPerm = mode == 0 ? "false" : "default");
        if (PlayerClaimData.get(player).editDefaultPerms(group, perm, mode)) {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.editPersonalGroup", group, perm, setPerm, ChatFormatting.GOLD), false);
        }
        return 1;
    }

    public static int setClaimHome(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Claim claim = ClaimUtils.checkReturn(player, BuiltinPermission.EDITCLAIM, ClaimUtils.genericNoPermMessage(player));
        if (claim == null) {
            return 0;
        }
        claim.setHomePos(player.blockPosition());
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.setHome", player.blockPosition().getX(), player.blockPosition().getY(), player.blockPosition().getZ(), ChatFormatting.GOLD), false);
        return 1;
    }

    private static int expandClaim(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        Claim claim = ClaimUtils.checkReturn(player, BuiltinPermission.EDITCLAIM, ClaimUtils.genericNoPermMessage(player));
        if (claim == null) {
            return 0;
        }
        ClaimStorage storage = ClaimStorage.get(player.serverLevel());
        int amount = IntegerArgumentType.getInteger(context, (String)"distance");
        ClaimBox dims = claim.getDimensions();
        Direction facing = player.getDirection();
        Tuple cornerPair = switch (facing) {
            case Direction.SOUTH -> new Tuple((Object)new BlockPos(dims.maxX(), dims.minY(), dims.maxZ()), (Object)new BlockPos(dims.maxX(), dims.maxY(), dims.maxZ() + amount));
            case Direction.EAST -> new Tuple((Object)new BlockPos(dims.maxX(), dims.minY(), dims.maxZ()), (Object)new BlockPos(dims.maxX() + amount, dims.maxY(), dims.maxZ()));
            case Direction.NORTH -> new Tuple((Object)new BlockPos(dims.minX(), dims.minY(), dims.minZ()), (Object)new BlockPos(dims.minX(), dims.maxY(), dims.minZ() - amount));
            case Direction.WEST -> new Tuple((Object)new BlockPos(dims.minX(), dims.minY(), dims.minZ()), (Object)new BlockPos(dims.minX() - amount, dims.maxY(), dims.minZ()));
            default -> throw new IllegalStateException("Unexpected value: " + String.valueOf(facing));
        };
        return storage.resizeClaim(claim, (BlockPos)cornerPair.getA(), (BlockPos)cornerPair.getB(), player) ? 1 : 0;
    }

    public static int teleport(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return CommandClaim.teleport(context, ((CommandSourceStack)context.getSource()).getPlayerOrException().getUUID());
    }

    public static int teleportAdminClaims(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return CommandClaim.teleport(context, null);
    }

    public static int teleport(CommandContext<CommandSourceStack> context, UUID owner) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        String name = StringArgumentType.getString(context, (String)"claim");
        Optional<Claim> claims = ClaimStorage.get(player.serverLevel()).allClaimsFromPlayer(owner).stream().filter(claim -> {
            if (claim.getClaimName().isEmpty()) {
                return claim.getClaimID().toString().equals(name);
            }
            return claim.getClaimName().equals(name);
        }).findFirst();
        if (claims.isEmpty()) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.teleportNoClaim", ChatFormatting.RED), false);
            return 0;
        }
        return claims.map(claim -> {
            BlockPos pos = claim.getHomePos();
            if (claim.canInteract(player, BuiltinPermission.TELEPORT, pos, false)) {
                PlayerClaimData data = PlayerClaimData.get(player);
                if (data.setTeleportTo(pos)) {
                    ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.teleportHome", ChatFormatting.GOLD), false);
                    return 1;
                }
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.teleportHomeFail", ChatFormatting.RED), false);
            } else {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.noPermissionSimple", ChatFormatting.DARK_RED), false);
            }
            return 0;
        }).orElse(0);
    }

    public static int editClaimMessages(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        return CommandClaim.editClaimMessages(context, (Component)Component.literal((String)StringArgumentType.getString(context, (String)"message")));
    }

    public static int editClaimMessages(CommandContext<CommandSourceStack> context, Component text) throws CommandSyntaxException {
        String feedback;
        Claim claim;
        if (text instanceof MutableComponent) {
            Style style = text.getStyle();
            if (style.isEmpty()) {
                style = style.applyFormat(ChatFormatting.WHITE);
            }
            if (!style.isItalic()) {
                style = style.withItalic(Boolean.valueOf(false));
            }
            ((MutableComponent)text).setStyle(style);
        }
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        PlayerClaimData data = PlayerClaimData.get(player);
        Claim rootClaim = ClaimUtils.checkReturn(player, BuiltinPermission.CLAIMMESSAGE, ClaimUtils.genericNoPermMessage(player));
        if (rootClaim == null) {
            return 0;
        }
        Claim claim2 = claim = data.getClaimMode().isSubclaim ? rootClaim.getSubClaim(player.blockPosition()) : rootClaim;
        if (claim == null) {
            return 0;
        }
        boolean sub = StringArgumentType.getString(context, (String)"title").equals("subtitle");
        boolean enter = StringArgumentType.getString(context, (String)"type").equals("enter");
        if (enter) {
            if (sub) {
                claim.setEnterTitle(claim.enterTitle, text);
                feedback = "flan.setEnterSubMessage";
            } else {
                claim.setEnterTitle(text, claim.enterSubtitle);
                feedback = "flan.setEnterMessage";
            }
        } else if (sub) {
            claim.setLeaveTitle(claim.leaveTitle, text);
            feedback = "flan.setLeaveSubMessage";
        } else {
            claim.setLeaveTitle(text, claim.leaveSubtitle);
            feedback = "flan.setLeaveMessage";
        }
        MutableComponent cmdFeed = ClaimUtils.translatedText(feedback, text).withStyle(ChatFormatting.GOLD);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> cmdFeed, false);
        return 1;
    }

    public static int addClaimListEntries(CommandContext<CommandSourceStack> context, CustomInteractListScreenHandler.Type type) throws CommandSyntaxException {
        Claim claim;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        PlayerClaimData data = PlayerClaimData.get(player);
        Claim rootClaim = ClaimUtils.checkReturn(player, BuiltinPermission.CLAIMMESSAGE, ClaimUtils.genericNoPermMessage(player));
        if (rootClaim == null) {
            return 0;
        }
        Claim claim2 = claim = data.getClaimMode().isSubclaim ? rootClaim.getSubClaim(player.blockPosition()) : rootClaim;
        if (claim == null) {
            return 0;
        }
        String result = switch (type) {
            default -> throw new MatchException(null, null);
            case CustomInteractListScreenHandler.Type.ITEM -> CommandClaim.addClaimListEntry(context, BuiltInRegistries.ITEM, claim.allowedItems);
            case CustomInteractListScreenHandler.Type.BLOCKBREAK -> CommandClaim.addClaimListEntry(context, BuiltInRegistries.BLOCK, claim.allowedBreakBlocks);
            case CustomInteractListScreenHandler.Type.BLOCKUSE -> CommandClaim.addClaimListEntry(context, BuiltInRegistries.BLOCK, claim.allowedUseBlocks);
            case CustomInteractListScreenHandler.Type.ENTITYATTACK -> CommandClaim.addClaimListEntry(context, BuiltInRegistries.ENTITY_TYPE, claim.allowedEntityAttack);
            case CustomInteractListScreenHandler.Type.ENTITYUSE -> CommandClaim.addClaimListEntry(context, BuiltInRegistries.ENTITY_TYPE, claim.allowedEntityUse);
        };
        MutableComponent cmdFeed = ClaimUtils.translatedText("flan.addIgnoreEntry", result, type.commandKey).withStyle(ChatFormatting.GOLD);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> cmdFeed, false);
        return 1;
    }

    public static int removeClaimListEntries(CommandContext<CommandSourceStack> context, CustomInteractListScreenHandler.Type type) throws CommandSyntaxException {
        Claim claim;
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        PlayerClaimData data = PlayerClaimData.get(player);
        Claim rootClaim = ClaimUtils.checkReturn(player, BuiltinPermission.CLAIMMESSAGE, ClaimUtils.genericNoPermMessage(player));
        if (rootClaim == null) {
            return 0;
        }
        Claim claim2 = claim = data.getClaimMode().isSubclaim ? rootClaim.getSubClaim(player.blockPosition()) : rootClaim;
        if (claim == null) {
            return 0;
        }
        String value = ((ResourceOrTagKeyArgument.Result)context.getArgument("entry", ResourceOrTagKeyArgument.Result.class)).asPrintable();
        switch (type) {
            case ITEM: {
                claim.allowedItems.removeAllowedItem(value);
                break;
            }
            case BLOCKBREAK: {
                claim.allowedBreakBlocks.removeAllowedItem(value);
                break;
            }
            case BLOCKUSE: {
                claim.allowedUseBlocks.removeAllowedItem(value);
                break;
            }
            case ENTITYATTACK: {
                claim.allowedEntityAttack.removeAllowedItem(value);
                break;
            }
            case ENTITYUSE: {
                claim.allowedEntityUse.removeAllowedItem(value);
            }
        }
        MutableComponent cmdFeed = ClaimUtils.translatedText("flan.removeIgnoreEntry", value, type.commandKey).withStyle(ChatFormatting.GOLD);
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> cmdFeed, false);
        return 1;
    }

    private static int sellClaimBlocks(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        boolean b = ConfigHandler.CONFIG.buySellHandler.sell(((CommandSourceStack)context.getSource()).getPlayerOrException(), Math.max(0, IntegerArgumentType.getInteger(context, (String)"amount")), m -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> m, false));
        return b ? 1 : 0;
    }

    private static int buyClaimBlocks(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        boolean b = ConfigHandler.CONFIG.buySellHandler.buy(((CommandSourceStack)context.getSource()).getPlayerOrException(), Math.max(0, IntegerArgumentType.getInteger(context, (String)"amount")), m -> ((CommandSourceStack)context.getSource()).sendSuccess(() -> m, false));
        return b ? 1 : 0;
    }

    private static int confirmCommand(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).getPlayerOrException();
        PlayerClaimData data = PlayerClaimData.get(player);
        String confirm = StringArgumentType.getString(context, (String)"confirm");
        if (!confirm.equals("confirm") && !confirm.equals("deny")) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.confirmCommand.args", ChatFormatting.RED), false);
            return 0;
        }
        int res = data.runPendingCommand(confirm.equals("confirm"));
        if (res == -1) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> ClaimUtils.translatedText("flan.confirmCommand.none", ChatFormatting.RED), false);
            return 0;
        }
        return res;
    }

    private static <T> String addClaimListEntry(CommandContext<CommandSourceStack> context, Registry<T> registry, AllowedRegistryList<T> list) throws CommandSyntaxException {
        ResourceOrTagKeyArgument.Result value = CommandHelpers.getRegistryType(context, "entry", registry.key());
        value.unwrap().ifRight(tag -> list.addAllowedItem(Either.right((Object)tag))).ifLeft(id -> {
            Object entry = registry.get(id);
            if (entry != Items.AIR) {
                list.addAllowedItem(Either.left((Object)entry));
            }
        });
        return value.asPrintable();
    }

    private static /* synthetic */ Component lambda$listClaimsFromUUID$101(OfflinePlayerData data) {
        return ClaimUtils.translatedText("flan.claimBlocksFormat", data.claimBlocks, data.getAdditionalClaims(), data.usedClaimBlocks(), data.remainingClaimBlocks(), ChatFormatting.GOLD);
    }

    private static /* synthetic */ Component lambda$listClaimsFromUUID$100(PlayerClaimData data) {
        return ClaimUtils.translatedText("flan.claimBlocksFormat", data.getClaimBlocks(), data.getAdditionalClaims(), data.usedClaimBlocks(), data.remainingClaimBlocks(), ChatFormatting.GOLD);
    }

    private static /* synthetic */ Component lambda$addClaimAs$82() {
        return ClaimUtils.translatedText("flan.claimCreateSuccess", ChatFormatting.GOLD);
    }

    private static /* synthetic */ Component lambda$addClaimAs$81() {
        return ClaimUtils.translatedText("flan.claimCreationFailCommand", new Object[0]);
    }

    private static /* synthetic */ Component lambda$addClaimAs$80(String as) {
        return ClaimUtils.translatedText("flan.noSuchPlayer", as);
    }

    private static /* synthetic */ Component lambda$addClaimAs$79(ResourceLocation levelID) {
        return ClaimUtils.translatedText("flan.noSuchLevel", levelID);
    }
}

