/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.platform.integration.currency.CommandCurrency;
import io.github.flemmli97.flan.player.PlayerClaimData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class BuySellHandler {
    public static final Codec<ItemStack> ITEM_STACK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("id").forGetter(ItemStack::getItem), (App)DataComponentPatch.CODEC.optionalFieldOf("components").forGetter(stack -> stack.getComponentsPatch().isEmpty() ? Optional.empty() : Optional.of(stack.getComponentsPatch()))).apply((Applicative)instance, (item, components) -> {
        ItemStack stack = new ItemStack((ItemLike)item, 1);
        components.ifPresent(arg_0 -> ((ItemStack)stack).applyComponents(arg_0));
        return stack;
    }));
    private static int[] xpCalc;
    private Type buyType = Type.MONEY;
    private Type sellType = Type.MONEY;
    private float buyAmount = -1.0f;
    private final List<BuyItem> buyItems = new ArrayList<BuyItem>();
    private float sellAmount = -1.0f;
    private final List<SellItem> sellItems = new ArrayList<SellItem>();

    private static ItemStack fromResults(List<ItemResult> stacks) {
        ItemStack stack = new ItemStack((ItemLike)Items.EMERALD);
        stack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)"flan.buy_sell.item").setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.AQUA)));
        ArrayList<Component> stackComp = new ArrayList<Component>();
        for (ItemResult r : stacks) {
            stackComp.add((Component)Component.translatable((String)"flan.buy_sell.item.amount", (Object[])new Object[]{Component.translatable((String)r.stack().getDescriptionId()), r.amount(), Float.valueOf(r.value())}).setStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.GREEN)));
        }
        ServerScreenHelper.addLore(stack, stackComp);
        return stack;
    }

    public boolean buy(ServerPlayer player, int blocks, Consumer<Component> message) {
        if (this.buyAmount == -1.0f && this.buyType != Type.ITEM) {
            message.accept((Component)ClaimUtils.translatedText("flan.buyDisabled", ChatFormatting.DARK_RED));
            return false;
        }
        PlayerClaimData data = PlayerClaimData.get(player);
        if (ConfigHandler.CONFIG.maxBuyBlocks >= 0 && data.getAdditionalClaims() + blocks > ConfigHandler.CONFIG.maxBuyBlocks) {
            message.accept((Component)ClaimUtils.translatedText("flan.buyLimit", ChatFormatting.DARK_RED));
            return false;
        }
        switch (this.buyType.ordinal()) {
            case 0: {
                return CommandCurrency.INSTANCE.buyClaimBlocks(player, blocks, this.buyAmount, message);
            }
            case 1: {
                if (this.buyItems.isEmpty()) {
                    message.accept((Component)ClaimUtils.translatedText("flan.buyDisabled", ChatFormatting.DARK_RED));
                    return false;
                }
                int payed = 0;
                ArrayList<ItemResult> bought = new ArrayList<ItemResult>();
                ArrayList<Pair> matching = new ArrayList<Pair>();
                block5: for (BuyItem ing : this.buyItems) {
                    for (ItemStack stack : player.getInventory().items) {
                        if (!this.matches(ing.predicate(), stack) || stack.isDamageableItem() && stack.getDamageValue() != 0) continue;
                        float toPay = blocks - payed;
                        int count = Math.min(stack.getCount(), (int)(toPay / ing.amount()));
                        float amount = (float)count * ing.amount();
                        payed = (int)((float)payed + amount);
                        if (count > 0) {
                            bought.add(new ItemResult(stack.copy(), count, ing.amount()));
                            matching.add(Pair.of((Object)stack, (Object)count));
                        }
                        if (payed < blocks) continue;
                        break block5;
                    }
                }
                if (payed == 0 || matching.isEmpty()) {
                    message.accept((Component)ClaimUtils.translatedText("flan.buyFailItem", ChatFormatting.DARK_RED));
                    return false;
                }
                for (Pair stack : matching) {
                    ((ItemStack)stack.getFirst()).shrink(((Integer)stack.getSecond()).intValue());
                }
                MutableComponent items = Component.translatable((String)"flan.buy_sell.items").withStyle(Style.EMPTY.applyFormat(ChatFormatting.AQUA).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(BuySellHandler.fromResults(bought)))));
                data.setAdditionalClaims(data.getAdditionalClaims() + payed);
                message.accept((Component)ClaimUtils.translatedText("flan.buySuccessItem", payed, items));
                return true;
            }
            case 2: {
                int deduct = Mth.ceil((float)((float)blocks * this.buyAmount));
                if ((float)deduct < (float)BuySellHandler.totalXpPointsForLevel(player.experienceLevel) + player.experienceProgress * (float)BuySellHandler.xpForLevel(player.experienceLevel + 1)) {
                    player.giveExperiencePoints(-deduct);
                    data.setAdditionalClaims(data.getAdditionalClaims() + blocks);
                    message.accept((Component)ClaimUtils.translatedText("flan.buySuccessXP", blocks, deduct));
                    return true;
                }
                message.accept((Component)ClaimUtils.translatedText("flan.buyFailXP", ChatFormatting.DARK_RED));
                return false;
            }
        }
        return false;
    }

    public boolean sell(ServerPlayer player, int blocks, Consumer<Component> message) {
        if (this.sellAmount == -1.0f && this.sellType != Type.ITEM) {
            message.accept((Component)ClaimUtils.translatedText("flan.sellDisabled", ChatFormatting.DARK_RED));
            return false;
        }
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.getAdditionalClaims() - Math.max(0, data.usedClaimBlocks() - data.getClaimBlocks()) < blocks) {
            message.accept((Component)ClaimUtils.translatedText("flan.sellFail", ChatFormatting.DARK_RED));
            return false;
        }
        switch (this.sellType.ordinal()) {
            case 0: {
                return CommandCurrency.INSTANCE.sellClaimBlocks(player, blocks, this.sellAmount, message);
            }
            case 1: {
                if (this.sellItems.isEmpty()) {
                    message.accept((Component)ClaimUtils.translatedText("flan.sellDisabled", ChatFormatting.DARK_RED));
                    return false;
                }
                int toSell = blocks;
                ArrayList<ItemResult> soldStacks = new ArrayList<ItemResult>();
                for (SellItem item : this.sellItems) {
                    int count = (int)((float)toSell / item.amount());
                    float amount = (float)count * item.amount();
                    toSell = (int)((float)toSell - amount);
                    while (count > 0) {
                        ItemEntity itemEntity;
                        ItemStack toGive = item.item().copy();
                        if (count > 64) {
                            toGive.setCount(64);
                            count -= 64;
                        } else {
                            toGive.setCount(count);
                            count = 0;
                        }
                        soldStacks.add(new ItemResult(toGive.copy(), toGive.getCount(), item.amount()));
                        boolean bl = player.getInventory().add(toGive);
                        if (bl && toGive.isEmpty() || (itemEntity = player.drop(toGive, false)) == null) continue;
                        itemEntity.setNoPickUpDelay();
                        itemEntity.setTarget(player.getUUID());
                    }
                    if (toSell > 0) continue;
                    break;
                }
                int sold = blocks - toSell;
                MutableComponent items = Component.translatable((String)"flan.buy_sell.items").withStyle(Style.EMPTY.applyFormat(ChatFormatting.AQUA).withHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(BuySellHandler.fromResults(soldStacks)))));
                data.setAdditionalClaims(data.getAdditionalClaims() - sold);
                message.accept((Component)ClaimUtils.translatedText("flan.sellSuccessItem", sold, items));
                return true;
            }
            case 2: {
                int amount = Mth.floor((float)((float)blocks * this.buyAmount));
                player.giveExperiencePoints(amount);
                data.setAdditionalClaims(data.getAdditionalClaims() - blocks);
                message.accept((Component)ClaimUtils.translatedText("flan.sellSuccessXP", blocks, amount));
                return false;
            }
        }
        return false;
    }

    private boolean matches(ItemPredicate predicate, ItemStack stack) {
        if ((predicate.components().alwaysMatches() || predicate.subPredicates().isEmpty()) && stack.getComponentsPatch().entrySet().stream().anyMatch(e -> e.getKey() != DataComponents.CUSTOM_NAME && e.getKey() != DataComponents.REPAIR_COST && e.getKey() != DataComponents.DAMAGE)) {
            return false;
        }
        return predicate.test(stack);
    }

    private static int totalXpPointsForLevel(int level) {
        if (xpCalc == null || level > xpCalc.length) {
            xpCalc = new int[level + 50];
            BuySellHandler.xpCalc[0] = 0;
            for (int i = 1; i < xpCalc.length; ++i) {
                BuySellHandler.xpCalc[i] = BuySellHandler.xpForLevel(i) + xpCalc[i - 1];
            }
        }
        return xpCalc[level];
    }

    private static int xpForLevel(int level) {
        if (--level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    public JsonObject toJson(MinecraftServer server) {
        JsonObject obj = new JsonObject();
        obj.addProperty("buyType", this.buyType.toString());
        obj.addProperty("buyValue", (Number)Float.valueOf(this.buyAmount));
        JsonArray buyArr = new JsonArray();
        RegistryOps ops = server.registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        this.buyItems.forEach(arg_0 -> BuySellHandler.lambda$toJson$4((DynamicOps)ops, buyArr, arg_0));
        obj.add("buyItems", (JsonElement)buyArr);
        obj.addProperty("sellType", this.sellType.toString());
        obj.addProperty("sellValue", (Number)Float.valueOf(this.sellAmount));
        JsonArray sellArr = new JsonArray();
        this.sellItems.forEach(arg_0 -> BuySellHandler.lambda$toJson$5((DynamicOps)ops, sellArr, arg_0));
        obj.add("sellItems", (JsonElement)sellArr);
        return obj;
    }

    public void fromJson(JsonObject object, MinecraftServer server) {
        this.buyType = Type.valueOf(ConfigHandler.fromJson(object, "buyType", this.buyType.toString()));
        this.buyAmount = object.has("buyValue") ? object.get("buyValue").getAsFloat() : this.buyAmount;
        this.buyItems.clear();
        JsonArray buyArr = ConfigHandler.arryFromJson(object, "buyItems");
        RegistryOps ops = server.registryAccess().createSerializationContext((DynamicOps)JsonOps.INSTANCE);
        buyArr.forEach(arg_0 -> this.lambda$fromJson$6((DynamicOps)ops, arg_0));
        this.buyItems.sort(BuyItem::compareTo);
        this.sellType = Type.valueOf(ConfigHandler.fromJson(object, "sellType", this.sellType.toString()));
        this.sellAmount = object.has("sellValue") ? object.get("sellValue").getAsFloat() : this.sellAmount;
        this.sellItems.clear();
        JsonArray sellArr = ConfigHandler.arryFromJson(object, "sellItems");
        sellArr.forEach(arg_0 -> this.lambda$fromJson$7((DynamicOps)ops, arg_0));
        this.sellItems.sort(SellItem::compareTo);
    }

    private /* synthetic */ void lambda$fromJson$7(DynamicOps ops, JsonElement k) {
        JsonObject o = k.getAsJsonObject();
        this.sellItems.add(new SellItem(o.get("amount").getAsFloat(), (ItemStack)ITEM_STACK_CODEC.parse(ops, (Object)o.get("item")).getOrThrow()));
    }

    private /* synthetic */ void lambda$fromJson$6(DynamicOps ops, JsonElement k) {
        JsonObject o = k.getAsJsonObject();
        this.buyItems.add(new BuyItem(o.get("amount").getAsFloat(), (ItemPredicate)ItemPredicate.CODEC.parse(ops, (Object)o.get("predicate")).getOrThrow()));
    }

    private static /* synthetic */ void lambda$toJson$5(DynamicOps ops, JsonArray sellArr, SellItem b) {
        JsonObject buyObj = new JsonObject();
        buyObj.addProperty("amount", (Number)Float.valueOf(b.amount()));
        buyObj.add("item", (JsonElement)ITEM_STACK_CODEC.encodeStart(ops, (Object)b.item).getOrThrow());
        sellArr.add((JsonElement)buyObj);
    }

    private static /* synthetic */ void lambda$toJson$4(DynamicOps ops, JsonArray buyArr, BuyItem b) {
        JsonObject buyObj = new JsonObject();
        buyObj.addProperty("amount", (Number)Float.valueOf(b.amount()));
        buyObj.add("predicate", (JsonElement)ItemPredicate.CODEC.encodeStart(ops, (Object)b.predicate()).getOrThrow());
        buyArr.add((JsonElement)buyObj);
    }

    static enum Type {
        MONEY,
        ITEM,
        XP;

    }

    record ItemResult(ItemStack stack, int amount, float value) {
    }

    record BuyItem(float amount, ItemPredicate predicate) implements Comparable<BuyItem>
    {
        @Override
        public int compareTo(@NotNull BuyItem buyItem) {
            return Float.compare(buyItem.amount, this.amount);
        }
    }

    record SellItem(float amount, ItemStack item) implements Comparable<SellItem>
    {
        @Override
        public int compareTo(@NotNull SellItem item) {
            return Float.compare(item.amount, this.amount);
        }
    }
}

