/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.event;

import com.google.common.collect.Sets;
import io.github.flemmli97.flan.api.data.IPermissionContainer;
import io.github.flemmli97.flan.api.permission.BuiltinPermission;
import io.github.flemmli97.flan.api.permission.InteractionOverrideManager;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimStorage;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.config.ConfigHandler;
import io.github.flemmli97.flan.platform.integration.permissions.PermissionNodeHandler;
import io.github.flemmli97.flan.player.PlayerClaimData;
import io.github.flemmli97.flan.player.display.EnumDisplayType;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ItemInteractEvents {
    private static final Set<Item> BLACK_LISTED_ITEMS = Sets.newHashSet((Object[])new Item[]{Items.COMPASS, Items.FILLED_MAP, Items.FIREWORK_ROCKET});

    public static InteractionResultHolder<ItemStack> useItem(Player p, Level world, InteractionHand hand) {
        Claim real;
        IPermissionContainer claim;
        ServerPlayer player;
        block15: {
            block14: {
                if (!(p instanceof ServerPlayer)) break block14;
                player = (ServerPlayer)p;
                if (!p.isSpectator()) break block15;
            }
            return InteractionResultHolder.pass((Object)p.getItemInHand(hand));
        }
        ItemStack stack = player.getItemInHand(hand);
        if (ConfigHandler.isClaimingTool(stack)) {
            BlockPos pos = ItemInteractEvents.rayTargetPos(player);
            if (pos != null) {
                ItemInteractEvents.claimLandHandling(player, pos);
                return InteractionResultHolder.success((Object)stack);
            }
            return InteractionResultHolder.pass((Object)stack);
        }
        if (ConfigHandler.isInspectionTool(stack)) {
            BlockPos pos = ItemInteractEvents.rayTargetPos(player, 32, false);
            if (pos != null) {
                ItemInteractEvents.inspect(player, pos);
                return InteractionResultHolder.success((Object)stack);
            }
            return InteractionResultHolder.pass((Object)stack);
        }
        ClaimStorage storage = ClaimStorage.get((ServerLevel)world);
        BlockPos pos = player.blockPosition();
        BlockHitResult hitResult = ItemInteractEvents.getPlayerHitResult(world, (Player)player, ClipContext.Fluid.SOURCE_ONLY);
        if (hitResult.getType() == HitResult.Type.BLOCK) {
            pos = new BlockPlaceContext((Player)player, hand, stack, hitResult).getClickedPos();
        }
        if ((claim = storage.getForPermissionCheck(pos)) == null) {
            return InteractionResultHolder.pass((Object)stack);
        }
        if (claim instanceof Claim && (real = (Claim)claim).canUseItem(stack)) {
            return InteractionResultHolder.pass((Object)stack);
        }
        ResourceLocation perm = InteractionOverrideManager.getInstance().getItemUse(stack.getItem());
        if (perm != null) {
            boolean success = claim.canInteract(player, perm, pos, true);
            if (success) {
                return InteractionResultHolder.pass((Object)stack);
            }
            if (perm.equals((Object)BuiltinPermission.PLACE)) {
                BlockPos update = pos;
                if (stack.getItem() == Items.LILY_PAD) {
                    BlockHitResult upResult = hitResult.withPosition(hitResult.getBlockPos().above());
                    update = new BlockPlaceContext(new UseOnContext((Player)player, hand, upResult)).getClickedPos();
                }
                player.connection.send((Packet)new ClientboundBlockUpdatePacket(update, world.getBlockState(update)));
                PlayerClaimData.get(player).addDisplayClaim(claim, EnumDisplayType.MAIN, player.blockPosition().getY());
                ItemInteractEvents.updateHeldItem(player);
            }
            return InteractionResultHolder.fail((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public static InteractionResult onItemUseBlock(UseOnContext context) {
        ServerPlayer player;
        block5: {
            block4: {
                Player player2 = context.getPlayer();
                if (!(player2 instanceof ServerPlayer)) break block4;
                player = (ServerPlayer)player2;
                if (!context.getItemInHand().isEmpty()) break block5;
            }
            return InteractionResult.PASS;
        }
        ClaimStorage storage = ClaimStorage.get((ServerLevel)context.getLevel());
        BlockPos interactPos = context.getClickedPos();
        InteractionResult interact = ItemInteractEvents.itemUseOn(context.getLevel(), player, storage, interactPos, context.getItemInHand());
        if (interact != InteractionResult.PASS) {
            return interact;
        }
        BlockPos placePos = new BlockPlaceContext(context).getClickedPos();
        return ItemInteractEvents.itemUseOn(context.getLevel(), player, storage, placePos, context.getItemInHand());
    }

    private static InteractionResult itemUseOn(Level level, ServerPlayer player, ClaimStorage storage, BlockPos placePos, ItemStack stack) {
        Claim real;
        Claim column;
        IPermissionContainer claim = storage.getForPermissionCheck(placePos);
        IPermissionContainer iPermissionContainer = storage.getForPermissionCheck(new BlockPos(placePos.getX(), level.getMaxBuildHeight(), placePos.getZ()));
        Claim claim2 = column = iPermissionContainer instanceof Claim ? (real = (Claim)iPermissionContainer) : null;
        if (claim == null) {
            return InteractionResult.PASS;
        }
        if (BLACK_LISTED_ITEMS.contains(stack.getItem())) {
            return InteractionResult.PASS;
        }
        if (claim instanceof Claim && (real = (Claim)claim).canUseItem(stack)) {
            return InteractionResult.PASS;
        }
        ResourceLocation perm = InteractionOverrideManager.getInstance().getItemUse(stack.getItem());
        if (perm == null && stack.has(DataComponents.JUKEBOX_PLAYABLE)) {
            perm = BuiltinPermission.JUKEBOX;
        }
        if (perm != null) {
            if (claim.canInteract(player, perm, placePos, false)) {
                if (column != null && stack.getItem() instanceof BlockItem) {
                    column.extendDownwards(placePos);
                }
                return InteractionResult.PASS;
            }
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.noPermissionSimple", ChatFormatting.DARK_RED), true);
            return InteractionResult.FAIL;
        }
        if (claim.canInteract(player, BuiltinPermission.PLACE, placePos, false)) {
            if (column != null && stack.getItem() instanceof BlockItem) {
                column.extendDownwards(placePos);
            }
            return InteractionResult.PASS;
        }
        player.displayClientMessage((Component)ClaimUtils.translatedText("flan.noPermissionSimple", ChatFormatting.DARK_RED), true);
        BlockState other = level.getBlockState(placePos.above());
        player.connection.send((Packet)new ClientboundBlockUpdatePacket(placePos.above(), other));
        PlayerClaimData.get(player).addDisplayClaim(claim, EnumDisplayType.MAIN, player.blockPosition().getY());
        ItemInteractEvents.updateHeldItem(player);
        return InteractionResult.FAIL;
    }

    private static void updateHeldItem(ServerPlayer player) {
        player.connection.send((Packet)new ClientboundContainerSetSlotPacket(-2, 0, player.getInventory().selected, player.getInventory().getSelected()));
        player.connection.send((Packet)new ClientboundContainerSetSlotPacket(-2, 0, 40, player.getInventory().getItem(40)));
    }

    private static boolean cantClaimInWorld(ServerLevel world) {
        for (String s : ConfigHandler.CONFIG.blacklistedWorlds) {
            if (!s.equals(world.dimension().location().toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean canClaimWorld(ServerLevel level, ServerPlayer player) {
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.isAdminIgnoreClaim()) {
            return true;
        }
        if (ConfigHandler.CONFIG.worldWhitelist) {
            if (!ItemInteractEvents.cantClaimInWorld(level)) {
                player.displayClientMessage((Component)ClaimUtils.translatedText("flan.landClaimDisabledWorld", ChatFormatting.DARK_RED), false);
                return false;
            }
        } else if (ItemInteractEvents.cantClaimInWorld(level)) {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.landClaimDisabledWorld", ChatFormatting.DARK_RED), false);
            return false;
        }
        return true;
    }

    public static BlockPos rayTargetPos(ServerPlayer player) {
        PlayerClaimData data = PlayerClaimData.get(player);
        return ItemInteractEvents.rayTargetPos(player, data.claimingRange, data.getClaimMode().is3d && data.editingCorner() != null);
    }

    public static BlockPos rayTargetPos(ServerPlayer player, int range, boolean allowMiss) {
        HitResult ray = player.pick((double)range, 0.0f, false);
        if (ray instanceof BlockHitResult) {
            BlockHitResult res = (BlockHitResult)ray;
            if (allowMiss) {
                return res.getBlockPos();
            }
            return res.getType() != HitResult.Type.MISS ? res.getBlockPos() : null;
        }
        return null;
    }

    public static boolean canPlayerClaim(ServerLevel level, ServerPlayer player) {
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.isAdminIgnoreClaim()) {
            return true;
        }
        if (!PermissionNodeHandler.INSTANCE.perm(player, "flan.claim.create", false)) {
            return false;
        }
        if (ConfigHandler.CONFIG.worldWhitelist) {
            return ItemInteractEvents.cantClaimInWorld(level);
        }
        return !ItemInteractEvents.cantClaimInWorld(level);
    }

    public static void claimLandHandling(ServerPlayer player, BlockPos target) {
        PlayerClaimData data;
        if (!PermissionNodeHandler.INSTANCE.perm(player, "flan.claim.create", false)) {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.noPermission", ChatFormatting.DARK_RED), true);
            return;
        }
        if (!ItemInteractEvents.canClaimWorld(player.serverLevel(), player)) {
            return;
        }
        ClaimStorage storage = ClaimStorage.get(player.serverLevel());
        Claim claim = storage.getClaimAt(target);
        if (claim == null) {
            claim = storage.getClaimAt(new BlockPos(target.getX(), player.serverLevel().getMaxBuildHeight(), target.getZ()));
        }
        if ((data = PlayerClaimData.get(player)).claimCooldown()) {
            return;
        }
        data.setClaimActionCooldown();
        if (claim != null) {
            if (claim.canInteract(player, BuiltinPermission.EDITCLAIM, target)) {
                if (data.getClaimMode().isSubclaim) {
                    Claim subClaim = claim.getSubClaim(target);
                    if (subClaim != null && data.currentEdit() == null) {
                        if (subClaim.isCorner(target)) {
                            data.setEditClaim(subClaim, player.blockPosition().getY());
                            data.setEditingCorner(target);
                            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.resizeClaim", ChatFormatting.GOLD), false);
                        } else {
                            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.cantClaimHere", ChatFormatting.RED), false);
                        }
                        data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.blockPosition().getY());
                    } else if (data.currentEdit() != null) {
                        if (!data.editingCorner().equals((Object)target)) {
                            Set<Claim> fl = claim.resizeSubclaim(data.currentEdit(), data.editingCorner(), target);
                            if (!fl.isEmpty()) {
                                fl.forEach(confl -> data.addDisplayClaim((IPermissionContainer)confl, EnumDisplayType.MAIN, player.blockPosition().getY()));
                                player.displayClientMessage((Component)ClaimUtils.translatedText("flan.conflictOther", ChatFormatting.RED), false);
                            }
                            data.setEditClaim(null, 0);
                            data.setEditingCorner(null);
                        }
                    } else if (data.editingCorner() != null) {
                        if (!data.editingCorner().equals((Object)target)) {
                            Set<Claim> fl = claim.tryCreateSubClaim(data.editingCorner(), target, data.getClaimMode().is3d);
                            data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.blockPosition().getY());
                            if (!fl.isEmpty()) {
                                fl.forEach(confl -> data.addDisplayClaim((IPermissionContainer)confl, EnumDisplayType.CONFLICT, player.blockPosition().getY()));
                                player.displayClientMessage((Component)ClaimUtils.translatedText("flan.conflictOther", ChatFormatting.RED), false);
                            } else {
                                player.displayClientMessage((Component)ClaimUtils.translatedText("flan.subClaimCreateSuccess", ChatFormatting.GOLD), false);
                            }
                            data.setEditingCorner(null);
                        }
                    } else {
                        data.setEditingCorner(target);
                    }
                } else if (claim.isCorner(target)) {
                    data.setEditClaim(claim, player.blockPosition().getY());
                    data.setEditingCorner(target);
                    player.displayClientMessage((Component)ClaimUtils.translatedText("flan.resizeClaim", ChatFormatting.GOLD), false);
                } else if (data.currentEdit() != null) {
                    storage.resizeClaim(data.currentEdit(), data.editingCorner(), target, player);
                    data.setEditClaim(null, 0);
                    data.setEditingCorner(null);
                } else {
                    data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.blockPosition().getY());
                    player.displayClientMessage((Component)ClaimUtils.translatedText("flan.cantClaimHere", ChatFormatting.RED), false);
                }
            } else {
                data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.blockPosition().getY());
                player.displayClientMessage((Component)ClaimUtils.translatedText("flan.cantClaimHere", ChatFormatting.RED), false);
            }
        } else if (data.getClaimMode().isSubclaim) {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.wrongMode", Component.translatable((String)data.getClaimMode().translationKey).withStyle(ChatFormatting.AQUA), ChatFormatting.RED), false);
        } else if (data.currentEdit() != null) {
            storage.resizeClaim(data.currentEdit(), data.editingCorner(), target, player);
            data.setEditClaim(null, 0);
            data.setEditingCorner(null);
        } else if (data.editingCorner() != null) {
            storage.createClaim(data.editingCorner(), target, player);
            data.setEditingCorner(null);
        } else {
            data.setEditingCorner(target);
        }
    }

    public static void inspect(ServerPlayer player, BlockPos target) {
        Claim claim = ClaimStorage.get(player.serverLevel()).getClaimAt(target);
        PlayerClaimData data = PlayerClaimData.get(player);
        if (data.claimCooldown()) {
            return;
        }
        data.setClaimActionCooldown();
        if (claim != null) {
            String owner = claim.isAdminClaim() ? "<Admin>" : ClaimUtils.fetchUsername(claim.getOwner(), player.level().getServer()).orElse(claim.getOwner().toString());
            MutableComponent text = ClaimUtils.translatedText("flan.inspectBlockOwner", owner, target.getX(), target.getY(), target.getZ(), ChatFormatting.GREEN);
            player.displayClientMessage((Component)text, false);
            data.addDisplayClaim(claim, EnumDisplayType.MAIN, player.blockPosition().getY());
        } else {
            player.displayClientMessage((Component)ClaimUtils.translatedText("flan.inspectNoClaim", ChatFormatting.RED), false);
        }
    }

    protected static BlockHitResult getPlayerHitResult(Level level, Player player, ClipContext.Fluid fluidMode) {
        float xRot = player.getXRot();
        float yRot = player.getYRot();
        Vec3 eye = player.getEyePosition();
        float h = Mth.cos((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float i = Mth.sin((float)(-yRot * ((float)Math.PI / 180) - (float)Math.PI));
        float j = -Mth.cos((float)(-xRot * ((float)Math.PI / 180)));
        float k = Mth.sin((float)(-xRot * ((float)Math.PI / 180)));
        float l = i * j;
        float n = h * j;
        Vec3 vec32 = eye.add((double)l * 5.0, (double)k * 5.0, (double)n * 5.0);
        return level.clip(new ClipContext(eye, vec32, ClipContext.Block.OUTLINE, fluidMode, (Entity)player));
    }
}

