/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.gui.ServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.StringResultScreenHandler;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ClaimTextHandler
extends ServerOnlyScreenHandler<Claim> {
    private ClaimTextHandler(int syncId, Inventory playerInventory, Claim claim) {
        super(syncId, playerInventory, 1, claim);
    }

    public static void openClaimMenu(ServerPlayer player, final Claim claim) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                return new ClaimTextHandler(syncId, inv, claim);
            }

            public Component getDisplayName() {
                return ClaimUtils.translatedText(claim.parentClaim() != null ? "flan.screenTitleEditorSub" : "flan.screenTitleEditor", new Object[0]);
            }
        };
        player.openMenu(fac);
    }

    @Override
    protected void fillInventoryWith() {
        block7: for (int i = 0; i < 9; ++i) {
            switch (i) {
                case 0: {
                    ItemStack stack = ServerScreenHelper.createStack(Items.TNT, (Component)ServerScreenHelper.coloredGuiText("flan.screenBack", ChatFormatting.DARK_RED));
                    ((Slot)this.slots.get(i)).set(stack);
                    continue block7;
                }
                case 2: {
                    ItemStack stack = ServerScreenHelper.createStack(Items.OAK_SIGN, (Component)ServerScreenHelper.coloredGuiText("flan.screenEnterText", ChatFormatting.GOLD));
                    ArrayList<Component> lore = new ArrayList<Component>();
                    lore.add((Component)ServerScreenHelper.coloredGuiText("flan.screenTextJson", ChatFormatting.GOLD));
                    lore.add((Component)ServerScreenHelper.coloredGuiText("flan.screenDelete", ChatFormatting.DARK_RED));
                    if (((Claim)this.data).enterTitle != null) {
                        lore.add(((Claim)this.data).enterTitle);
                    }
                    ServerScreenHelper.addLore(stack, lore);
                    ((Slot)this.slots.get(i)).set(stack);
                    continue block7;
                }
                case 3: {
                    ItemStack stack = ServerScreenHelper.createStack(Items.OAK_SIGN, (Component)ServerScreenHelper.coloredGuiText("flan.screenEnterSubText", ChatFormatting.GOLD));
                    ArrayList<Component> lore = new ArrayList();
                    lore.add((Component)ServerScreenHelper.coloredGuiText("flan.screenTextJson", ChatFormatting.GOLD));
                    lore.add((Component)ServerScreenHelper.coloredGuiText("flan.screenDelete", ChatFormatting.DARK_RED));
                    if (((Claim)this.data).enterSubtitle != null) {
                        lore.add(((Claim)this.data).enterSubtitle);
                    }
                    ServerScreenHelper.addLore(stack, lore);
                    ((Slot)this.slots.get(i)).set(stack);
                    continue block7;
                }
                case 4: {
                    ItemStack stack = ServerScreenHelper.createStack(Items.OAK_SIGN, (Component)ServerScreenHelper.coloredGuiText("flan.screenLeaveText", ChatFormatting.GOLD));
                    ArrayList<Component> lore = new ArrayList();
                    lore.add((Component)ServerScreenHelper.coloredGuiText("flan.screenTextJson", ChatFormatting.GOLD));
                    lore.add((Component)ServerScreenHelper.coloredGuiText("flan.screenDelete", ChatFormatting.DARK_RED));
                    if (((Claim)this.data).leaveTitle != null) {
                        lore.add(((Claim)this.data).leaveTitle);
                    }
                    ServerScreenHelper.addLore(stack, lore);
                    ((Slot)this.slots.get(i)).set(stack);
                    continue block7;
                }
                case 5: {
                    ItemStack stack = ServerScreenHelper.createStack(Items.OAK_SIGN, (Component)ServerScreenHelper.coloredGuiText("flan.screenLeaveSubText", ChatFormatting.GOLD));
                    ArrayList<Component> lore = new ArrayList();
                    lore.add((Component)ServerScreenHelper.coloredGuiText("flan.screenTextJson", ChatFormatting.GOLD));
                    lore.add((Component)ServerScreenHelper.coloredGuiText("flan.screenDelete", ChatFormatting.DARK_RED));
                    if (((Claim)this.data).leaveSubtitle != null) {
                        lore.add(((Claim)this.data).leaveSubtitle);
                    }
                    ServerScreenHelper.addLore(stack, lore);
                    ((Slot)this.slots.get(i)).set(stack);
                    continue block7;
                }
                default: {
                    ((Slot)this.slots.get(i)).set(ServerScreenHelper.emptyFiller());
                }
            }
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 2 || slot == 3 || slot == 4 || slot == 5 || slot == 8;
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        if (index == 0) {
            player.closeContainer();
            player.getServer().execute(() -> ClaimMenuScreenHandler.openClaimMenu(player, (Claim)this.data));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
        } else {
            Consumer<Component> cons;
            switch (index) {
                case 2: {
                    Consumer<Component> consumer = text -> ((Claim)this.data).setEnterTitle((Component)text, ((Claim)this.data).enterSubtitle);
                    break;
                }
                case 3: {
                    Consumer<Component> consumer = text -> ((Claim)this.data).setEnterTitle(((Claim)this.data).enterTitle, (Component)text);
                    break;
                }
                case 4: {
                    Consumer<Component> consumer = text -> ((Claim)this.data).setLeaveTitle((Component)text, ((Claim)this.data).leaveSubtitle);
                    break;
                }
                case 5: {
                    Consumer<Component> consumer = text -> ((Claim)this.data).setLeaveTitle(((Claim)this.data).leaveTitle, (Component)text);
                    break;
                }
                default: {
                    Consumer<Component> consumer = cons = null;
                }
            }
            if (cons != null) {
                player.closeContainer();
                if (clickType == 0) {
                    player.getServer().execute(() -> StringResultScreenHandler.createNewStringResult((Player)player, s -> {
                        player.closeContainer();
                        cons.accept((Component)Component.literal((String)s).withStyle(Style.EMPTY.withItalic(Boolean.valueOf(false)).applyFormat(ChatFormatting.WHITE)));
                        player.getServer().execute(() -> ClaimTextHandler.openClaimMenu(player, (Claim)this.data));
                        ServerScreenHelper.playSongToPlayer(player, SoundEvents.ANVIL_USE, 1.0f, 1.0f);
                    }, () -> {
                        player.closeContainer();
                        player.getServer().execute(() -> ClaimTextHandler.openClaimMenu(player, (Claim)this.data));
                        ServerScreenHelper.playSongToPlayer(player, SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
                    }));
                } else {
                    MutableComponent text2 = ClaimUtils.translatedText("flan.chatClaimTextEdit", new Object[0]);
                    String command = "/flan claimMessage" + (index == 2 || index == 3 ? " enter" : " leave") + (index == 2 || index == 4 ? " title" : " subtitle") + " text ";
                    text2.withStyle(Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, command)));
                    player.displayClientMessage((Component)text2, false);
                }
                ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
            }
        }
        return true;
    }
}

