/*
 * Decompiled with CFR 0.152.
 */
package io.github.flemmli97.flan.gui;

import com.mojang.datafixers.util.Either;
import io.github.flemmli97.flan.claim.Claim;
import io.github.flemmli97.flan.claim.ClaimUtils;
import io.github.flemmli97.flan.gui.ClaimMenuScreenHandler;
import io.github.flemmli97.flan.gui.PagedServerOnlyScreenHandler;
import io.github.flemmli97.flan.gui.ServerScreenHelper;
import io.github.flemmli97.flan.gui.StringResultScreenHandler;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class CustomInteractListScreenHandler
extends PagedServerOnlyScreenHandler<Data> {
    private boolean removeMode;

    private CustomInteractListScreenHandler(int syncId, Inventory playerInventory, Data data) {
        super(syncId, playerInventory, 6, data);
    }

    public static void openMenu(Player player, final Type type, final Claim claim) {
        MenuProvider fac = new MenuProvider(){

            public AbstractContainerMenu createMenu(int syncId, Inventory inv, Player player) {
                return new CustomInteractListScreenHandler(syncId, inv, new Data(claim, type));
            }

            public Component getDisplayName() {
                return ClaimUtils.translatedText(type.translationKey, new Object[0]);
            }
        };
        player.openMenu(fac);
    }

    @Override
    protected void fillInventoryWith() {
        for (int i = 0; i < 54; ++i) {
            ItemStack stack;
            if (i == 0) {
                stack = ServerScreenHelper.createStack(Items.TNT, (Component)ServerScreenHelper.coloredGuiText("flan.screenBack", ChatFormatting.DARK_RED));
                ((Slot)this.slots.get(i)).set(stack);
                continue;
            }
            if (i == 3) {
                stack = ServerScreenHelper.createStack(Items.ANVIL, (Component)ServerScreenHelper.coloredGuiText("flan.screenAdd", ChatFormatting.DARK_GREEN));
                ((Slot)this.slots.get(i)).set(stack);
                continue;
            }
            if (i == 4) {
                stack = ServerScreenHelper.createStack(Items.REDSTONE_BLOCK, (Component)ServerScreenHelper.coloredGuiText("flan.screenRemoveMode", this.removeMode, ChatFormatting.DARK_RED));
                ((Slot)this.slots.get(i)).set(stack);
                continue;
            }
            if (i < 9 || i > 44 || i % 9 == 0 || i % 9 == 8) {
                ((Slot)this.slots.get(i)).set(ServerScreenHelper.emptyFiller());
                continue;
            }
            List<ItemStack> stacks = switch (((Data)this.data).type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> ((Data)this.data).claim.allowedItems.asStacks();
                case 1 -> ((Data)this.data).claim.allowedBreakBlocks.asStacks();
                case 2 -> ((Data)this.data).claim.allowedUseBlocks.asStacks();
                case 3 -> ((Data)this.data).claim.allowedEntityAttack.asStacks();
                case 4 -> ((Data)this.data).claim.allowedEntityUse.asStacks();
            };
            int row = i / 9 - 1;
            int id = i % 9 + row * 7 - 1 + this.getPage() * 28;
            if (id < stacks.size()) {
                ItemStack stack2 = stacks.get(id);
                CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)stack2, tag -> tag.putInt("Index", id));
                ((Slot)this.slots.get(i)).set(stack2);
                continue;
            }
            ((Slot)this.slots.get(i)).set(ItemStack.EMPTY);
        }
    }

    @Override
    protected boolean isRightSlot(int slot) {
        return slot == 0 || slot == 3 || slot == 4 || slot < 45 && slot > 8 && slot % 9 != 0 && slot % 9 != 8;
    }

    @Override
    protected boolean handleSlotClicked(ServerPlayer player, int index, Slot slot, int clickType) {
        if (index == 0) {
            player.closeContainer();
            player.getServer().execute(() -> ClaimMenuScreenHandler.openClaimMenu(player, ((Data)this.data).claim));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
            return true;
        }
        if (index == 3) {
            player.closeContainer();
            player.getServer().execute(() -> StringResultScreenHandler.createNewStringResult((Player)player, s -> {
                switch (((Data)this.data).type.ordinal()) {
                    case 0: {
                        if (s.startsWith("#")) {
                            ((Data)this.data).claim.allowedItems.addAllowedItem((Either<Item, TagKey<Item>>)Either.right((Object)TagKey.create((ResourceKey)BuiltInRegistries.ITEM.key(), (ResourceLocation)ResourceLocation.parse((String)s.substring(1)))));
                            break;
                        }
                        Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)s));
                        if (item == Items.AIR) break;
                        ((Data)this.data).claim.allowedItems.addAllowedItem((Either<Item, TagKey<Item>>)Either.left((Object)item));
                        break;
                    }
                    case 1: {
                        if (s.startsWith("#")) {
                            ((Data)this.data).claim.allowedBreakBlocks.addAllowedItem((Either<Block, TagKey<Block>>)Either.right((Object)TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.parse((String)s.substring(1)))));
                            break;
                        }
                        Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)s));
                        if (block == Blocks.AIR) break;
                        ((Data)this.data).claim.allowedBreakBlocks.addAllowedItem((Either<Block, TagKey<Block>>)Either.left((Object)block));
                        break;
                    }
                    case 2: {
                        if (s.startsWith("#")) {
                            ((Data)this.data).claim.allowedUseBlocks.addAllowedItem((Either<Block, TagKey<Block>>)Either.right((Object)TagKey.create((ResourceKey)BuiltInRegistries.BLOCK.key(), (ResourceLocation)ResourceLocation.parse((String)s.substring(1)))));
                            break;
                        }
                        Block block = (Block)BuiltInRegistries.BLOCK.get(ResourceLocation.parse((String)s));
                        if (block == Blocks.AIR) break;
                        ((Data)this.data).claim.allowedUseBlocks.addAllowedItem((Either<Block, TagKey<Block>>)Either.left((Object)block));
                        break;
                    }
                    case 3: {
                        if (s.startsWith("#")) {
                            ((Data)this.data).claim.allowedEntityAttack.addAllowedItem(Either.right((Object)TagKey.create((ResourceKey)BuiltInRegistries.ENTITY_TYPE.key(), (ResourceLocation)ResourceLocation.parse((String)s.substring(1)))));
                            break;
                        }
                        EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)s));
                        if (entityType == EntityType.PIG && !s.equals("minecraft:pig")) break;
                        ((Data)this.data).claim.allowedEntityAttack.addAllowedItem(Either.left((Object)entityType));
                        break;
                    }
                    case 4: {
                        if (s.startsWith("#")) {
                            ((Data)this.data).claim.allowedEntityUse.addAllowedItem(Either.right((Object)TagKey.create((ResourceKey)BuiltInRegistries.ENTITY_TYPE.key(), (ResourceLocation)ResourceLocation.parse((String)s.substring(1)))));
                            break;
                        }
                        EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(ResourceLocation.parse((String)s));
                        if (entityType == EntityType.PIG && !s.equals("minecraft:pig")) break;
                        ((Data)this.data).claim.allowedEntityUse.addAllowedItem(Either.left((Object)entityType));
                    }
                }
                player.closeContainer();
                player.getServer().execute(() -> CustomInteractListScreenHandler.openMenu((Player)player, ((Data)this.data).type, ((Data)this.data).claim));
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.ANVIL_USE, 1.0f, 1.0f);
            }, () -> {
                player.closeContainer();
                player.getServer().execute(() -> CustomInteractListScreenHandler.openMenu((Player)player, ((Data)this.data).type, ((Data)this.data).claim));
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.VILLAGER_NO, 1.0f, 1.0f);
            }));
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
            return true;
        }
        if (index == 4) {
            this.removeMode = !this.removeMode;
            ItemStack stack = ServerScreenHelper.createStack(Items.REDSTONE_BLOCK, (Component)ServerScreenHelper.coloredGuiText("flan.screenRemoveMode", this.removeMode, ChatFormatting.DARK_RED));
            slot.set(stack);
            ServerScreenHelper.playSongToPlayer(player, (Holder<SoundEvent>)SoundEvents.UI_BUTTON_CLICK, 1.0f, 1.0f);
            return true;
        }
        ItemStack stack = slot.getItem();
        if (!stack.isEmpty()) {
            int idx;
            CustomData nbt = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            int n = idx = nbt != null ? nbt.copyTag().getInt("Index") : 0;
            if (this.removeMode) {
                switch (((Data)this.data).type.ordinal()) {
                    case 0: {
                        ((Data)this.data).claim.allowedItems.removeAllowedItem(idx);
                        break;
                    }
                    case 1: {
                        ((Data)this.data).claim.allowedBreakBlocks.removeAllowedItem(idx);
                        break;
                    }
                    case 2: {
                        ((Data)this.data).claim.allowedUseBlocks.removeAllowedItem(idx);
                    }
                }
                slot.set(ItemStack.EMPTY);
                ServerScreenHelper.playSongToPlayer(player, SoundEvents.BAT_DEATH, 1.0f, 1.0f);
            }
        }
        return false;
    }

    @Override
    protected PagedServerOnlyScreenHandler.PageSettings pageSettings() {
        int size = switch (((Data)this.data).type.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> ((Data)this.data).claim.allowedItems.size();
            case 1 -> ((Data)this.data).claim.allowedBreakBlocks.size();
            case 2 -> ((Data)this.data).claim.allowedUseBlocks.size();
            case 3 -> ((Data)this.data).claim.allowedEntityAttack.size();
            case 4 -> ((Data)this.data).claim.allowedEntityUse.size();
        };
        return new PagedServerOnlyScreenHandler.PageSettings((size - 1) / 28, 47, 51);
    }

    public static enum Type {
        ITEM("flan.screenMenuItemUse", "item"),
        BLOCKBREAK("flan.screenMenuBlockBreak", "block_break"),
        BLOCKUSE("flan.screenMenuBlockUse", "block_use"),
        ENTITYATTACK("flan.screenMenuEntityAttack", "entity_attack"),
        ENTITYUSE("flan.screenMenuEntityUse", "entity_use");

        public final String translationKey;
        public final String commandKey;

        private Type(String translationKey, String commandKey) {
            this.translationKey = translationKey;
            this.commandKey = commandKey;
        }
    }

    public record Data(Claim claim, Type type) {
    }
}

